/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpReferenceBase;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpUnnecessaryFullyQualifiedNameInspection;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportClassIntention
extends PsiElementBaseIntentionAction {
    private static final Function<String, String> NAME_UNIFIER = s -> StringUtil.toLowerCase((String)s);

    public static boolean canBeImported(@NotNull PhpReferenceBase classReference) {
        if (classReference == null) {
            PhpImportClassIntention.$$$reportNull$$$0(0);
        }
        return PhpCodeInsightUtil.isImportSupported(classReference) && PhpCodeInsightUtil.hasQualifier(classReference);
    }

    public static boolean canBeImported(@NotNull PhpReference classReference) {
        if (classReference == null) {
            PhpImportClassIntention.$$$reportNull$$$0(1);
        }
        return PhpImportClassIntention.canBeImported((PhpReferenceBase)classReference);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpImportClassIntention.getNameText();
        if (string == null) {
            PhpImportClassIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpImportClassIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpImportClassIntention.$$$reportNull$$$0(4);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PhpReference classReference = PhpPsiUtil.getClassReferenceAt(element);
        if (!(classReference instanceof ClassReference) && !(classReference instanceof PhpDocType)) {
            return false;
        }
        PhpDocTag docTag = PhpPsiUtil.getParentOfClass((PsiElement)classReference, PhpDocTag.class);
        if (docTag != null && StringUtil.equals((CharSequence)docTag.getName(), (CharSequence)"@coversDefaultClass")) {
            return false;
        }
        if (PhpImportClassIntention.canBeImported(classReference)) {
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
            if (scopeForUseOperator == null) {
                return false;
            }
            String fqn = PhpCodeInsightUtil.getImmediateFQN(classReference);
            if (fqn == null || !PhpLangUtil.isFqn(fqn)) {
                return false;
            }
            if (PhpLangUtil.isClassNameSpecial(PhpLangUtil.toName(fqn))) {
                return false;
            }
            if (!PhpImportClassIntention.collectUsedAliases(scopeForUseOperator, PhpGroupUseElement.PhpUseKeyword.CLASS).contains(StringUtil.toLowerCase((String)PhpLangUtil.toShortName(fqn)))) {
                return false;
            }
            this.setText(PhpImportClassIntention.getNameText());
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PhpReference classReference;
        if (project == null) {
            PhpImportClassIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpImportClassIntention.$$$reportNull$$$0(6);
        }
        if ((classReference = PhpPsiUtil.getClassReferenceAt(element)) == null) {
            return;
        }
        String fqn = PhpCodeInsightUtil.getImmediateFQN(classReference);
        if (fqn == null) {
            return;
        }
        PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
        if (scopeForUseOperator == null) {
            return;
        }
        Set<String> usedAliases = PhpImportClassIntention.collectUsedAliases(scopeForUseOperator, PhpGroupUseElement.PhpUseKeyword.CLASS);
        String name = PhpLangUtil.toShortName(fqn);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PhpImportClassIntention.apply(project, scopeForUseOperator, fqn, name + "Alias", this.getText(), PhpGroupUseElement.PhpUseKeyword.CLASS);
        } else {
            PhpImportClassDialog dialog = new PhpImportClassDialog(project, fqn, usedAliases);
            if (dialog.showAndGet()) {
                String alias = dialog.getAlias();
                PhpImportClassIntention.apply(project, scopeForUseOperator, fqn, PhpLangUtil.equalsClassNames(alias, name) ? null : alias, this.getText(), PhpGroupUseElement.PhpUseKeyword.CLASS);
            }
        }
    }

    public static Set<String> collectUsedAliases(@NotNull PhpPsiElement scopeHolder, PhpGroupUseElement.PhpUseKeyword ... keywords) {
        if (scopeHolder == null) {
            PhpImportClassIntention.$$$reportNull$$$0(7);
        }
        Set<String> aliases = PhpCodeInsightUtil.getAliasesInScope(scopeHolder, keywords).keySet();
        return ContainerUtil.map2Set((Object[])ArrayUtilRt.toStringArray(aliases), NAME_UNIFIER);
    }

    public static void apply(@NotNull Project project, @NotNull PhpPsiElement scopeForUseOperator, final @NotNull String originalFqn, @Nullable String alias, String text, final @NotNull PhpGroupUseElement.PhpUseKeyword useKeyword) {
        String name;
        if (project == null) {
            PhpImportClassIntention.$$$reportNull$$$0(8);
        }
        if (scopeForUseOperator == null) {
            PhpImportClassIntention.$$$reportNull$$$0(9);
        }
        if (originalFqn == null) {
            PhpImportClassIntention.$$$reportNull$$$0(10);
        }
        if (useKeyword == null) {
            PhpImportClassIntention.$$$reportNull$$$0(11);
        }
        final HashSet references = new HashSet();
        final HashSet phpDocTypes = new HashSet();
        scopeForUseOperator.acceptChildren(new PhpRecursiveElementVisitor(){

            @Override
            public void visitPhpElement(PhpPsiElement element) {
                if (!PhpCodeInsightUtil.isScopeForUseOperator(element)) {
                    super.visitPhpElement(element);
                }
            }

            @Override
            public void visitPhpDocType(PhpDocType phpDocType) {
                super.visitPhpDocType(phpDocType);
                if (useKeyword != PhpGroupUseElement.PhpUseKeyword.CLASS) {
                    return;
                }
                if (PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN(phpDocType)) && !PhpUnnecessaryFullyQualifiedNameInspection.phpdocUseFqcn(phpDocType)) {
                    phpDocTypes.add(phpDocType);
                }
            }

            @Override
            public void visitPhpClassReference(ClassReference classReference) {
                if (useKeyword != PhpGroupUseElement.PhpUseKeyword.CLASS) {
                    return;
                }
                PhpImportClassIntention.addReference(classReference, originalFqn, references);
            }

            @Override
            public void visitPhpConstantReference(ConstantReference reference) {
                if (useKeyword != PhpGroupUseElement.PhpUseKeyword.CONSTANT) {
                    return;
                }
                PhpImportClassIntention.addReference(reference, originalFqn, references);
            }

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                super.visitPhpFunctionCall(reference);
                if (useKeyword != PhpGroupUseElement.PhpUseKeyword.FUNCTION) {
                    return;
                }
                PhpImportClassIntention.addReference(reference, originalFqn, references);
            }
        });
        PsiFile file = scopeForUseOperator.getContainingFile();
        if (file == null || !IntentionPreviewUtils.prepareElementForWrite((PsiElement)file)) {
            return;
        }
        String string = name = alias != null ? alias : PhpLangUtil.toShortName(originalFqn);
        if (PhpImportClassIntention.collectUsedAliases(scopeForUseOperator, useKeyword).contains(StringUtil.toLowerCase((String)name))) {
            return;
        }
        IntentionPreviewUtils.write(() -> {
            PhpAliasImporter.insertUseStatementWithKeyword(StringUtil.nullize((String)useKeyword.getValue()), originalFqn, alias, scopeForUseOperator);
            for (PhpReference reference : references) {
                PhpImportClassIntention.replaceClassReference(reference, alias);
            }
            PhpCodeStyleSettings settings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
            if (!settings.PHPDOC_USE_FQCN) {
                for (PhpDocType phpDocType : phpDocTypes) {
                    PhpImportClassIntention.replaceClassReference(phpDocType, alias);
                }
            }
        });
    }

    private static void addReference(PhpReference reference, @NotNull String originalFqn, Set<PhpReference> references) {
        if (originalFqn == null) {
            PhpImportClassIntention.$$$reportNull$$$0(12);
        }
        if (PhpImportClassIntention.canBeImported(reference) && PhpLangUtil.equalsClassNames(originalFqn, PhpCodeInsightUtil.getImmediateFQN(reference))) {
            references.add(reference);
        }
    }

    public static void replaceClassReference(@NotNull PhpPsiElement classReference, @Nullable String newFqn) {
        if (classReference == null) {
            PhpImportClassIntention.$$$reportNull$$$0(13);
        }
        if (newFqn == null) {
            PhpImportClassIntention.replaceNamespaceReference(classReference, null);
        } else {
            Project project = classReference.getProject();
            if (classReference instanceof PhpDocType || classReference instanceof PhpDocRef) {
                ASTNode nameNode = ((PhpReferenceBase)classReference).getNameNode();
                if (nameNode != null) {
                    String restOfDocType = classReference.getText().substring(nameNode.getPsi().getTextRangeInParent().getEndOffset());
                    classReference.replace((PsiElement)PhpPsiElementFactory.createPhpDocType(project, newFqn + restOfDocType));
                    return;
                }
                PhpDocType type = PhpPsiElementFactory.createPhpDocType(project, PhpType.pluralise(newFqn, PhpType.getPluralDimension(classReference.getText())));
                classReference.replace((PsiElement)type);
            } else {
                ClassReference newReference = PhpPsiElementFactory.createClassReference(project, newFqn);
                classReference.replace((PsiElement)newReference);
            }
        }
    }

    private static void replaceNamespaceReference(@NotNull PhpPsiElement classReference, @Nullable String newNamespaceQualifiedName) {
        if (classReference == null) {
            PhpImportClassIntention.$$$reportNull$$$0(14);
        }
        PhpNamespaceReference namespaceReference = (PhpNamespaceReference)PsiTreeUtil.findChildOfType((PsiElement)classReference, PhpNamespaceReference.class);
        PhpCodeEditUtil.replaceNamespaceReference(classReference, newNamespaceQualifiedName, namespaceReference);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @IntentionName
    @IntentionFamilyName
    @NlsContexts.Command
    public static String getNameText() {
        return PhpBundle.message("intention.import.class", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpImportClassIntention";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFqn";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpImportClassIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBeImported";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectUsedAliases";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addReference";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceClassReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceNamespaceReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpImportClassDialog
    extends DialogWrapper {
        private static final String DIMENSION_SERVICE_KEY = "#com.jetbrains.php.lang.intentions.PhpImportClassDialog#";
        private final JTextField myAliasTextField;
        private final String myFqn;
        private Set<String> myUsedAliases;

        protected PhpImportClassDialog(@Nullable Project project, @NotNull String fqn, @NotNull Set<String> aliases) {
            if (fqn == null) {
                PhpImportClassDialog.$$$reportNull$$$0(0);
            }
            if (aliases == null) {
                PhpImportClassDialog.$$$reportNull$$$0(1);
            }
            super(project);
            this.myFqn = fqn;
            this.myUsedAliases = aliases;
            this.myAliasTextField = new JTextField(PhpLangUtil.toShortName(this.myFqn));
            this.myAliasTextField.setPreferredSize(new Dimension(400, this.myAliasTextField.getPreferredSize().height));
            this.myUsedAliases = aliases;
            this.setTitle(PhpBundle.message("intention.import.class", new Object[0]));
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return null;
        }

        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.insets = JBUI.insetsBottom((int)4);
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridwidth = 0;
            gbConstraints.fill = 1;
            JLabel aliasLabel = new JLabel(PhpBundle.message("intention.import.class.alias.name", new Object[0]));
            panel.add((Component)aliasLabel, gbConstraints);
            gbConstraints.insets = JBUI.insetsBottom((int)8);
            gbConstraints.gridwidth = 2;
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridx = 0;
            gbConstraints.weighty = 1.0;
            panel.add((Component)this.myAliasTextField, gbConstraints);
            return panel;
        }

        private String getAlias() {
            return this.myAliasTextField.getText().trim();
        }

        protected boolean postponeValidation() {
            return false;
        }

        @Nullable
        protected ValidationInfo doValidate() {
            String alias = this.getAlias();
            if (!PhpNameUtil.isValidClassName(alias)) {
                return new ValidationInfo(PhpBundle.message("validation.invalid.alias", alias), (JComponent)this.myAliasTextField);
            }
            if (this.myUsedAliases.contains(StringUtil.toLowerCase((String)alias))) {
                return new ValidationInfo(PhpBundle.message("intention.import.class.alias.already.exists", new Object[0]), (JComponent)this.myAliasTextField);
            }
            return null;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myAliasTextField;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return DIMENSION_SERVICE_KEY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aliases";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/intentions/PhpImportClassIntention$PhpImportClassDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

