/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.injection.PhpInjectorBase;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLangTag;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInjectLanguageIntention
extends PsiUpdateModCommandAction<PsiElement> {
    @IntentionName
    @IntentionFamilyName
    public static final String TEXT = PhpBundle.message("inject.language.using.phpdoc", new Object[0]);
    private static final String LANGUAGE = "text";
    private static final String TEMPLATE = "/** @lang text */";

    public PhpInjectLanguageIntention() {
        super(PsiElement.class);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiElement host;
        if (context == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(2);
        }
        if ((host = PhpInjectLanguageIntention.getHost(element)) != null) {
            PsiElement added;
            PhpDocComment phpDoc = PhpInjectorBase.getDocComment(host);
            if (phpDoc == null) {
                PhpDocComment comment = PhpPsiElementFactory.createFromText(context.project(), PhpDocComment.class, TEMPLATE);
                assert (comment != null);
                added = host.getParent().addBefore((PsiElement)comment, host);
            } else {
                PhpDocLangTag tag = PhpPsiElementFactory.createFromText(context.project(), PhpDocLangTag.class, TEMPLATE);
                assert (tag != null);
                added = phpDoc.addBefore((PsiElement)tag, phpDoc.getLastChild());
            }
            int selectionPos = added.getText().indexOf(LANGUAGE);
            if (selectionPos >= 0) {
                int selectionStart = added.getTextOffset() + selectionPos;
                updater.select(TextRange.from((int)selectionStart, (int)LANGUAGE.length()));
            }
        }
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        PhpDocComment phpDoc;
        Object lang;
        PsiElement host;
        if (context == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(4);
        }
        if ((host = PhpInjectLanguageIntention.getHost(element)) != null && (lang = PhpPsiUtil.getChildByCondition((PsiElement)(phpDoc = PhpInjectorBase.getDocComment(host)), PhpDocLangTag.INSTANCEOF)) == null) {
            return Presentation.of((String)this.getFamilyName());
        }
        return null;
    }

    @Nullable
    private static PsiElement getHost(@NotNull PsiElement element) {
        if (element == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(5);
        }
        PsiElement originalElement = element.getOriginalElement();
        StringLiteralExpression stringLiteral = PhpPsiUtil.getParentOfClass(originalElement, StringLiteralExpression.class);
        return PhpInjectionUtil.getLargestStringLiteral((PsiElement)stringLiteral);
    }

    @NotNull
    public String getFamilyName() {
        String string = TEXT;
        if (string == null) {
            PhpInjectLanguageIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpInjectLanguageIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpInjectLanguageIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHost";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

