/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpBreakContinueInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.lang.intentions.PhpNegateExpressionIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpLoop;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.unwrap.PhpElseUnwrapper;
import com.jetbrains.php.refactoring.unwrap.PhpIfUnwrapper;
import com.jetbrains.php.refactoring.unwrap.PhpUnwrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInvertIfIntention
extends PsiUpdateModCommandAction<PsiElement> {
    public PhpInvertIfIntention() {
        super(PsiElement.class);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.invert.if.statement", new Object[0]);
        if (string == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static void flipIfElse(@NotNull Project project, @NotNull If ifStatement) {
        if (project == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(1);
        }
        if (ifStatement == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(2);
        }
        If ifStatementCopy = (If)ifStatement.copy();
        PhpInvertIfIntention.setupThenBranch(project, ifStatement.getStatement(), ifStatement.getElseIfBranches(), ifStatementCopy.getElseBranch());
        PhpInvertIfIntention.setupElseBranch(project, ifStatement, ifStatementCopy.getStatement());
        PhpInvertIfIntention.updateCondition((PsiElement)ifStatement.getCondition());
    }

    private static void setupThenBranch(@NotNull Project project, Statement thenBranch, ElseIf[] elseIfBranches, Else elseBranchCopy) {
        boolean needBraces;
        if (project == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(3);
        }
        StringBuilder newThenBranchText = new StringBuilder(1024);
        boolean elseIf = elseIfBranches.length != 0;
        boolean bl = needBraces = elseIf || elseBranchCopy == null || !(elseBranchCopy.getStatement() instanceof GroupStatement);
        if (needBraces) {
            newThenBranchText.append('{');
        }
        for (int i = 0; i < elseIfBranches.length; ++i) {
            ElseIf elseIfBranch = elseIfBranches[i];
            String text = elseIfBranch.getText();
            if (i == 0) {
                text = text.substring(4);
            }
            newThenBranchText.append(text);
            elseIfBranch.delete();
        }
        if (elseBranchCopy != null) {
            if (elseIf) {
                newThenBranchText.append(elseBranchCopy.getText());
            } else {
                PhpPsiElement elseBranchCopyStatement = elseBranchCopy.getStatement();
                if (elseBranchCopyStatement != null) {
                    newThenBranchText.append(elseBranchCopyStatement.getText());
                }
            }
        }
        if (needBraces) {
            newThenBranchText.append('}');
        }
        Statement newThenBranch = PhpPsiElementFactory.createStatement(project, newThenBranchText.toString());
        thenBranch.replace((PsiElement)newThenBranch);
    }

    private static void setupElseBranch(@NotNull Project project, If ifStatement, Statement thenBranchCopy) {
        if (project == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(4);
        }
        Else elseBranch = ifStatement.getElseBranch();
        if (PhpInvertIfIntention.isEmpty(thenBranchCopy)) {
            if (elseBranch != null) {
                elseBranch.delete();
            }
        } else if (elseBranch != null) {
            String newElseStatementText = PhpInvertIfIntention.getNewElseStatementText(thenBranchCopy);
            Statement newElseStatement = PhpPsiElementFactory.createStatement(project, newElseStatementText);
            PhpPsiElement elseBranchStatement = elseBranch.getStatement();
            if (elseBranchStatement != null) {
                elseBranchStatement.replace((PsiElement)newElseStatement);
            } else {
                elseBranch.add((PsiElement)newElseStatement);
            }
        } else {
            String newIfStatementText = "if (true) {} else " + PhpInvertIfIntention.getNewElseStatementText(thenBranchCopy);
            If newIfStatement = (If)PhpPsiElementFactory.createStatement(project, newIfStatementText);
            Else newElseBranch = newIfStatement.getElseBranch();
            assert (newElseBranch != null);
            ifStatement.add((PsiElement)newElseBranch);
        }
    }

    private static boolean isEmpty(Statement statement) {
        if (statement instanceof GroupStatement) {
            PsiElement[] statements;
            for (PsiElement s : statements = statement.getChildren()) {
                if (s instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getNewElseStatementText(@NotNull Statement thenBranchCopy) {
        if (thenBranchCopy == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(5);
        }
        return thenBranchCopy instanceof GroupStatement ? thenBranchCopy.getText() : "{" + thenBranchCopy.getText() + "}";
    }

    public static void updateCondition(@Nullable PsiElement condition) {
        if (condition == null) {
            return;
        }
        PsiElement inverted = PhpNegateExpressionIntention.createInvertedExpression(condition);
        if (inverted == null) {
            return;
        }
        PhpNegateExpressionIntention.unwrapIfNecessary(PhpCodeEditUtil.replace(condition, inverted));
    }

    private static void flipElseIf(@NotNull Project project, ElseIf elseIfBranch) {
        if (project == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(6);
        }
        If ifStatement = (If)elseIfBranch.getParent();
        int i = elseIfBranch.getTextRange().getStartOffset() - ifStatement.getTextRange().getStartOffset();
        String ifStatementText = ifStatement.getText();
        String targetIfStatementText = ifStatementText.substring(i + 4);
        If targetIfStatement = (If)PhpPsiElementFactory.createStatement(project, targetIfStatementText);
        PhpInvertIfIntention.flipIfElse(project, targetIfStatement);
        String newIfStatementText = ifStatementText.substring(0, i + 4) + targetIfStatement.getText();
        Statement newIfStatement = PhpPsiElementFactory.createStatement(project, newIfStatementText);
        ifStatement.replace((PsiElement)newIfStatement);
    }

    @Nullable
    public static PhpBlock getBlock(@NotNull If anIf) {
        Object block;
        if (anIf == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(7);
        }
        if ((block = PhpPsiUtil.getParentByCondition((PsiElement)anIf, (Condition<? super PsiElement>)((Condition)b -> b instanceof PhpLoop || b instanceof Function || b instanceof PhpFile))) == null) {
            return null;
        }
        IElementType blockStopKeyword = block instanceof PhpLoop ? PhpTokenTypes.kwCONTINUE : PhpTokenTypes.kwRETURN;
        if ((block = PhpPsiUtil.getChildByCondition(block, GroupStatement.INSTANCEOF)) == null) {
            return null;
        }
        return new PhpBlock((PsiElement)block, blockStopKeyword);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiElement firstStatementAfterIf;
        PsiElement prevSibling;
        if (context == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(9);
        }
        if (updater == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(10);
        }
        PsiElement controlStatement = element.getParent();
        Project project = context.project();
        if (controlStatement instanceof ElseIf) {
            PhpInvertIfIntention.flipElseIf(project, (ElseIf)controlStatement);
            return;
        }
        if (controlStatement instanceof Else && (prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(controlStatement, true)) instanceof ElseIf) {
            PhpInvertIfIntention.flipElseIf(project, (ElseIf)prevSibling);
            return;
        }
        If anIf = (If)ObjectUtils.tryCast((Object)controlStatement, If.class);
        if (anIf == null) {
            return;
        }
        if (anIf.getElseBranch() != null) {
            PhpInvertIfIntention.flipIfElse(project, anIf);
            return;
        }
        PhpBlock phpBlock = PhpInvertIfIntention.getBlock(anIf);
        if (phpBlock == null) {
            return;
        }
        PsiElement block = phpBlock.getBlock();
        IElementType blockStopKeyword = phpBlock.getBlockStopKeyword();
        PsiElement parent = anIf.getParent();
        Statement lastBlockStatement = PhpInvertIfIntention.getLastBlockStatement(parent);
        if (parent == block && anIf == lastBlockStatement) {
            PhpInvertIfIntention.addInvertedIfBefore(project, anIf, blockStopKeyword);
            new PhpIfUnwrapper().unwrapElement((PsiElement)anIf, new PhpUnwrapper.Context(true));
            return;
        }
        if (PhpInvertIfIntention.alwaysReturned(anIf, block, false) && (firstStatementAfterIf = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)anIf, true)) instanceof Statement) {
            Else anElse = (Else)PhpInvertIfIntention.addEmptyElse(project, anIf);
            PhpInvertIfIntention.copyRangeToAnElse(project, anElse, firstStatementAfterIf, (PsiElement)lastBlockStatement);
            parent.deleteChildRange(firstStatementAfterIf, (PsiElement)lastBlockStatement);
            PhpInvertIfIntention.flipIfElse(project, anIf);
            PhpInvertIfIntention.unwrapElseIfSingleReturnStatement(anIf, blockStopKeyword);
            return;
        }
        PsiElement anElse = PhpInvertIfIntention.addEmptyElse(project, anIf);
        PhpInvertIfIntention.flipIfElse(project, (If)anElse.getParent());
    }

    public static boolean alwaysReturned(If anIf, @NotNull PsiElement block, boolean onlyExplicitReturn) {
        if (block == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(11);
        }
        return PhpInvertIfIntention.alwaysJumpToExitInstruction((PsiElement)anIf, block, PhpInvertIfIntention.findThenBranchInstruction(anIf), onlyExplicitReturn);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(12);
        }
        if (element == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(13);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if ((parent instanceof If || parent instanceof ElseIf || parent instanceof Else) && PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.opCOLON) == null) {
            return Presentation.of((String)this.getFamilyName());
        }
        return null;
    }

    private static void unwrapElseIfSingleReturnStatement(If anIf, IElementType blockStopKeyword) {
        Else flippedElse = anIf.getElseBranch();
        assert (flippedElse != null);
        Statement onlyStatement = PhpInvertIfIntention.getOnlyStatement((PsiElement)flippedElse.getStatement());
        if (onlyStatement instanceof PhpContinue && blockStopKeyword == PhpTokenTypes.kwCONTINUE || onlyStatement instanceof PhpReturn) {
            new PhpElseUnwrapper().unwrap((PsiElement)flippedElse);
        }
    }

    private static boolean alwaysJumpToExitInstruction(final PsiElement statement, final @Nullable PsiElement block, PhpConditionInstruction instructionToStartFrom, final boolean alwaysExplicitReturn) {
        if (instructionToStartFrom == null) {
            return false;
        }
        final Ref nonExitInstructionOutsideIfAccessed = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(instructionToStartFrom, false, new PhpInstructionProcessor(){

            @Override
            public boolean processInstruction(PhpInstruction instruction) {
                if (alwaysExplicitReturn && (instruction instanceof PhpReturnInstruction || instruction instanceof PhpThrowInstruction || instruction instanceof PhpInterruptScriptInstruction)) {
                    return false;
                }
                PsiElement anchor = instruction.getAnchor();
                if (anchor != null && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)anchor, (boolean)false)) {
                    nonExitInstructionOutsideIfAccessed.set((Object)true);
                    return false;
                }
                return super.processInstruction(instruction);
            }

            @Override
            public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                if (alwaysExplicitReturn) {
                    nonExitInstructionOutsideIfAccessed.set((Object)true);
                }
                return false;
            }

            @Override
            public boolean processBreakContinueInstruction(PhpBreakContinueInstruction instruction) {
                Statement statement2 = instruction.getTargetStatement();
                if (block != null && statement2 == block.getParent()) {
                    return false;
                }
                return super.processBreakContinueInstruction(instruction);
            }
        });
        return (Boolean)nonExitInstructionOutsideIfAccessed.get() == false;
    }

    @Nullable
    public static PhpConditionInstruction findThenBranchInstruction(final If anIf) {
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)anIf);
        if (scopeHolder == null) {
            return null;
        }
        PhpStatementInstruction instruction = PhpControlFlowUtil.getStatementInstruction(scopeHolder.getControlFlow(), anIf);
        if (instruction == null) {
            return null;
        }
        final Ref thenBranchInstruction = new Ref(null);
        PhpControlFlowUtil.processSuccessors(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                if (instruction.getCondition() == anIf.getCondition() && instruction.getResult()) {
                    thenBranchInstruction.set((Object)instruction);
                    return false;
                }
                return super.processConditionInstruction(instruction);
            }
        });
        return (PhpConditionInstruction)thenBranchInstruction.get();
    }

    private static PsiElement addEmptyElse(@NotNull Project project, If anIf) {
        if (project == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(14);
        }
        return anIf.add((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, Else.class, "if(){}else{}"));
    }

    private static void copyRangeToAnElse(@NotNull Project project, Else anElse, @Nullable PsiElement firstStatement, PsiElement lastStatement) {
        if (project == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(15);
        }
        If emptyIf = PhpPsiElementFactory.createPhpPsiFromText(project, If.class, "if(){}");
        GroupStatement statement = (GroupStatement)emptyIf.getStatement();
        assert (statement != null);
        PsiElement openBrace = statement.getFirstChild();
        statement.addRangeAfter(firstStatement, lastStatement, openBrace);
        PhpPsiElement elseStatement = anElse.getStatement();
        if (elseStatement != null) {
            elseStatement.replace((PsiElement)statement);
        } else {
            anElse.add((PsiElement)statement);
        }
    }

    @Nullable
    public static Statement getOnlyStatement(@Nullable PsiElement statement) {
        return statement instanceof GroupStatement ? (Statement)ObjectUtils.tryCast((Object)((GroupStatement)statement).getOnlyStatement(), Statement.class) : (Statement)ObjectUtils.tryCast((Object)statement, Statement.class);
    }

    @Nullable
    private static Statement getLastBlockStatement(PsiElement block) {
        PsiElement child;
        for (child = block.getLastChild(); child != null && !(child instanceof Statement); child = child.getPrevSibling()) {
        }
        return (Statement)child;
    }

    private static void addInvertedIfBefore(@NotNull Project project, If anIf, IElementType blockStopKeyword) {
        if (project == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(16);
        }
        If invertedIf = (If)anIf.getParent().addBefore(anIf.copy(), (PsiElement)anIf);
        PhpInvertIfIntention.updateCondition((PsiElement)invertedIf.getCondition());
        PhpInvertIfIntention.replaceBodyWithBlockStopStatement(project, blockStopKeyword, invertedIf);
    }

    private static void replaceBodyWithBlockStopStatement(@NotNull Project project, IElementType blockStopKeyword, If invertedIf) {
        if (project == null) {
            PhpInvertIfIntention.$$$reportNull$$$0(17);
        }
        If blockStopIf = PhpPsiElementFactory.createPhpPsiFromText(project, If.class, "if(){" + blockStopKeyword + ";}");
        GroupStatement blockStopStatement = (GroupStatement)blockStopIf.getStatement();
        assert (blockStopStatement != null);
        PhpInvertIfIntention.replaceStatement(invertedIf, blockStopStatement);
    }

    private static void replaceStatement(If invertedIf, GroupStatement blockStopStatement) {
        Statement statement = invertedIf.getStatement();
        if (statement != null) {
            statement.replace((PsiElement)blockStopStatement);
        } else {
            invertedIf.add((PsiElement)blockStopStatement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpInvertIfIntention";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenBranchCopy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anIf";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpInvertIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "flipIfElse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupThenBranch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupElseBranch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNewElseStatementText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "flipElseIf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBlock";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "alwaysReturned";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyElse";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyRangeToAnElse";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addInvertedIfBefore";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceBodyWithBlockStopStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpBlock {
        @NotNull
        private final PsiElement myBlock;
        @NotNull
        private final IElementType myBlockStopKeyword;

        public PhpBlock(@NotNull PsiElement block, @NotNull IElementType blockStopKeyword) {
            if (block == null) {
                PhpBlock.$$$reportNull$$$0(0);
            }
            if (blockStopKeyword == null) {
                PhpBlock.$$$reportNull$$$0(1);
            }
            this.myBlock = block;
            this.myBlockStopKeyword = blockStopKeyword;
        }

        @NotNull
        public PsiElement getBlock() {
            PsiElement psiElement = this.myBlock;
            if (psiElement == null) {
                PhpBlock.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @NotNull
        public IElementType getBlockStopKeyword() {
            IElementType iElementType = this.myBlockStopKeyword;
            if (iElementType == null) {
                PhpBlock.$$$reportNull$$$0(3);
            }
            return iElementType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockStopKeyword";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpInvertIfIntention$PhpBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpInvertIfIntention$PhpBlock";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlockStopKeyword";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

