/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.intentions.PhpExtractConditionIntention;
import com.jetbrains.php.lang.intentions.PhpMergeNestedConditionIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMergeElseIfIntention
extends PsiUpdateModCommandAction<PsiElement> {
    private static final PsiComment[] EMPTY_COMMENTS = new PsiComment[0];

    public PhpMergeElseIfIntention() {
        super(PsiElement.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Else anElse;
        if (context == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(1);
        }
        if ((anElse = PhpPsiUtil.getParentOfClass(element, Else.class)) == null) {
            return null;
        }
        If anIf = PhpMergeNestedConditionIntention.getInnerOnlyIf((PsiElement)anElse.getStatement());
        if (anIf == null || element.getParent() != anElse && element.getParent() != anIf) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName());
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Else anElse;
        if (context == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(4);
        }
        if ((anElse = PhpPsiUtil.getParentOfClass(element, Else.class)) == null) {
            return;
        }
        If innerIf = PhpMergeNestedConditionIntention.getInnerOnlyIf((PsiElement)anElse.getStatement());
        if (innerIf == null) {
            return;
        }
        Pair<ElseIf, PsiElement> createElseIfAnchors = PhpMergeElseIfIntention.createElseIfAnchors(innerIf);
        PhpMergeElseIfIntention.addCommentsToBody((ElseIf)createElseIfAnchors.first, PhpMergeElseIfIntention.getComments(anElse));
        PhpMergeElseIfIntention.replaceElseWithElseIfBranches(anElse, createElseIfAnchors);
    }

    private static PsiComment @NotNull [] getComments(Else anElse) {
        PhpPsiElement statement = anElse.getStatement();
        PsiComment[] psiCommentArray = (PsiComment[])ObjectUtils.notNull((Object)((PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)(statement instanceof GroupStatement ? statement : anElse), PsiComment.class)), (Object)EMPTY_COMMENTS);
        if (psiCommentArray == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(5);
        }
        return psiCommentArray;
    }

    private static void replaceElseWithElseIfBranches(Else anElse, Pair<ElseIf, PsiElement> createdBranchesAnchors) {
        if (createdBranchesAnchors.first == createdBranchesAnchors.second) {
            anElse.getParent().addBefore((PsiElement)createdBranchesAnchors.first, (PsiElement)anElse);
        } else {
            anElse.getParent().addRangeBefore((PsiElement)createdBranchesAnchors.first, (PsiElement)createdBranchesAnchors.second, (PsiElement)anElse);
        }
        anElse.delete();
    }

    private static void addCommentsToBody(@NotNull ElseIf elseIf, PsiComment @NotNull [] comments) {
        if (elseIf == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(6);
        }
        if (comments == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(7);
        }
        if (comments.length == 0) {
            return;
        }
        Statement statement = elseIf.getStatement();
        if (statement == null) {
            return;
        }
        PsiElement anchor = PhpMergeElseIfIntention.findAnchor(statement);
        PsiElement parent = anchor.getParent();
        anchor = parent.addBefore((PsiElement)comments[0], anchor);
        for (int i = 1; i < comments.length; ++i) {
            anchor = parent.addAfter((PsiElement)comments[i], anchor);
        }
    }

    @NotNull
    private static PsiElement findAnchor(Statement statement) {
        PsiElement lastChild = statement.getLastChild();
        if (statement instanceof GroupStatement && PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.chRBRACE)) {
            PsiElement firstStatement = (PsiElement)((GroupStatement)statement).statements().first();
            PsiElement psiElement = firstStatement != null ? firstStatement : lastChild;
            if (psiElement == null) {
                PhpMergeElseIfIntention.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        Statement statement2 = statement;
        if (statement2 == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(9);
        }
        return statement2;
    }

    @NotNull
    private static Pair<ElseIf, PsiElement> createElseIfAnchors(If anIf) {
        String textWithoutIfKeyword = PhpExtractConditionIntention.getTextAfterFirstChild((PsiElement)anIf);
        If createdIf = PhpPsiElementFactory.createPhpPsiFromText(anIf.getProject(), If.class, "if (true) {} elseif " + textWithoutIfKeyword);
        ElseIf[] elseIfBranches = createdIf.getElseIfBranches();
        ElseIf firstAnchor = elseIfBranches[0];
        Statement lastAnchor = PhpMergeElseIfIntention.getLastBranch(createdIf, elseIfBranches);
        Pair pair = Pair.create((Object)firstAnchor, (Object)lastAnchor);
        if (pair == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @NotNull
    public static Statement getLastBranch(If createdIf, ElseIf[] elseIfBranches) {
        Statement statement = (Statement)ObjectUtils.notNull((Object)createdIf.getElseBranch(), () -> Objects.requireNonNull((ElseIf)ArrayUtil.getLastElement((Object[])elseIfBranches)));
        if (statement == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(11);
        }
        return statement;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("merge.into.elseif", new Object[0]);
        if (string == null) {
            PhpMergeElseIfIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpMergeElseIfIntention";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseIf";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpMergeElseIfIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnchor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createElseIfAnchors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastBranch";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCommentsToBody";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

