/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.codeSmell.PhpTernaryExpressionCanBeReplacedWithConditionInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpExpressionWithoutClarifyingParenthesesInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpUnnecessaryParenthesesInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNegateExpressionIntention
extends PsiUpdateModCommandAction<PsiElement> {
    public PhpNegateExpressionIntention() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("negate.boolean.expression", new Object[0]);
        if (string == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        BinaryExpression expression;
        if (context == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(2);
        }
        if ((expression = PhpNegateExpressionIntention.getBinaryExpression(element)) == null) {
            return null;
        }
        PsiElement operation = expression.getOperation();
        if (operation == null) {
            return null;
        }
        String text = operation.getText();
        String invertedOperatorText = PhpNegateExpressionIntention.getInvertedOperatorText(text);
        if (invertedOperatorText == null) {
            return null;
        }
        return Presentation.of((String)PhpBundle.message("intention.name.replace.with", text, invertedOperatorText));
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        BinaryExpression binaryExpression;
        if (context == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(5);
        }
        if ((binaryExpression = PhpNegateExpressionIntention.getBinaryExpression(element)) == null) {
            return;
        }
        PsiElement topmostParent = PhpTernaryExpressionCanBeReplacedWithConditionInspection.skipParentParenthesis((PsiElement)binaryExpression).getParent();
        if (topmostParent instanceof UnaryExpression && PhpNegateExpressionIntention.isNegation((UnaryExpression)topmostParent)) {
            binaryExpression = (BinaryExpression)topmostParent.replace((PsiElement)binaryExpression);
        } else {
            PsiElement notUnaryExpression = PhpNegateExpressionIntention.createNotUnaryExpression(context.project(), (PsiElement)binaryExpression);
            PsiElement parent = binaryExpression.getParent();
            PsiElement unaryExpression = parent instanceof ParenthesizedExpression ? parent.replace(notUnaryExpression) : binaryExpression.replace(notUnaryExpression);
            binaryExpression = (BinaryExpression)PsiTreeUtil.findChildOfType((PsiElement)unaryExpression, BinaryExpression.class);
        }
        if (binaryExpression == null) {
            return;
        }
        PsiElement inverted = PhpNegateExpressionIntention.createInvertedExpression(binaryExpression, PhpNegateExpressionIntention.createInvertedOperation(binaryExpression.getOperation()));
        if (inverted == null) {
            return;
        }
        binaryExpression.replace(inverted);
    }

    private static BinaryExpression getBinaryExpression(@NotNull PsiElement element) {
        BinaryExpression expression;
        if (element == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(6);
        }
        if ((expression = PhpPsiUtil.getParentOfClass(element, false, BinaryExpression.class)) != null) {
            return expression;
        }
        UnaryExpression unaryExpression = PhpPsiUtil.getParentOfClass(element, false, UnaryExpression.class);
        if (unaryExpression != null && PhpNegateExpressionIntention.isNegation(unaryExpression)) {
            return (BinaryExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize((PsiElement)unaryExpression.getValue()), BinaryExpression.class);
        }
        return null;
    }

    public static boolean isNegation(UnaryExpression parent) {
        return PhpPsiUtil.isOfType(parent.getOperation(), PhpTokenTypes.opNOT);
    }

    @NotNull
    private static PsiElement createNotUnaryExpression(@NotNull Project project, PsiElement expression) {
        if (project == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(7);
        }
        if (expression instanceof ParenthesizedExpression) {
            return PhpNegateExpressionIntention.createNotUnaryExpression(project, (PsiElement)((ParenthesizedExpression)expression).getArgument());
        }
        if (expression instanceof UnaryExpression && PhpNegateExpressionIntention.isNegation((UnaryExpression)expression)) {
            PsiElement psiElement = PhpPsiUtil.unparenthesize((PsiElement)((UnaryExpression)expression).getValue());
            if (psiElement == null) {
                PhpNegateExpressionIntention.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        UnaryExpression notUnaryExpression = PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "!(" + expression.getText() + ")");
        if (PhpUnnecessaryParenthesesInspection.isParensUnnecessary((ParenthesizedExpression)notUnaryExpression.getValue())) {
            UnaryExpression unaryExpression = PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "!" + expression.getText());
            if (unaryExpression == null) {
                PhpNegateExpressionIntention.$$$reportNull$$$0(9);
            }
            return unaryExpression;
        }
        UnaryExpression unaryExpression = notUnaryExpression;
        if (unaryExpression == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(10);
        }
        return unaryExpression;
    }

    @Nullable
    private static PsiElement createInvertedExpression(@NotNull BinaryExpression expression, PsiElement invertedOperation) {
        if (expression == null) {
            PhpNegateExpressionIntention.$$$reportNull$$$0(11);
        }
        PsiElement left = expression.getLeftOperand();
        PsiElement right = expression.getRightOperand();
        if (Holder.LOGICAL_OPS.contains(expression.getOperationType())) {
            left = PhpExpressionWithoutClarifyingParenthesesInspection.wrapInParens(PhpNegateExpressionIntention.createInvertedExpression(left));
            right = PhpExpressionWithoutClarifyingParenthesesInspection.wrapInParens(PhpNegateExpressionIntention.createInvertedExpression(right));
        }
        if (left == null || right == null) {
            return null;
        }
        assert (invertedOperation != null) : expression.getText();
        String binaryExpressionText = String.format("%s %s %s", left.getText(), invertedOperation.getText(), right.getText());
        BinaryExpression invertedExpression = PhpPsiElementFactory.createPhpPsiFromText(expression.getProject(), BinaryExpression.class, binaryExpressionText);
        PhpNegateExpressionIntention.unwrapIfNecessary(invertedExpression.getLeftOperand());
        PhpNegateExpressionIntention.unwrapIfNecessary(invertedExpression.getRightOperand());
        return invertedExpression;
    }

    public static PsiElement unwrapIfNecessary(PsiElement element) {
        ParenthesizedExpression parenthesized;
        if (element instanceof ParenthesizedExpression && PhpUnnecessaryParenthesesInspection.isParensUnnecessary(parenthesized = (ParenthesizedExpression)element)) {
            return element.replace((PsiElement)parenthesized.extract());
        }
        return element;
    }

    @Nullable
    public static PsiElement createInvertedExpression(@Nullable PsiElement element) {
        PsiElement invertedOperation;
        if (element instanceof ParenthesizedExpression) {
            return PhpNegateExpressionIntention.createInvertedExpression((PsiElement)((ParenthesizedExpression)element).getArgument());
        }
        if (element instanceof BinaryExpression && (invertedOperation = PhpNegateExpressionIntention.createInvertedOperation(((BinaryExpression)element).getOperation())) != null) {
            return PhpNegateExpressionIntention.createInvertedExpression((BinaryExpression)element, invertedOperation);
        }
        if (PhpLangUtil.isTrue(element)) {
            return PhpPsiElementFactory.createConstantReference(element.getProject(), "false");
        }
        if (PhpLangUtil.isFalse(element)) {
            return PhpPsiElementFactory.createConstantReference(element.getProject(), "true");
        }
        return element != null ? PhpNegateExpressionIntention.createNotUnaryExpression(element.getProject(), element) : null;
    }

    @Nullable
    private static PsiElement createInvertedOperation(@Nullable PsiElement operation) {
        String invertedOperatorText;
        String string = invertedOperatorText = operation != null ? PhpNegateExpressionIntention.getInvertedOperatorText(operation.getText()) : null;
        if (invertedOperatorText == null) {
            return null;
        }
        BinaryExpression binaryExpression = PhpPsiElementFactory.createPhpPsiFromText(operation.getProject(), BinaryExpression.class, "$a " + invertedOperatorText + " $b");
        return binaryExpression.getOperation();
    }

    @Nullable
    @NlsSafe
    private static String getInvertedOperatorText(@NlsSafe String operationText) {
        Pair pair = (Pair)ContainerUtil.find(Holder.OUR_OPERATORS_PAIRS, t -> ((String)t.first).equals(operationText) || ((String)t.second).equals(operationText));
        if (pair == null) {
            return null;
        }
        return ((String)pair.first).equals(operationText) ? (String)pair.second : (String)pair.first;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpNegateExpressionIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpNegateExpressionIntention";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotUnaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNotUnaryExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createInvertedExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 11 -> new IllegalArgumentException(string);
        };
    }

    private static class Holder {
        private static final Collection<Pair<String, String>> OUR_OPERATORS_PAIRS = List.of(Pair.create((Object)"||", (Object)"&&"), Pair.create((Object)"and", (Object)"or"), Pair.create((Object)"&", (Object)"|"), Pair.create((Object)"===", (Object)"!=="), Pair.create((Object)"==", (Object)"!="), Pair.create((Object)">", (Object)"<="), Pair.create((Object)">=", (Object)"<"));
        private static final TokenSet LOGICAL_OPS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsLOGICAL_OPS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opBIT_AND, PhpTokenTypes.opBIT_OR})});

        private Holder() {
        }
    }
}

