/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.intentions.PhpStatementUtils;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReplaceIfWithSwitchIntention
extends PsiUpdateModCommandAction<PsiElement> {
    @Nls
    @IntentionName
    public static final String TEXT = PhpBundle.message("replace.if.with.switch", new Object[0]);

    public PhpReplaceIfWithSwitchIntention() {
        super(PsiElement.class);
    }

    protected boolean isElementApplicable(@NotNull PsiElement element, @NotNull ActionContext context) {
        if (element == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.kwIF)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof If)) {
            return false;
        }
        return PhpReplaceIfWithSwitchIntention.getConditionExpression((If)parent, PhpTokenTypes.opEQUAL, false) != null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(4);
        }
        If ifStatement = (If)element.getParent();
        assert (ifStatement != null);
        PsiElement caseExpression = PhpReplaceIfWithSwitchIntention.getConditionExpression(ifStatement, PhpTokenTypes.opEQUAL, true);
        assert (caseExpression != null);
        ArrayList<IfStatementBranch> branches = new ArrayList<IfStatementBranch>();
        SmartList ifStatementsToDelete = new SmartList();
        PhpReplaceIfWithSwitchIntention.collectBranches(ifStatement, caseExpression, branches, (List<If>)ifStatementsToDelete, PhpTokenTypes.opEQUAL);
        for (If ifStatementToDelete : ifStatementsToDelete) {
            ifStatementToDelete.delete();
        }
        PhpReplaceIfWithSwitchIntention.updateIfStatement(context.project(), ifStatement, caseExpression, branches);
    }

    @Nullable
    public static PsiElement getConditionExpression(@NotNull If ifStatement, IElementType allowedEqualityOperator, boolean checkSiblingIfs) {
        if (ifStatement == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(5);
        }
        PhpPsiElement condition = ifStatement.getCondition();
        List<PsiElement> possibleCaseExpressions = PhpReplaceIfWithSwitchIntention.determinePossibleCaseExpressions((PsiElement)condition, allowedEqualityOperator);
        for (PsiElement caseExpression : possibleCaseExpressions) {
            if (PhpSideEffectDetector.canContainSideEffect(caseExpression)) continue;
            If ifStatementToCheck = ifStatement;
            while (PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase((PsiElement)ifStatementToCheck.getCondition(), caseExpression, allowedEqualityOperator)) {
                ElseIf[] elseIfBranches;
                for (ElseIf elseIfBranch : elseIfBranches = ifStatementToCheck.getElseIfBranches()) {
                    if (PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase((PsiElement)elseIfBranch.getCondition(), caseExpression, allowedEqualityOperator)) continue;
                    return null;
                }
                Else elseBranch = ifStatementToCheck.getElseBranch();
                if (elseBranch != null && elseBranch.getStatement() instanceof If) {
                    ifStatementToCheck = (If)elseBranch.getStatement();
                    continue;
                }
                if (checkSiblingIfs && elseBranch == null && ifStatementToCheck.getNextPsiSibling() instanceof If) {
                    ifStatementToCheck = (If)ifStatementToCheck.getNextPsiSibling();
                    assert (ifStatementToCheck != null);
                    if (PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase((PsiElement)ifStatementToCheck.getCondition(), caseExpression, allowedEqualityOperator)) continue;
                    return caseExpression;
                }
                return caseExpression;
            }
        }
        return null;
    }

    public static void collectBranches(If ifStatement, PsiElement caseExpression, List<IfStatementBranch> branches, List<If> ifStatementsToDelete, IElementType allowedEqualityOperator) {
        If currentIfStatement = ifStatement;
        while (true) {
            ElseIf[] elseIfBranches;
            PhpReplaceIfWithSwitchIntention.createBranch(currentIfStatement, caseExpression, branches, allowedEqualityOperator);
            for (ElseIf elseIfBranch : elseIfBranches = currentIfStatement.getElseIfBranches()) {
                PhpReplaceIfWithSwitchIntention.createBranch(elseIfBranch, caseExpression, branches, allowedEqualityOperator);
            }
            Else elseBranch = currentIfStatement.getElseBranch();
            if (elseBranch != null) {
                PhpPsiElement elseBranchStatement = elseBranch.getStatement();
                if (elseBranchStatement instanceof If) {
                    currentIfStatement = (If)elseBranchStatement;
                    continue;
                }
                if (!(elseBranchStatement instanceof Statement)) break;
                IfStatementBranch elseIfBranch = new IfStatementBranch();
                elseIfBranch.setElse();
                elseIfBranch.setStatement((Statement)elseBranchStatement);
                branches.add(elseIfBranch);
                break;
            }
            PhpPsiElement nextSibling = currentIfStatement.getNextPsiSibling();
            if (!(nextSibling instanceof If) || !PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase((PsiElement)(currentIfStatement = (If)nextSibling).getCondition(), caseExpression, allowedEqualityOperator)) break;
            ifStatementsToDelete.add(currentIfStatement);
        }
    }

    @NotNull
    private static List<PsiElement> determinePossibleCaseExpressions(PsiElement condition, IElementType allowedEqualityOperator) {
        PsiElement expressionToCheck = PhpPsiUtil.unparenthesize(condition);
        SmartList possibleCaseExpressions = new SmartList();
        if (expressionToCheck instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expressionToCheck;
            IElementType operator = binaryExpression.getOperationType();
            PsiElement leftOperand = binaryExpression.getLeftOperand();
            PsiElement rightOperand = binaryExpression.getRightOperand();
            if (PhpLangUtil.isShortCircuitOrOperator(operator)) {
                return PhpReplaceIfWithSwitchIntention.determinePossibleCaseExpressions(leftOperand, allowedEqualityOperator);
            }
            if (operator == allowedEqualityOperator) {
                if (PhpReplaceIfWithSwitchIntention.canBeCaseLabel(leftOperand) && rightOperand != null) {
                    possibleCaseExpressions.add(rightOperand);
                }
                if (PhpReplaceIfWithSwitchIntention.canBeCaseLabel(rightOperand)) {
                    possibleCaseExpressions.add(leftOperand);
                }
            }
        }
        SmartList smartList = possibleCaseExpressions;
        if (smartList == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    private static boolean canBeMadeIntoCase(PsiElement condition, PsiElement caseExpression, IElementType allowedEqualityOperator) {
        PsiElement expressionToCheck = PhpPsiUtil.unparenthesize(condition);
        if (expressionToCheck instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expressionToCheck;
            IElementType operator = binaryExpression.getOperationType();
            PsiElement leftOperand = binaryExpression.getLeftOperand();
            PsiElement rightOperand = binaryExpression.getRightOperand();
            if (PhpLangUtil.isShortCircuitOrOperator(operator)) {
                return PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase(leftOperand, caseExpression, allowedEqualityOperator) && PhpReplaceIfWithSwitchIntention.canBeMadeIntoCase(rightOperand, caseExpression, allowedEqualityOperator);
            }
            if (operator == allowedEqualityOperator) {
                return PhpReplaceIfWithSwitchIntention.canBeCaseLabel(leftOperand) && rightOperand != null && PhpCodeEditUtil.isEquivalent(caseExpression, rightOperand) || PhpReplaceIfWithSwitchIntention.canBeCaseLabel(rightOperand) && leftOperand != null && PhpCodeEditUtil.isEquivalent(caseExpression, leftOperand);
            }
        }
        return false;
    }

    private static boolean canBeCaseLabel(PsiElement expression) {
        return expression != null && PhpCodeValidationUtil.isAllowedAsConstantValue(expression);
    }

    private static void createBranch(ControlStatement ifStatement, PsiElement caseExpression, List<IfStatementBranch> branches, IElementType allowedEqualityOperator) {
        ArrayList<PsiElement> labels = new ArrayList<PsiElement>();
        PhpPsiElement condition = ifStatement.getCondition();
        PhpReplaceIfWithSwitchIntention.collectLabels((PsiElement)condition, caseExpression, labels, allowedEqualityOperator);
        IfStatementBranch ifBranch = new IfStatementBranch();
        for (PsiElement label : labels) {
            ifBranch.addLabel(label.getText());
        }
        ifBranch.setStatement(ifStatement.getStatement());
        branches.add(ifBranch);
    }

    private static void collectLabels(PsiElement condition, PsiElement caseExpression, List<PsiElement> labels, IElementType allowedEqualityOperator) {
        PsiElement expressionToCheck = PhpPsiUtil.unparenthesize(condition);
        if (expressionToCheck instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expressionToCheck;
            IElementType operator = binaryExpression.getOperationType();
            PsiElement leftOperand = binaryExpression.getLeftOperand();
            PsiElement rightOperand = binaryExpression.getRightOperand();
            if (PhpLangUtil.isShortCircuitOrOperator(operator)) {
                PhpReplaceIfWithSwitchIntention.collectLabels(leftOperand, caseExpression, labels, allowedEqualityOperator);
                PhpReplaceIfWithSwitchIntention.collectLabels(rightOperand, caseExpression, labels, allowedEqualityOperator);
            } else if (operator == allowedEqualityOperator && leftOperand != null && rightOperand != null) {
                if (PhpCodeEditUtil.isEquivalent(caseExpression, rightOperand)) {
                    labels.add(leftOperand);
                } else {
                    labels.add(rightOperand);
                }
            }
        }
    }

    private static void updateIfStatement(@NotNull Project project, If ifStatement, PsiElement caseExpression, List<IfStatementBranch> branches) {
        if (project == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(7);
        }
        StringBuilder switchStatementText = new StringBuilder(1024);
        switchStatementText.append("switch(").append(caseExpression.getText()).append(')').append('{');
        for (IfStatementBranch branch : branches) {
            Statement statement = branch.getStatement();
            if (!branch.isDefault()) {
                List<String> labels = branch.getValues();
                PhpReplaceIfWithSwitchIntention.dumpBranch(switchStatementText, labels, statement);
                continue;
            }
            PhpReplaceIfWithSwitchIntention.dumpDefaultBranch(switchStatementText, statement);
        }
        switchStatementText.append('}');
        String switchStatementString = switchStatementText.toString();
        Statement switchStatement = PhpPsiElementFactory.createStatement(project, switchStatementString);
        ifStatement.replace((PsiElement)switchStatement);
    }

    private static void dumpBranch(StringBuilder switchStatementString, List<String> labels, Statement body) {
        PhpReplaceIfWithSwitchIntention.dumpLabels(switchStatementString, labels);
        PhpReplaceIfWithSwitchIntention.dumpBody(switchStatementString, body);
    }

    private static void dumpLabels(StringBuilder switchStatementString, List<String> labels) {
        for (String label : labels) {
            switchStatementString.append("case ").append(label).append(":");
        }
    }

    private static void dumpDefaultBranch(StringBuilder switchStatementString, Statement body) {
        switchStatementString.append("default: ");
        PhpReplaceIfWithSwitchIntention.dumpBody(switchStatementString, body);
    }

    private static void dumpBody(StringBuilder switchStatementString, Statement bodyStatement) {
        if (bodyStatement instanceof GroupStatement && PhpPsiUtil.isOfType(bodyStatement.getFirstChild(), PhpTokenTypes.chLBRACE)) {
            for (PsiElement s = bodyStatement.getFirstChild(); s != null; s = s.getNextSibling()) {
                if (PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE)) continue;
                PhpReplaceIfWithSwitchIntention.appendElement(switchStatementString, s);
            }
        } else {
            PhpReplaceIfWithSwitchIntention.appendElement(switchStatementString, (PsiElement)bodyStatement);
        }
        if (PhpStatementUtils.statementMayCompleteNormally(bodyStatement)) {
            switchStatementString.append("break;");
        }
    }

    private static void appendElement(StringBuilder switchStatementString, PsiElement element) {
        if (element instanceof PhpBreak) {
            Integer identifier;
            PhpBreak breakStatement = (PhpBreak)element;
            PsiElement label = breakStatement.getArgument();
            Integer n = identifier = label != null ? PhpCodeInsightUtil.toInt(label) : null;
            if (identifier == null && label != null) {
                switchStatementString.append("break ").append(label.getText()).append(" + 1;");
            } else {
                int newIdentifier = identifier != null ? identifier + 1 : 2;
                switchStatementString.append("break ").append(newIdentifier).append(";");
            }
        } else {
            PsiElement child = element.getFirstChild();
            if (child != null) {
                while (child != null) {
                    PhpReplaceIfWithSwitchIntention.appendElement(switchStatementString, child);
                    child = child.getNextSibling();
                }
            } else {
                switchStatementString.append(element.getText());
            }
        }
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceIfWithSwitchIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithSwitchIntention";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceIfWithSwitchIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "determinePossibleCaseExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isElementApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConditionExpression";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateIfStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }

    public static class IfStatementBranch
    implements ControlStatementBranch {
        private final List<String> labels = new ArrayList<String>();
        private Statement statement;
        private boolean isElse;

        public void addLabel(String label) {
            this.labels.add(label);
        }

        public void setStatement(Statement statement) {
            this.statement = statement;
        }

        public Statement getStatement() {
            return this.statement;
        }

        @Override
        public PsiElement getOnlyBodyStatement() {
            return this.statement instanceof GroupStatement ? ((GroupStatement)this.statement).getOnlyStatement() : this.statement;
        }

        @Override
        public List<String> getValues() {
            return Collections.unmodifiableList(this.labels);
        }

        @Override
        public boolean isDefault() {
            return this.isElse;
        }

        public void setElse() {
            this.isElse = true;
        }
    }

    public static interface ControlStatementBranch {
        public PsiElement getOnlyBodyStatement();

        public List<String> getValues();

        public boolean isDefault();
    }
}

