/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReplaceTernaryWithIfIntention
extends PsiUpdateModCommandAction<TernaryExpression> {
    public PhpReplaceTernaryWithIfIntention() {
        super(TernaryExpression.class);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull TernaryExpression ternaryExpression, @NotNull ModPsiUpdater updater) {
        Statement currentStatement;
        if (context == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(0);
        }
        if (ternaryExpression == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(2);
        }
        PhpPsiElement trueVariant = ternaryExpression.getTrueVariant();
        PhpPsiElement falseVariant = ternaryExpression.getFalseVariant();
        PhpPsiElement condition = ternaryExpression.getCondition();
        if (trueVariant != null && falseVariant != null && condition != null && (currentStatement = PhpPsiUtil.getParentOfClass((PsiElement)ternaryExpression, Statement.class)) != null) {
            int statementStart = currentStatement.getTextOffset();
            int ternaryStart = ternaryExpression.getTextOffset() - statementStart;
            int ternaryLength = ternaryExpression.getTextLength();
            String statementText = currentStatement.getText();
            int ternaryEnd = ternaryStart + ternaryLength;
            String arg = "if (" + condition.getText() + ") { " + statementText.substring(0, ternaryStart) + trueVariant.getText() + statementText.substring(ternaryEnd);
            arg = arg + " } else {" + statementText.substring(0, ternaryStart) + falseVariant.getText() + statementText.substring(ternaryEnd) + "}";
            If newElement = PhpPsiElementFactory.createFirstFromText(context.project(), If.class, arg);
            if (newElement != null) {
                currentStatement.replace((PsiElement)newElement);
            }
        }
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull TernaryExpression ternaryExpression) {
        if (context == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(3);
        }
        if (ternaryExpression == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(4);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable((PsiElement)ternaryExpression)) {
            return null;
        }
        Statement statement = PhpPsiUtil.getParentOfClass((PsiElement)ternaryExpression, Statement.class);
        if (statement == null || statement instanceof GroupStatement || PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.kwCONST)) {
            return null;
        }
        return Presentation.of((String)PhpReplaceTernaryWithIfIntention.getTitle());
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("replace.ternary.expression.with.if.clause", new Object[0]);
        if (string == null) {
            PhpReplaceTernaryWithIfIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @IntentionName
    public static String getTitle() {
        return PhpBundle.message("intention.replace.ternary.expression.with.if", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ternaryExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceTernaryWithIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceTernaryWithIfIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

