/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.library.PhpEmbeddedStubsNotificationProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.util.PhpStringUtil;
import java.text.SimpleDateFormat;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpShowDateTimeExampleOutputIntention
extends PsiBasedModCommandAction<PsiElement>
implements HighPriorityAction {
    private static final SimpleDateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat RFC_2822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
    private static final Set<String> STD_FORMAT_FUNCTION = Set.of("date", "idate", "gmdate", "strftime", "gmstrftime", "date_create_immutable_from_format", "date_create_from_format", "date_parse_from_format", "date_format", "date_interval_format", "format");

    public PhpShowDateTimeExampleOutputIntention() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.show.example.date.time.output", new Object[0]);
        if (string == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiElement element) {
        String formatString;
        if (context == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(2);
        }
        if ((formatString = PhpShowDateTimeExampleOutputIntention.computeFormatString(element)) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(3);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.info((String)formatString);
        if (modCommand == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(4);
        }
        return modCommand;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(6);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element) || PhpShowDateTimeExampleOutputIntention.computeFormatString(element) == null) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName());
    }

    @NlsSafe
    @Nullable
    private static String computeFormatString(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        ClassConstantReference classConstantReference = PhpPsiUtil.getParentOfClass(element, ClassConstantReference.class);
        if (classConstantReference != null) {
            return PhpShowDateTimeExampleOutputIntention.tryToComputeFormatString(classConstantReference);
        }
        ConstantReference constantReference = PhpPsiUtil.getParentOfClass(element, ConstantReference.class);
        if (constantReference != null) {
            return PhpShowDateTimeExampleOutputIntention.tryToComputeFormatString(constantReference);
        }
        StringLiteralExpression string = PhpPsiUtil.getParentOfClass(element, StringLiteralExpression.class);
        if (string == null) {
            return null;
        }
        if (PhpPsiUtil.getChildOfClass((PsiElement)string, Variable.class) != null) {
            return null;
        }
        if (!PhpShowDateTimeExampleOutputIntention.isSuitableFormatPlace(string)) {
            return null;
        }
        return PhpShowDateTimeExampleOutputIntention.computeDateTimeExampleOutput(element.getProject(), PhpStringUtil.unescapeText(string));
    }

    public static boolean isSuitableFormatPlace(StringLiteralExpression string) {
        ParameterListOwner plo;
        int index = PhpCodeInsightUtil.getParameterIndex((PsiElement)string);
        if (index >= 0 && (plo = PhpPsiUtil.getParentOfClass((PsiElement)string, ParameterListOwner.class)) instanceof FunctionReference) {
            return PhpShowDateTimeExampleOutputIntention.isStdFunctionFormatArgument(index, (FunctionReference)plo);
        }
        return false;
    }

    private static boolean isStdFunctionFormatArgument(int parameterIndex, FunctionReference functionCall) {
        return ContainerUtil.exists((Iterable)functionCall.multiResolveStrict(Function.class), function -> {
            if (PhpLangUtil.isGlobalNamespaceFQN(function.getNamespaceName()) && !STD_FORMAT_FUNCTION.contains(function.getName()) && PhpEmbeddedStubsNotificationProvider.isStubsFile(function.getContainingFile().getVirtualFile())) {
                return false;
            }
            return PhpShowDateTimeExampleOutputIntention.isFormatParameter(parameterIndex, function);
        });
    }

    private static boolean isFormatParameter(int parameterIndex, @NotNull Function function) {
        Parameter parameter;
        if (function == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(7);
        }
        return (parameter = function.getParameter(parameterIndex)) != null && PhpLangUtil.equalsParameterNames(parameter.getName(), "format");
    }

    private static String tryToComputeFormatString(ClassConstantReference reference) {
        String defaultValue = (String)ContainerUtil.getOnlyItem((Collection)ContainerUtil.map2Set(reference.multiResolveStrict(Field.class), e -> e.getDefaultValuePresentation()));
        return PhpShowDateTimeExampleOutputIntention.tryToComputeFormatStringFromDefaultValue(reference.getProject(), defaultValue);
    }

    private static String tryToComputeFormatString(ConstantReference reference) {
        String defaultValue = (String)ContainerUtil.getOnlyItem((Collection)ContainerUtil.map2Set((Collection)reference.multiResolveStrict(Constant.class), e -> e.getValuePresentation()));
        return PhpShowDateTimeExampleOutputIntention.tryToComputeFormatStringFromDefaultValue(reference.getProject(), defaultValue);
    }

    private static String tryToComputeFormatStringFromDefaultValue(Project project, String defaultValue) {
        if (defaultValue != null && StringUtil.isQuotedString((String)defaultValue)) {
            return PhpShowDateTimeExampleOutputIntention.computeDateTimeExampleOutput(project, StringUtil.unquoteString((String)defaultValue));
        }
        return null;
    }

    @Nullable
    private static String computeDateTimeExampleOutput(@NotNull Project project, String contents) {
        if (project == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(8);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return PhpShowDateTimeExampleOutputIntention.computeDateTimeExampleOutput(project, contents, calendar);
    }

    @Nullable
    public static String computeDateTimeExampleOutput(@NotNull Project project, String contents, Calendar calendar) {
        if (project == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(9);
        }
        if (contents.length() > 100) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < contents.length(); ++i) {
            char c = contents.charAt(i);
            if (c == '\\' && i < contents.length() - 1) {
                res.append(contents.charAt(++i));
                continue;
            }
            res.append(PhpShowDateTimeExampleOutputIntention.getJavaSimpleDatePattern(project, c, calendar));
        }
        return res.toString();
    }

    private static String getJavaSimpleDatePattern(Project project, int c, Calendar calendar) {
        return switch (c) {
            case 100 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "dd");
            case 68 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "EEE");
            case 106 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "d");
            case 108 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "EEEE");
            case 78 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "u");
            case 83 -> PhpShowDateTimeExampleOutputIntention.getEnglishSuffix(calendar.get(5));
            case 119 -> String.valueOf(calendar.get(7) - 1);
            case 122 -> String.valueOf(calendar.get(6) - 1);
            case 87 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "w");
            case 70 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "MMMM");
            case 109 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "MM");
            case 77 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "MMM");
            case 110 -> StringUtil.trimStart((String)PhpShowDateTimeExampleOutputIntention.format(calendar, "MM"), (String)"0");
            case 116 -> String.valueOf(YearMonth.of(calendar.get(1), calendar.get(2)).lengthOfMonth());
            case 76 -> {
                if (Year.isLeap(calendar.get(1))) {
                    yield "1";
                }
                yield "0";
            }
            case 89, 111 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "YYYY");
            case 120 -> {
                if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP820)) {
                    yield PhpShowDateTimeExampleOutputIntention.format(calendar, "YYYY");
                }
                yield Character.toString(c);
            }
            case 88 -> {
                if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP820)) {
                    yield "+" + PhpShowDateTimeExampleOutputIntention.format(calendar, "YYYY");
                }
                yield Character.toString(c);
            }
            case 121 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "YY");
            case 97 -> StringUtil.toLowerCase((String)PhpShowDateTimeExampleOutputIntention.format(calendar, "a"));
            case 65 -> StringUtil.toUpperCase((String)PhpShowDateTimeExampleOutputIntention.format(calendar, "a"));
            case 66 -> String.valueOf(PhpShowDateTimeExampleOutputIntention.getSwatchTime(calendar));
            case 103 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "h");
            case 71 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "H");
            case 104 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "hh");
            case 72 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "HH");
            case 105 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "mm");
            case 115 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "ss");
            case 117 -> String.format("%06d", calendar.getTimeInMillis() % 100000L);
            case 118 -> String.format("%03d", calendar.getTimeInMillis() % 100L);
            case 101 -> calendar.getTimeZone().toZoneId().toString();
            case 73 -> {
                if (calendar.getTimeZone().inDaylightTime(calendar.getTime())) {
                    yield "1";
                }
                yield "0";
            }
            case 79 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "Z");
            case 80 -> PhpShowDateTimeExampleOutputIntention.getGMT(calendar);
            case 112 -> {
                if (PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP800)) {
                    yield PhpShowDateTimeExampleOutputIntention.getGMT(calendar);
                }
                yield Character.toString(c);
            }
            case 84 -> PhpShowDateTimeExampleOutputIntention.format(calendar, "zzz");
            case 90 -> String.valueOf(ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()).getOffset().getTotalSeconds());
            case 99 -> PhpShowDateTimeExampleOutputIntention.addColonToGMT(ISO_8601.format(calendar.getTime()));
            case 114 -> RFC_2822.format(calendar.getTime());
            case 85 -> String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTime().getTime()));
            default -> Character.toString(c);
        };
    }

    @NotNull
    private static String getGMT(Calendar calendar) {
        return PhpShowDateTimeExampleOutputIntention.addColonToGMT(PhpShowDateTimeExampleOutputIntention.format(calendar, "Z"));
    }

    @NotNull
    private static String addColonToGMT(String s) {
        if (s.length() >= 4) {
            String string = s.substring(0, s.length() - 2) + ":" + s.substring(s.length() - 2);
            if (string == null) {
                PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String format(Calendar calendar, String mm) {
        String string = new SimpleDateFormat(mm).format(calendar.getTime());
        if (string == null) {
            PhpShowDateTimeExampleOutputIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static int getSwatchTime(Calendar calendar) {
        long sse = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
        long retval = (sse - (sse - (sse % 86400L + 3600L))) * 10L;
        if (retval < 0L) {
            retval += 864000L;
        }
        return (int)(retval / 864L % 1000L);
    }

    private static String getEnglishSuffix(int number) {
        if (number >= 10 && number <= 19) {
            return "th";
        }
        return switch (number % 10) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpShowDateTimeExampleOutputIntention";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpShowDateTimeExampleOutputIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addColonToGMT";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFormatParameter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeDateTimeExampleOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

