/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.array;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.intentions.array.OffsetPair;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpConvertArraySyntaxBase
extends PsiUpdateModCommandAction<PsiElement> {
    public PhpConvertArraySyntaxBase() {
        super(PsiElement.class);
    }

    public static PsiElement changeSyntax(ArrayCreationExpression expression) {
        if (expression.isShortSyntax()) {
            PsiElement rightBracket = expression.getLastChild();
            PsiElement leftBracket = expression.getFirstChild();
            PsiElement arrayKw = PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.kwARRAY, "array");
            PsiElement lparen = PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.chLPAREN, "(");
            PsiElement rparen = PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.chRPAREN, ")");
            expression.addBefore(arrayKw, leftBracket);
            leftBracket.replace(lparen);
            rightBracket.replace(rparen);
        } else {
            PsiElement arrayKw = expression.getFirstChild();
            if (arrayKw != null) {
                PsiElement lParen = PhpPsiUtil.getNextSiblingIgnoreWhitespace(arrayKw, true);
                PsiElement rParen = expression.getLastChild();
                if (rParen != null && lParen != null) {
                    rParen.replace(PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.chRBRACKET, "]"));
                    lParen.replace(PhpPsiElementFactory.createFromText(expression.getProject(), PhpTokenTypes.chLBRACKET, "["));
                    arrayKw.delete();
                }
            }
        }
        return expression;
    }

    abstract boolean isAvailable(PsiElement var1);

    public abstract int getLeftStartOffset(PsiElement var1);

    public abstract int getRightStartOffset(PsiElement var1);

    public abstract int getEndOffset(PsiElement var1);

    public abstract String openStringToInsert();

    abstract String closeStringToInsert();

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(2);
        }
        this.invokeWithStrategy(context.project(), element, true);
    }

    public void invokeWithStrategy(Project project, PsiElement element, boolean isRecursive) {
        ArrayCreationExpression arrayCreationExpression = PhpPsiUtil.getParentOfClass(element, false, ArrayCreationExpression.class);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = element.getContainingFile().getViewProvider().getDocument();
        if (arrayCreationExpression != null && this.isAvailable((PsiElement)arrayCreationExpression)) {
            if (isRecursive) {
                this.collectAllNestedArrays(arrayCreationExpression).forEach(it -> PhpConvertArraySyntaxBase.changeSyntax(it));
            } else {
                this.singleReplace(document, documentManager, (PsiElement)arrayCreationExpression);
            }
        }
    }

    private List<ArrayCreationExpression> collectAllNestedArrays(ArrayCreationExpression arrayCreationExpression) {
        final ArrayList<ArrayCreationExpression> offsetPairs = new ArrayList<ArrayCreationExpression>();
        arrayCreationExpression.accept(new PhpRecursiveElementVisitor(){

            @Override
            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                if (PhpConvertArraySyntaxBase.this.isAvailable((PsiElement)expression)) {
                    offsetPairs.add(expression);
                }
                super.visitPhpArrayCreationExpression(expression);
            }
        });
        return offsetPairs;
    }

    public void makeReplaces(Document document, List<OffsetPair> offsetPairs) {
        int sumOffset = 0;
        for (OffsetPair it : offsetPairs) {
            this.makeUncommittedReplace(document, it.myOffsetTriple.leftStartOffset - sumOffset, it.myOffsetTriple.rightStartOffset - sumOffset, it.myOffsetTriple.endOffset - sumOffset);
            sumOffset += it.myOffsetTriple.getCalculatedOffset(this);
        }
    }

    protected void singleReplace(Document document, PsiDocumentManager documentManager, PsiElement arrayCreationExpression) {
        int endOffset = this.getEndOffset(arrayCreationExpression);
        int leftStartOffset = this.getLeftStartOffset(arrayCreationExpression);
        int rightStartOffset = this.getRightStartOffset(arrayCreationExpression);
        if (document != null && this.makeUncommittedReplace(document, leftStartOffset, rightStartOffset, endOffset)) {
            documentManager.commitDocument(document);
        }
    }

    public boolean makeUncommittedReplace(Document document, int leftStartOffset, int rightStartOffset, int endOffset) {
        if (endOffset > -1 && leftStartOffset > -1 && rightStartOffset > -1 && document.getTextLength() >= endOffset && document.getTextLength() > rightStartOffset && document.getTextLength() >= leftStartOffset) {
            int totalOffset = rightStartOffset - leftStartOffset - this.openStringToInsert().length();
            document.replaceString(leftStartOffset, rightStartOffset, (CharSequence)this.openStringToInsert());
            document.replaceString(endOffset - totalOffset, endOffset - totalOffset + 1, (CharSequence)this.closeStringToInsert());
            return true;
        }
        return false;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        ArrayCreationExpression expression;
        if (context == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpConvertArraySyntaxBase.$$$reportNull$$$0(4);
        }
        if ((expression = PhpPsiUtil.getParentOfClass(element, ArrayCreationExpression.class)) != null && this.isAvailable((PsiElement)expression)) {
            return Presentation.of((String)this.getFamilyName());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/intentions/array/PhpConvertArraySyntaxBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

