/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.changeVisibility;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureHandler;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class PhpChangeVisibilityIntentionBase
extends BaseElementAtCaretIntentionAction {
    private static final String ALL_FIELDS_IN_LIST = "All fields";
    private static final String CURRENT_METHOD_TEXT = "Current Method only";
    private static boolean ourChangeAllFields;

    @TestOnly
    public static void setChangeAllFields(boolean changeAllFields) {
        ourChangeAllFields = changeAllFields;
    }

    @NotNull
    @NlsSafe
    protected abstract PhpModifier.Access getTargetAccess();

    protected boolean isChangingSetVisibility() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpClassMember targetElement;
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(2);
        }
        if ((targetElement = PhpChangeVisibilityIntentionBase.getTargetElement(element)) == null) {
            return;
        }
        if (targetElement instanceof Method) {
            this.changeAccess(project, editor, (Method)targetElement);
        } else if (targetElement instanceof PhpPromotedFieldParameterImpl) {
            this.changeAccess(project, (PhpPromotedFieldParameterImpl)targetElement);
        } else if (targetElement instanceof Field) {
            PhpClassFieldsList fieldsList = PhpPsiUtil.getParentOfClass((PsiElement)targetElement, PhpClassFieldsList.class);
            if (fieldsList == null) {
                return;
            }
            Collection<Field> allFieldsInList = fieldsList.getFields();
            if (allFieldsInList.size() > 1) {
                this.changeAccessViaPopup(editor, (Field)targetElement, fieldsList, allFieldsInList);
            } else {
                this.changeAccess((Field)targetElement);
            }
        }
    }

    public void changeAccess(@NotNull Project project, @NotNull PhpPromotedFieldParameterImpl promotedProperty) {
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(3);
        }
        if (promotedProperty == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(4);
        }
        Runnable callback = () -> {
            List<PsiElement> tokens = PhpPsiUtil.getChildrenOfType((PsiElement)promotedProperty, PhpTokenTypes.tsVISIBILITY_MODIFIERS);
            PsiElement visibilityToken = (PsiElement)ContainerUtil.find(tokens, it -> this.isChangingSetVisibility() == PhpModifierListImpl.isSetOperationModifier(it));
            if (visibilityToken == null || !PhpQuickFixBase.ensureFileWritableInQuickFix(project, visibilityToken.getContainingFile().getVirtualFile())) {
                return;
            }
            if (IntentionPreviewUtils.isPreviewElement((PsiElement)promotedProperty)) {
                visibilityToken.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.tsVISIBILITY_MODIFIERS, String.format("function a(%s $a){}", new Object[]{this.getTargetAccess()})));
            } else {
                WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> visibilityToken.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.tsVISIBILITY_MODIFIERS, String.format("function a(%s $a){}", new Object[]{this.getTargetAccess()}))), (PsiFile[])new PsiFile[0]);
            }
        };
        if (!this.checkConflicts(project, promotedProperty.getPromotedFieldAccess(), Collections.singleton(promotedProperty), callback)) {
            callback.run();
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        List<PsiElement> tokens;
        PsiElement visibilityModifier;
        Object modifierList;
        PhpClassMember targetElement;
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(7);
        }
        if ((targetElement = PhpChangeVisibilityIntentionBase.getTargetElement(file.findElementAt(editor.getCaretModel().getOffset()))) instanceof Field && !(targetElement instanceof PhpPromotedFieldParameterImpl)) {
            targetElement = targetElement.getParent();
        }
        if ((modifierList = PhpPsiUtil.getChildByCondition((PsiElement)targetElement, (Condition<? super PsiElement>)((Condition)PhpModifierList.class::isInstance))) != null) {
            targetElement = modifierList;
        }
        if ((visibilityModifier = (PsiElement)ContainerUtil.find(tokens = PhpPsiUtil.getChildrenOfType((PsiElement)targetElement, PhpTokenTypes.tsVISIBILITY_MODIFIERS), it -> this.isChangingSetVisibility() == PhpModifierListImpl.isSetOperationModifier(it))) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }
        visibilityModifier.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.tsVISIBILITY_MODIFIERS, "class a {" + this.getTargetAccess() + " $a}"));
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(9);
        }
        return intentionPreviewInfo;
    }

    public void changeAccess(@NotNull Field element) {
        PhpClassFieldsList fieldsList;
        if (element == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(10);
        }
        if ((fieldsList = PhpPsiUtil.getParentOfClass(element, PhpClassFieldsList.class)) == null) {
            return;
        }
        Collection<Field> allFieldsInList = fieldsList.getFields();
        this.changeAccess(element, fieldsList, allFieldsInList);
    }

    public void weakenAccess(@NotNull Field field) {
        PhpClassFieldsList fieldsList;
        if (field == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(11);
        }
        if ((fieldsList = PhpPsiUtil.getParentOfClass(field, PhpClassFieldsList.class)) == null) {
            return;
        }
        Collection<Field> allFieldsInList = fieldsList.getFields();
        PhpModifier modifier = Objects.requireNonNull((Field)ContainerUtil.getFirstItem(allFieldsInList)).getModifier();
        Project project = fieldsList.getProject();
        if (modifier.getAccess().isWeakerThan(this.getTargetAccess())) {
            throw new IllegalArgumentException("New access must be weaker");
        }
        if (allFieldsInList.size() > 1) {
            PhpPsiElement changedFieldsList = this.copyFieldAndChangeAccess(field, field.getName(), PhpChangeVisibilityIntentionBase.getDefaultValueText(field));
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
            fieldsList.getParent().addAfter((PsiElement)changedFieldsList, (PsiElement)fieldsList);
            return;
        }
        if (PhpPsiUtil.isOfType((PsiElement)fieldsList, PhpElementTypes.CLASS_CONSTANTS)) {
            PhpModifierList modifierList = PhpPsiElementFactory.createModifierList(project, PhpModifier.instance(this.getTargetAccess(), modifier.getAbstractness(), PhpModifier.State.DYNAMIC));
            PsiElement modifierListChild = PhpPsiUtil.getChildOfType((PsiElement)fieldsList, PhpElementTypes.MODIFIER_LIST);
            PsiElement firstChild = PhpPsiUtil.getChildOfType((PsiElement)fieldsList, PhpTokenTypes.kwCONST);
            if (modifierListChild != null) {
                modifierListChild.replace((PsiElement)modifierList);
            } else if (firstChild != null) {
                fieldsList.addBefore((PsiElement)modifierList, firstChild);
            }
            return;
        }
        PsiElement modifierListChild = PhpPsiUtil.getChildOfType((PsiElement)fieldsList, PhpElementTypes.MODIFIER_LIST);
        if (modifierListChild instanceof PhpModifierList) {
            PhpModifierList list = (PhpModifierList)modifierListChild;
            PhpModifierList changedModifierList = PhpPsiElementFactory.createModifierList(fieldsList.getProject(), PhpModifier.instance(this.getTargetAccess(), modifier.getAbstractness(), modifier.getState()));
            if (list.hasReadonly()) {
                changedModifierList.add(PhpPsiElementFactory.createFromText(fieldsList.getProject(), PhpTokenTypes.IDENTIFIER, "readonly"));
            }
            list.replace((PsiElement)changedModifierList);
        }
    }

    public void changeAccess(@NotNull Project project, @NotNull Editor editor, @NotNull Method currentMethod) {
        Method superMethod;
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(13);
        }
        if (currentMethod == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(14);
        }
        if (this.isAvailable(superMethod = PhpChangeSignatureUsageSearcher.findDeepestSuperMethod(currentMethod, currentMethod.getMethodType(false) == Method.MethodType.CONSTRUCTOR))) {
            String containingName = superMethod.getContainingClass() != null ? superMethod.getContainingClass().getName() : superMethod.getContainingFile().getName();
            JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(CURRENT_METHOD_TEXT, "Method in parent " + containingName + " and its descendants")).setTitle(PhpBundle.message("target", new Object[0])).setMovable(true).setResizable(false).setRequestFocus(true).setItemChosenCallback(option -> this.doChangeAccess(project, editor, StringUtil.equals((CharSequence)CURRENT_METHOD_TEXT, (CharSequence)option) ? currentMethod : superMethod)).createPopup().showInBestPositionFor(editor);
        } else {
            this.doChangeAccess(project, editor, currentMethod);
        }
    }

    public void doChangeAccess(@NotNull Project project, @Nullable Editor editor, @NotNull Method method) {
        String errorMessage;
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(15);
        }
        if (method == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(16);
        }
        if (StringUtil.isNotEmpty((String)(errorMessage = PhpChangeSignatureHandler.refactorStatus(project, method)))) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)this.getFamilyName(), null);
            return;
        }
        new PhpChangeSignatureProcessor(project, new PhpMethodDescriptor(method), this.getTargetAccess().toString(), method.getName(), PhpChangeVisibilityIntentionBase.getReturnType(method), PhpChangeVisibilityIntentionBase.getParametersInfo(method), Collections.emptySet(), false, false).run();
    }

    private static PhpParameterInfo @NotNull [] getParametersInfo(@NotNull Method method) {
        if (method == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(17);
        }
        Parameter[] parameters = method.getParameters();
        PhpParameterInfo[] infos = new PhpParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            infos[i] = new PhpParameterInfo(i, parameters[i]);
        }
        if (infos == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(18);
        }
        return infos;
    }

    private void changeAccessViaPopup(@NotNull Editor editor, @NotNull Field selectedField, @NotNull PhpPsiElement fieldsList, @NotNull Collection<Field> allFieldsInList) {
        if (editor == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(19);
        }
        if (selectedField == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(20);
        }
        if (fieldsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(21);
        }
        if (allFieldsInList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.changeAccess(!ourChangeAllFields ? selectedField : null, fieldsList, allFieldsInList);
            return;
        }
        SmartList highlighters = new SmartList();
        JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList("Only '" + selectedField.getName() + "'", ALL_FIELDS_IN_LIST)).setItemSelectedCallback(arg_0 -> PhpChangeVisibilityIntentionBase.lambda$changeAccessViaPopup$5(editor, selectedField, fieldsList, (List)highlighters, arg_0)).setTitle(PhpBundle.message("expressions", new Object[0])).setMovable(true).setResizable(false).setRequestFocus(true).setItemChosenCallback(option -> this.changeAccess(!StringUtil.equals((CharSequence)ALL_FIELDS_IN_LIST, (CharSequence)option) ? selectedField : null, fieldsList, allFieldsInList)).addListener(new JBPopupListener(){
            final /* synthetic */ List val$highlighters;
            {
                this.val$highlighters = list;
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpChangeVisibilityIntentionBase.dropHighlighters(this.val$highlighters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/lang/intentions/changeVisibility/PhpChangeVisibilityIntentionBase$1", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    private static void handleHighlighting(String option, Editor editor, PhpClassMember targetElement, PhpPsiElement classFieldsList, List<RangeHighlighter> highlighters) {
        if (option == null) {
            return;
        }
        PhpChangeVisibilityIntentionBase.dropHighlighters(highlighters);
        if (StringUtil.equals((CharSequence)ALL_FIELDS_IN_LIST, (CharSequence)option)) {
            highlighters.add(PhpChangeVisibilityIntentionBase.addRangeHighlighter(editor, (PsiElement)classFieldsList));
        } else {
            highlighters.add(PhpChangeVisibilityIntentionBase.addRangeHighlighter(editor, (PsiElement)targetElement));
        }
    }

    public static void dropHighlighters(@NotNull List<RangeHighlighter> highlighters) {
        if (highlighters == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(23);
        }
        highlighters.forEach(RangeMarker::dispose);
        highlighters.clear();
    }

    @NotNull
    public static RangeHighlighter addRangeHighlighter(Editor editor, PsiElement element) {
        TextRange range = element.getTextRange();
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, range.getStartOffset(), range.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
        if (rangeHighlighter == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(24);
        }
        return rangeHighlighter;
    }

    private void changeFieldListAccess(@NotNull PhpPsiElement fieldsList, @NotNull PhpModifier modifier) {
        if (fieldsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(25);
        }
        if (modifier == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(26);
        }
        if (PhpPsiUtil.isOfType((PsiElement)fieldsList, PhpElementTypes.CLASS_CONSTANTS)) {
            this.changeConstantListAccess(fieldsList, modifier);
            return;
        }
        PsiElement list = PhpPsiUtil.getChildOfType((PsiElement)fieldsList, PhpElementTypes.MODIFIER_LIST);
        if (list instanceof PhpModifierList) {
            PhpModifierList modifierList = (PhpModifierList)list;
            PhpModifier newModifier = this.isChangingSetVisibility() ? PhpModifier.instance(modifier.getAccess(), this.getTargetAccess(), modifier.getAbstractness(), modifier.getState()) : PhpModifier.instance(this.getTargetAccess(), modifier.getSetAccess(), modifier.getAbstractness(), modifier.getState());
            PhpModifierList changedModifierList = PhpPsiElementFactory.createModifierList(fieldsList.getProject(), newModifier);
            if (this.isChangingSetVisibility() && !modifierList.hasPublic() && !modifierList.hasProtected() && !modifierList.hasPrivate()) {
                changedModifierList = PhpPsiElementFactory.createModifierList(fieldsList.getProject(), this.getTargetAccess());
            }
            if (modifierList.hasReadonly()) {
                changedModifierList.add(PhpPsiElementFactory.createFromText(fieldsList.getProject(), PhpTokenTypes.IDENTIFIER, "readonly"));
            }
            if (IntentionPreviewUtils.isPreviewElement((PsiElement)modifierList.getContainingFile())) {
                modifierList.replace((PsiElement)changedModifierList);
            } else if (PhpQuickFixBase.ensureFileWritableInQuickFix(modifierList.getProject(), modifierList.getContainingFile().getVirtualFile())) {
                PhpModifierList finalChangedModifierList = changedModifierList;
                WriteCommandAction.runWriteCommandAction((Project)fieldsList.getProject(), (String)this.getFamilyName(), null, () -> modifierList.replace((PsiElement)finalChangedModifierList), (PsiFile[])new PsiFile[0]);
            }
        }
    }

    private void changeConstantListAccess(@NotNull PhpPsiElement constantsList, @NotNull PhpModifier modifier) {
        if (constantsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(27);
        }
        if (modifier == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(28);
        }
        Project project = constantsList.getProject();
        PhpModifierList modifierList = PhpPsiElementFactory.createModifierList(project, PhpModifier.instance(this.getTargetAccess(), modifier.getAbstractness(), PhpModifier.State.DYNAMIC));
        PsiElement modifierListChild = PhpPsiUtil.getChildOfType((PsiElement)constantsList, PhpElementTypes.MODIFIER_LIST);
        PsiElement firstChild = PhpPsiUtil.getChildOfType((PsiElement)constantsList, PhpTokenTypes.kwCONST);
        if (PhpQuickFixBase.ensureFileWritableInQuickFix(project, constantsList.getContainingFile().getVirtualFile())) {
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> {
                if (modifierListChild != null) {
                    modifierListChild.replace((PsiElement)modifierList);
                } else if (firstChild != null) {
                    constantsList.addBefore((PsiElement)modifierList, firstChild);
                }
            }, (PsiFile[])new PsiFile[0]);
        }
    }

    private void changeAccess(@Nullable Field field, @NotNull PhpPsiElement fieldsList, @NotNull Collection<Field> allFieldsInList) {
        if (fieldsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(29);
        }
        if (allFieldsInList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(30);
        }
        PhpModifier modifier = Objects.requireNonNull((Field)ContainerUtil.getFirstItem(allFieldsInList)).getModifier();
        Runnable callback = field != null && allFieldsInList.size() > 1 ? () -> this.changeModifierAccess(field, fieldsList) : () -> this.changeFieldListAccess(fieldsList, modifier);
        Project project = fieldsList.getProject();
        if (this.checkConflicts(project, modifier.getAccess(), field != null ? Collections.singleton(field) : allFieldsInList, callback)) {
            return;
        }
        callback.run();
    }

    private boolean checkConflicts(Project project, PhpModifier.Access access, Collection<Field> fields, Runnable changeCurrentFieldAccessCallback) {
        MultiMap<PsiElement, String> conflicts;
        return access.isWeakerThan(this.getTargetAccess()) && PhpChangeVisibilityIntentionBase.checkConflicts(project, conflicts = this.findConflicts(project, fields), changeCurrentFieldAccessCallback);
    }

    private static boolean checkConflicts(@NotNull Project project, MultiMap<PsiElement, String> conflicts, Runnable callback) {
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(31);
        }
        if (conflicts == null) {
            return true;
        }
        if (!conflicts.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("");
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts, callback);
            if (!conflictsDialog.showAndGet()) {
                return true;
            }
        }
        return false;
    }

    private void changeModifierAccess(@NotNull Field field, @NotNull PhpPsiElement fieldsList) {
        if (field == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(32);
        }
        if (fieldsList == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(33);
        }
        PhpPsiElement changedFieldsList = this.copyFieldAndChangeAccess(field, field.getName(), PhpChangeVisibilityIntentionBase.getDefaultValueText(field));
        if (PhpQuickFixBase.ensureFileWritableInQuickFix(field.getProject(), fieldsList.getContainingFile().getVirtualFile())) {
            WriteCommandAction.runWriteCommandAction((Project)field.getProject(), (String)this.getFamilyName(), null, () -> {
                PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
                fieldsList.getParent().addAfter((PsiElement)changedFieldsList, (PsiElement)fieldsList);
            }, (PsiFile[])new PsiFile[0]);
        }
    }

    @Nullable
    public static String getDefaultValueText(@NotNull Field field) {
        if (field == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(34);
        }
        PsiElement defaultValue = PhpChangeVisibilityIntentionBase.hasDefaultValue(field) ? field.getDefaultValue() : null;
        return defaultValue != null ? defaultValue.getText() : null;
    }

    private static boolean hasDefaultValue(@NotNull Field field) {
        if (field == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(35);
        }
        return PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(field.getLastChild(), true), PhpTokenTypes.opASGN);
    }

    @NotNull
    private PhpPsiElement copyFieldAndChangeAccess(Field field, String fieldName, @Nullable String defaultValueText) {
        PhpModifier changedModifier = PhpModifier.instance(this.getTargetAccess(), field.getModifier().getAbstractness(), field.getModifier().getState());
        PhpPsiElement phpPsiElement = field.isConstant() ? PhpPsiElementFactory.createClassConstant(field.getProject(), changedModifier.copy(PhpModifier.State.DYNAMIC), fieldName, StringUtil.notNullize((String)defaultValueText)) : PhpPsiElementFactory.createClassField(field.getProject(), changedModifier, field.isReadonly(), fieldName, defaultValueText, PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(field.getProject(), field.getDeclaredType(), field));
        if (phpPsiElement == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(36);
        }
        return phpPsiElement;
    }

    @Nullable
    private MultiMap<PsiElement, String> findConflicts(Project project, Collection<Field> accessChangeCandidates) {
        MultiMap conflicts = new MultiMap();
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
            for (Field field : accessChangeCandidates) {
                PhpClass containingClass = field.getContainingClass();
                if (containingClass == null) continue;
                this.collectConflictsFromSuperMembers((MultiMap<PsiElement, String>)conflicts, field);
                this.collectConflictsFromReferences((MultiMap<PsiElement, String>)conflicts, field, containingClass);
            }
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, project)) {
            return conflicts;
        }
        return null;
    }

    private void collectConflictsFromReferences(MultiMap<PsiElement, String> conflicts, Field field, PhpClass containingClass) {
        ReferencesSearch.search((PsiElement)field, (SearchScope)field.getUseScope()).forEach(ref -> {
            Collection<PhpClass> current;
            if (ref instanceof MemberReference && PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess((MemberReference)ref, containingClass, current = PhpAnnotatorVisitor.resolveCurrentScope((MemberReference)ref, this.getTargetAccess())).isWeakerThan(this.getTargetAccess())) {
                this.putConflict(conflicts, field, ref.getElement(), (PhpClass)ContainerUtil.getFirstItem(current));
            }
            return true;
        });
    }

    private void collectConflictsFromSuperMembers(MultiMap<PsiElement, String> conflicts, Field field) {
        PhpClassHierarchyUtils.processSuperFields(field, (baseField, subClass, baseClass) -> {
            if (baseField.getModifier().getAccess().isWeakerThan(this.getTargetAccess())) {
                this.putConflict(conflicts, field, (PsiElement)baseField, baseClass);
                return false;
            }
            return true;
        });
    }

    private void putConflict(MultiMap<PsiElement, String> conflicts, Field field, PsiElement usage, @Nullable PhpClass current) {
        String currentName = current != null ? current.getName() : usage.getContainingFile().getName();
        String conflictMessage = PhpBundle.message("change.signature.visibility.not.accessible", new Object[]{RefactoringUIUtil.getDescription((PsiElement)field, (boolean)true), this.getTargetAccess(), currentName});
        conflicts.putValue((Object)usage, (Object)conflictMessage);
    }

    @Nullable
    private static String getReturnType(@NotNull Function function) {
        PhpTypeDeclaration returnType;
        if (function == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(37);
        }
        return (returnType = function.getTypeDeclaration()) != null ? returnType.getText() : null;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(38);
        }
        if (editor == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(39);
        }
        if (element == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(40);
        }
        PhpClassMember targetElement = PhpChangeVisibilityIntentionBase.getTargetElement(element);
        return this.isAvailable(targetElement);
    }

    @Contract(value="null->false")
    protected boolean isAvailable(@Nullable PhpClassMember targetElement) {
        PhpClass containingClass;
        PhpClass phpClass = containingClass = targetElement != null ? targetElement.getContainingClass() : null;
        if (containingClass == null || containingClass.isInterface()) {
            return false;
        }
        if (!PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY.isSupported(targetElement.getProject()) && targetElement instanceof Field && ((Field)targetElement).isConstant()) {
            return false;
        }
        PhpModifier modifier = targetElement.getModifier();
        PhpModifier.Access access = PhpChangeVisibilityIntentionBase.getAccess(targetElement);
        if (targetElement instanceof Field) {
            if (access == this.getTargetAccess()) {
                return false;
            }
            PhpModifier.Access setAccess = modifier.getSetAccess();
            return setAccess == null || !setAccess.isWeakerThan(this.getTargetAccess());
        }
        return access != this.getTargetAccess();
    }

    @Nullable
    private static PhpModifier.Access getAccess(PhpClassMember targetElement) {
        PhpModifierList modifierList = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)(targetElement instanceof Method ? targetElement : targetElement.getParent()), PhpModifierList.INSTANCEOF);
        return modifierList != null && PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.tsVISIBILITY_MODIFIERS) != null ? targetElement.getModifier().getAccess() : null;
    }

    @Nullable
    private static PhpClassMember getTargetElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PhpModifierList) {
            parent = parent.getParent();
        }
        if (parent instanceof PhpDocMethod || parent instanceof PhpDocProperty) {
            return null;
        }
        if (parent instanceof PhpClassFieldsList) {
            return (PhpClassMember)ContainerUtil.getOnlyItem(((PhpClassFieldsList)parent).getFields());
        }
        return parent instanceof Method || parent instanceof Field ? (PhpClassMember)ObjectUtils.tryCast((Object)parent, PhpClassMember.class) : null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        Object access = this.isChangingSetVisibility() ? this.getTargetAccess() + "(set)" : this.getTargetAccess().toString();
        String string = PhpBundle.message("make.01", access);
        if (string == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpChangeVisibilityIntentionBase.$$$reportNull$$$0(42);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void lambda$changeAccessViaPopup$5(Editor editor, Field selectedField, PhpPsiElement fieldsList, List highlighters, String option) {
        PhpChangeVisibilityIntentionBase.handleHighlighting(option, editor, selectedField, fieldsList, highlighters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 18, 24, 36, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 13: 
            case 19: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 10: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promotedProperty";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: 
            case 18: 
            case 24: 
            case 36: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/changeVisibility/PhpChangeVisibilityIntentionBase";
                break;
            }
            case 11: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMethod";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedField";
                break;
            }
            case 21: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldsList";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFieldsInList";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantsList";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/changeVisibility/PhpChangeVisibilityIntentionBase";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersInfo";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighter";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFieldAndChangeAccess";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "changeAccess";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 8: 
            case 9: 
            case 18: 
            case 24: 
            case 36: 
            case 41: 
            case 42: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "weakenAccess";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doChangeAccess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParametersInfo";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "changeAccessViaPopup";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "dropHighlighters";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "changeFieldListAccess";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "changeConstantListAccess";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "changeModifierAccess";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueText";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultValue";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 18, 24, 36, 41, 42 -> new IllegalStateException(string);
        };
    }
}

