/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.inArray;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.intentions.PhpReplaceIfWithTernaryIntention;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReplaceInArrayFunctionWithDisjunctionIntention
extends PsiUpdateModCommandAction<FunctionReference> {
    public PhpReplaceInArrayFunctionWithDisjunctionIntention() {
        super(FunctionReference.class);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.replace.in.array.with.disjunction", new Object[0]);
        if (string == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull FunctionReference reference) {
        String replacementText;
        if (context == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(2);
        }
        if ((replacementText = PhpReplaceInArrayFunctionWithDisjunctionIntention.getReplacementText(reference)) == null) {
            return null;
        }
        return Presentation.of((String)PhpBundle.message("intention.message.replace.in.array.with.disjunction", replacementText));
    }

    @Nullable
    private static String getReplacementText(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(3);
        }
        if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "in_array")) {
            return null;
        }
        ParameterList parameters = reference.getParameterList();
        if (parameters == null) {
            return null;
        }
        PhpExpression needle = (PhpExpression)ObjectUtils.tryCast((Object)parameters.getParameter("needle", 0), PhpExpression.class);
        ArrayCreationExpression haystack = (ArrayCreationExpression)ObjectUtils.tryCast((Object)parameters.getParameter("haystack", 1), ArrayCreationExpression.class);
        if (needle == null || haystack == null) {
            return null;
        }
        PsiElement strictElement = parameters.getParameter("strict", 2);
        ConstantReference strict = (ConstantReference)ObjectUtils.tryCast((Object)strictElement, ConstantReference.class);
        if (strictElement != null && strict == null) {
            return null;
        }
        if (strict != null && !PhpLangUtil.isTrue(strict) && !PhpLangUtil.isFalse(strict)) {
            return null;
        }
        if (PhpSideEffectDetector.canContainSideEffect((PsiElement)needle)) {
            return null;
        }
        List<PsiElement> haystackElements = PhpReplaceInArrayFunctionWithDisjunctionIntention.getArrayValues(haystack);
        List expressionsWithSideEffects = ContainerUtil.filter(haystackElements, PhpSideEffectDetector::canContainSideEffect);
        if (expressionsWithSideEffects.size() > 1) {
            return null;
        }
        return PhpReplaceInArrayFunctionWithDisjunctionIntention.createReplacementText(needle, (PsiElement)ContainerUtil.getOnlyItem((Collection)expressionsWithSideEffects), haystackElements, strict);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull FunctionReference replaceable, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(4);
        }
        if (replaceable == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(6);
        }
        String replacementText = "(" + PhpReplaceInArrayFunctionWithDisjunctionIntention.getReplacementText(replaceable) + ")";
        ParenthesizedExpression replacement = PhpPsiElementFactory.createFirstFromText(context.project(), ParenthesizedExpression.class, replacementText);
        if (replacement == null) {
            return;
        }
        PhpReplaceIfWithTernaryIntention.unwrapIfNecessary(replaceable.replace((PsiElement)replacement));
    }

    @NotNull
    private static String createReplacementText(PhpExpression needle, PsiElement elementWithSideEffect, List<PsiElement> haystackElements, ConstantReference strict) {
        haystackElements.removeIf(element -> Objects.equals(element, elementWithSideEffect));
        if (elementWithSideEffect != null) {
            haystackElements.add(0, elementWithSideEffect);
        }
        boolean strictIsTrue = strict != null && PhpLangUtil.isTrue(strict);
        String equalitySign = strictIsTrue ? " === " : " == ";
        String string = StringUtil.join(haystackElements, element -> needle.getText() + equalitySign + element.getText(), (String)" || ");
        if (string == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static List<PsiElement> getArrayValues(ArrayCreationExpression array) {
        List children = PhpPsiUtil.getChildren((PsiElement)array, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.ARRAY_VALUE, PhpElementTypes.HASH_ARRAY_ELEMENT)));
        List list = ContainerUtil.map(children, element -> element instanceof ArrayHashElement ? ((ArrayHashElement)element).getValue() : element.getFirstChild());
        if (list == null) {
            PhpReplaceInArrayFunctionWithDisjunctionIntention.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/inArray/PhpReplaceInArrayFunctionWithDisjunctionIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/inArray/PhpReplaceInArrayFunctionWithDisjunctionIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplacementText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayValues";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementText";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

