/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.intentions.strings.PhpConvertStringRepresentationIntentionBase;
import com.jetbrains.php.lang.intentions.strings.converters.PhpInterpolationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringRepresentationConverter;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpConvertToInterpolationIntentionBase<F extends PsiElement>
extends PhpConvertStringRepresentationIntentionBase<F, StringLiteralExpression> {
    @Override
    protected PhpStringRepresentationConverter<StringLiteralExpression> getToConverter() {
        return PhpInterpolationStringRepresentationConverter.INSTANCE;
    }

    @Override
    @Nullable
    protected Presentation getPresentation(Project project, F targetElement, List<PhpStringPartDescriptor> parts) {
        if (ContainerUtil.exists(parts, e -> !PhpConvertToInterpolationIntentionBase.possiblePartOfStringInterpolation(e))) {
            return null;
        }
        return Presentation.of((String)(ContainerUtil.and(parts, PhpConvertToInterpolationIntentionBase::canBeInlinedIntoInterpolation) ? this.getScalarFixName() : this.getInterpolationFixName()));
    }

    @NotNull
    @Nls
    protected abstract String getInterpolationFixName();

    @NotNull
    @IntentionName
    protected abstract String getScalarFixName();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.getInterpolationFixName();
        if (string == null) {
            PhpConvertToInterpolationIntentionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static boolean possiblePartOfStringInterpolation(PhpStringPartDescriptor e) {
        FunctionReference functionReference;
        if (FunctionReference.class.isAssignableFrom(e.getElementClass()) && !MethodReference.class.isAssignableFrom(e.getElementClass()) && (functionReference = (FunctionReference)ObjectUtils.tryCast((Object)e.getElement(), FunctionReference.class)) != null && StringUtil.isNotEmpty((String)functionReference.getName())) {
            return false;
        }
        if (MemberReference.class.isAssignableFrom(e.getElementClass())) {
            MemberReference memberReference = (MemberReference)ObjectUtils.tryCast((Object)e.getElement(), MemberReference.class);
            if (memberReference instanceof ClassConstantReference) {
                return false;
            }
            if (memberReference != null && memberReference.isStatic() && !(memberReference.getClassReference() instanceof Variable)) {
                return false;
            }
        }
        return PhpConvertToInterpolationIntentionBase.canBeInlinedIntoInterpolation(e) || PhpAnnotatorVisitor.possiblePartOfStringInterpolation(e.getElementClass(), PhpTokenTypes.chLBRACE);
    }

    private static boolean canBeInlinedIntoInterpolation(PhpStringPartDescriptor e) {
        return StringLiteralExpression.class.isAssignableFrom(e.getElementClass()) || e.getElementType() == PhpElementTypes.NUMBER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/intentions/strings/PhpConvertToInterpolationIntentionBase", "getFamilyName"));
    }
}

