/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.PhpExpressionClassNamesProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpOverriddenTraitMethodTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassReferenceImpl
extends PhpReferenceImpl
implements ClassReference {
    private static final TokenSet NN = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER, PhpTokenTypes.VARIABLE, PhpTokenTypes.kwSTATIC, PhpTokenTypes.kwARRAY});

    public ClassReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            ClassReferenceImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpClassReference(this);
    }

    @Override
    @NotNull
    public Collection<String> getSignatureParts() {
        String className = this.getFQN();
        if (PhpLangUtil.isClassNameSpecial(className)) {
            PhpClass phpClass = PhpClassImpl.getContainingClass((PsiElement)this);
            className = phpClass != null ? ("parent".equalsIgnoreCase(className) ? (phpClass.isTrait() ? "0" : phpClass.getSuperFQN()) : phpClass.getFQN()) : "";
        }
        List<String> list = Collections.singletonList(PhpTypeSignatureKey.CLASS.sign(className));
        if (list == null) {
            ClassReferenceImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        String name = this.getName();
        String namespaceName = this.getNamespaceName();
        Collection<? extends PhpNamedElement> collection = ClassReferenceImpl.resolveGlobal(this, name, namespaceName, false);
        if (collection == null) {
            ClassReferenceImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public static Collection<? extends PhpNamedElement> resolveGlobal(PhpReference e, String name, String namespaceName, boolean newToClassOnly) {
        PhpType boundClassType;
        PhpClass phpClass;
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        PhpIndex phpIndex = PhpIndex.getInstance(e.getProject());
        if (StringUtil.isEmpty((String)name)) {
            return Collections.emptySet();
        }
        Collection<PhpClass> classes = new ArrayList<PhpClass>();
        boolean foreign = ClassReferenceImpl.isInForeignFunction(e);
        if (!foreign && ("self".equals(name) || "static".equals(name))) {
            phpClass = PhpPsiUtil.getParentOfClass((PsiElement)e, PhpClass.class);
            if (phpClass != null) {
                classes.add(phpClass);
                if ("static".equals(name) || phpClass.isTrait()) {
                    Collection<PhpClass> subclasses = phpClass.isTrait() ? PhpOverriddenTraitMethodTP.traitUsages(phpClass) : phpIndex.getAllSubclasses(phpClass.getFQN());
                    classes.addAll(subclasses);
                }
            }
        } else if (!foreign && "parent".equalsIgnoreCase(name) && (phpClass = (boundClassType = PhpTypeAnalyserVisitor.getClosureReboundType(e)) != null ? (PhpClass)ContainerUtil.getFirstItem(PhpIndex.getInstance(e.getProject()).getAnyByFQN((String)ContainerUtil.getFirstItem(boundClassType.global(e.getProject()).getTypes()))) : PhpPsiUtil.getParentOfClass((PsiElement)e, PhpClass.class)) != null) {
            Object superClass;
            if (phpClass.isTrait()) {
                Collection<PhpClass> traitUsagesByName = phpIndex.getNestedTraitUsages(phpClass, null);
                result.addAll(traitUsagesByName);
            } else if (phpClass.getSuperFQN() != null && (superClass = (PhpClass)ContainerUtil.getFirstItem(phpClass.getSuperClasses())) != null) {
                name = superClass.getName();
                namespaceName = superClass.getNamespaceName();
            }
        }
        PsiElement parent = e.getParent();
        Set<? extends PhpNamedElement> locals = ClassReferenceImpl.resolveLocal(e, name, namespaceName);
        for (PhpNamedElement phpNamedElement : locals) {
            if (phpNamedElement instanceof PhpUse) {
                PhpReference reference = ((PhpUse)phpNamedElement).getTargetReference();
                if (reference == null) continue;
                name = reference.getName();
                namespaceName = reference.getNamespaceName();
                continue;
            }
            if (!(phpNamedElement instanceof PhpClass)) continue;
            classes.add((PhpClass)phpNamedElement);
        }
        if (result.isEmpty() && classes.isEmpty() && name != null) {
            String fqn = PhpLangUtil.toFQN(PhpLangUtil.concat(namespaceName, name));
            result.addAll(phpIndex.getInterfacesByFQN(fqn));
            result.addAll(phpIndex.getTraitsByFQN(fqn));
            classes = phpIndex.getClassesByFQN(fqn);
            if ((parent instanceof PhpTypeDeclaration || e instanceof PhpDocType) && "\\object".equalsIgnoreCase(fqn) && !PhpLangUtil.isSpecialPrimitiveType(fqn, e.getProject())) {
                classes = PhpIndex.getInstance(e.getProject()).getClassesByFQN("\\___PHPSTORM_HELPERS\\object");
            }
        }
        HashSet filteredResult = new HashSet();
        for (PhpClass klass : classes) {
            PhpClass.PhpOverloadedMethods constructors;
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = constructors = !newToClassOnly && ClassReferenceImpl.shouldResolveToConstructor(e) ? PhpClassImpl.getConstructors(klass, new HashSet<PhpClass>()) : PhpClass.PhpOverloadedMethods.EMPTY;
            if (!constructors.isEmpty()) {
                result.addAll(MethodReferenceImpl.chooseOverloadedMethods((ParameterListOwner)parent, constructors));
                continue;
            }
            result.add(klass);
        }
        filteredResult.addAll(PhpReferenceImpl.extendedResolve2(e, result));
        if (parent instanceof PhpUse && !((PhpUse)parent).isTraitImport()) {
            filteredResult.addAll(PhpReferenceImpl.extendedResolve2(e, phpIndex.getNamespacesByName(e.getNamespaceName() + e.getName())));
        }
        return filteredResult;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        Collection<? extends PhpNamedElement> collection = ClassReferenceImpl.resolveLocal(this);
        if (collection == null) {
            ClassReferenceImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        Variable variableClassReference;
        String text = this.getText();
        if (ClassReferenceImpl.isPrimitiveTypeDeclaration((PsiElement)this, text)) {
            PhpType phpType = new PhpType().add(text);
            if (phpType == null) {
                ClassReferenceImpl.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        PhpType type = new PhpType();
        boolean insidePlainFunction = ClassReferenceImpl.isInForeignFunction(this);
        if (!insidePlainFunction) {
            PhpType closureReboundType;
            String name = this.getName();
            if ((PhpLangUtil.isParentReference(name) || PhpLangUtil.isSelfReference(name) || PhpLangUtil.isStaticReference(name)) && (closureReboundType = PhpTypeAnalyserVisitor.getClosureReboundType(this)) != null) {
                PhpType phpType = PhpLangUtil.isParentReference(name) ? closureReboundType.map(n -> PhpTypeSignatureKey.PARENT.sign(PhpTypeSignatureKey.CLASS.sign((CharSequence)n))) : closureReboundType;
                if (phpType == null) {
                    ClassReferenceImpl.$$$reportNull$$$0(5);
                }
                return phpType;
            }
            type.add(ClassReferenceImpl.resolveClassTypeFromSpecialName((PsiElement)this, name));
        }
        if ((variableClassReference = (Variable)ObjectUtils.tryCast((Object)this.getFirstPsiChild(), Variable.class)) != null) {
            for (String value : ClassReferenceImpl.inferDynamicClassReferenceFQNs(variableClassReference)) {
                type.add(value);
            }
            type.add(variableClassReference.getType().filterScalarPrimitives());
        }
        if (type.isEmpty()) {
            type.add(this.getFQN());
        }
        PhpType phpType = type;
        if (phpType == null) {
            ClassReferenceImpl.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @NotNull
    public static PhpType resolveClassTypeFromSpecialName(PsiElement point, String classReferenceName) {
        PhpType type = new PhpType();
        PhpClass phpClass = PhpClassImpl.getContainingClass(point);
        if (phpClass != null) {
            if (PhpLangUtil.isParentReference(classReferenceName)) {
                type.add(phpClass.getSuperFQN());
            } else if (PhpLangUtil.isSelfReference(classReferenceName)) {
                if (phpClass.isAnonymous()) {
                    type.add(phpClass.getType());
                } else {
                    PhpTypeSignatureKey key = phpClass.isTrait() ? PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT : PhpTypeSignatureKey.SELF_CLASS;
                    type.add(key.sign(phpClass.getFQN()));
                }
            } else if (PhpLangUtil.isStaticReference(classReferenceName)) {
                if (phpClass.isAnonymous()) {
                    type.add(phpClass.getType());
                } else {
                    type.add(PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign(phpClass.getFQN()));
                }
            }
        }
        PhpType phpType = type;
        if (phpType == null) {
            ClassReferenceImpl.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    public static boolean isPrimitiveTypeDeclaration(@NotNull PsiElement element, @NotNull String fqn) {
        if (element == null) {
            ClassReferenceImpl.$$$reportNull$$$0(8);
        }
        if (fqn == null) {
            ClassReferenceImpl.$$$reportNull$$$0(9);
        }
        return PhpType.isPrimitiveType(fqn) && element.getParent() instanceof PhpTypeDeclaration;
    }

    public static Collection<? extends PhpNamedElement> resolveLocal(@NotNull PhpReference classReference) {
        if (classReference == null) {
            ClassReferenceImpl.$$$reportNull$$$0(10);
        }
        if (classReference.isAbsolute()) {
            return Collections.emptySet();
        }
        String name = classReference.getName();
        return ClassReferenceImpl.resolveLocal(classReference, name, classReference.getNamespaceName());
    }

    public static Set<? extends PhpNamedElement> resolveLocal(PhpReference e, String name, String currentNamespace) {
        if (name == null) {
            return Collections.emptySet();
        }
        if (("self".equals(name) || "static".equals(name) || "$this".equals(name)) && !ClassReferenceImpl.isInForeignFunction(e)) {
            PhpDocComment comment;
            PhpClass phpClass = PhpClassImpl.getContainingClass((PsiElement)e);
            if (phpClass != null) {
                return Collections.singleton(phpClass);
            }
            if (PhpPsiUtil.isOfType(e.getParent(), (IElementType)PhpDocElementTypes.phpDocMethodType) && (comment = PhpPsiUtil.getParentOfClass((PsiElement)e, true, PhpDocComment.class)) != null) {
                PsiElement owner = comment.getOwner();
                return owner instanceof PhpClass ? Collections.singleton((PhpClass)owner) : Collections.emptySet();
            }
        }
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        String immediateNS = e.getImmediateNamespaceName();
        boolean referenceIsFqn = immediateNS.length() > 0 && immediateNS.charAt(0) == '\\' && !PhpLangUtil.mayBeReferenceToUserDefinedClass(immediateNS + name, e.getProject());
        boolean skipUses = referenceIsFqn || PhpReferenceImpl.isImport((PsiElement)e);
        String fqn = currentNamespace + name;
        PsiFile file = e.getContainingFile();
        if (file instanceof PhpFile) {
            MultiMap<String, PhpNamedElement> map = ((PhpFile)file).getTopLevelDefs();
            Collection its = map.get((Object)fqn);
            for (PhpNamedElement it : its) {
                if (!(it instanceof PhpClass) && (!(it instanceof PhpUse) || skipUses || PhpUseImpl.isOfFunction((PhpUse)it) || PhpUseImpl.isOfConst((PhpUse)it))) continue;
                result.add(it);
            }
        }
        return result;
    }

    private static boolean isInForeignFunction(PhpReference e) {
        Function f = PhpPsiUtil.getParentOfClass((PsiElement)e, Function.class);
        return f != null && !(f instanceof Method) && !f.isClosure();
    }

    @Override
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    @Override
    public PsiElement handleElementRename(@NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            ClassReferenceImpl.$$$reportNull$$$0(11);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            PsiElement newIdentifier = PhpPsiElementFactory.createFromText(this.getProject(), PhpTokenTypes.IDENTIFIER, "namespace Foo\\" + name + ";");
            ASTNode newNameNode = newIdentifier.getNode();
            assert (newNameNode != null);
            nameNode.getTreeParent().replaceChild(nameNode, newNameNode);
        }
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ClassReferenceImpl.$$$reportNull$$$0(12);
        }
        if (this.isReferenceTo(element)) {
            return this;
        }
        if (element instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return this;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ClassReferenceImpl.$$$reportNull$$$0(13);
        }
        if (element instanceof Method && this.getParent() instanceof NewExpression && ((Method)element).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            PsiElement target = this.resolve();
            if (target instanceof PhpClass) {
                boolean[] hit = new boolean[]{false};
                PhpClassHierarchyUtils.processSuperClasses((PhpClass)target, true, false, (Processor<? super PhpClass>)((Processor)aClass -> {
                    hit[0] = aClass.getConstructor() == element;
                    return hit[0];
                }));
                return hit[0];
            }
            if (target instanceof Method) {
                return target == element;
            }
        }
        if (element instanceof PhpClass || element instanceof Method || element instanceof PhpNamespace || element instanceof PhpUse) {
            if (element instanceof PhpClass) {
                PhpClass c = (PhpClass)element;
                String fqn = this.getFQN();
                if (fqn != null && PhpLangUtil.equalsClassNames(fqn, c.getFQN())) {
                    return true;
                }
            }
            ResolveResult[] results = this.multiResolve(false);
            boolean isReference = false;
            for (ResolveResult result : results) {
                if (!result.isValidResult() || result.getElement() != element) continue;
                isReference = true;
                break;
            }
            if (isReference) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public String getFQN() {
        return ClassReferenceImpl.getLocalFQN(this);
    }

    @Nullable
    public static String getLocalFQN(@NotNull PhpReference reference) {
        ClassReference superRef;
        PhpClass containingClass;
        if (reference == null) {
            ClassReferenceImpl.$$$reportNull$$$0(14);
        }
        if (PhpLangUtil.isParentReference((PsiElement)reference) && (containingClass = PhpClassImpl.getContainingClass((PsiElement)reference)) instanceof PhpClassImpl && (superRef = ((PhpClassImpl)containingClass).getSuperRef()) != null && superRef != reference) {
            return superRef.getFQN();
        }
        if (PhpPsiUtil.isOfType(reference.getFirstChild(), PhpTokenTypes.kwLIST)) {
            return "list";
        }
        Collection<? extends PhpNamedElement> elements = ClassReferenceImpl.resolveLocal(reference);
        Set FQNs = ContainerUtil.map2Set(elements, PhpNamedElement::getFQN);
        if (FQNs.size() == 1) {
            return (String)FQNs.iterator().next();
        }
        String className = reference.getName();
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        return PhpLangUtil.isClassNameSpecial(className) ? className : reference.getNamespaceName() + className;
    }

    @NotNull
    public static Collection<String> inferDynamicClassReferenceFQNs(@NotNull Variable variable) {
        if (variable == null) {
            ClassReferenceImpl.$$$reportNull$$$0(15);
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)variable, () -> CachedValueProvider.Result.create(ClassReferenceImpl.doInferDynamicClassReferenceFQNs(variable), (Object[])new Object[]{variable}));
        if (collection == null) {
            ClassReferenceImpl.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> doInferDynamicClassReferenceFQNs(@NotNull Variable variable) {
        if (variable == null) {
            ClassReferenceImpl.$$$reportNull$$$0(17);
        }
        HashSet<String> dynamicClassReferenceFQNs = new HashSet<String>();
        boolean ambiguousAssignment = ClassReferenceImpl.collectDynamicClassReferences(variable, dynamicClassReferenceFQNs);
        if (dynamicClassReferenceFQNs.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ClassReferenceImpl.$$$reportNull$$$0(18);
            }
            return list;
        }
        if (ambiguousAssignment) {
            dynamicClassReferenceFQNs.add("\\mixed");
        }
        HashSet<String> hashSet = dynamicClassReferenceFQNs;
        if (hashSet == null) {
            ClassReferenceImpl.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private static boolean collectDynamicClassReferences(@NotNull Variable variable, Collection<? super String> dynamicClassReferenceFQNs) {
        if (variable == null) {
            ClassReferenceImpl.$$$reportNull$$$0(20);
        }
        Ref ambiguousAssignment = new Ref((Object)Boolean.FALSE);
        HashSet<PsiElement> assignedNonLiteralValues = new HashSet<PsiElement>();
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        ClassReferenceImpl.collectAssignedValues(instruction, dynamicClassReferenceFQNs, assignedNonLiteralValues, (Ref<Boolean>)ambiguousAssignment);
        ClassReferenceImpl.addFQNsFromNonLiteralValues(dynamicClassReferenceFQNs, (Ref<Boolean>)ambiguousAssignment, assignedNonLiteralValues);
        return (Boolean)ambiguousAssignment.get();
    }

    private static void addFQNsFromNonLiteralValues(Collection<? super String> dynamicClassReferenceFQNs, Ref<Boolean> ambiguousAssignment, @NotNull Collection<PsiElement> assignedNonLiteralValues) {
        if (assignedNonLiteralValues == null) {
            ClassReferenceImpl.$$$reportNull$$$0(21);
        }
        for (PsiElement assignedNonLiteral : assignedNonLiteralValues) {
            PhpType type = ClassReferenceImpl.getTypeWithoutProviders(assignedNonLiteral);
            PhpType filteredTypes = type.filterUnknown().filterOut(PhpType::isNotExtendablePrimitiveType);
            if (type.isEmpty() || filteredTypes.size() != type.size()) {
                ambiguousAssignment.set((Object)Boolean.TRUE);
            }
            dynamicClassReferenceFQNs.addAll(filteredTypes.getTypes());
        }
    }

    private static void collectAssignedValues(final PhpAccessVariableInstruction variableAccessInstruction, final Collection<? super String> dynamicClassReferenceFQNs, final Collection<? super PsiElement> assignedNonLiteralValues, final Ref<Boolean> ambiguousAssignment) {
        if (variableAccessInstruction == null) {
            return;
        }
        final CharSequence variableName = variableAccessInstruction.getVariableName();
        PhpControlFlowUtil.processPredecessors(variableAccessInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (!PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    return true;
                }
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (((PhpAccessInstructionImpl)((Object)instruction)).isReadOrReadRefAccessLocalAware()) {
                    ambiguousAssignment.set((Object)Boolean.TRUE);
                } else if (access.isWrite()) {
                    ClassReferenceImpl.addAssignedValue((PsiElement)instruction.getAnchor(), dynamicClassReferenceFQNs, (Ref<Boolean>)ambiguousAssignment, new HashSet());
                    for (PsiElement assignedValue : ClassReferenceImpl.getAssignedValues(instruction.getAnchor())) {
                        ClassReferenceImpl.addAssignedValue(assignedValue, dynamicClassReferenceFQNs, (Ref<Boolean>)ambiguousAssignment, assignedNonLiteralValues);
                    }
                    return false;
                }
                return true;
            }

            @Override
            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                Variable variable = (Variable)ObjectUtils.tryCast((Object)variableAccessInstruction.getAnchor(), Variable.class);
                Collection<Object> resolvedElements = variable != null ? variable.resolveLocal() : Collections.emptyList();
                Set resolvedParametersDeclaredTypes = variable != null ? (Collection)ClassReferenceImpl.declaredTypesFromResolvedParameters(resolvedElements).map(s -> PhpType.isPrimitiveType(s) ? "\\mixed" : s).collect(Collectors.toSet()) : Collections.emptySet();
                boolean ambiguousDeclaredParameter = false;
                if (!resolvedParametersDeclaredTypes.isEmpty()) {
                    dynamicClassReferenceFQNs.addAll(resolvedParametersDeclaredTypes);
                } else {
                    ambiguousAssignment.set((Object)Boolean.TRUE);
                    ambiguousDeclaredParameter = true;
                }
                for (PhpNamedElement phpNamedElement : resolvedElements) {
                    if (!(phpNamedElement instanceof Parameter)) continue;
                    ClassReferenceImpl.addAssignedValue((PsiElement)phpNamedElement, dynamicClassReferenceFQNs, (Ref<Boolean>)(ambiguousDeclaredParameter ? ambiguousAssignment : new Ref()), assignedNonLiteralValues);
                }
                return super.processEntryPointInstruction(instruction);
            }
        });
    }

    @NotNull
    private static Stream<String> declaredTypesFromResolvedParameters(Collection<? extends PhpNamedElement> resolvedElements) {
        StreamEx typesFromUsedVariables = ((StreamEx)StreamEx.of(resolvedElements).select(Variable.class).filter(v -> v.getParent() instanceof PhpUseList)).flatMap(v -> ClassReferenceImpl.inferDynamicClassReferenceFQNs(v).stream());
        AbstractStreamEx abstractStreamEx = StreamEx.of(resolvedElements).select(Parameter.class).map(Parameter::getDeclaredType).flatMap(type -> type.getTypes().stream()).append((Stream)typesFromUsedVariables);
        if (abstractStreamEx == null) {
            ClassReferenceImpl.$$$reportNull$$$0(22);
        }
        return abstractStreamEx;
    }

    private static void addAssignedValue(PsiElement assignedValue, Collection<? super String> dynamicClassReferenceFQNs, Ref<Boolean> ambiguousAssignment, Collection<? super PsiElement> assignedNonLiteralValues) {
        if (assignedValue != null) {
            Collection<@Nullable String> classNames = PhpExpressionClassNamesProvider.fetchClassNames(assignedValue);
            if (!classNames.isEmpty()) {
                if (classNames.contains(null)) {
                    ambiguousAssignment.set((Object)true);
                }
                dynamicClassReferenceFQNs.addAll(ContainerUtil.filter(classNames, Objects::nonNull));
                return;
            }
            assignedNonLiteralValues.add((PsiElement)assignedValue);
        }
    }

    @NotNull
    private static PhpType getTypeWithoutProviders(@NotNull PsiElement nonLiteralValue) {
        PsiElement parameter;
        if (nonLiteralValue == null) {
            ClassReferenceImpl.$$$reportNull$$$0(23);
        }
        if (nonLiteralValue instanceof FunctionReference && !(nonLiteralValue instanceof MethodReference) && PhpLangUtil.equalsFunctionNames(((FunctionReference)nonLiteralValue).getName(), "get_class") && (parameter = ((FunctionReference)nonLiteralValue).getParameter(0)) != null) {
            return ClassReferenceImpl.getTypeWithoutProviders(parameter);
        }
        PhpType phpType = PhpTypeInfo.getTypeFromAST(nonLiteralValue, new PhpTypeAnalyserVisitor(){

            @Override
            public Collection<? extends PhpTypeProvider4> getTypeProviders(@NotNull PsiElement psi) {
                if (psi == null) {
                    2.$$$reportNull$$$0(0);
                }
                return Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/jetbrains/php/lang/psi/elements/impl/ClassReferenceImpl$2", "getTypeProviders"));
            }
        });
        if (phpType == null) {
            ClassReferenceImpl.$$$reportNull$$$0(24);
        }
        return phpType;
    }

    @NotNull
    private static Collection<PsiElement> getAssignedValues(PhpPsiElement variable) {
        AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)variable, AssignmentExpression.class);
        if (assignmentExpression == null || assignmentExpression.getVariable() != variable) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                ClassReferenceImpl.$$$reportNull$$$0(25);
            }
            return list;
        }
        return ClassReferenceImpl.extractAssignedValues((PsiElement)assignmentExpression.getValue());
    }

    @NotNull
    private static List<PsiElement> extractAssignedValues(PsiElement value) {
        if (value instanceof TernaryExpression) {
            List list = ContainerUtil.concat(ClassReferenceImpl.extractAssignedValues((PsiElement)((TernaryExpression)value).getTrueVariant()), ClassReferenceImpl.extractAssignedValues((PsiElement)((TernaryExpression)value).getFalseVariant()));
            if (list == null) {
                ClassReferenceImpl.$$$reportNull$$$0(26);
            }
            return list;
        }
        if (value instanceof BinaryExpression && PhpPsiUtil.isOfType(value, PhpElementTypes.COALESCE_EXPRESSION)) {
            List list = ContainerUtil.concat(ClassReferenceImpl.extractAssignedValues(((BinaryExpression)value).getLeftOperand()), ClassReferenceImpl.extractAssignedValues(((BinaryExpression)value).getRightOperand()));
            if (list == null) {
                ClassReferenceImpl.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<PsiElement> list = Collections.singletonList(value);
        if (list == null) {
            ClassReferenceImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    public static boolean shouldResolveToConstructor(@NotNull PhpReference reference) {
        if (reference == null) {
            ClassReferenceImpl.$$$reportNull$$$0(29);
        }
        if (!(reference instanceof ClassReference)) {
            return false;
        }
        PsiElement parent = reference.getParent();
        return parent instanceof NewExpression || parent instanceof PhpAttribute;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 16, 18, 19, 22, 24, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ClassReferenceImpl";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedNonLiteralValues";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonLiteralValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ClassReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureParts";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClassTypeFromSpecialName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inferDynamicClassReferenceFQNs";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doInferDynamicClassReferenceFQNs";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "declaredTypesFromResolvedParameters";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithoutProviders";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignedValues";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "extractAssignedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveTypeDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFQN";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "inferDynamicClassReferenceFQNs";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doInferDynamicClassReferenceFQNs";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectDynamicClassReferences";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addFQNsFromNonLiteralValues";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithoutProviders";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldResolveToConstructor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 16, 18, 19, 22, 24, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }
}

