/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantImpl
extends PhpNamedElementImpl<PhpConstantStub>
implements Constant {
    public static final Condition<PsiElement> CONST_STATEMENT_CONDITION = psiElement -> PhpPsiUtil.isOfType(psiElement, PhpElementTypes.CONSTANTS);
    private static final int DEFAULT_VALUE_PRESENTATION_MAX_LENGTH = 20;

    public ConstantImpl(ASTNode node) {
        super(node);
    }

    public ConstantImpl(PhpConstantStub stub) {
        super(stub, PhpStubElementTypes.CONST);
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getConstantPresentation(this);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getNamespaceName() {
        PhpConstantStub stub = (PhpConstantStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getNamespaceName();
            if (string == null) {
                ConstantImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = super.getNamespaceName();
        if (string == null) {
            ConstantImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            ConstantImpl.$$$reportNull$$$0(2);
        }
        if ((nameNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            ASTNode node = constantReference.getNameNode();
            assert (node != null);
            nameNode.getTreeParent().replaceChild(nameNode, node);
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            ConstantImpl.$$$reportNull$$$0(3);
        }
        phpElementVisitor.visitPhpConstant(this);
    }

    @Override
    public Icon getIcon() {
        return PhpIcons.CONSTANT;
    }

    @Nullable
    public PhpPsiElement getValue() {
        return this.getFirstPsiChild();
    }

    @Override
    @Nullable
    public String getValuePresentation() {
        PhpConstantStub stub = (PhpConstantStub)this.getGreenStub();
        if (stub != null) {
            return stub.getValuePresentation();
        }
        return ConstantImpl.getValuePresentationInternal((PsiElement)this.getValue());
    }

    static String getValuePresentationInternal(@Nullable PsiElement value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ArrayCreationExpression) {
            return "[...]";
        }
        return ConstantImpl.getValuePresentation(value.getText());
    }

    @NotNull
    public static String getValuePresentation(String elementText) {
        String text = StreamEx.of((Object[])StringUtil.splitByLines((String)elementText)).joining((CharSequence)" ");
        String string = StringUtil.first((String)text, (int)20, (boolean)true);
        if (string == null) {
            ConstantImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public boolean isWriteAccess() {
        return true;
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        return PhpPsiUtil.getDocCommentFor(this, (NullableFunction<? super PhpPsiElement, ? extends PhpPsiElement>)((NullableFunction)element -> (PhpPsiElement)PhpPsiUtil.getParentByCondition((PsiElement)element, CONST_STATEMENT_CONDITION, GroupStatement.INSTANCEOF)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ConstantImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ConstantImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

