/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpPotentialGlobalEntryTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstantReferenceImpl
extends PhpReferenceImpl
implements ConstantReference {
    public ConstantReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            ConstantReferenceImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpConstantReference(this);
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        Collection<? extends PhpNamedElement> locals = this.resolveLocal();
        String name = this.getName();
        String namespaceName = this.getNamespaceName();
        boolean allowGlobal = ConstantReferenceImpl.allowGlobal(this);
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        for (PhpNamedElement phpNamedElement : locals) {
            if (phpNamedElement instanceof PhpUse) {
                PhpReference reference = ((PhpUse)phpNamedElement).getTargetReference();
                if (reference == null) continue;
                name = reference.getName();
                namespaceName = reference.getNamespaceName();
                allowGlobal = false;
                continue;
            }
            if (!(phpNamedElement instanceof Constant)) continue;
            result.add(phpNamedElement);
        }
        if (result.size() == 0) {
            PhpIndex phpIndex = PhpIndex.getInstance(this.getProject());
            Collection<Constant> collection = phpIndex.getConstantsByName(name);
            Collection<Constant> filtered = phpIndex.filterByNamespace(collection, namespaceName, allowGlobal);
            result.addAll(filtered);
        }
        Collection collection = PhpReferenceImpl.extendedResolve2(this, result);
        if (collection == null) {
            ConstantReferenceImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<String> getSignatureParts() {
        String sign = PhpTypeSignatureKey.CONSTANT.sign(this.getFQN());
        if (this.getImmediateNamespaceName().isEmpty() && !"\\".equals(this.getNamespaceName())) {
            List<String> list = Collections.singletonList(PhpPotentialGlobalEntryTP.TYPE_KEY.sign(sign));
            if (list == null) {
                ConstantReferenceImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<String> list = Collections.singletonList(sign);
        if (list == null) {
            ConstantReferenceImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        return ConstantReferenceImpl.resolveLocal(this);
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = PhpCodeInsightUtil.getLocalType(this);
        if (phpType == null) {
            ConstantReferenceImpl.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> resolveLocal(ConstantReferenceImpl reference) {
        String name = reference.getName();
        if (StringUtil.isEmpty((String)name)) {
            Set set = Collections.emptySet();
            if (set == null) {
                ConstantReferenceImpl.$$$reportNull$$$0(5);
            }
            return set;
        }
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        String immediateNS = reference.getImmediateNamespaceName();
        boolean skipUses = immediateNS.length() > 0 && immediateNS.charAt(0) == '\\' || PhpPsiUtil.getParentOfClass((PsiElement)reference, false, PhpUse.class) != null && PhpPsiUtil.getParentOfClass((PsiElement)reference, true, PhpClass.class) == null;
        PhpFile containingFile = (PhpFile)reference.getContainingFile();
        if (containingFile == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                ConstantReferenceImpl.$$$reportNull$$$0(6);
            }
            return set;
        }
        MultiMap<String, PhpNamedElement> map = containingFile.getTopLevelDefs();
        String fqn = reference.getNamespaceName() + name;
        Collection its = map.get((Object)fqn);
        for (PhpNamedElement it : its) {
            if (!PhpLangUtil.equalsConstantNames(it.getName(), name) || !(it instanceof Constant) && (!(it instanceof PhpUse) || skipUses || !PhpUseImpl.isOfConst((PhpUse)it) || !immediateNS.isEmpty())) continue;
            result.add(it);
        }
        HashSet<PhpNamedElement> hashSet = result;
        if (hashSet == null) {
            ConstantReferenceImpl.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ConstantReferenceImpl.$$$reportNull$$$0(8);
        }
        if (element instanceof Constant || element instanceof PhpUse) {
            Constant constant;
            boolean caseSensitive;
            if (element instanceof Constant && ((caseSensitive = (constant = (Constant)element).isCaseSensitive()) ? PhpLangUtil.equals(this.getFQN(), constant.getFQN()) : PhpLangUtil.equalsIgnoreCase(this.getFQN(), constant.getFQN()))) {
                return true;
            }
            return Arrays.stream(this.multiResolve(false)).filter(ResolveResult::isValidResult).map(ResolveResult::getElement).anyMatch(element::equals);
        }
        return false;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return super.getNameNode();
    }

    @Override
    @NotNull
    public PhpType getType() {
        if (PhpLangUtil.isNull(this)) {
            PhpType phpType = PhpType.NULL;
            if (phpType == null) {
                ConstantReferenceImpl.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        if (PhpLangUtil.isFalse(this)) {
            PhpType phpType = PhpType.FALSE;
            if (phpType == null) {
                ConstantReferenceImpl.$$$reportNull$$$0(10);
            }
            return phpType;
        }
        if (PhpLangUtil.isTrue(this)) {
            PhpType phpType = PhpType.TRUE;
            if (phpType == null) {
                ConstantReferenceImpl.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        PhpType phpType = super.getType();
        if (phpType == null) {
            ConstantReferenceImpl.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    @Override
    @Nullable
    public String getFQN() {
        String name = this.getName();
        if (name != null && PhpLangUtil.isBuiltInConstant(name)) {
            return PhpLangUtil.toFQN(name);
        }
        Collection<? extends PhpNamedElement> elements = this.resolveLocal();
        if (elements.size() == 1) {
            return ((PhpNamedElement)ContainerUtil.getFirstItem(elements)).getFQN();
        }
        return super.getFQN();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ConstantReferenceImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ConstantReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureParts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

