/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpClassMemberIconProvider;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.BasicPhpStubElementTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.impl.ConstantImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassFieldsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpModifierListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpCustomDocTagTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpFieldStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldImpl
extends PhpNamedElementImpl<PhpFieldStub>
implements Field,
StubBasedPsiElement<PhpFieldStub>,
PhpDeprecationAttributeOwner {
    private static final TokenSet NN = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER}), PhpTokenTypes.tsKEYWORDS});

    public FieldImpl(ASTNode node) {
        super(node);
    }

    public FieldImpl(PhpFieldStub stub, IStubElementType type) {
        super(stub, type);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            FieldImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpField(this);
    }

    @Override
    public boolean isFinal() {
        PhpFieldStub stub = (PhpFieldStub)this.getGreenStub();
        if (stub != null) {
            return stub.isFinal();
        }
        if (this.getModifier().isFinal()) {
            return true;
        }
        PhpClass clazz = this.getContainingClass();
        if (clazz == null) {
            return false;
        }
        return clazz.isFinal();
    }

    @Override
    public boolean hasPropertyHooksContainer() {
        PhpFieldStub stub = (PhpFieldStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasPropertyHooksContainer();
        }
        return FieldImpl.getPropertyHooksContainer(this) != null;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpClassMemberIconProvider.getFieldIcon(this);
    }

    @Override
    @Nullable
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getFieldPresentation(this);
    }

    @Override
    @NotNull
    public String getName() {
        String name = super.getName();
        String string = name.charAt(0) == '$' ? name.substring(1) : name;
        if (string == null) {
            FieldImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        CharSequence name = super.getNameCS();
        return name.length() > 0 ? (name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name) : "";
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FieldImpl.$$$reportNull$$$0(2);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ASTNode node;
            ASTNode aSTNode = node = this.isConstant() ? PhpPsiElementFactory.createClassConstantReferenceUsingSelf(this.getProject(), name).getNameNode() : PhpPsiElementFactory.createVariable(this.getProject(), name, true).getNameNode();
            if (node != null) {
                nameNode.getTreeParent().replaceChild(nameNode, node);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public PhpModifier getModifier() {
        PhpModifier.State state = PhpModifier.State.DYNAMIC;
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        PhpModifier.Access setAccess = null;
        PhpModifier.Abstractness abstractness = PhpModifier.Abstractness.IMPLEMENTED;
        PhpFieldStub fieldStub = (PhpFieldStub)this.getGreenStub();
        if (fieldStub != null) {
            if (fieldStub.isPrivate()) {
                access = PhpModifier.Access.PRIVATE;
            }
            if (fieldStub.isProtected()) {
                access = PhpModifier.Access.PROTECTED;
            }
            if (fieldStub.isStatic()) {
                state = PhpModifier.State.STATIC;
            }
            if (fieldStub.isFinal()) {
                abstractness = PhpModifier.Abstractness.FINAL;
            }
            if (fieldStub.isAbstract()) {
                abstractness = PhpModifier.Abstractness.ABSTRACT;
            }
        } else {
            PhpModifierList modifierList;
            PhpClassFieldsList list = this.getParentList();
            PhpModifierList phpModifierList = modifierList = list != null ? list.getModifierList() : null;
            if (modifierList != null) {
                ASTNode[] nodes;
                for (ASTNode node : nodes = modifierList.getNode().getChildren(PhpTokenTypes.tsVARIABLE_MODIFIERS)) {
                    if (PhpModifierListImpl.isSetOperationModifier(node)) {
                        if (node.getElementType() == PhpTokenTypes.kwPRIVATE) {
                            setAccess = PhpModifier.Access.PRIVATE;
                            continue;
                        }
                        if (node.getElementType() == PhpTokenTypes.kwPROTECTED) {
                            setAccess = PhpModifier.Access.PROTECTED;
                            continue;
                        }
                        if (node.getElementType() != PhpTokenTypes.kwPUBLIC) continue;
                        setAccess = PhpModifier.Access.PUBLIC;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwPRIVATE) {
                        access = PhpModifier.Access.PRIVATE;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwPROTECTED) {
                        access = PhpModifier.Access.PROTECTED;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwPUBLIC || node.getElementType() == PhpTokenTypes.kwVAR) {
                        access = PhpModifier.Access.PUBLIC;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwSTATIC) {
                        state = PhpModifier.State.STATIC;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwFINAL) {
                        abstractness = PhpModifier.Abstractness.FINAL;
                        continue;
                    }
                    if (node.getElementType() != PhpTokenTypes.kwABSTRACT) continue;
                    abstractness = PhpModifier.Abstractness.ABSTRACT;
                }
            }
        }
        if (this.isConstant()) {
            state = PhpModifier.State.STATIC;
        }
        PhpModifier phpModifier = PhpModifier.instance(access, setAccess, abstractness, state);
        if (phpModifier == null) {
            FieldImpl.$$$reportNull$$$0(3);
        }
        return phpModifier;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValuePresentation() != null;
    }

    @Nullable
    public static PsiElement getReadonlyKeyword(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        ASTNode readonlyNode = (ASTNode)ContainerUtil.find((Object[])element.getNode().getChildren(null), FieldImpl::isReadonlyKeyword);
        return readonlyNode != null ? readonlyNode.getPsi() : null;
    }

    public static boolean isReadonlyKeyword(@NotNull ASTNode node) {
        if (node == null) {
            FieldImpl.$$$reportNull$$$0(4);
        }
        if (PhpPsiUtil.isOfType(node, PhpTokenTypes.IDENTIFIER) && "readonly".equalsIgnoreCase(node.getText())) {
            PsiElement psi = node.getPsi();
            return psi != null && !(psi.getParent() instanceof ParameterList);
        }
        return false;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isReadonly() {
        PhpFieldStub stub = (PhpFieldStub)this.getGreenStub();
        if (stub != null) {
            return stub.isReadonly();
        }
        PhpClassFieldsList list = this.getParentList();
        if (list == null) {
            return false;
        }
        PhpModifierList modifierList = list.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (modifierList.hasReadonly()) {
            return true;
        }
        PhpClass containingClass = this.getContainingClass();
        return containingClass != null && containingClass.isReadonly();
    }

    @Override
    @Nullable
    public PsiElement getDefaultValue() {
        if (this.getNode().findChildByType(PhpTokenTypes.opASGN) == null) {
            return null;
        }
        return this.getFirstPsiChild();
    }

    @Override
    @Nullable
    public String getDefaultValuePresentation() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            return ((PhpFieldStub)stub).getDefaultValuePresentation();
        }
        return ConstantImpl.getValuePresentationInternal(this.getDefaultValue());
    }

    @Override
    @Nullable
    public PhpClassFieldsList getParentList() {
        return (PhpClassFieldsList)ObjectUtils.tryCast((Object)this.getParent(), PhpClassFieldsList.class);
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        PhpClassFieldsList parent = this.getParentList();
        return parent != null ? PhpPsiUtil.getDocCommentFor(parent) : null;
    }

    @Override
    @Nullable
    public PhpClass getContainingClass() {
        return (PhpClass)this.getStubOrPsiParentOfType(PhpClass.class);
    }

    @Override
    public boolean isWriteAccess() {
        return true;
    }

    @Override
    @NotNull
    public String getFQN() {
        PhpClass containingClass = this.getContainingClass();
        return containingClass != null ? containingClass.getFQN() + "." + (this.isConstant() ? "" : "$") + this.getName() : "";
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType languageTypeMap = ParameterImpl.getTypeFromLanguageMap(this);
        if (languageTypeMap != null) {
            PhpType phpType = languageTypeMap;
            if (phpType == null) {
                FieldImpl.$$$reportNull$$$0(5);
            }
            return phpType;
        }
        PhpType phpType = super.getType();
        if (phpType == null) {
            FieldImpl.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @Override
    @NotNull
    public PhpType getDeclaredType() {
        PhpType languageTypeMap = ParameterImpl.getTypeFromLanguageMap(this);
        if (languageTypeMap != null) {
            PhpType phpType = languageTypeMap;
            if (phpType == null) {
                FieldImpl.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PhpFieldStub stub = (PhpFieldStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getDeclaredType();
            if (phpType == null) {
                FieldImpl.$$$reportNull$$$0(8);
            }
            return phpType;
        }
        PhpTypeDeclaration typeDeclaration = (PhpTypeDeclaration)PhpPsiUtil.getPrevSiblingByCondition(this, (Condition<? super PsiElement>)((Condition)PhpTypeDeclaration.class::isInstance));
        if (typeDeclaration == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                FieldImpl.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        PhpType phpType = typeDeclaration.getType();
        if (phpType == null) {
            FieldImpl.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        PhpClassFieldsList parent = this.getParentList();
        Collection<PhpAttribute> collection = parent != null ? FieldImpl.getAttributesStubAware((PhpClassFieldsListImpl)parent) : Collections.emptyList();
        if (collection == null) {
            FieldImpl.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Override
    @Nullable
    public PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfo() {
        return FunctionImpl.getDeprecationInfoFromAttribute(this);
    }

    public static Set<? extends PhpNamedElement> collectFieldDeclarations(@NotNull PhpPsiElement point) {
        if (point == null) {
            FieldImpl.$$$reportNull$$$0(12);
        }
        return FieldImpl.getCollectDeclarations(point, false);
    }

    private static Set<? extends PhpNamedElement> getCollectDeclarations(PhpPsiElement point, final boolean constants) {
        PhpClass parent = PhpClassImpl.getContainingClass((PsiElement)point);
        if (parent == null) {
            return Collections.emptySet();
        }
        final HashSet fieldSet = new HashSet();
        parent.acceptChildren(new PhpRecursiveElementVisitor(){

            @Override
            public void visitPhpField(Field field) {
                if (constants == field.isConstant()) {
                    fieldSet.add(field);
                }
            }

            @Override
            public void visitPhpFunction(Function function) {
            }

            @Override
            public void visitPhpMethod(Method method) {
            }
        });
        return fieldSet;
    }

    public static Set<? extends PhpNamedElement> collectClassConstDeclarations(@NotNull PhpPsiElement point) {
        if (point == null) {
            FieldImpl.$$$reportNull$$$0(13);
        }
        return FieldImpl.getCollectDeclarations(point, true);
    }

    @Override
    @NotNull
    public PhpType getDocType() {
        return FieldImpl.getDocType(this);
    }

    @NotNull
    public static PhpType getDocType(Field field) {
        PhpType res = new PhpType();
        FieldImpl.getNativeDocTags(field).forEach(res::add);
        FieldImpl.getCustomTags(field.getDocComment()).forEach(res::add);
        PhpType phpType = res;
        if (phpType == null) {
            FieldImpl.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    public static Collection<? extends PhpDocTag> getNativeDocTags(Field field) {
        PhpDocComment comment = field.getDocComment();
        return comment instanceof PhpDocCommentImpl ? ((PhpDocCommentImpl)comment).getVarTags() : Collections.emptyList();
    }

    @Override
    public Collection<PhpDocTag> getDocTags() {
        return ContainerUtil.union(FieldImpl.getCustomTags(this.getDocComment()), FieldImpl.getNativeDocTags(this));
    }

    @NotNull
    public static Collection<PhpDocTag> getCustomTags(@Nullable PhpDocComment comment) {
        Collection<PhpDocTag> collection = PhpCustomDocTagTypeProvider.getTypeFromCustomTag(comment, PhpCustomDocTagTypeProvider::getVarTag);
        if (collection == null) {
            FieldImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Override
    @Nullable
    public PhpFieldType getTypeDeclaration() {
        return (PhpFieldType)PhpPsiUtil.getPrevSiblingByCondition(this, (Condition<? super PsiElement>)((Condition)PhpFieldType.class::isInstance));
    }

    @Override
    public boolean updateType(@NotNull PhpType type) {
        if (type == null) {
            FieldImpl.$$$reportNull$$$0(16);
        }
        FieldImpl.changeFieldType(this.getProject(), this, type);
        return true;
    }

    private static void changeFieldType(@NotNull Project project, @NotNull Field field, @NotNull PhpType newType) {
        PhpClassFieldsList fieldsList;
        if (project == null) {
            FieldImpl.$$$reportNull$$$0(17);
        }
        if (field == null) {
            FieldImpl.$$$reportNull$$$0(18);
        }
        if (newType == null) {
            FieldImpl.$$$reportNull$$$0(19);
        }
        if ((fieldsList = field.getParentList()) == null || !PhpPsiUtil.isOfType((PsiElement)fieldsList, PhpElementTypes.CLASS_FIELDS) && !PhpPsiUtil.isOfType((PsiElement)fieldsList, PhpElementTypes.CLASS_CONSTANTS)) {
            return;
        }
        String newTypeString = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, newType, field);
        if (PhpHierarchyChecksInspection.isGroupedDeclarations(fieldsList)) {
            PhpClassFieldsList newFieldsList = FieldImpl.copyListWithSingleField(field, fieldsList);
            FieldImpl.changeFieldType(project, (Field)ContainerUtil.getFirstItem(newFieldsList.getFields()), newFieldsList, newTypeString);
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
            fieldsList.getParent().addAfter((PsiElement)newFieldsList, (PsiElement)fieldsList);
        } else {
            FieldImpl.changeFieldType(project, field, fieldsList, newTypeString);
        }
    }

    @NotNull
    public static PhpClassFieldsList copyListWithSingleField(@NotNull Field field, PhpClassFieldsList list) {
        if (field == null) {
            FieldImpl.$$$reportNull$$$0(20);
        }
        PhpClassFieldsList newFieldsList = (PhpClassFieldsList)list.copy();
        newFieldsList.getFields().stream().filter(f -> !f.getName().equals(field.getName())).forEach(f -> PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)f, PhpTokenTypes.opCOMMA));
        PhpClassFieldsList phpClassFieldsList = newFieldsList;
        if (phpClassFieldsList == null) {
            FieldImpl.$$$reportNull$$$0(21);
        }
        return phpClassFieldsList;
    }

    private static void changeFieldType(@NotNull Project project, @NotNull Field field, @NotNull PhpClassFieldsList fieldsList, @Nullable String typeString) {
        PhpTypeDeclaration typeDeclaration;
        if (project == null) {
            FieldImpl.$$$reportNull$$$0(22);
        }
        if (field == null) {
            FieldImpl.$$$reportNull$$$0(23);
        }
        if (fieldsList == null) {
            FieldImpl.$$$reportNull$$$0(24);
        }
        if ((typeDeclaration = field.getTypeDeclaration()) != null && typeString == null) {
            typeDeclaration.delete();
        } else if (typeDeclaration != null) {
            typeDeclaration.replace((PsiElement)FieldImpl.createFieldType(project, typeString));
        } else if (typeString != null) {
            if (field.isConstant()) {
                fieldsList.addBefore((PsiElement)PhpPsiElementFactory.createClassConstantType(project, typeString), field);
            } else {
                fieldsList.addBefore((PsiElement)FieldImpl.createFieldType(project, typeString), field);
            }
            fieldsList.addBefore((PsiElement)PhpPsiElementFactory.createWhiteSpace(project), field);
        }
    }

    @NotNull
    private static PhpFieldType createFieldType(@NotNull Project project, @NotNull String type) {
        if (project == null) {
            FieldImpl.$$$reportNull$$$0(25);
        }
        if (type == null) {
            FieldImpl.$$$reportNull$$$0(26);
        }
        PhpFieldType phpFieldType = PhpPsiElementFactory.createPhpPsiFromText(project, PhpFieldType.class, "class A { public " + type + " $a; }");
        if (phpFieldType == null) {
            FieldImpl.$$$reportNull$$$0(27);
        }
        return phpFieldType;
    }

    @Override
    @NotNull
    public List<PhpPropertyHook> getPropertyHooksList() {
        List<PhpPropertyHook> list = FieldImpl.getPropertyHooksList(this);
        if (list == null) {
            FieldImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    @ApiStatus.Internal
    protected static List<PhpPropertyHook> getPropertyHooksList(Field field) {
        PhpNamedStub stub;
        if (field instanceof FieldImpl) {
            FieldImpl fieldImpl = (FieldImpl)field;
            v0 = (PhpNamedStub)fieldImpl.getGreenStub();
        } else if (field instanceof PhpPromotedFieldParameterImpl) {
            PhpPromotedFieldParameterImpl promotedField = (PhpPromotedFieldParameterImpl)field;
            v0 = (PhpNamedStub)promotedField.getGreenStub();
        } else {
            v0 = stub = null;
        }
        if (stub != null) {
            PhpPropertyHook[] propertyHooks = (PhpPropertyHook[])stub.getChildrenByType(BasicPhpStubElementTypes.PROPERTY_HOOK, PhpPropertyHook.ARRAY_FACTORY);
            return Arrays.stream(propertyHooks).toList();
        }
        return FieldImpl.getPropertyHooksListInternal(field);
    }

    private static List<PhpPropertyHook> getPropertyHooksListInternal(@NotNull Field field) {
        if (field == null) {
            FieldImpl.$$$reportNull$$$0(29);
        }
        return PhpPsiUtil.getChildren(FieldImpl.getPropertyHooksContainer(field), PhpPropertyHook.INSTANCEOF);
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiElement getPropertyHooksContainer(Field field) {
        PsiElement lastChild = field.getLastChild();
        if (PhpPsiUtil.isOfType(lastChild, PhpElementTypes.PROPERTY_HOOKS)) {
            return lastChild;
        }
        return null;
    }

    @Override
    public boolean isAbstract() {
        PhpFieldStub stub = (PhpFieldStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAbstract();
        }
        PhpClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this.getModifier().isAbstract();
        }
        return this.getModifier().isAbstract() || containingClass.isInterface();
    }

    @Override
    public boolean isVirtualProperty() {
        return FieldImpl.isVirtualProperty(this);
    }

    private static boolean isVirtualPropertyInternal(Field field, boolean isSuper) {
        if (field.isAbstract()) {
            return false;
        }
        List<PhpPropertyHook> propertyHooks = field.getPropertyHooksList();
        if (propertyHooks.isEmpty()) {
            return false;
        }
        Ref scopeContainsFieldReference = new Ref((Object)false);
        if (ContainerUtil.exists(propertyHooks, it -> it.isShort() && it.getHookType() == PhpPropertyHook.PhpPropertyHookType.SET)) {
            return false;
        }
        for (PhpPropertyHook propertyHook : propertyHooks) {
            FieldImpl.processPropertyHookControlFlow(propertyHook, field.getName(), (Ref<Boolean>)scopeContainsFieldReference);
            if (!((Boolean)scopeContainsFieldReference.get()).booleanValue()) continue;
            return false;
        }
        if (!isSuper) {
            PhpClassHierarchyUtils.processSuperFields(field, (superField, superClass, baseClass) -> {
                if (!FieldImpl.isVirtualPropertyInternal(superField, true)) {
                    scopeContainsFieldReference.set((Object)true);
                    return false;
                }
                return true;
            });
        }
        return (Boolean)scopeContainsFieldReference.get() == false;
    }

    public static boolean isVirtualProperty(Field field) {
        return FieldImpl.isVirtualPropertyInternal(field, false);
    }

    private static void processPropertyHookControlFlow(PhpPropertyHook propertyHook, final String myFieldName, final Ref<Boolean> result) {
        PhpControlFlowUtil.processFlow(propertyHook.getControlFlow(), new PhpInstructionProcessor(){

            @Override
            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                CharSequence varName = instruction.getVariableName();
                if (varName == null) {
                    return true;
                }
                CharSequence fieldName = instruction.getFieldName();
                if (fieldName.equals(myFieldName) && varName.equals("this")) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public boolean isPropertyWithAsymmetricVisibility() {
        return PhpModifierListImpl.getSetOperationModifierPsiElement(this) != null;
    }

    public static PsiElement getVisibilityPsi(Field field) {
        PhpPsiElement element = null;
        if (field instanceof FieldImpl) {
            FieldImpl fieldImpl = (FieldImpl)field;
            PhpClassFieldsList parentList = fieldImpl.getParentList();
            if (parentList == null) {
                return null;
            }
            element = parentList.getModifierList();
        } else if (field instanceof Parameter) {
            element = field;
        }
        List<PsiElement> tokens = PhpPsiUtil.getChildrenOfType((PsiElement)element, PhpTokenTypes.tsVISIBILITY_MODIFIERS);
        return (PsiElement)ContainerUtil.find(tokens, it -> !PhpModifierListImpl.isSetOperationModifier(it));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 6, 7, 8, 9, 10, 11, 14, 15, 21, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FieldImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 20: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FieldImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTags";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "copyListWithSingleField";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyHooksList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: 
            case 27: 
            case 28: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReadonlyKeyword";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldDeclarations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectClassConstDeclarations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "changeFieldType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyListWithSingleField";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createFieldType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyHooksListInternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 6, 7, 8, 9, 10, 11, 14, 15, 21, 27, 28 -> new IllegalStateException(string);
        };
    }
}

