/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.PhpMemberResolveResult;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldReferenceImpl
extends MemberReferenceImpl
implements FieldReference {
    private static final TokenSet NN = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER}), PhpTokenTypes.tsKEYWORDS});

    public FieldReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected Collection<PhpMemberResolveResult> resolveGlobalDescriptors(Function<PhpExpression, PhpType> classReferenceTypeProvider) {
        @NotNull Collection<PhpMemberResolveResult> elements = super.resolveGlobalDescriptors(classReferenceTypeProvider);
        if (!elements.isEmpty()) {
            Collection<PhpMemberResolveResult> collection = elements;
            if (collection == null) {
                FieldReferenceImpl.$$$reportNull$$$0(0);
            }
            return collection;
        }
        PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(this, PhpAccessFieldByVariableInstruction.class);
        PhpExpression classReference = this.getClassReference();
        if (classReference != null && instruction != null && instruction.getAccess().isRead()) {
            ArrayList fakeElements = new ArrayList();
            Ref canBeDefined = new Ref();
            Ref canBeUndefined = new Ref();
            PhpUndefinedFieldInspection.processReachability(classReference, this.getName(), instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, f -> fakeElements.add(new DynamicallyDeclaredField((FieldReference)f)));
            if (canBeDefined.get() == Boolean.TRUE) {
                List list = ContainerUtil.map(fakeElements, f -> new PhpMemberResolveResult((PhpNamedElement)f, false));
                if (list == null) {
                    FieldReferenceImpl.$$$reportNull$$$0(1);
                }
                return list;
            }
        }
        List<PhpMemberResolveResult> list = Collections.emptyList();
        if (list == null) {
            FieldReferenceImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = FieldReferenceImpl.isClassNameLiteral(this) ? PhpType.STRING : super.resolveLocalType();
        if (phpType == null) {
            FieldReferenceImpl.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    @Override
    @NotNull
    protected PhpType getResolvedElementType(PhpNamedElement resolvedElement) {
        PhpType type = super.getResolvedElementType(resolvedElement);
        if (!type.isEmpty() && PhpIndexImpl.isNonPrivateFieldWithTypeOnlyFromDefaultValue(resolvedElement)) {
            PhpType phpType = PhpType.or(type, PhpType.MIXED);
            if (phpType == null) {
                FieldReferenceImpl.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            FieldReferenceImpl.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    public static boolean isClassNameLiteral(@NotNull MemberReference reference) {
        if (reference == null) {
            FieldReferenceImpl.$$$reportNull$$$0(6);
        }
        return PsiUtilCore.getElementType((ASTNode)reference.getNameNode()) == PhpTokenTypes.kwCLASS;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            FieldReferenceImpl.$$$reportNull$$$0(7);
        }
        phpElementVisitor.visitPhpFieldReference(this);
    }

    @Override
    public ASTNode getNameNode() {
        PsiElement lastChild = this.getLastChild();
        if (lastChild instanceof Variable && (!this.isStatic() || lastChild.getPrevSibling().getNode().getElementType().equals(PhpTokenTypes.DOLLAR))) {
            return null;
        }
        if (lastChild instanceof LeafPsiElement) {
            return NN.contains(lastChild.getNode().getElementType()) ? lastChild.getNode() : null;
        }
        ASTNode node = lastChild.getNode();
        ASTNode out = node.findChildByType(NN);
        if (out != null) {
            return out;
        }
        return TreeUtil.findChildBackward((ASTNode)node, PhpStubElementTypes.VARIABLE);
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name != null && name.length() > 0 && name.charAt(0) == '$' ? name.substring(1) : name;
    }

    @Override
    public CharSequence getNameCS() {
        CharSequence name = super.getNameCS();
        return name != null && name.length() > 0 && name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name;
    }

    @Override
    public boolean isConstant() {
        CharSequence name = super.getNameCS();
        return name != null && (name.length() == 0 || name.charAt(0) != '$');
    }

    @NotNull
    public Set<PhpNamedElement> resolveMember(@NotNull PhpClass klass, boolean localOnly) {
        if (klass == null) {
            FieldReferenceImpl.$$$reportNull$$$0(8);
        }
        Set<PhpNamedElement> set = this.resolveMemberWithGenerics(klass, localOnly, null);
        if (set == null) {
            FieldReferenceImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public Set<PhpNamedElement> resolveMemberWithGenerics(@NotNull PhpClass klass, boolean localOnly, @Nullable String genericInstantiationType) {
        if (klass == null) {
            FieldReferenceImpl.$$$reportNull$$$0(10);
        }
        Set<PhpNamedElement> set = FieldReferenceImpl.resolveMemberImpl(this, klass, localOnly, false, genericInstantiationType);
        if (set == null) {
            FieldReferenceImpl.$$$reportNull$$$0(11);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     */
    public static Set<PhpNamedElement> resolveMemberImpl(MemberReference reference, @NotNull PhpClass klass, boolean localOnly, boolean dfaReachable, @Nullable String genericInstantiationType) {
        HashSet hashSet;
        void var5_14;
        HashSet finalFields;
        PhpExpression classReference;
        void var5_12;
        if (klass == null) {
            FieldReferenceImpl.$$$reportNull$$$0(12);
        }
        boolean isStatic = !reference.getReferenceType().isDynamic();
        boolean isPartFromPropertyHookCallViaParent = MethodReferenceImpl.getFieldReferencedFromPropertyHookCall(reference) != null;
        boolean lookForConstant = (reference instanceof ClassConstantReference || reference instanceof FieldReference && ((FieldReference)reference).isConstant()) && isStatic && !isPartFromPropertyHookCallViaParent;
        CharSequence name = reference.getNameCS();
        if (!localOnly) {
            Collection<@Nullable Field> collection = PhpClassImpl.findFieldsByName(klass, name, lookForConstant, dfaReachable, genericInstantiationType);
        } else if (klass instanceof PhpClassImpl) {
            Collection<@Nullable Field> collection = FieldReferenceImpl.resolveFields(reference, (PhpClassImpl)klass, lookForConstant, name);
        } else {
            List<@Nullable Field> list = Collections.singletonList(klass.findOwnFieldByName(name, lookForConstant));
        }
        if (ContainerUtil.exists((Iterable)var5_12, f -> f instanceof PhpDocProperty) && ContainerUtil.exists((Iterable)var5_12, f -> !(f instanceof PhpDocProperty)) && PhpLangUtil.isThisReference((PsiElement)(classReference = reference.getClassReference())) && PhpClassImpl.getContainingClass((PsiElement)classReference) == klass) {
            @Nullable List list = ContainerUtil.filter((Collection)var5_12, f -> !(f instanceof PhpDocProperty));
        }
        if ((finalFields = var5_14.stream().filter(Objects::nonNull).filter(f -> f.getModifier().isStatic() == isStatic || isPartFromPropertyHookCallViaParent).collect(Collectors.toSet())).isEmpty() && isStatic) {
            if (ContainerUtil.all((Collection)var5_14, PhpDocProperty.class::isInstance)) {
                hashSet = new HashSet(var5_14);
                return hashSet;
            }
        }
        hashSet = finalFields;
        return hashSet;
    }

    static Collection<@Nullable Field> resolveFields(MemberReference reference, final PhpClassImpl klass, boolean lookForConstant, final CharSequence name) {
        Collection<Field> fields = PhpClassImpl.findOwnFieldsByName(name, lookForConstant, true, klass.getOwnDeclaredFieldMap());
        if (!fields.isEmpty()) {
            return fields;
        }
        if (reference instanceof FieldReference && PhpLangUtil.isThisReference((PsiElement)reference.getClassReference())) {
            PhpClass containingClass;
            Method method = PhpPsiUtil.getParentOfClass((PsiElement)reference, Method.class);
            PhpClass phpClass = containingClass = method != null ? method.getContainingClass() : null;
            if (containingClass == klass) {
                Method methodToAnalyse = (Method)ObjectUtils.notNull((Object)containingClass.getOwnConstructor(), (Object)method);
                final ArrayList<Field> res = new ArrayList<Field>();
                PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(methodToAnalyse.getControlFlow().getExitPoint(), false, new PhpClassImpl.PhpFieldAccessProcessor(klass){

                    @Override
                    protected boolean processFieldAccessInstruction(PhpAccessInstruction instruction, FieldReference reference) {
                        String currentName = reference.getName();
                        if (StringUtil.isNotEmpty((String)currentName) && PhpLangUtil.equalsFieldNames(currentName, name)) {
                            PhpPsiElement anchor = instruction.getAnchor();
                            if (anchor instanceof FieldReference) {
                                res.add(new PhpClassImpl.MyASTRenamableFakePsiElement(klass, (FieldReference)anchor));
                            }
                            return false;
                        }
                        return true;
                    }
                });
                return res;
            }
        }
        return PhpClassImpl.findOwnFieldsByName(name, lookForConstant, true, klass.getOwnDynamicFieldMap());
    }

    @Override
    public PsiElement handleElementRename(@NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FieldReferenceImpl.$$$reportNull$$$0(13);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ASTNode node;
            ASTNode aSTNode = node = nameNode.getElementType() == PhpTokenTypes.IDENTIFIER ? PhpPsiElementFactory.createFieldReferenceUsingThis(this.getProject(), name).getNameNode() : PhpPsiElementFactory.createVariable(this.getProject(), name, true).getNameNode();
            assert (node != null);
            nameNode.getTreeParent().replaceChild(nameNode, node);
        }
        return this;
    }

    @Override
    public boolean isWriteAccess() {
        return this.isWriteAccess(true);
    }

    public boolean isWriteAccess(boolean global) {
        FieldReferenceImpl that = this;
        PsiElement parent = this.getParent();
        while (parent instanceof ArrayAccessExpression) {
            that = parent;
            parent = parent.getParent();
        }
        if (VariableImpl.inMultiAssignment(parent)) {
            return true;
        }
        if (parent instanceof AssignmentExpression) {
            return ((AssignmentExpression)parent).getVariable() == that;
        }
        if (parent instanceof UnaryExpression && (PhpPsiUtil.isOfType(parent, PhpElementTypes.INFIX_WRITE_EXPRESSION) || PhpPsiUtil.isOfType(parent, PhpElementTypes.POSTFIX_EXPRESSION))) {
            return true;
        }
        return PhpCodeInsightUtil.isPassByRefParameter((PsiElement)that, global);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            FieldReferenceImpl.$$$reportNull$$$0(14);
        }
        if (!(element instanceof PhpClassMember)) {
            return false;
        }
        List resolvedElements = Arrays.stream(this.multiResolve(false)).filter(ResolveResult::isValidResult).map(ResolveResult::getElement).collect(Collectors.toList());
        if (ContainerUtil.find(resolvedElements, element::equals) != null) {
            return true;
        }
        if (element instanceof PhpClassImpl.MyRenamableFakePsiElement) {
            return StreamEx.of(resolvedElements).select(PhpClassImpl.MyRenamableFakePsiElement.class).anyMatch(e -> e.getParent().equals(element.getParent()));
        }
        return false;
    }

    @Override
    protected PhpTypeSignatureKey getTypeSignatureKey() {
        return PhpTypeSignatureKey.FIELD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 8, 10, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FieldReferenceImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobalDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedElementType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FieldReferenceImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMember";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberWithGenerics";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClassNameLiteral";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberWithGenerics";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 8, 10, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }

    public static final class DynamicallyDeclaredField
    extends RenameableFakePsiElement
    implements PhpNamedElement {
        private final FieldReference myReference;

        private DynamicallyDeclaredField(FieldReference reference) {
            super(reference.getParent());
            this.myReference = reference;
        }

        @Override
        @Nullable
        public ASTNode getNameNode() {
            return this.myReference.getNameNode();
        }

        @Override
        @NotNull
        @NlsSafe
        public String getName() {
            String string = StringUtil.notNullize((String)this.myReference.getName());
            if (string == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public CharSequence getNameCS() {
            String string = this.getName();
            if (string == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public PhpDocComment getDocComment() {
            return null;
        }

        @Override
        public void processDocs(Processor<PhpDocComment> processor) {
        }

        @Nullable
        public String getTypeName() {
            return PhpBundle.message("dynamically.declared.field", new Object[0]);
        }

        @Override
        public Icon getIcon() {
            return PhpIcons.FIELD;
        }

        @Override
        @NotNull
        @NlsSafe
        public String getFQN() {
            String string = StringUtil.notNullize((String)this.myReference.getFQN());
            if (string == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        @NlsSafe
        public String getNamespaceName() {
            String string = this.myReference.getNamespaceName();
            if (string == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

        @Override
        public boolean isInternal() {
            return false;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            ASTNode node = this.myReference.getNameNode();
            return node != null ? node.getPsi() : null;
        }

        @Override
        @NotNull
        public PhpType getType() {
            PhpType phpType = this.myReference.getType();
            if (phpType == null) {
                DynamicallyDeclaredField.$$$reportNull$$$0(4);
            }
            return phpType;
        }

        @Override
        @Nullable
        public PhpPsiElement getFirstPsiChild() {
            return this.myReference.getFirstPsiChild();
        }

        @Override
        @Nullable
        public PhpPsiElement getNextPsiSibling() {
            return this.myReference.getNextPsiSibling();
        }

        @Override
        @Nullable
        public PhpPsiElement getPrevPsiSibling() {
            return this.myReference.getPrevPsiSibling();
        }

        public int getTextOffset() {
            PsiElement identifier = this.getNameIdentifier();
            return identifier != null ? identifier.getTextRange().getStartOffset() : this.myReference.getTextOffset();
        }

        @Nullable
        public String getLocationString() {
            return PhpPresentationUtil.getPresentablePathForFile(this.getContainingFile().getVirtualFile(), this.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/lang/psi/elements/impl/FieldReferenceImpl$DynamicallyDeclaredField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameCS";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFQN";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

