/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpScope;
import com.jetbrains.php.codeInsight.PhpScopeImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.type.PhpMissingReturnTypeInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpCustomDocTagTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpAvailableInLanguageLevelRangeElement;
import com.jetbrains.php.lang.psi.stubs.PhpDeprecationInfoOwnerStub;
import com.jetbrains.php.lang.psi.stubs.PhpFunctionStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.stubs.indexes.gist.PhpElementStubGist;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionImpl
extends PhpNamedElementImpl<PhpNamedStub>
implements Function,
StubBasedPsiElement<NamedStub>,
PhpDeprecationAttributeOwner,
PhpAvailableInLanguageLevelRangeElement {
    private static final Predicate<String> NOT_PLURAL_OR_ARRAY = t -> !PhpType.isPluralType(t) && !PhpType.isArray(t);
    public static final String AVAILABLE_IN_LANGUAGE_LEVEL_RANGE_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\Internal\\PhpStormStubsElementAvailable";
    @NotNull
    private static final TokenSet FUNCTION_KEYWORD = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwFUNCTION, PhpTokenTypes.kwFN});
    private PhpScope myScope;

    public FunctionImpl(ASTNode node) {
        super(node);
    }

    protected FunctionImpl(PhpNamedStub stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            FunctionImpl.$$$reportNull$$$0(0);
        }
        super(stub, nodeType);
    }

    @Override
    public PhpDocComment getDocComment() {
        PhpDocComment comment = null;
        if (this.isClosure()) {
            PsiElement parent = this.getParent();
            if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE) && (comment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)parent)) == null && ((parent = parent.getParent()) instanceof AssignmentExpression || parent instanceof PhpReturn || parent instanceof ParameterList && ((ParameterList)parent).getParameter(0) == this.getParent()) && (comment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)parent)) == null && (parent = parent.getParent()) instanceof Statement) {
                comment = PhpPsiUtil.getDocCommentFor((Statement)parent);
            }
            return comment;
        }
        return super.getDocComment();
    }

    public FunctionImpl(PhpFunctionStub stub) {
        super(stub, PhpStubElementTypes.FUNCTION);
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getFunctionPresentation(this);
    }

    @Override
    public Parameter @NotNull [] getParameters() {
        if (this.getGreenStub() != null) {
            return this.getStubParameters();
        }
        ParameterList element = this.getParameterList();
        if (element == null) {
            if (Parameter.EMPTY_ARRAY == null) {
                FunctionImpl.$$$reportNull$$$0(1);
            }
            return Parameter.EMPTY_ARRAY;
        }
        List childrenOfType = ContainerUtil.filter(PhpPsiUtil.getChildren((PsiElement)element, Parameter.INSTANCEOF), ParameterImpl::isAvailableByLanguageLevel);
        Parameter[] parameterArray = childrenOfType.isEmpty() ? Parameter.EMPTY_ARRAY : childrenOfType.toArray(Parameter.EMPTY_ARRAY);
        if (parameterArray == null) {
            FunctionImpl.$$$reportNull$$$0(2);
        }
        return parameterArray;
    }

    private Parameter @NotNull [] getStubParameters() {
        Object[] parameters = (Parameter[])this.getStubOrPsiChildren(ParameterImpl.PARAMETER, Parameter.ARRAY_FACTORY);
        if (ContainerUtil.exists((Object[])parameters, p -> !ParameterImpl.isAvailableByLanguageLevel(p))) {
            Parameter[] parameterArray = ContainerUtil.filter((Object[])parameters, ParameterImpl::isAvailableByLanguageLevel).toArray(Parameter.EMPTY_ARRAY);
            if (parameterArray == null) {
                FunctionImpl.$$$reportNull$$$0(3);
            }
            return parameterArray;
        }
        if (parameters == null) {
            FunctionImpl.$$$reportNull$$$0(4);
        }
        return parameters;
    }

    @Nullable
    private ParameterList getParameterList() {
        return (ParameterList)PhpPsiUtil.getChildByCondition(this, ParameterList.INSTANCEOF);
    }

    @Override
    @Nullable
    public Parameter getParameter(int index) {
        if (index < 0) {
            return null;
        }
        if (this.getGreenStub() != null) {
            Parameter[] parameters = this.getStubParameters();
            return index < parameters.length ? parameters[index] : null;
        }
        ParameterList list = this.getParameterList();
        return list != null ? (Parameter)ObjectUtils.tryCast((Object)list.getParameter(index), Parameter.class) : null;
    }

    @Override
    public boolean hasRefParams() {
        return ContainerUtil.exists((Object[])this.getParameters(), Parameter::isPassByRef);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FunctionImpl.$$$reportNull$$$0(5);
        }
        if ((nameNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            ASTNode node = constantReference.getNameNode();
            assert (node != null);
            nameNode.getTreeParent().replaceChild(nameNode, node);
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            FunctionImpl.$$$reportNull$$$0(6);
        }
        phpElementVisitor.visitPhpFunction(this);
    }

    @Override
    public Icon getIcon() {
        return this.isClosure() ? AllIcons.Nodes.Lambda : PhpIcons.FUNCTION;
    }

    @Override
    public boolean isClosure() {
        return this.getName().length() == 0;
    }

    @Override
    @Nullable
    public PsiElement getReturnByReferenceTokenFromAST() {
        ASTNode functionKeyword = this.getNode().findChildByType(FUNCTION_KEYWORD);
        return functionKeyword != null ? PhpPsiUtil.findNextSiblingOfAnyType(functionKeyword.getPsi(), PhpTokenTypes.opBIT_AND) : null;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getFQN() {
        String string = super.getFQN();
        if (string == null) {
            FunctionImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType phpType = this.getType(true);
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public PhpType getType(boolean substituteMetaDirective) {
        if (ContainerUtil.exists((Object[])this.getParameters(), p -> !p.getAttributes("\\JetBrains\\PhpStorm\\Internal\\ReturnTypeContract").isEmpty())) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        PhpType typeFromLanguage = this.getTypeFromLanguageMap();
        PhpType type = typeFromLanguage != null ? typeFromLanguage : super.getType();
        PhpType phpType = substituteMetaDirective && this.stubFunctionWithMetaDirective() ? type.filterOut(t -> PhpType.isArray(t) || PhpType.isMixedType(t)) : type;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @Nullable
    protected PhpType getTypeFromLanguageMap() {
        return ParameterImpl.getTypeFromLanguageMap(this);
    }

    public static PhpType getLocalTypeFromGistOrStub(StubBasedPsiElementBase<?> element) {
        if (Registry.is((String)"php.use.type.gist")) {
            PhpType type = PhpElementStubGist.Companion.getLocalType(element);
            if (type != null) {
                return new PhpType().add(type);
            }
        } else {
            PhpTypedStub stub = (PhpTypedStub)element.getGreenStub();
            if (stub != null) {
                return stub.getType();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public PhpType getLocalType(boolean interactive) {
        PhpType onlyArrayPluralInferredType;
        PhpType type = FunctionImpl.getLocalTypeFromGistOrStub(this);
        if (type != null) {
            PhpType phpType = type;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        type = new PhpType();
        PhpType docType = !interactive ? this.getDocType() : PhpType.EMPTY;
        Map<String, String> parametrisedTypes = PhpTypeAnalyserVisitor.getShortNameToParametrisedTypes(docType);
        boolean parametrisedInt = parametrisedTypes.containsKey("\\int");
        type.add(docType);
        PhpType declaredType = this.getDeclaredType().map(t -> parametrisedTypes.getOrDefault(t, (String)t));
        if (declaredType.equals(PhpType.NEVER)) {
            PhpType phpType = new PhpType().add(PhpType.NEVER);
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(12);
            }
            return phpType;
        }
        boolean hasPluralDocType = docType.getTypes().stream().anyMatch(PhpType::isPluralType);
        boolean declaredTypeIsArray = declaredType.filterNull().equals(PhpType.ARRAY);
        boolean declaredTypeIsObject = declaredType.filterNull().equals(PhpType.OBJECT);
        if (!declaredTypeIsArray || !hasPluralDocType) {
            type.add(declaredType);
        } else if (declaredType.isNullable()) {
            type.add(PhpType.NULL);
        }
        type = this.computeDeclaredType(type);
        if (!(declaredType.isEmpty() || declaredTypeIsArray || declaredTypeIsObject)) {
            PhpType phpType = FunctionImpl.overrideIntWithRange(type, parametrisedInt);
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        PhpType inferredType = this.getInferredType();
        if (type.isEmpty()) {
            PhpType phpType = PhpTypeAnalyserVisitor.generaliseIntRange(inferredType);
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(14);
            }
            return phpType;
        }
        if (declaredTypeIsObject) {
            boolean incompleteTypeResolvableToClass;
            boolean bl = incompleteTypeResolvableToClass = !inferredType.isComplete() && ContainerUtil.and(inferredType.getTypes(), t -> PhpTypeSignatureKey.SELF_CLASS.isSigned((String)t));
            if (!inferredType.isEmpty() && inferredType.isComplete() && !inferredType.equals(PhpType.VOID) || incompleteTypeResolvableToClass) {
                type = type.filter(PhpType.OBJECT);
            }
        }
        if (declaredTypeIsArray && !(onlyArrayPluralInferredType = inferredType.filterOut(NOT_PLURAL_OR_ARRAY)).isEmpty()) {
            inferredType = onlyArrayPluralInferredType;
            type = type.filter(PhpType.ARRAY);
        }
        Stream<String> filtered = inferredType.getTypesWithParametrisedParts().stream().filter(s -> s != null && !"\\void".equals(s));
        if (!declaredTypeIsObject) {
            filtered = filtered.filter(s -> !PhpType.isMixedType(s) && !PhpType.isUnresolved(s)).filter(s -> !hasPluralDocType || !PhpType.isArray(s));
        }
        filtered.forEach(type::add);
        PhpType phpType = FunctionImpl.overrideIntWithRange(type, parametrisedInt);
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(15);
        }
        return phpType;
    }

    private static PhpType overrideIntWithRange(PhpType type, boolean parametrisedInt) {
        return parametrisedInt ? new PhpType().add(PhpType.fromStrings(ContainerUtil.filter(type.getTypesWithParametrisedParts(), t -> !"\\int".equalsIgnoreCase((String)t)))) : type;
    }

    @NotNull
    protected PhpType computeDeclaredType(PhpType typeFromDeclaration) {
        PhpType phpType = typeFromDeclaration;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(16);
        }
        return phpType;
    }

    @Override
    @NotNull
    public PhpType getDeclaredType() {
        PhpType typeFromLanguageMap = this.getTypeFromLanguageMap();
        if (typeFromLanguageMap != null) {
            PhpType phpType = typeFromLanguageMap;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(17);
            }
            return phpType;
        }
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getDeclaredType();
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(18);
            }
            return phpType;
        }
        PhpReturnType returnTypeElement = this.getTypeDeclaration();
        if (returnTypeElement != null) {
            PhpType phpType = returnTypeElement.getType();
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(19);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(20);
        }
        return phpType;
    }

    @Override
    @NotNull
    public PhpType getDocType() {
        PhpType type = new PhpType();
        this.returnTags().forEach(type::add);
        PhpType phpType = type;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(21);
        }
        return phpType;
    }

    @NotNull
    public Stream<PhpDocTag> returnTags() {
        Stream<PhpDocTag> stream = Stream.concat(Stream.of(this.getDocTag()), FunctionImpl.getCustomTags(this.getDocComment()).stream()).filter(Objects::nonNull);
        if (stream == null) {
            FunctionImpl.$$$reportNull$$$0(22);
        }
        return stream;
    }

    @Nullable
    private PhpDocTag getDocTag() {
        PhpDocComment docComment = this.getDocComment();
        return docComment != null ? docComment.getReturnTag() : null;
    }

    @Override
    public Collection<PhpDocTag> getDocTags() {
        return ContainerUtil.union(FunctionImpl.getCustomTags(this.getDocComment()), (Collection)ContainerUtil.createMaybeSingletonSet((Object)this.getDocTag()));
    }

    @NotNull
    public static Collection<PhpDocTag> getCustomTags(PhpDocComment docComment) {
        Collection<PhpDocTag> collection = PhpCustomDocTagTypeProvider.getTypeFromCustomTag(docComment, PhpCustomDocTagTypeProvider::getReturnTag);
        if (collection == null) {
            FunctionImpl.$$$reportNull$$$0(23);
        }
        return collection;
    }

    private boolean stubFunctionWithMetaDirective() {
        PhpDocComment comment = this.getDocComment();
        return comment != null && comment.getTagElementsByName("@meta").length > 0;
    }

    @Override
    @NotNull
    public PhpType getInferredType() {
        PsiElement argument2;
        PhpType type = new PhpType();
        if (this instanceof Method && ((Method)((Object)this)).isAbstract()) {
            PhpType phpType = type;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(24);
            }
            return phpType;
        }
        if (this.isClosure() && FunctionImpl.isShortArrowFunction(this) && (argument2 = FunctionImpl.getShortArrowFunctionArgument(this)) != null) {
            type.add(FunctionImpl.getType(argument2));
            PhpType phpType = type;
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(25);
            }
            return phpType;
        }
        return FunctionImpl.getInferredControlFlowType(this.getControlFlow(), argument -> this.isSelfReferencedFunction((PsiElement)argument));
    }

    @NotNull
    public static PhpType getInferredControlFlowType(PhpControlFlow flow, final java.util.function.Function<PsiElement, Boolean> isSelfReferenced) {
        final PhpType type = new PhpType();
        final int[] returnCount = new int[]{0};
        final Ref hasEmptyType = new Ref((Object)false);
        final Ref hasYield = new Ref((Object)false);
        final Ref maybeVoid = new Ref((Object)false);
        PhpInstructionProcessor processor = new PhpInstructionProcessor(){

            @Override
            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                returnCount[0] = returnCount[0] + 1;
                PsiElement argument = instruction.getArgument();
                if (!((Boolean)isSelfReferenced.apply(argument)).booleanValue()) {
                    PhpType phpType = FunctionImpl.getType(argument);
                    if (phpType.isEmpty()) {
                        hasEmptyType.set((Object)true);
                    }
                    type.add(phpType);
                }
                return false;
            }

            @Override
            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                hasYield.set((Object)true);
                PsiElement argument = instruction.getArgument();
                if (argument != null) {
                    type.add(argument.getParent());
                }
                type.add("\\Generator");
                return super.processYieldInstruction(instruction);
            }

            @Override
            public boolean processThrowInstruction(PhpThrowInstruction instruction) {
                return false;
            }

            @Override
            public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                maybeVoid.set((Object)true);
                return super.processExitPointInstruction(instruction);
            }
        };
        PhpControlFlowUtil.processSuccessors(flow.getEntryPoint(), false, processor);
        if (((Boolean)maybeVoid.get()).booleanValue()) {
            if (returnCount[0] == 0 && type.isEmpty() || !((Boolean)hasYield.get()).booleanValue() && FunctionImpl.isExitPointReachable(flow)) {
                type.add(PhpType.VOID);
            }
        } else if (returnCount[0] == 0 && !((Boolean)hasYield.get()).booleanValue()) {
            return new PhpType();
        }
        if (type.isEmpty() || ((Boolean)hasEmptyType.get()).booleanValue()) {
            type.add(PhpType.MIXED);
        }
        PhpType phpType = type;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(26);
        }
        return phpType;
    }

    private static boolean isExitPointReachable(PhpControlFlow flow) {
        final Ref exitPointIsReachable = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors(flow.getExitPoint(), false, new PhpInstructionProcessor(){

            @Override
            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                return false;
            }

            @Override
            public boolean processThrowInstruction(PhpThrowInstruction instruction) {
                return false;
            }

            @Override
            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                return false;
            }

            @Override
            public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                if (!instruction.getResult()) {
                    return false;
                }
                return super.processCatchConditionInstruction(instruction);
            }

            @Override
            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                exitPointIsReachable.set((Object)true);
                return super.processEntryPointInstruction(instruction);
            }
        });
        return (Boolean)exitPointIsReachable.get();
    }

    private boolean isSelfReferencedFunction(PsiElement argument) {
        if (argument instanceof FunctionReference && PhpLangUtil.equalsFunctionNames(((FunctionReference)argument).getName(), this.getName())) {
            Collection elements = ((FunctionReference)argument).resolveLocal();
            return ContainerUtil.getOnlyItem((Collection)elements) == this;
        }
        return false;
    }

    @Override
    @Nullable
    public PhpReturnType getReturnType() {
        return (PhpReturnType)PhpPsiUtil.getChildByCondition(this, PhpReturnType.INSTANCEOF);
    }

    @Override
    public PhpReturnType getTypeDeclaration() {
        return this.getReturnType();
    }

    @Override
    public boolean updateType(@NotNull PhpType type) {
        if (type == null) {
            FunctionImpl.$$$reportNull$$$0(27);
        }
        if (Function.super.updateType(type)) {
            return true;
        }
        PhpChangeSignatureProcessor.addReturnType((Function)this, PhpMissingReturnTypeInspection.createTypeHint(PhpLanguageLevel.current((Project)this.getProject()), this, type));
        return true;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        Collection<PhpAttribute> collection = FunctionImpl.getAttributesStubAware(this);
        if (collection == null) {
            FunctionImpl.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @Override
    @Nullable
    public PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfo() {
        return FunctionImpl.getDeprecationInfoFromAttribute(this);
    }

    @Override
    @Nullable
    public String getAvailableInLanguageLevelFrom() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub instanceof PhpAvailableInLanguageLevelRangeElement) {
            return ((PhpAvailableInLanguageLevelRangeElement)((Object)stub)).getAvailableInLanguageLevelFrom();
        }
        return this.getAvailableInLanguageLevelFromAstBased();
    }

    @Override
    @Nullable
    public String getAvailableInLanguageLevelTo() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub instanceof PhpAvailableInLanguageLevelRangeElement) {
            return ((PhpAvailableInLanguageLevelRangeElement)((Object)stub)).getAvailableInLanguageLevelTo();
        }
        return this.getAvailableInLanguageLevelToAstBased();
    }

    @Nullable
    public static PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfoFromAttribute(@NotNull PhpAttributesOwner attributeOwner) {
        StubElement stub;
        if (attributeOwner == null) {
            FunctionImpl.$$$reportNull$$$0(29);
        }
        if (attributeOwner instanceof StubBasedPsiElementBase && (stub = ((StubBasedPsiElementBase)attributeOwner).getGreenStub()) instanceof PhpDeprecationInfoOwnerStub) {
            return ((PhpDeprecationInfoOwnerStub)stub).getDeprecationInfo();
        }
        PhpAttribute attribute = (PhpAttribute)ContainerUtil.getFirstItem(attributeOwner.getAttributes("\\JetBrains\\PhpStorm\\Deprecated"));
        if (attribute == null) {
            return null;
        }
        PsiElement[] parameters = attribute.getParameters();
        String reason = FunctionImpl.findParameterByNameOrIndex(parameters, "reason", 0);
        PsiElement replacementDeprecationAttributeParameter = FunctionImpl.getReplacementDeprecationAttributeParameter(parameters);
        String replaceWith = replacementDeprecationAttributeParameter instanceof StringLiteralExpression ? ((StringLiteralExpression)replacementDeprecationAttributeParameter).getContents() : null;
        String version = FunctionImpl.findParameterByNameOrIndex(parameters, "since", 2);
        return new PhpDeprecationAttributeOwner.PhpDeprecationInfo(version, reason, replaceWith);
    }

    public static PsiElement getReplacementDeprecationAttributeParameter(PsiElement[] parameters) {
        return FunctionImpl.getElement(parameters, "replacement", 1);
    }

    @NotNull
    public static PhpType getType(@Nullable PsiElement value) {
        if (value != null) {
            if (PhpLangUtil.isThisReference(value)) {
                PhpClass aClass = PhpClassImpl.getContainingClass(value);
                if (aClass != null) {
                    PhpType phpType = new PhpType().add(PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign(aClass.getFQN()));
                    if (phpType == null) {
                        FunctionImpl.$$$reportNull$$$0(30);
                    }
                    return phpType;
                }
                PhpType phpType = PhpType.EMPTY;
                if (phpType == null) {
                    FunctionImpl.$$$reportNull$$$0(31);
                }
                return phpType;
            }
            PhpType phpType = new PhpType().add(value);
            if (phpType == null) {
                FunctionImpl.$$$reportNull$$$0(32);
            }
            return phpType;
        }
        PhpType phpType = PhpType.VOID;
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(33);
        }
        return phpType;
    }

    @Override
    public Collection<String> getDocExceptions() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub instanceof PhpFunctionStub) {
            return ((PhpFunctionStub)stub).getDocExceptions();
        }
        return FunctionImpl.getDocExceptions(this);
    }

    @Override
    public boolean isReturningByReference() {
        PhpFunctionStub stub = (PhpFunctionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isReturningByReference();
        }
        return this.getReturnByReferenceTokenFromAST() != null;
    }

    @NotNull
    protected static Collection<String> getDocExceptions(@NotNull Function function) {
        PhpDocComment docComment;
        if (function == null) {
            FunctionImpl.$$$reportNull$$$0(34);
        }
        if ((docComment = function.getDocComment()) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                FunctionImpl.$$$reportNull$$$0(35);
            }
            return set;
        }
        Collection collection = Arrays.stream(docComment.getExceptionClasses()).flatMap(type -> type.getTypes().stream()).collect(PhpStringUtil.toCaseInsensitiveSet());
        if (collection == null) {
            FunctionImpl.$$$reportNull$$$0(36);
        }
        return collection;
    }

    @Override
    @NotNull
    public PhpControlFlow getControlFlow() {
        PhpControlFlow phpControlFlow = this.getScope().getControlFlow();
        if (phpControlFlow == null) {
            FunctionImpl.$$$reportNull$$$0(37);
        }
        return phpControlFlow;
    }

    @Override
    @NotNull
    public PhpScope getScope() {
        if (this.myScope == null) {
            this.myScope = new PhpScopeImpl(this);
        }
        PhpScope phpScope = this.myScope;
        if (phpScope == null) {
            FunctionImpl.$$$reportNull$$$0(38);
        }
        return phpScope;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        if (this.myScope != null) {
            this.myScope.clear();
        }
    }

    @Override
    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        Set<CharSequence> set = Collections.emptySet();
        if (set == null) {
            FunctionImpl.$$$reportNull$$$0(39);
        }
        return set;
    }

    @NotNull
    public static PhpType getDeclaredType(@NotNull Function function) {
        if (function == null) {
            FunctionImpl.$$$reportNull$$$0(40);
        }
        PhpType phpType = new PhpType().add(function.getDeclaredType()).add(function.getDocType());
        if (phpType == null) {
            FunctionImpl.$$$reportNull$$$0(41);
        }
        return phpType;
    }

    public static boolean isShortArrowFunction(@Nullable Function function) {
        return function != null && function.getNode().findChildByType(PhpTokenTypes.kwFN) != null;
    }

    @Nullable
    public static PsiElement getShortArrowFunctionArgument(@NotNull Function function) {
        if (function == null) {
            FunctionImpl.$$$reportNull$$$0(42);
        }
        return FunctionImpl.getShortArrowArgument(function);
    }

    public static PsiElement getShortArrowArgument(@NotNull PsiElement element) {
        ASTNode hash;
        if (element == null) {
            FunctionImpl.$$$reportNull$$$0(43);
        }
        if ((hash = element.getNode().findChildByType(PhpTokenTypes.opHASH_ARRAY)) == null) {
            return null;
        }
        return PhpPsiUtil.getNextSiblingIgnoreWhitespace(hash.getPsi(), true);
    }

    public static Parameter[] getParametersForAllLanguageLevels(Function element) {
        return PhpPsiUtil.getChildren(PhpPsiUtil.getChildByCondition(element, ParameterList.INSTANCEOF), Parameter.INSTANCEOF).toArray(Parameter.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 30, 31, 32, 33, 35, 36, 37, 38, 39, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FunctionImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeOwner";
                break;
            }
            case 34: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FunctionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDeclaredType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "returnTags";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTags";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredControlFlowType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocExceptions";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecationInfoFromAttribute";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDocExceptions";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getShortArrowFunctionArgument";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getShortArrowArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 30, 31, 32, 33, 35, 36, 37, 38, 39, 41 -> new IllegalStateException(string);
        };
    }
}

