/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpBaseMemberReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpOptionalCompletionTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class MemberReferenceImpl
extends PhpBaseMemberReference
implements MemberReference {
    private static final String STD_CLASS = "\\stdClass";
    static final java.util.function.Function<PhpExpression, PhpType> CLASS_REFERENCE_TYPE_PROVIDER = PhpTypedElement::getGlobalType;

    protected MemberReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PhpModifier.State getReferenceType() {
        PhpExpression ref = this.getClassReference();
        if (ref != null) {
            if (!(ref instanceof Variable) && !(ref instanceof FieldReference) && "parent".equals(ref.getName())) {
                PhpModifier.State state = PhpModifier.State.PARENT;
                if (state == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(0);
                }
                return state;
            }
            PsiElement nextSibling = ref.getNextSibling();
            if (PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.SCOPE_RESOLUTION)) {
                PhpModifier.State state = PhpModifier.State.STATIC;
                if (state == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(1);
                }
                return state;
            }
        }
        PhpModifier.State state = PhpModifier.State.DYNAMIC;
        if (state == null) {
            MemberReferenceImpl.$$$reportNull$$$0(2);
        }
        return state;
    }

    @Override
    public boolean hasNullSafeDereference() {
        PhpExpression reference = this.getClassReference();
        return this.isNullSafeDereference() || reference instanceof MemberReference && ((MemberReference)reference).hasNullSafeDereference();
    }

    public boolean isNullSafeDereference() {
        PhpExpression reference1 = this.getClassReference();
        return PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)reference1, true), PhpTokenTypes.opQUEST);
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(MemberReferenceImpl.resolveLocal(this), (Object[])new Object[]{this}));
        if (collection == null) {
            MemberReferenceImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = this.getType(this.resolveLocal());
        if (phpType == null) {
            MemberReferenceImpl.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    @NotNull
    protected PhpType getType(Collection<? extends PhpNamedElement> phpNamedElements) {
        PhpType resultType = new PhpType();
        for (PhpNamedElement phpNamedElement : phpNamedElements) {
            PhpType type = this.getResolvedElementType(phpNamedElement);
            Set<String> types = type.getTypesWithParametrisedParts();
            for (String s : types) {
                if (("$this".equals(s) || "static".equals(s)) && phpNamedElement instanceof PhpClassMember) {
                    resultType.add((PsiElement)((PhpClassMember)phpNamedElement).getContainingClass());
                    continue;
                }
                resultType.add(s);
            }
        }
        PhpExpression classReference = this.getClassReference();
        PhpType phpType = new PhpType();
        for (String name : resultType.getTypesWithParametrisedParts()) {
            if (name.equals("static") && classReference instanceof ClassReference) {
                PhpType phpType2 = phpType.add(((ClassReference)classReference).resolveLocalType());
                if (phpType2 == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(5);
                }
                return phpType2;
            }
            phpType.add(name);
        }
        PhpType phpType3 = phpType;
        if (phpType3 == null) {
            MemberReferenceImpl.$$$reportNull$$$0(6);
        }
        return phpType3;
    }

    @NotNull
    protected PhpType getResolvedElementType(PhpNamedElement resolvedElement) {
        PhpType phpType = resolvedElement.getType();
        if (phpType == null) {
            MemberReferenceImpl.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    @NotNull
    static Collection<? extends PhpNamedElement> resolveLocal(@NotNull PhpBaseMemberReference reference) {
        if (reference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(8);
        }
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        PhpExpression classReference = reference.getClassReference();
        if (classReference instanceof PhpReference) {
            Set<? extends PhpNamedElement> c;
            if (MemberReferenceImpl.chainIsTooDeep(classReference)) {
                Set set = Collections.emptySet();
                if (set == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(9);
                }
                return set;
            }
            if (PhpLangUtil.isThisReference((PsiElement)classReference) && (c = MemberReferenceImpl.resolveThisReference(reference)) != null) {
                result.addAll(c);
                HashSet<PhpNamedElement> hashSet = result;
                if (hashSet == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(10);
                }
                return hashSet;
            }
            Collection<PhpNamedElement> phpNamedElements = classReference instanceof Variable ? Collections.singleton((Variable)classReference) : ((PhpReference)classReference).resolveLocal();
            for (PhpNamedElement element : phpNamedElements) {
                PhpType type = element.getType();
                Set<String> types = type.getTypes();
                PsiFile file = reference.getContainingFile();
                if (!(file instanceof PhpFile)) continue;
                MultiMap<String, PhpNamedElement> defs = ((PhpFile)file).getTopLevelDefs();
                for (String fqn : types) {
                    Set<PhpClass> aClasses = fqn.startsWith("__anonymous@") ? Collections.singleton(PhpCompletionContributor.findAnonymousClass((PsiElement)reference, fqn)) : defs.get((Object)fqn);
                    for (PhpNamedElement phpNamedElement : aClasses) {
                        if (!(phpNamedElement instanceof PhpClass) || ((PhpClass)phpNamedElement).isTrait()) continue;
                        Set<? extends PhpNamedElement> elements = reference.resolveMember((PhpClass)phpNamedElement, true);
                        result.addAll(elements);
                    }
                }
            }
        }
        HashSet<PhpNamedElement> hashSet = result;
        if (hashSet == null) {
            MemberReferenceImpl.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @Nullable
    public static Set<? extends PhpNamedElement> resolveThisReference(@NotNull PhpBaseMemberReference reference) {
        PhpClass aClass;
        if (reference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(12);
        }
        if ((aClass = PhpPsiUtil.getParentOfClass((PsiElement)reference, true, PhpClass.class)) != null && !aClass.isTrait()) {
            return reference.resolveMember(aClass, true);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        Collection<? extends PhpNamedElement> collection = this.resolveGlobal(CLASS_REFERENCE_TYPE_PROVIDER);
        if (collection == null) {
            MemberReferenceImpl.$$$reportNull$$$0(13);
        }
        return collection;
    }

    public static Collection<? extends PhpNamedElement> resolveInHierarchy(@NotNull MemberReference memberReference) {
        if (memberReference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(14);
        }
        return MemberReferenceImpl.resolveInHierarchy((PhpBaseMemberReference)((Object)memberReference), CLASS_REFERENCE_TYPE_PROVIDER);
    }

    public static Collection<? extends PhpNamedElement> resolveInHierarchy(@NotNull PhpBaseMemberReference memberReference, java.util.function.Function<PhpExpression, PhpType> classReferenceTypeProvider) {
        if (memberReference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(15);
        }
        if (classReferenceTypeProvider != CLASS_REFERENCE_TYPE_PROVIDER) {
            return MemberReferenceImpl.resolveInHierarchyInner(memberReference, classReferenceTypeProvider);
        }
        return (Collection)CachedValuesManager.getCachedValue((PsiElement)memberReference, () -> CachedValueProvider.Result.createSingleDependency(MemberReferenceImpl.resolveInHierarchyInner(memberReference, classReferenceTypeProvider), (Object)PsiModificationTracker.MODIFICATION_COUNT));
    }

    private static Collection<? extends PhpNamedElement> resolveInHierarchyInner(@NotNull PhpBaseMemberReference memberReference, java.util.function.Function<PhpExpression, PhpType> classReferenceTypeProvider) {
        Set<String> classReferenceTypes;
        if (memberReference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(16);
        }
        PhpExpression classReference = memberReference.getClassReference();
        PhpType classReferenceType = classReferenceTypeProvider.apply(classReference).filterPlurals().filter(PhpType.ARRAY);
        Set<String> set = classReferenceTypes = classReference != null ? classReferenceType.getTypesWithParametrisedParts() : Collections.emptySet();
        if (classReference != null && IdempotenceChecker.isLoggingEnabled()) {
            IdempotenceChecker.logTrace((String)String.format("Resolve member reference: %s\nClass reference: %s\n Class type: %s", memberReference.getText(), classReference.getText(), classReferenceTypes));
        }
        return MemberReferenceImpl.resolveInHierarchyInner(memberReference, classReferenceTypes, classReferenceType);
    }

    private static Collection<? extends PhpNamedElement> resolveInHierarchyInner(PhpBaseMemberReference memberReference, Collection<String> classReferenceTypes, PhpType classReferenceType) {
        Project project = memberReference.getProject();
        HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>();
        PhpClass aClass = PhpPsiUtil.getParentOfClass((PsiElement)memberReference, true, PhpClass.class);
        for (String fqn : classReferenceTypes) {
            String genericInstantiationType = PhpGenericsBaseExtendedWithGenericTypeProvider.findGenericInstantiationType(classReferenceType, fqn);
            if (aClass != null && PhpLangUtil.equalsClassNames(aClass.getFQN(), fqn)) {
                result.addAll(memberReference.resolveMemberWithGenerics(aClass, false, genericInstantiationType));
                if (!result.isEmpty() || !aClass.isTrait()) continue;
                AtomicInteger count = new AtomicInteger(0);
                PhpIndex.getInstance(project).processNestedTraitUsages(aClass, null, (Processor<? super PhpClass>)((Processor)aClass1 -> {
                    Set<? extends PhpNamedElement> elements = memberReference.resolveMemberWithGenerics((PhpClass)aClass1, false, genericInstantiationType);
                    result.addAll(elements);
                    return result.size() < 100 && count.incrementAndGet() < 1000;
                }));
                continue;
            }
            if (fqn.startsWith("\\class-string") && genericInstantiationType != null) {
                List<String> parts = PhpType.getParametrizedParts(genericInstantiationType);
                if (parts.isEmpty()) continue;
                String className = parts.get(0);
                Collection<PhpClass> classes = PhpIndex.getInstance(memberReference.getProject()).getAnyByFQN(className);
                if (classes.isEmpty()) continue;
                result.addAll(memberReference.resolveMemberWithGenerics(classes.iterator().next(), false, genericInstantiationType));
                continue;
            }
            Collection<PhpClass> classes = MemberReferenceImpl.findClasses(memberReference, fqn);
            if (aClass != null && classes.contains(aClass)) {
                result.addAll(memberReference.resolveMemberWithGenerics(aClass, false, genericInstantiationType));
                continue;
            }
            for (PhpClass phpClass : classes) {
                if (MemberReferenceImpl.tryToAddMembersFromContextClass(memberReference, result, aClass, phpClass)) continue;
                result.addAll(memberReference.resolveMemberWithGenerics(phpClass, false, genericInstantiationType));
            }
        }
        return PhpReferenceImpl.extendedResolve2(memberReference, result);
    }

    private static boolean tryToAddMembersFromContextClass(PhpBaseMemberReference memberReference, Set<PhpNamedElement> result, PhpClass aClass, PhpClass phpClass) {
        Set<? extends PhpNamedElement> elementsFromContextClass;
        if (aClass != null && PhpClassHierarchyUtils.isSuperClass(aClass, phpClass, false) && !(elementsFromContextClass = memberReference.resolveMember(aClass, true)).isEmpty() && ContainerUtil.all(elementsFromContextClass, e -> e instanceof PhpClassMember && ((PhpClassMember)e).getModifier().isPrivate())) {
            result.addAll(elementsFromContextClass);
            return true;
        }
        return false;
    }

    public static Stream<? extends PhpNamedElement> lookInSubclasses(Project project, @NotNull MemberReference memberReference, @NotNull String classFqn) {
        if (memberReference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(17);
        }
        if (classFqn == null) {
            MemberReferenceImpl.$$$reportNull$$$0(18);
        }
        return MemberReferenceImpl.lookInSubclasses(project, (PhpBaseMemberReference)((Object)memberReference), classFqn);
    }

    static Stream<? extends PhpNamedElement> lookInSubclasses(Project project, @NotNull PhpBaseMemberReference memberReference, @NotNull String classFqn) {
        StreamEx<PhpClass> subclasses;
        if (memberReference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(19);
        }
        if (classFqn == null) {
            MemberReferenceImpl.$$$reportNull$$$0(20);
        }
        PhpExpression classReference = memberReference.getClassReference();
        if (memberReference.isStatic() && classReference instanceof ClassReference && !PhpLangUtil.canBeResolvedInSubclasses((PsiElement)classReference)) {
            return Stream.empty();
        }
        if (!(memberReference instanceof MemberReferenceImpl) || PhpLangUtil.equalsClassNames(STD_CLASS, classFqn)) {
            return Stream.empty();
        }
        PhpIndex index = PhpIndex.getInstance(project);
        PhpType classReferenceType = classReference != null ? classReference.getGlobalType() : PhpType.EMPTY;
        boolean classReferenceResolveOnlyToClasses = ContainerUtil.and(classReferenceType.getTypes(), fqn -> MemberReferenceImpl.isPlainClass(index, fqn));
        Collection<PhpClass> classesByFQN = index.getAnyByFQN(classFqn);
        boolean allInterfaces = !classesByFQN.isEmpty() && ContainerUtil.all(classesByFQN, PhpClass::isInterface);
        StreamEx<PhpClass> streamEx = subclasses = classReferenceResolveOnlyToClasses ? MemberReferenceImpl.subclasses(index, classReferenceType.getTypes()) : MemberReferenceImpl.subclasses(index, Collections.singleton(classFqn));
        if (allInterfaces) {
            subclasses = MemberReferenceImpl.withSuperClasses(subclasses);
        }
        return ((StreamEx)subclasses.distinct()).flatMap(subclass -> memberReference.resolveMember((PhpClass)subclass, true).stream()).distinct();
    }

    private static StreamEx<PhpClass> withSuperClasses(Stream<PhpClass> subclasses) {
        HashSet res = new HashSet();
        subclasses.forEach(subclass -> PhpClassHierarchyUtils.processSuperClasses(subclass, true, true, (Processor<? super PhpClass>)((Processor)superClass -> {
            if (res.add(superClass)) {
                PhpClassHierarchyUtils.processSuperTraits(superClass, (Processor<? super PhpClass>)((Processor)res::add));
                return true;
            }
            return false;
        })));
        return StreamEx.of(res);
    }

    private static StreamEx<PhpClass> subclasses(PhpIndex index, @NotNull Set<@NlsSafe String> fqns) {
        if (fqns == null) {
            MemberReferenceImpl.$$$reportNull$$$0(21);
        }
        return ((StreamEx)StreamEx.of(fqns).filter(t -> !PhpLangUtil.equalsClassNames(STD_CLASS, t))).flatMap(fqn -> MemberReferenceImpl.subClasses(index, fqn));
    }

    private static Stream<PhpClass> subClasses(PhpIndex index, String fqn) {
        Stream<PhpClass> subclasses = index.getAllSubclasses(fqn).stream();
        Collection<PhpClass> traits = index.getTraitsByFQN(fqn);
        if (!traits.isEmpty()) {
            return Stream.concat(subclasses, traits.stream().flatMap(t -> index.getTraitUsages((PhpClass)t).stream()));
        }
        return subclasses;
    }

    private static boolean isPlainClass(PhpIndex index, String fqn) {
        return ContainerUtil.and(index.getAnyByFQN(fqn), c -> !c.isInterface() && !c.isTrait());
    }

    @NotNull
    private static @Unmodifiable Collection<PhpClass> findClasses(@NotNull PhpBaseMemberReference reference, @NotNull String fqn) {
        PhpClass phpClass;
        if (reference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(22);
        }
        if (fqn == null) {
            MemberReferenceImpl.$$$reportNull$$$0(23);
        }
        Collection<PhpClass> classes = fqn.startsWith("__anonymous@") ? ((phpClass = (PhpClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)reference.getContainingFile(), (int)Integer.parseInt(fqn.substring("__anonymous@".length())), PhpClass.class, (boolean)true)) != null ? Collections.singletonList(phpClass) : ContainerUtil.emptyList()) : PhpIndex.getInstance(reference.getProject()).getAnyByFQN(fqn);
        Set set = ContainerUtil.union(PhpLangUtil.getLocalClasses((PsiElement)reference, fqn), classes);
        if (set == null) {
            MemberReferenceImpl.$$$reportNull$$$0(24);
        }
        return set;
    }

    public static int getDepth(PhpExpression reference) {
        if (reference == null) {
            return 0;
        }
        return (Integer)CachedValuesManager.getCachedValue((PsiElement)reference, () -> CachedValueProvider.Result.create((Object)MemberReferenceImpl.doGetDepth(reference), (Object[])new Object[]{reference}));
    }

    private static int doGetDepth(PhpExpression reference) {
        int d = 0;
        while (reference instanceof MemberReference && ++d <= 101) {
            reference = ((MemberReference)reference).getClassReference();
        }
        return d;
    }

    @Override
    @NotNull
    public Collection<String> getSignatureParts() {
        PhpExpression reference = this.getClassReference();
        if (reference instanceof ClassReference && PhpLangUtil.isParentReference((PsiElement)reference)) {
            PhpClass containingClass;
            Function method = PhpPsiUtil.getParentOfClass((PsiElement)reference, Function.class);
            PhpClass phpClass = containingClass = method instanceof Method ? ((Method)method).getContainingClass() : null;
            if (containingClass != null) {
                String rs = PhpTypeSignatureKey.CLASS.sign(containingClass.getFQN());
                List<String> list = Collections.singletonList(PhpTypeSignatureKey.PARENT.sign(this.getTypeSignatureKey().sign(rs + "." + this.getName())));
                if (list == null) {
                    MemberReferenceImpl.$$$reportNull$$$0(25);
                }
                return list;
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (reference != null) {
            Set<String> types = reference.getType().getTypesWithParametrisedParts();
            for (String type : types) {
                if (PhpType.isNotExtendablePrimitiveType(type)) continue;
                if (type.startsWith("\\class-string")) {
                    for (String part : PhpType.getParametrizedParts(type)) {
                        result.add(this.getTypeSignatureKey().sign(part + "." + this.getName()));
                    }
                    continue;
                }
                String rs = PhpTypeSignatureKey.CLASS.signIfUnsigned(type);
                if (rs.length() <= 2) continue;
                result.add(this.isFluentMethodCall(rs) ? rs : this.getTypeSignatureKey().sign(rs + "." + this.getName()));
            }
            if (reference instanceof Variable && MemberReferenceImpl.mayHaveDynamicClassFQN(this)) {
                for (String dynamicClassFQN : ClassReferenceImpl.inferDynamicClassReferenceFQNs((Variable)reference)) {
                    result.add(PhpOptionalCompletionTP.TYPE_KEY.sign(this.getTypeSignatureKey().sign(dynamicClassFQN + "." + this.getName())));
                }
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            MemberReferenceImpl.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private boolean isFluentMethodCall(String signature) {
        return this.isSignedByCurrentMemberReference(signature) && this.isSignedByCurrentMemberReference(MemberReferenceImpl.extractClassReference(signature));
    }

    @NotNull
    private static String extractClassReference(String signature) {
        String string = signature.substring(2, signature.lastIndexOf(46));
        if (string == null) {
            MemberReferenceImpl.$$$reportNull$$$0(27);
        }
        return string;
    }

    private boolean isSignedByCurrentMemberReference(String rs) {
        return this.getTypeSignatureKey().isSigned(rs) && rs.substring(rs.lastIndexOf(46) + 1).equals(this.getName());
    }

    protected abstract PhpTypeSignatureKey getTypeSignatureKey();

    public static boolean mayHaveDynamicClassFQN(@NotNull PhpBaseMemberReference memberReference) {
        PhpExpression classReference;
        if (memberReference == null) {
            MemberReferenceImpl.$$$reportNull$$$0(28);
        }
        return (classReference = memberReference.getClassReference()) instanceof Variable && !PhpLangUtil.isThisReference((PsiElement)classReference) && memberReference.isStatic();
    }

    public static boolean chainIsTooDeep(PhpExpression classReference) {
        return MemberReferenceImpl.getDepth(classReference) >= 100;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 8, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 28 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/MemberReferenceImpl";
                break;
            }
            case 8: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberReference";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqns";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceType";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedElementType";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/MemberReferenceImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureParts";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClassReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveThisReference";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveInHierarchy";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveInHierarchyInner";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lookInSubclasses";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "subclasses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveDynamicClassFQN";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 8, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 28 -> new IllegalArgumentException(string);
        };
    }
}

