/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.expressions.StaticScalar;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ConstantImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDefineImpl
extends PhpNamedElementImpl<PhpConstantStub>
implements PhpDefine {
    private static final Logger LOG = Logger.getInstance(PhpDefineImpl.class);

    public PhpDefineImpl(ASTNode node) {
        super(node);
    }

    public PhpDefineImpl(PhpConstantStub stub) {
        super(stub, PhpStubElementTypes.DEFINE);
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getConstantPresentation(this);
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        List<PsiElement> operands;
        PsiElement lastOperand;
        PsiElement[] parameters = this.getParameters();
        if (parameters.length > 0 && (lastOperand = (PsiElement)ContainerUtil.getLastItem(operands = PhpDefineImpl.collectOperands(parameters[0]))) != null) {
            return lastOperand.getNode().findChildByType(StaticScalar.STRING_BODY);
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            String stubName = stub.getName();
            return stubName != null ? stubName : "";
        }
        String name = this.getNameUnescaped();
        String string = (PhpLangUtil.isFqn(name) ? "\\" : "") + PhpLangUtil.toShortName(name);
        if (string == null) {
            PhpDefineImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        String string = this.getName();
        if (string == null) {
            PhpDefineImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getNamespaceName() {
        PhpConstantStub stub = (PhpConstantStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getNamespaceName();
            if (string == null) {
                PhpDefineImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = PhpLangUtil.getParentNamespaceFQN(PhpLangUtil.toFQN(this.getNameUnescaped()));
        if (string == null) {
            PhpDefineImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private String getNameUnescaped() {
        PsiElement[] parameters = this.getParameters();
        if (parameters.length > 0) {
            String string = PhpDefineImpl.collectOperands(parameters[0]).stream().map(this::getOperandText).collect(Collectors.joining());
            if (string == null) {
                PhpDefineImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static List<PsiElement> collectOperands(@NotNull PsiElement operand) {
        if (operand == null) {
            PhpDefineImpl.$$$reportNull$$$0(5);
        }
        if (operand instanceof StringLiteralExpression) {
            List<PsiElement> list = Collections.singletonList(operand);
            if (list == null) {
                PhpDefineImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<PsiElement> operands = Collections.emptyList();
        ArrayDeque<PsiElement> stack = new ArrayDeque<PsiElement>(Collections.singleton(operand));
        int depth = 0;
        while (!stack.isEmpty()) {
            if (depth++ > 100) {
                LOG.error("Complex name '" + operand.getText() + "' is too deep to analyze");
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    PhpDefineImpl.$$$reportNull$$$0(7);
                }
                return list;
            }
            PsiElement curr = (PsiElement)stack.pop();
            if (curr instanceof ConcatenationExpression) {
                PhpDefineImpl.pushIfNotNull(stack, ((ConcatenationExpression)curr).getRightOperand());
                PhpDefineImpl.pushIfNotNull(stack, ((ConcatenationExpression)curr).getLeftOperand());
                continue;
            }
            if (curr instanceof ParenthesizedExpression) {
                PhpPsiElement unparenthesized = ((ParenthesizedExpression)curr).extract();
                if (unparenthesized == null) continue;
                PhpDefineImpl.pushIfNotNull(stack, (PsiElement)unparenthesized);
                continue;
            }
            if (curr instanceof StringLiteralExpression || PhpDefineImpl.isNamespaceConstant(curr) || PhpPsiUtil.isOfType(curr, PhpElementTypes.NUMBER)) {
                if (operands.isEmpty()) {
                    operands = new ArrayList<PsiElement>();
                }
                operands.add(curr);
                continue;
            }
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpDefineImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<PsiElement> list = operands;
        if (list == null) {
            PhpDefineImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static void pushIfNotNull(@NotNull Deque<PsiElement> stack, @Nullable PsiElement e) {
        if (stack == null) {
            PhpDefineImpl.$$$reportNull$$$0(10);
        }
        if (e != null) {
            stack.push(e);
        }
    }

    private String getOperandText(PsiElement operand) {
        if (operand instanceof StringLiteralExpression) {
            StringLiteralExpression string = (StringLiteralExpression)operand;
            return PhpStringUtil.unescapeText(string.getContents(), string.isSingleQuote());
        }
        if (PhpDefineImpl.isNamespaceConstant(operand)) {
            return PhpLangUtil.toName(super.getNamespaceName());
        }
        if (PhpPsiUtil.isOfType(operand, PhpElementTypes.NUMBER)) {
            return PhpPsiUtil.getLiteralText(operand);
        }
        return null;
    }

    public static boolean isNamespaceConstant(PsiElement e) {
        return e instanceof ConstantReference && "__NAMESPACE__".equals(e.getText());
    }

    public PsiElement setName(@NonNls @NotNull String name) {
        ASTNode nameNode;
        if (name == null) {
            PhpDefineImpl.$$$reportNull$$$0(11);
        }
        if ((nameNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            char s = nameNode.getElementType() == PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE ? (char)'\'' : '\"';
            PsiElement constantReference = PhpPsiElementFactory.createFromText(this.getProject(), nameNode.getElementType(), s + name + s);
            nameNode.getTreeParent().replaceChild(nameNode, constantReference.getNode());
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpDefineImpl.$$$reportNull$$$0(12);
        }
        phpElementVisitor.visitPhpConstant(this);
    }

    @Override
    public Icon getIcon() {
        return PhpIcons.CONSTANT;
    }

    @Nullable
    public PhpPsiElement getValue() {
        PsiElement[] parameters = this.getParameters();
        return parameters.length > 1 && parameters[1] instanceof PhpPsiElement ? (PhpPsiElement)parameters[1] : null;
    }

    @Override
    @Nullable
    public String getValuePresentation() {
        PhpConstantStub stub = (PhpConstantStub)this.getGreenStub();
        if (stub != null) {
            return stub.getValuePresentation();
        }
        return ConstantImpl.getValuePresentationInternal((PsiElement)this.getValue());
    }

    @Override
    public boolean isCaseSensitive() {
        PhpConstantStub stub = (PhpConstantStub)this.getGreenStub();
        if (stub != null) {
            return stub.isCaseSensitive();
        }
        PsiElement[] parameters = this.getParameters();
        if (parameters.length < 3) {
            return true;
        }
        return !parameters[2].getText().equalsIgnoreCase("true");
    }

    @Override
    public boolean isWriteAccess() {
        return true;
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        return PhpPsiUtil.getDocCommentFor(this, (NullableFunction<? super PhpPsiElement, ? extends PhpPsiElement>)((NullableFunction)element -> (PhpPsiElement)PhpPsiUtil.getParentByCondition((PsiElement)element, Statement.INSTANCEOF, GroupStatement.INSTANCEOF)));
    }

    public PsiElement @NotNull [] getParameters() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof FunctionReference) {
            PsiElement[] psiElementArray = ((FunctionReference)firstChild).getParameters();
            if (psiElementArray == null) {
                PhpDefineImpl.$$$reportNull$$$0(13);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            PhpDefineImpl.$$$reportNull$$$0(14);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpDefineImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameUnescaped";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpDefineImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOperands";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectOperands";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "pushIfNotNull";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

