/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.stubs.PhpEnumCaseStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpEnumCaseImpl
extends PhpNamedElementImpl<PhpEnumCaseStub>
implements PhpEnumCase {
    protected static final PhpEnumCase[] EMPTY_ENUM_ARRAY = new PhpEnumCase[0];

    public PhpEnumCaseImpl(ASTNode node) {
        super(node);
    }

    public PhpEnumCaseImpl(PhpEnumCaseStub stub) {
        super(stub, PhpStubElementTypes.ENUM_CASE);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            PhpEnumCaseImpl.$$$reportNull$$$0(0);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            PhpEnumCase enumCase = PhpPsiElementFactory.createEnumCase(this.getProject(), name, null);
            nameNode.getTreeParent().replaceChild(nameNode, Objects.requireNonNull(enumCase.getNameNode()));
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpEnumCaseImpl.$$$reportNull$$$0(1);
        }
        phpElementVisitor.visitPhpEnumCase(this);
    }

    @Override
    @Nullable
    public PhpExpression getExpression() {
        return (PhpExpression)PhpPsiUtil.getChildByCondition((PsiElement)this, PhpExpression.INSTANCEOF);
    }

    @Override
    @Nullable
    public PhpEnumCase.PhpDefaultValueDescriptor getDefaultValueDescriptor() {
        PhpEnumCaseStub stub = (PhpEnumCaseStub)this.getGreenStub();
        if (stub != null) {
            return stub.getDefaultValueDescriptor();
        }
        return PhpEnumCaseImpl.createDescriptor(this.getExpression());
    }

    @Nullable
    private static PhpEnumCase.PhpDefaultValueDescriptor createDescriptor(@Nullable PhpExpression expression) {
        if (expression instanceof StringLiteralExpression && PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations((PsiElement)expression)) {
            return new PhpStringDefaultValueDescriptor(expression.getText(), ((StringLiteralExpression)expression).isSingleQuote());
        }
        if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.NUMBER)) {
            return new PhpIntDefaultValueDescriptor(expression.getText());
        }
        if (expression != null) {
            return new PhpUnknownDefaultValueDescriptor(expression.getText());
        }
        return null;
    }

    @Override
    @Nullable
    public PhpClass getContainingClass() {
        return (PhpClass)this.getStubOrPsiParentOfType(PhpClass.class);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpIcons.CONSTANT;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        Collection<PhpAttribute> collection = PhpEnumCaseImpl.getAttributesStubAware(this);
        if (collection == null) {
            PhpEnumCaseImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @NotNull
    public PhpModifier getModifier() {
        PhpModifier phpModifier = PhpModifier.PUBLIC_FINAL_STATIC;
        if (phpModifier == null) {
            PhpEnumCaseImpl.$$$reportNull$$$0(3);
        }
        return phpModifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpEnumCaseImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpEnumCaseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class PhpStringDefaultValueDescriptor
    extends PhpEnumCase.PhpDefaultValueDescriptor {
        private final boolean mySingleQuote;

        public PhpStringDefaultValueDescriptor(@NotNull String value, boolean quote) {
            if (value == null) {
                PhpStringDefaultValueDescriptor.$$$reportNull$$$0(0);
            }
            super(value);
            this.mySingleQuote = quote;
        }

        @Override
        @NotNull
        public PhpEnumCase.MatchResult match(@NotNull PsiElement element) {
            if (element == null) {
                PhpStringDefaultValueDescriptor.$$$reportNull$$$0(1);
            }
            if (element instanceof StringLiteralExpression && PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations(element)) {
                PhpEnumCase.MatchResult matchResult = PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.unescapedStringContentsEquals((StringLiteralExpression)element, this.getValue(), this.mySingleQuote) ? PhpEnumCase.MatchResult.MATCHES : PhpEnumCase.MatchResult.NOT_MATCHING;
                if (matchResult == null) {
                    PhpStringDefaultValueDescriptor.$$$reportNull$$$0(2);
                }
                return matchResult;
            }
            PhpEnumCase.MatchResult matchResult = PhpEnumCase.MatchResult.UNKNOWN;
            if (matchResult == null) {
                PhpStringDefaultValueDescriptor.$$$reportNull$$$0(3);
            }
            return matchResult;
        }

        public boolean isSingleQuote() {
            return this.mySingleQuote;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpEnumCaseImpl$PhpStringDefaultValueDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpEnumCaseImpl$PhpStringDefaultValueDescriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "match";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "match";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpIntDefaultValueDescriptor
    extends PhpEnumCase.PhpDefaultValueDescriptor {
        public PhpIntDefaultValueDescriptor(@NotNull String value) {
            if (value == null) {
                PhpIntDefaultValueDescriptor.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @NotNull
        public PhpEnumCase.MatchResult match(@NotNull PsiElement element) {
            if (element == null) {
                PhpIntDefaultValueDescriptor.$$$reportNull$$$0(1);
            }
            if (PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER)) {
                PhpEnumCase.MatchResult matchResult;
                try {
                    matchResult = Integer.parseInt(this.getValue()) == Integer.parseInt(element.getText()) ? PhpEnumCase.MatchResult.MATCHES : PhpEnumCase.MatchResult.NOT_MATCHING;
                }
                catch (NumberFormatException e) {
                    PhpEnumCase.MatchResult matchResult2 = PhpEnumCase.MatchResult.UNKNOWN;
                    if (matchResult2 == null) {
                        PhpIntDefaultValueDescriptor.$$$reportNull$$$0(3);
                    }
                    return matchResult2;
                }
                if (matchResult == null) {
                    PhpIntDefaultValueDescriptor.$$$reportNull$$$0(2);
                }
                return matchResult;
            }
            PhpEnumCase.MatchResult matchResult = PhpEnumCase.MatchResult.UNKNOWN;
            if (matchResult == null) {
                PhpIntDefaultValueDescriptor.$$$reportNull$$$0(4);
            }
            return matchResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpEnumCaseImpl$PhpIntDefaultValueDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpEnumCaseImpl$PhpIntDefaultValueDescriptor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "match";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "match";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpUnknownDefaultValueDescriptor
    extends PhpEnumCase.PhpDefaultValueDescriptor {
        public PhpUnknownDefaultValueDescriptor(@NlsSafe String text) {
            super(text);
        }

        @Override
        @NotNull
        public PhpEnumCase.MatchResult match(@NotNull PsiElement element) {
            if (element == null) {
                PhpUnknownDefaultValueDescriptor.$$$reportNull$$$0(0);
            }
            PhpEnumCase.MatchResult matchResult = PhpEnumCase.MatchResult.UNKNOWN;
            if (matchResult == null) {
                PhpUnknownDefaultValueDescriptor.$$$reportNull$$$0(1);
            }
            return matchResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpEnumCaseImpl$PhpUnknownDefaultValueDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpEnumCaseImpl$PhpUnknownDefaultValueDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "match";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "match";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

