/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpFileImpl;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayIndexImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpFileReferenceSet;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypedElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpFilePathHolderStub;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStub;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStubImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFilePathUtils {
    private static final Logger LOG = Logger.getInstance(PhpFilePathUtils.class);
    public static final String DIRNAME = "dirname";
    static final String FILE_PROTOCOL_PREFIX = "file://";
    static final String PROJECT_PROTOCOL_PREFIX = "project://";
    private static final RecursionGuard<PsiElement> RECURSION_GUARD = RecursionManager.createGuard((String)"php.file.path.elements");

    private PhpFilePathUtils() {
    }

    @Nullable
    public static String getFileName(PsiElement argument) {
        List<String> fileNames = PhpFilePathUtils.getFileNames(argument, null);
        return (String)ContainerUtil.getFirstItem(fileNames);
    }

    @NotNull
    public static List<String> getFileNames(PsiElement argument, @Nullable Function<PsiElement, List<String>> overrideValueSupplier) {
        return PhpFilePathUtils.evaluate(argument, overrideValueSupplier, false);
    }

    @Nullable
    static String evaluate(PsiElement element) {
        List<String> results = PhpFilePathUtils.evaluate(element, null, false);
        return (String)ContainerUtil.getFirstItem(results);
    }

    @NotNull
    public static List<String> evaluate(PsiElement element, @Nullable Function<PsiElement, List<String>> overrideValueSupplier, boolean localOnly) {
        try {
            return DumbService.isDumb((Project)element.getProject()) ? Collections.emptyList() : PhpFilePathUtils.evaluate(element, new HashMap<PsiElement, List<List<PhpFilePathDescriptor>>>(), overrideValueSupplier, localOnly);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating element '" + element.getText() + "' in " + element.getContainingFile(), e);
        }
    }

    @NotNull
    private static List<String> evaluate(PsiElement element, Map<PsiElement, List<List<PhpFilePathDescriptor>>> visited, @Nullable Function<PsiElement, List<String>> overrideValueSupplier, boolean localOnly) {
        List<List<PhpFilePathDescriptor>> collection = PhpFilePathUtils.doEvaluatePreventingRecursion(element, visited, (Ref<Integer>)Ref.create((Object)0), overrideValueSupplier, localOnly);
        List list = ContainerUtil.map(collection, parts -> PhpFilePathUtils.concatToString(element.getProject(), parts, new HashSet<PsiElement>()));
        if (list == null) {
            PhpFilePathUtils.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static String concatToString(@NotNull Project project, List<PhpFilePathDescriptor> parts, Collection<PsiElement> visited) {
        if (project == null) {
            PhpFilePathUtils.$$$reportNull$$$0(1);
        }
        String string = StringUtil.join(parts, s -> s.evaluate(project, visited), (String)"");
        if (string == null) {
            PhpFilePathUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static List<List<PhpFilePathDescriptor>> doEvaluatePreventingRecursion(@Nullable PsiElement element, Map<PsiElement, List<List<PhpFilePathDescriptor>>> visited, Ref<Integer> depth, @Nullable Function<PsiElement, List<String>> overrideValueSupplier, boolean localOnly) {
        if (element == null) {
            List<List<PhpFilePathDescriptor>> list = Collections.emptyList();
            if (list == null) {
                PhpFilePathUtils.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = (List)ObjectUtils.notNull((Object)((List)RECURSION_GUARD.doPreventingRecursion((Object)element, false, () -> PhpFilePathUtils.doEvaluate(element, visited, depth, overrideValueSupplier, localOnly))), Collections.emptyList());
        if (list == null) {
            PhpFilePathUtils.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<List<PhpFilePathDescriptor>> doEvaluate(PsiElement element, Map<PsiElement, List<List<PhpFilePathDescriptor>>> visited, Ref<Integer> depth, @Nullable Function<PsiElement, List<String>> overrideValueSupplier, boolean localOnly) {
        PhpPsiElement index;
        PhpPsiElement value;
        SmartList resultFromResolvedElements;
        Collection results;
        String name;
        List<PhpFilePathDescriptor> v2;
        PsiFile file;
        List overrideValue;
        List<String> appliedValue;
        PsiElement parent;
        depth.set((Object)((Integer)depth.get() + 1));
        if (element == null) {
            List<List<PhpFilePathDescriptor>> list = Collections.emptyList();
            if (list == null) {
                PhpFilePathUtils.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (localOnly && element instanceof Variable && ((Variable)element).isWriteAccess(false) && (!((parent = element.getParent()) instanceof AssignmentExpression) || ((AssignmentExpression)parent).getVariable() != element)) {
            List<List<PhpFilePathDescriptor>> list = Collections.emptyList();
            if (list == null) {
                PhpFilePathUtils.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (visited.containsKey(element)) {
            List<List<PhpFilePathDescriptor>> list = visited.get(element);
            if (list == null) {
                PhpFilePathUtils.$$$reportNull$$$0(7);
            }
            return list;
        }
        visited.put((PsiElement)element, Collections.emptyList());
        Project project = element.getProject();
        if (overrideValueSupplier != null && (appliedValue = overrideValueSupplier.apply((PsiElement)element)) != null && !(overrideValue = ContainerUtil.map(appliedValue, v -> PhpProjectRelativeStringFilePathDescriptor.fullPath(v, project))).isEmpty()) {
            return PhpFilePathUtils.cacheList(visited, (PsiElement)element, overrideValue);
        }
        int maxDepth = Registry.get((String)"php.include.evaluate.depth.max").asInteger();
        if ((Integer)depth.get() > maxDepth) {
            LOG.info("Expression is too complex, reached maximum allowed depth of " + maxDepth + " tree levels at " + (PsiElement)element + " in " + element.getContainingFile().getName());
            List<List<PhpFilePathDescriptor>> list = Collections.emptyList();
            if (list == null) {
                PhpFilePathUtils.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.PARENTHESIZED_EXPRESSION)) {
            PhpPsiElement child = ((PhpPsiElement)element).getFirstPsiChild();
            if (child == null) {
                return PhpFilePathUtils.cache(visited, (PsiElement)element, null);
            }
            element = child;
        }
        if ((element instanceof Variable || element instanceof ConstantReference || element instanceof FunctionReference) && (file = element.getContainingFile()) instanceof PhpFileImpl && !(v2 = PhpProjectRelativeStringFilePathDescriptor.fullPath(((PhpFileImpl)file).findDefinedVariableValue(element.getText()), project)).isEmpty()) {
            return PhpFilePathUtils.cache(visited, (PsiElement)element, v2);
        }
        if (element instanceof ClassConstantReference) {
            Collection<? extends PhpNamedElement> constants;
            String signature = ((ClassConstantReference)element).getSignature();
            Collection<? extends PhpNamedElement> collection = constants = localOnly ? ((ClassConstantReference)element).resolveLocal() : PhpIndex.getInstance(project).getBySignature(signature);
            if (localOnly && constants.isEmpty()) {
                return PhpFilePathUtils.cache(visited, (PsiElement)element, PhpSignatureFilePathDescriptor.signature(signature));
            }
            for (PhpNamedElement phpNamedElement : constants) {
                if (!(phpNamedElement instanceof Field)) continue;
                return PhpFilePathUtils.cache(visited, (PsiElement)element, PhpProjectRelativeStringFilePathDescriptor.fullPath(StringUtil.unquoteString((String)StringUtil.defaultIfEmpty((String)((Field)phpNamedElement).getDefaultValuePresentation(), (String)"")), project));
            }
        }
        if (element instanceof ConstantReference) {
            name = ((ConstantReference)element).getName();
            if ("__DIR__".equals(name)) {
                PsiDirectory directory = element.getContainingFile().getOriginalFile().getContainingDirectory();
                return PhpFilePathUtils.cache(visited, (PsiElement)element, directory != null ? PhpProjectRelativeStringFilePathDescriptor.fullPath(directory.getVirtualFile().getPath(), project) : null);
            }
            if ("__FILE__".equals(name)) {
                return PhpFilePathUtils.cache(visited, (PsiElement)element, PhpProjectRelativeStringFilePathDescriptor.fullPath(PhpFilePathUtils.getPathToFileContaining((PsiElement)element), project));
            }
            results = localOnly ? ((ConstantReference)element).resolveLocal() : ContainerUtil.map((Object[])((ConstantReference)element).multiResolve(false), ResolveResult::getElement);
            resultFromResolvedElements = new SmartList();
            if (localOnly && results.isEmpty()) {
                resultFromResolvedElements.add(PhpSignatureFilePathDescriptor.signature(((ConstantReference)element).getSignature()));
            }
            for (PsiElement target : results) {
                if (!(target instanceof Constant)) continue;
                PsiElement value2 = ((Constant)target).getValue();
                StubElement stub = ((PhpTypedElementImpl)target).getGreenStub();
                if (stub instanceof PhpConstantStubImpl) {
                    resultFromResolvedElements.addAll(((PhpConstantStubImpl)stub).getFilePaths());
                    continue;
                }
                resultFromResolvedElements.addAll(PhpFilePathUtils.doEvaluatePreventingRecursion(value2, visited, depth, overrideValueSupplier, localOnly));
            }
            return !resultFromResolvedElements.isEmpty() ? PhpFilePathUtils.cacheList(visited, (PsiElement)element, (List<List<PhpFilePathDescriptor>>)resultFromResolvedElements) : PhpFilePathUtils.cache(visited, (PsiElement)element, null);
        }
        if (element instanceof ArrayAccessExpression && (value = ((ArrayAccessExpression)element).getValue()) instanceof Variable && "_SERVER".contentEquals(((Variable)value).getNameCS()) && (index = ((ArrayAccessExpression)element).getIndex()) != null && (index = ((ArrayIndexImpl)index).getValue()) instanceof StringLiteralExpression && ((StringLiteralExpression)index).getContents().equals("DOCUMENT_ROOT")) {
            String path = PhpRuntimeConfiguration.getInstance(project).getResolvedDocumentRootPath();
            return PhpFilePathUtils.cache(visited, (PsiElement)element, PhpProjectRelativeStringFilePathDescriptor.fullPath(StringUtil.isEmpty((String)path) ? project.getBaseDir().getPath() : path, project));
        }
        if (element instanceof Variable) {
            List variables = PhpFilePathUtils.resolveVariables((PsiElement)element, localOnly);
            results = localOnly ? ContainerUtil.filter(variables, v -> v instanceof Variable && ((Variable)v).isWriteAccess(false)) : variables;
            resultFromResolvedElements = new SmartList();
            if (localOnly && results.isEmpty()) {
                resultFromResolvedElements.add(PhpSignatureFilePathDescriptor.variable(((Variable)element).getName()));
            }
            for (PsiElement target : results) {
                if (!(target instanceof VariableImpl)) continue;
                PhpVariableStub stub = (PhpVariableStub)((VariableImpl)target).getGreenStub();
                if (stub instanceof PhpVariableStubImpl) {
                    resultFromResolvedElements.addAll(((PhpVariableStubImpl)stub).getFilePaths());
                    continue;
                }
                AssignmentExpression assignmentExpression = (AssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)target, AssignmentExpression.class, (boolean)true, (Class[])new Class[]{Statement.class});
                if (assignmentExpression == null || assignmentExpression.getVariable() != target) continue;
                PhpPsiElement value3 = assignmentExpression.getValue();
                resultFromResolvedElements.addAll(PhpFilePathUtils.doEvaluatePreventingRecursion((PsiElement)value3, visited, depth, overrideValueSupplier, localOnly));
            }
            return !resultFromResolvedElements.isEmpty() ? PhpFilePathUtils.cacheList(visited, (PsiElement)element, (List<List<PhpFilePathDescriptor>>)resultFromResolvedElements) : PhpFilePathUtils.cache(visited, (PsiElement)element, null);
        }
        if (element instanceof FunctionReference) {
            name = ((FunctionReference)element).getName();
            if (name != null && (name.equalsIgnoreCase(DIRNAME) || name.equalsIgnoreCase("realpath") || name.equalsIgnoreCase("getcwd"))) {
                PsiElement p = ((FunctionReference)element).getParameter(0);
                if (p != null) {
                    @NotNull List<List<PhpFilePathDescriptor>> vs = PhpFilePathUtils.doEvaluatePreventingRecursion(p, visited, depth, overrideValueSupplier, localOnly);
                    SmartList smartList = new SmartList();
                    for (List<PhpFilePathDescriptor> v3 : vs) {
                        if (name.equalsIgnoreCase(DIRNAME)) {
                            smartList.add(PhpDirUpFilePathDescriptor.create(v3, PhpFilePathUtils.getLevel((FunctionReference)element)));
                            continue;
                        }
                        smartList.add(v3);
                    }
                    return PhpFilePathUtils.cacheList(visited, (PsiElement)element, (List<List<PhpFilePathDescriptor>>)smartList);
                }
                PsiDirectory directory = element.getContainingFile().getOriginalFile().getContainingDirectory();
                return PhpFilePathUtils.cache(visited, (PsiElement)element, directory != null ? PhpProjectRelativeStringFilePathDescriptor.fullPath(directory.getVirtualFile().getPath(), project) : null);
            }
            return PhpFilePathUtils.cache(visited, (PsiElement)element, null);
        }
        if (PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.STRING)) {
            ArrayList<PhpFilePathDescriptor> stringRes = new ArrayList<PhpFilePathDescriptor>();
            int s = 1;
            String text = element.getText();
            for (PsiElement child : element.getChildren()) {
                if (!(child instanceof Variable)) continue;
                List<PhpFilePathDescriptor> v4 = PhpFilePathUtils.findVariableDescriptors((PsiElement)element, visited, depth, overrideValueSupplier, localOnly, ((Variable)child).getName());
                if (!v4.isEmpty()) {
                    TextRange range = child.getTextRangeInParent();
                    String prefix = text.substring(1, range.getStartOffset());
                    if (!prefix.isEmpty()) {
                        stringRes.addAll(PhpProjectRelativeStringFilePathDescriptor.fullPath(prefix, project));
                    }
                    stringRes.add((PhpFilePathDescriptor)ContainerUtil.getFirstItem(v4));
                    s = range.getEndOffset();
                    continue;
                }
                return PhpFilePathUtils.cache(visited, (PsiElement)element, Collections.emptyList());
            }
            if (s < text.length()) {
                stringRes.addAll(PhpProjectRelativeStringFilePathDescriptor.fullPath(text.substring(s, text.length() - 1), project));
            }
            return PhpFilePathUtils.cache(visited, (PsiElement)element, stringRes);
        }
        if (element instanceof ConcatenationExpression) {
            ConcatenationExpression concatExpr = (ConcatenationExpression)element;
            PsiElement leftOperand = concatExpr.getLeftOperand();
            PsiElement rightOperand = concatExpr.getRightOperand();
            List<List<PhpFilePathDescriptor>> list = PhpFilePathUtils.doEvaluatePreventingRecursion(leftOperand, visited, depth, overrideValueSupplier, localOnly);
            List<List<PhpFilePathDescriptor>> rightOperandEvalResults = PhpFilePathUtils.doEvaluatePreventingRecursion(rightOperand, visited, depth, overrideValueSupplier, localOnly);
            if (!list.isEmpty() && !rightOperandEvalResults.isEmpty()) {
                ArrayList<List<PhpFilePathDescriptor>> results3 = new ArrayList<List<PhpFilePathDescriptor>>();
                for (List<PhpFilePathDescriptor> leftResult : list) {
                    for (List<PhpFilePathDescriptor> rightResult : rightOperandEvalResults) {
                        results3.add(ContainerUtil.concat(leftResult, rightResult));
                    }
                }
                return PhpFilePathUtils.cacheList(visited, (PsiElement)element, results3);
            }
        }
        return PhpFilePathUtils.cache(visited, (PsiElement)element, null);
    }

    @NotNull
    private static Collection<? extends PsiElement> resolveVariables(PsiElement element, boolean localOnly) {
        if (localOnly) {
            Collection<Object> collection = VariableImpl.isLocalWriteAccess(element) ? Collections.singletonList(element) : ((Variable)element).resolveLocal();
            if (collection == null) {
                PhpFilePathUtils.$$$reportNull$$$0(9);
            }
            return collection;
        }
        List list = ContainerUtil.map((Object[])((Variable)element).multiResolve(false), ResolveResult::getElement);
        if (list == null) {
            PhpFilePathUtils.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static List<PhpFilePathDescriptor> findVariableDescriptors(PsiElement element, Map<PsiElement, List<List<PhpFilePathDescriptor>>> visited, Ref<Integer> depth, @Nullable Function<PsiElement, List<String>> overrideValueSupplier, boolean localOnly, String name) {
        String variableValue = ((PhpFileImpl)element.getContainingFile().getOriginalFile()).findDefinedVariableValue("$" + name);
        List<PhpFilePathDescriptor> v = PhpProjectRelativeStringFilePathDescriptor.fullPath(variableValue, element.getProject());
        if (v.isEmpty()) {
            if (localOnly) {
                List<PhpFilePathDescriptor> list = PhpSignatureFilePathDescriptor.variable(name);
                if (list == null) {
                    PhpFilePathUtils.$$$reportNull$$$0(11);
                }
                return list;
            }
            Collection<Variable> byName = PhpIndex.getInstance(element.getProject()).getVariablesByName(name);
            for (Variable variable : byName) {
                PhpVariableStub stub = (PhpVariableStub)((VariableImpl)variable).getGreenStub();
                List<List<PhpFilePathDescriptor>> evaluate = stub instanceof PhpVariableStubImpl ? ((PhpVariableStubImpl)stub).getFilePaths() : PhpFilePathUtils.doEvaluatePreventingRecursion((PsiElement)variable, visited, depth, overrideValueSupplier, localOnly);
                List evaluatedItem = (List)ContainerUtil.getFirstItem(evaluate);
                if (evaluatedItem == null || evaluatedItem.isEmpty()) continue;
                List list = evaluatedItem;
                if (list == null) {
                    PhpFilePathUtils.$$$reportNull$$$0(12);
                }
                return list;
            }
        }
        List<PhpFilePathDescriptor> list = v;
        if (list == null) {
            PhpFilePathUtils.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static String getPathToFileContaining(@NotNull PsiElement element) {
        if (element == null) {
            PhpFilePathUtils.$$$reportNull$$$0(14);
        }
        String string = element.getContainingFile().getOriginalFile().getVirtualFile().getPath();
        if (string == null) {
            PhpFilePathUtils.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static int getLevel(FunctionReference dirnameCall) {
        PsiElement levels = dirnameCall.getParameter(1);
        return levels != null ? StringUtil.parseInt((String)levels.getText(), (int)1) : -1;
    }

    @NotNull
    private static String traverseDirUp(String path, int level) {
        int slash = path.lastIndexOf(47, path.length() - 2);
        if (level >= 0) {
            for (int i = 1; i < level; ++i) {
                if (slash < 0) {
                    String string = path;
                    if (string == null) {
                        PhpFilePathUtils.$$$reportNull$$$0(16);
                    }
                    return string;
                }
                slash = path.lastIndexOf(47, slash - 1);
            }
        }
        String string = slash >= 0 ? path.substring(0, slash) : path;
        if (string == null) {
            PhpFilePathUtils.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static List<List<PhpFilePathDescriptor>> cache(@NotNull Map<PsiElement, List<List<PhpFilePathDescriptor>>> visited, @NotNull PsiElement element, @Nullable List<PhpFilePathDescriptor> result) {
        if (visited == null) {
            PhpFilePathUtils.$$$reportNull$$$0(18);
        }
        if (element == null) {
            PhpFilePathUtils.$$$reportNull$$$0(19);
        }
        if (result == null || result.isEmpty()) {
            return PhpFilePathUtils.cacheList(visited, element, Collections.emptyList());
        }
        return PhpFilePathUtils.cacheList(visited, element, Collections.singletonList(result));
    }

    @NotNull
    private static List<List<PhpFilePathDescriptor>> cacheList(@NotNull Map<PsiElement, List<List<PhpFilePathDescriptor>>> visited, @NotNull PsiElement element, @NotNull List<List<PhpFilePathDescriptor>> result) {
        if (visited == null) {
            PhpFilePathUtils.$$$reportNull$$$0(20);
        }
        if (element == null) {
            PhpFilePathUtils.$$$reportNull$$$0(21);
        }
        if (result == null) {
            PhpFilePathUtils.$$$reportNull$$$0(22);
        }
        visited.put(element, result);
        List<List<PhpFilePathDescriptor>> list = result;
        if (list == null) {
            PhpFilePathUtils.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    public static PsiFile getIncludedFile(PsiFile containingFile, PsiElement argument) {
        String relPath;
        VirtualFile virtualFile = containingFile.getOriginalFile().getVirtualFile();
        VirtualFile included = virtualFile.findFileByRelativePath("../" + (relPath = PhpFilePathUtils.getFileName(argument)));
        if (included == null && relPath != null) {
            included = VirtualFileManager.getInstance().findFileByUrl(relPath);
        }
        PsiFile file = included != null ? containingFile.getManager().findFile(included) : null;
        return file instanceof PhpFile ? (PhpFile)file : null;
    }

    @NotNull
    public static String getStaticPath(PhpPsiElement argument) {
        PhpPsiElement child = PhpFilePathUtils.getStaticElement(argument);
        if (child == null) {
            return "";
        }
        if (PhpPsiUtil.isOfType(child.getFirstChild(), PhpDocTokenTypes.DOC_URL)) {
            child = argument.getFirstChild();
        }
        String path = StringUtil.unquoteString((String)child.getText());
        if (child instanceof PhpDocRef) {
            path = StringUtil.trimStart((String)path, (String)"/");
        }
        String string = path = StringUtil.trimStart((String)path, (String)"./");
        if (string == null) {
            PhpFilePathUtils.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    public static PhpPsiElement getStaticElement(PhpPsiElement argument) {
        PhpPsiElement child = argument;
        if (child == null) {
            return null;
        }
        if (child instanceof PhpDocRef || PhpFilePathUtils.isFileUrl(child)) {
            return child;
        }
        if (PhpPsiUtil.isOfType((PsiElement)child, PhpElementTypes.PARENTHESIZED_EXPRESSION)) {
            child = child.getFirstPsiChild();
        }
        if (child instanceof StringLiteralExpression) {
            return child;
        }
        if (child instanceof BinaryExpression && PhpPsiUtil.isOfType((PsiElement)child, PhpElementTypes.CONCATENATION_EXPRESSION)) {
            PsiElement[] elements = child.getChildren();
            for (int i = elements.length - 1; i >= 0; --i) {
                PsiElement element = elements[i];
                if (!(element instanceof PhpPsiElement)) continue;
                if (!(element instanceof StringLiteralExpression)) break;
                return (StringLiteralExpression)element;
            }
        }
        return null;
    }

    private static boolean isFileUrl(PhpPsiElement element) {
        PsiElement firstChild = element.getFirstChild();
        return PhpPsiUtil.isOfType(firstChild, PhpDocTokenTypes.DOC_URL) && (firstChild.getText().startsWith(FILE_PROTOCOL_PREFIX) || firstChild.getText().startsWith(PROJECT_PROTOCOL_PREFIX));
    }

    public static int getFilePathRelativeOffset(int textOffset, PhpPsiElement argument) {
        PhpPsiElement element = PhpFilePathUtils.getStaticElement(argument);
        if (element == null) {
            return 0;
        }
        int offset = element.getTextOffset() - textOffset;
        String text = element.getText();
        if (StringUtil.isQuotedString((String)text)) {
            ++offset;
        }
        String path = StringUtil.unquoteString((String)text);
        if (element instanceof PhpDocRef && path.startsWith("/")) {
            ++offset;
        }
        if (path.startsWith("./")) {
            offset += 2;
        }
        return offset;
    }

    @Nullable
    public static String getSingleDynamicPath(PhpPsiElement argument) {
        List<String> paths = PhpFilePathUtils.getDynamicPaths(argument);
        return (String)ContainerUtil.getFirstItem(paths);
    }

    @NotNull
    public static @NotNull List<@NotNull String> getDynamicPaths(PhpPsiElement argument) {
        List list = ContainerUtil.notNullize(PhpFilePathUtils.getDynamicPaths(argument, () -> PhpFilePathUtils.getFileNames((PsiElement)argument, null)));
        if (list == null) {
            PhpFilePathUtils.$$$reportNull$$$0(25);
        }
        return list;
    }

    public static @Nullable List<@NotNull String> getDynamicPaths(PhpPsiElement argument, @NotNull Supplier<? extends List<String>> fullFilePathSupplier) {
        PhpPsiElement child;
        if (fullFilePathSupplier == null) {
            PhpFilePathUtils.$$$reportNull$$$0(26);
        }
        if ((child = argument) instanceof ParenthesizedExpression) {
            child = ((ParenthesizedExpression)child).getArgument();
        }
        if (child instanceof StringLiteralExpression) {
            return null;
        }
        List<String> fullPaths = fullFilePathSupplier.get();
        String s = PhpFilePathUtils.getStaticPath(argument);
        SmartList dynamicPaths = new SmartList();
        for (String full : fullPaths) {
            int index;
            if (full == null || s.length() <= 0 || (index = full.indexOf(s)) < 0) continue;
            dynamicPaths.add(full.substring(0, index));
        }
        return dynamicPaths;
    }

    @NlsSafe
    public static String computeFilePath(String value, TextRange rangeInParent, ASTNode node, String elementText) {
        ASTNode leaf = node.findLeafElementAt(rangeInParent.getStartOffset());
        if (leaf == null) {
            throw new RuntimeException("null leaf node @offset " + rangeInParent.getStartOffset() + "in '" + elementText + "'");
        }
        if (PhpPsiUtil.isOfType(leaf, PhpDocTokenTypes.DOC_URL)) {
            return value;
        }
        PsiElement element = leaf.getPsi().getParent();
        assert (element != null);
        if (element instanceof PhpDocRef) {
            return value;
        }
        boolean isReadingString = PhpElementTypes.STRING.equals(element.getNode().getElementType());
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        while (offset < value.length()) {
            if (isReadingString) {
                int quoteOffset;
                if (value.charAt(offset) == '\"' || value.charAt(offset) == '\'') {
                    ++offset;
                }
                if ((quoteOffset = value.indexOf(34, offset)) < 0) {
                    quoteOffset = value.indexOf(39, offset);
                }
                if (quoteOffset < offset) {
                    quoteOffset = value.length();
                }
                sb.append(value, offset, quoteOffset);
                offset = quoteOffset + 2;
            } else {
                int pointOffset = value.indexOf(46, offset);
                if (pointOffset < 0) {
                    pointOffset = value.length();
                }
                String idValue = null;
                if ((element instanceof Variable || element instanceof ConstantReference || element instanceof FunctionReference) && (idValue = PhpFilePathUtils.evaluate(element)) != null && idValue.startsWith(FILE_PROTOCOL_PREFIX)) {
                    idValue = idValue.substring(7);
                }
                if (idValue != null) {
                    sb.append(idValue);
                }
                for (offset = pointOffset + 1; offset < value.length() && value.charAt(offset) == ' '; ++offset) {
                }
            }
            if (offset < value.length() && (value.charAt(offset) == '\"' || value.charAt(offset) == '\'')) {
                isReadingString = true;
                ++offset;
                continue;
            }
            isReadingString = false;
        }
        return sb.toString();
    }

    public static PsiReference @NotNull [] getReferences(final PsiElement element, final PhpPsiElement argument) {
        if (PhpFilePathUtils.getStaticPath(argument).length() > 0) {
            FileReference[] fileReferences = new PhpFileReferenceSet(element, argument, null).getAllReferences();
            if (fileReferences.length > 0) {
                if (fileReferences == null) {
                    PhpFilePathUtils.$$$reportNull$$$0(27);
                }
                return fileReferences;
            }
            PsiReference psiReference = new PsiReference(){

                @NotNull
                public PsiElement getElement() {
                    PsiElement psiElement = element.getFirstChild();
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiElement;
                }

                @NotNull
                public TextRange getRangeInElement() {
                    TextRange textRange = element.getFirstChild().getTextRange();
                    if (textRange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return textRange;
                }

                public PsiElement resolve() {
                    return PhpFilePathUtils.getIncludedFile(element.getContainingFile(), (PsiElement)argument);
                }

                @NotNull
                public String getCanonicalText() {
                    String string = this.getRangeInElement().substring(this.getElement().getText());
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                    if (newElementName == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return null;
                }

                public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return null;
                }

                public boolean isReferenceTo(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return element2 instanceof PhpFile && element2 == this.resolve();
                }

                public boolean isSoft() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 3, 4, 5 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$1";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElementName";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getRangeInElement";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getCanonicalText";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "handleElementRename";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "bindToElement";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray;
                            objectArray[2] = "isReferenceTo";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 3, 4, 5 -> new IllegalArgumentException(string);
                    };
                }
            };
            PsiReference[] psiReferenceArray = new PsiReference[]{psiReference};
            if (psiReferenceArray == null) {
                PhpFilePathUtils.$$$reportNull$$$0(28);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PhpFilePathUtils.$$$reportNull$$$0(29);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public static List<List<PhpFilePathDescriptor>> evaluateLocally(PsiElement psi) {
        if (psi == null) {
            List<List<PhpFilePathDescriptor>> list = Collections.emptyList();
            if (list == null) {
                PhpFilePathUtils.$$$reportNull$$$0(30);
            }
            return list;
        }
        if (psi instanceof Constant) {
            return PhpFilePathUtils.evaluateLocally(((Constant)psi).getValue());
        }
        return PhpFilePathUtils.doEvaluatePreventingRecursion(psi, new HashMap<PsiElement, List<List<PhpFilePathDescriptor>>>(), (Ref<Integer>)Ref.create((Object)0), null, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 14, 18, 19, 20, 21, 22, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullFilePathSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 1: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "concatToString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doEvaluatePreventingRecursion";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doEvaluate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVariables";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariableDescriptors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToFileContaining";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseDirUp";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheList";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicPaths";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateLocally";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "concatToString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPathToFileContaining";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cacheList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 14, 18, 19, 20, 21, 22, 26 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpProjectRelativeStringFilePathDescriptor
    implements PhpFilePathDescriptor {
        private static final int VALUE_LENGTH_LIMIT = 200;
        private final String myRelativePath;

        public PhpProjectRelativeStringFilePathDescriptor(String relativePath) {
            this.myRelativePath = relativePath;
        }

        @Override
        public String evaluate(@NotNull Project project, Collection<PsiElement> visited) {
            if (project == null) {
                PhpProjectRelativeStringFilePathDescriptor.$$$reportNull$$$0(0);
            }
            String projectDirPath = PhpProjectRelativeStringFilePathDescriptor.getProjectDirPath(project);
            assert (projectDirPath != null) : "can't guess project directory";
            return projectDirPath + this.getRelativePath();
        }

        public String getRelativePath() {
            return this.myRelativePath;
        }

        public static List<PhpFilePathDescriptor> fullPath(@Nullable String path, @NotNull Project project) {
            if (project == null) {
                PhpProjectRelativeStringFilePathDescriptor.$$$reportNull$$$0(1);
            }
            if (path == null) {
                return Collections.emptyList();
            }
            String projectDirPath = PhpProjectRelativeStringFilePathDescriptor.getProjectDirPath(project);
            if (projectDirPath != null && path.startsWith(projectDirPath)) {
                String relativeValue = path.substring(projectDirPath.length());
                if (relativeValue.length() >= 200) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(new PhpProjectRelativeStringFilePathDescriptor(relativeValue));
            }
            return PhpStringFilePathDescriptor.string(path);
        }

        @Nullable
        private static String getProjectDirPath(@NotNull Project project) {
            VirtualFile projectDir;
            if (project == null) {
                PhpProjectRelativeStringFilePathDescriptor.$$$reportNull$$$0(2);
            }
            return (projectDir = ProjectUtil.guessProjectDir((Project)project)) != null ? projectDir.getPath() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$PhpProjectRelativeStringFilePathDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fullPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getProjectDirPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpSignatureFilePathDescriptor
    implements PhpFilePathDescriptor {
        private final String mySignature;

        public PhpSignatureFilePathDescriptor(String signature) {
            this.mySignature = signature;
        }

        @Override
        public String evaluate(@NotNull Project project, Collection<PsiElement> visited) {
            if (project == null) {
                PhpSignatureFilePathDescriptor.$$$reportNull$$$0(0);
            }
            for (PhpNamedElement phpNamedElement : PhpIndex.getInstance(project).getBySignature(this.mySignature)) {
                PhpTypedStub stub;
                if (!(phpNamedElement instanceof PhpTypedElementImpl) || !visited.add((PsiElement)phpNamedElement) || !((stub = (PhpTypedStub)((PhpTypedElementImpl)((Object)phpNamedElement)).getGreenStub()) instanceof PhpFilePathHolderStub)) continue;
                for (List<PhpFilePathDescriptor> path : ((PhpFilePathHolderStub)((Object)stub)).getFilePaths()) {
                    String res = PhpFilePathUtils.concatToString(project, path, visited);
                    if (res.isEmpty()) continue;
                    return res;
                }
            }
            return null;
        }

        public static List<PhpFilePathDescriptor> variable(String name) {
            return PhpSignatureFilePathDescriptor.signature(PhpTypeSignatureKey.VARIABLE.sign(name));
        }

        public static List<PhpFilePathDescriptor> signature(String signature) {
            return Collections.singletonList(new PhpSignatureFilePathDescriptor(signature));
        }

        public String getSignature() {
            return this.mySignature;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$PhpSignatureFilePathDescriptor", "evaluate"));
        }
    }

    public static class PhpDirUpFilePathDescriptor
    implements PhpFilePathDescriptor {
        private final List<PhpFilePathDescriptor> myDescriptors;
        private final int myLevel;

        public PhpDirUpFilePathDescriptor(List<PhpFilePathDescriptor> descriptors, int level) {
            this.myDescriptors = descriptors;
            this.myLevel = level;
        }

        @Override
        public String evaluate(@NotNull Project project, Collection<PsiElement> visited) {
            if (project == null) {
                PhpDirUpFilePathDescriptor.$$$reportNull$$$0(0);
            }
            return PhpFilePathUtils.traverseDirUp(PhpFilePathUtils.concatToString(project, this.myDescriptors, visited), this.myLevel);
        }

        public static List<PhpFilePathDescriptor> create(List<PhpFilePathDescriptor> descriptors, int level) {
            if (descriptors.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new PhpDirUpFilePathDescriptor(descriptors, level));
        }

        public List<PhpFilePathDescriptor> getDescriptors() {
            return this.myDescriptors;
        }

        public int getLevel() {
            return this.myLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$PhpDirUpFilePathDescriptor", "evaluate"));
        }
    }

    public static interface PhpFilePathDescriptor {
        default public String evaluate(@NotNull Project project) {
            if (project == null) {
                PhpFilePathDescriptor.$$$reportNull$$$0(0);
            }
            return this.evaluate(project, new HashSet<PsiElement>());
        }

        public String evaluate(@NotNull Project var1, Collection<PsiElement> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$PhpFilePathDescriptor", "evaluate"));
        }
    }

    public static class PhpStringFilePathDescriptor
    implements PhpFilePathDescriptor {
        private static final int VALUE_LENGTH_LIMIT = 50;
        private final String myString;

        public PhpStringFilePathDescriptor(String string) {
            this.myString = string;
        }

        @Override
        public String evaluate(@NotNull Project project, Collection<PsiElement> visited) {
            if (project == null) {
                PhpStringFilePathDescriptor.$$$reportNull$$$0(0);
            }
            return this.myString;
        }

        public static List<PhpFilePathDescriptor> string(@Nullable String value) {
            if (value == null || value.length() >= 50) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new PhpStringFilePathDescriptor(value));
        }

        public String getString() {
            return this.myString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$PhpStringFilePathDescriptor", "evaluate"));
        }
    }
}

