/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.codeInsight.completion.FileReferenceWithExtendedCompletion;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpFilePathUtils;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.phar.PharFileType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFileReferenceSet
extends FileReferenceSet {
    private static final Set<String> SUPPORTED_PROTOCOLS = Set.of("file://", "project://", "phar://");
    private final boolean myFromPhar;
    protected final PhpPsiElement argument;

    public PhpFileReferenceSet(@NotNull PsiElement element, @Nullable PhpPsiElement argument, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(PhpFileReferenceSet.cutTrailingSlashOrPharPrefix(FileUtil.toSystemIndependentName((String)PhpFilePathUtils.getStaticPath(argument))), element, PhpFileReferenceSet.getOffset(element, argument), provider, element.getContainingFile().getViewProvider().getVirtualFile().isCaseSensitive());
        String staticPath = PhpFilePathUtils.getStaticPath(argument);
        this.myFromPhar = staticPath.startsWith("phar://") || staticPath.contains(".phar");
        this.argument = argument;
    }

    private static int getOffset(PsiElement element, PhpPsiElement argument) {
        int offset = PhpFilePathUtils.getFilePathRelativeOffset(element.getTextOffset(), argument);
        String staticPath = PhpFilePathUtils.getStaticPath(argument);
        String protocol = (String)ContainerUtil.find(SUPPORTED_PROTOCOLS, p -> staticPath.startsWith((String)p));
        if (protocol != null) {
            offset += protocol.length();
        }
        return offset;
    }

    private static String cutTrailingSlashOrPharPrefix(String path) {
        path = StringUtil.trimEnd((String)path, (String)"/");
        for (String protocol : SUPPORTED_PROTOCOLS) {
            if (!path.startsWith(protocol)) continue;
            path = StringUtil.trimStart((String)path, (String)protocol);
            break;
        }
        return path;
    }

    public PhpFileReference createFileReference(TextRange range, int index, String text) {
        return new PhpFileReference(this, range, index, text);
    }

    @NlsSafe
    @NotNull
    public String getPathString() {
        String string = PhpFilePathUtils.getStaticPath(this.argument);
        if (string == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean couldBeConvertedTo(boolean relative) {
        return false;
    }

    public boolean isAbsolutePathReference() {
        if (super.isAbsolutePathReference()) {
            return true;
        }
        String pathString = PhpFilePathUtils.getFileName((PsiElement)this.argument);
        return PhpFileReferenceSet.isAbsolutePathAllowFileProtocol(pathString);
    }

    public static boolean isAbsolutePathAllowFileProtocol(String pathString) {
        if (pathString == null) {
            return false;
        }
        if ((pathString = StringUtil.trimStart((String)pathString, (String)"file://")).length() >= 1 && (pathString.charAt(0) == '/' || pathString.charAt(0) == '\\')) {
            return true;
        }
        return FileUtil.isAbsolute((String)pathString);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiFile containingFile = this.getElement().getContainingFile().getOriginalFile();
        if (!(containingFile instanceof PhpFile)) {
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                PhpFileReferenceSet.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (this.argument.getText().startsWith("project://") || this.argument.getText().startsWith("/")) {
            Collection collection = this.toFileSystemItems(ProjectRootManager.getInstance((Project)containingFile.getProject()).getContentRoots());
            if (collection == null) {
                PhpFileReferenceSet.$$$reportNull$$$0(3);
            }
            return collection;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        List<String> dynamicPaths = this.getDynamicPaths();
        String staticArgumentPath = PhpFilePathUtils.getStaticPath(this.argument);
        boolean shouldAddStaticPath = dynamicPaths.isEmpty() || ContainerUtil.exists(dynamicPaths, StringUtil::isEmptyOrSpaces);
        for (String string : dynamicPaths) {
            void var7_7;
            if (StringUtil.isEmptyOrSpaces((String)string)) continue;
            if (!string.endsWith("/")) {
                String continuation = StringUtil.substringBefore((String)staticArgumentPath, (String)"/");
                String string2 = string + (continuation == null ? staticArgumentPath : continuation);
            }
            if (!this.isAbsolutePathReference()) {
                void var7_10;
                PsiDirectory containingDirectory;
                block17: {
                    Collection collection;
                    try {
                        containingDirectory = containingFile.getContainingDirectory();
                        if (containingDirectory != null) break block17;
                        collection = super.computeDefaultContexts();
                    }
                    catch (Exception e) {
                        throw new Error(e.getClass().getName() + ": " + e.getMessage() + " while processing element " + this.getElement() + " '" + this.getElement().getText() + "'", e);
                    }
                    if (collection == null) {
                        PhpFileReferenceSet.$$$reportNull$$$0(4);
                    }
                    return collection;
                }
                VirtualFile file = containingDirectory.getVirtualFile();
                String string3 = file.getPath() + "/" + (String)var7_10;
            }
            String target = FileUtil.toCanonicalPath((String)var7_7);
            files.add(VirtualFileManager.getInstance().findFileByUrl(containingFile.getVirtualFile().getFileSystem().getProtocol() + "://" + target));
        }
        if (shouldAddStaticPath) {
            if (this.isAbsolutePathReference()) {
                ContainerUtil.addAll(files, (Object[])ManagingFS.getInstance().getLocalRoots());
                ContainerUtil.addAll(files, (Object[])new VirtualFile[]{containingFile.getVirtualFile().getFileSystem().findFileByPath("/")});
            } else {
                VirtualFile vFile = containingFile.getVirtualFile().getParent();
                if (vFile != null) {
                    files.add(vFile);
                }
                if (!staticArgumentPath.startsWith("..")) {
                    files.addAll(PhpIncludePathManager.getInstance(this.getElement().getProject()).getAllIncludedRoots());
                    files.add(ProjectUtil.guessProjectDir((Project)containingFile.getProject()));
                }
            }
        }
        Collection collection = this.toFileSystemItems(files);
        if (collection == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    protected List<String> getDynamicPaths() {
        List<String> list = PhpFilePathUtils.getDynamicPaths(this.argument);
        if (list == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static PsiDirectory getDynamicPathDirectory(@Nullable String dynamicPath, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(7);
        }
        if (dynamicPath == null) {
            return null;
        }
        PsiDirectory dir = containingFile.getContainingDirectory();
        String path = dynamicPath.startsWith("/") ? dynamicPath : dir.getVirtualFile().getPath() + "/" + dynamicPath;
        String canonicalPath = FileUtil.toCanonicalPath((String)path);
        String protocol = containingFile.getVirtualFile().getFileSystem().getProtocol();
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(protocol + "://" + canonicalPath);
        if (file == null) {
            return null;
        }
        return containingFile.getManager().findDirectory(file);
    }

    public static boolean isSlashSkipped(@NotNull FileReference ref, @Nullable String dynamicPath) {
        if (ref == null) {
            PhpFileReferenceSet.$$$reportNull$$$0(8);
        }
        if (dynamicPath == null || dynamicPath.endsWith("/")) {
            return false;
        }
        PsiElement element = ref.getElement();
        int prevOffset = ref.getRangeInElement().getStartOffset() - 1;
        return prevOffset >= 0 && element.getText().charAt(prevOffset) != '/';
    }

    @Nullable
    private static ResolveResult getCorrespondingPharFileResult(ResolveResult result) {
        PsiElement element = result.getElement();
        if (!(element instanceof PsiFile)) {
            return null;
        }
        VirtualFile vFile = ((PsiFile)element).getVirtualFile();
        if (vFile == null || !PharFileType.isPhar(vFile)) {
            return null;
        }
        VirtualFile realPharFile = PharFileSystem.getInstance().refreshAndFindFileByPath(vFile.getPath());
        if (realPharFile == null) {
            return null;
        }
        PsiDirectory dir = element.getManager().findDirectory(realPharFile);
        if (dir == null) {
            return null;
        }
        return new PsiElementResolveResult((PsiElement)dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpFileReferenceSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFileReferenceSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicPathDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSlashSkipped";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public class PhpFileReference
    extends FileReference
    implements FileReferenceWithExtendedCompletion {
        public PhpFileReference(PhpFileReferenceSet set, TextRange range, int index, String text) {
            super((FileReferenceSet)set, range, index, text);
        }

        @Nullable
        public String getText() {
            String _path = PhpFilePathUtils.computeFilePath(super.getText(), super.getRangeInElement(), this.getElement().getNode(), this.getElement().getText());
            String text = FileUtil.toSystemIndependentName((String)_path);
            return text.endsWith("/") ? text.substring(0, text.length() - "/".length()) : text;
        }

        @NotNull
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getUnresolvedMessagePattern() {
            String string = PhpBundle.message("file.0.does.not.exists", this.getCanonicalRepresentationText());
            if (string == null) {
                PhpFileReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        @InspectionMessage
        public String getCanonicalRepresentationText() {
            String value = this.getCanonicalText();
            return PhpFilePathUtils.computeFilePath(value, super.getRangeInElement(), this.getElement().getNode(), this.getElement().getText());
        }

        protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
            if (containingFile == null) {
                PhpFileReference.$$$reportNull$$$0(1);
            }
            ResolveResult[] results = super.innerResolve(caseSensitive, containingFile);
            if (PhpFileReferenceSet.this.myFromPhar) {
                for (int i = 0; i < results.length; ++i) {
                    ResolveResult result = results[i];
                    ResolveResult pharResult = PhpFileReferenceSet.getCorrespondingPharFileResult(result);
                    if (pharResult == null) continue;
                    results[i] = pharResult;
                }
            }
            if (results == null) {
                PhpFileReference.$$$reportNull$$$0(2);
            }
            return results;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                PhpFileReference.$$$reportNull$$$0(3);
            }
            String newText = this.replaceTextReference(newElementName);
            Object newElement = PhpPsiElementFactory.createFirstFromText(this.getElement().getProject(), this.getElement().getClass(), newText);
            assert (newElement != null) : newText;
            return this.getElement().replace(newElement);
        }

        @NotNull
        private String replaceTextReference(@NotNull String newElementName) {
            if (newElementName == null) {
                PhpFileReference.$$$reportNull$$$0(4);
            }
            String text = this.getElement().getText();
            String content = text.substring(0, this.getRangeInElement().getStartOffset()) + newElementName + text.substring(this.getRangeInElement().getEndOffset());
            if (this.getElement() instanceof PhpDocTag) {
                String string = "/** " + content + " \n **/";
                if (string == null) {
                    PhpFileReference.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (this.getElement() instanceof PhpDocRef) {
                String string = "/** @link " + content + " \n **/";
                if (string == null) {
                    PhpFileReference.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = content + ";";
            if (string == null) {
                PhpFileReference.$$$reportNull$$$0(7);
            }
            return string;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                PhpFileReference.$$$reportNull$$$0(8);
            }
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }

        public void bindToExtendedElement(@NotNull PsiElement element) throws IncorrectOperationException {
            PsiFile file;
            if (element == null) {
                PhpFileReference.$$$reportNull$$$0(9);
            }
            if ((file = (PsiFile)ObjectUtils.tryCast((Object)element, PsiFile.class)) == null) {
                return;
            }
            if (ContainerUtil.exists((Object[])this.multiResolve(true), r -> file.equals(r.getElement()))) {
                return;
            }
            List<String> dynamicPaths = PhpFileReferenceSet.this.getDynamicPaths();
            if (dynamicPaths.size() != 1) {
                return;
            }
            String dynamicPath = dynamicPaths.get(0);
            String relativePath = FileUtil.getRelativePath((String)dynamicPath, (String)file.getVirtualFile().getPath(), (char)'/');
            if (relativePath == null) {
                return;
            }
            this.handleElementRename((String)(PhpFileReferenceSet.isSlashSkipped(this, dynamicPath) ? "/" + relativePath : relativePath));
        }

        public Object @NotNull [] getVariants() {
            FileReferenceCompletion completion = FileReferenceCompletion.getInstance();
            if (completion == null) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    PhpFileReference.$$$reportNull$$$0(10);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            Object[] baseVariants = completion.getFileReferenceCompletionVariants((FileReference)this);
            PhpFileReferenceSet phpFileReferenceSet = (PhpFileReferenceSet)((Object)ObjectUtils.tryCast((Object)this.getFileReferenceSet(), PhpFileReferenceSet.class));
            if (phpFileReferenceSet == null || phpFileReferenceSet.getContainingFile() == null) {
                if (baseVariants == null) {
                    PhpFileReference.$$$reportNull$$$0(11);
                }
                return baseVariants;
            }
            List<String> dynamicPaths = phpFileReferenceSet.getDynamicPaths();
            StreamEx additionalVariants = ((StreamEx)((StreamEx)StreamEx.of(dynamicPaths).filter(p -> PhpFileReferenceSet.isSlashSkipped(this, p))).map(p -> PhpFileReferenceSet.getDynamicPathDirectory(p, phpFileReferenceSet.getContainingFile())).filter(Objects::nonNull)).flatMap(dir -> Arrays.stream(dir.getChildren())).select(PsiFileSystemItem.class).map(fsItem -> PhpFileReference.getLookupItem(fsItem)).map(lookupItem -> PhpFileReference.addInsertHandler(lookupItem));
            Object[] objectArray = Stream.concat(Arrays.stream(baseVariants), additionalVariants).toArray();
            if (objectArray == null) {
                PhpFileReference.$$$reportNull$$$0(12);
            }
            return objectArray;
        }

        @Nullable
        private static Object getLookupItem(PsiFileSystemItem fsItem) {
            if (fsItem instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)fsItem;
                Icon icon = dir.getIcon(3);
                return LookupElementBuilder.create((Object)dir, (String)dir.getName()).withIcon(icon);
            }
            return FileInfoManager.getFileLookupItem((PsiElement)fsItem);
        }

        private static Object addInsertHandler(Object lookupElement) {
            LookupElementBuilder builder2 = (LookupElementBuilder)ObjectUtils.tryCast((Object)lookupElement, LookupElementBuilder.class);
            if (builder2 == null) {
                return lookupElement;
            }
            return builder2.withInsertHandler((context, item) -> {
                context.getEditor().getCaretModel().moveCaretRelatively(-item.getLookupString().length(), 0, false, false, false);
                PhpInsertHandlerUtil.insertStringAtCaret(context.getEditor(), "/");
                context.getEditor().getCaretModel().moveCaretRelatively(item.getLookupString().length(), 0, false, false, false);
            });
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + " '" + this.getText() + "' " + this.getRangeInElement() + " = <" + this.getRangeInElement().substring(this.getElement().getText()) + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3, 4, 8, 9 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpFileReferenceSet$PhpFileReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpFileReferenceSet$PhpFileReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "innerResolve";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replaceTextReference";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "innerResolve";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceTextReference";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToExtendedElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3, 4, 8, 9 -> new IllegalArgumentException(string);
            };
        }
    }
}

