/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpScope;
import com.jetbrains.php.codeInsight.PhpScopeImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.stubs.PhpNamespaceStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.roots.PhpNamespaceByPsrProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamespaceImpl
extends PhpNamedElementImpl<PhpNamespaceStub>
implements PhpNamespace {
    private PhpScope myScope;

    public PhpNamespaceImpl(ASTNode node) {
        super(node);
    }

    public PhpNamespaceImpl(PhpNamespaceStub stub) {
        super(stub, PhpStubElementTypes.NAMESPACE);
    }

    @Override
    @Nullable
    public GroupStatement getStatements() {
        return (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)this, GroupStatement.class);
    }

    @Override
    @NotNull
    public String getParentNamespaceName() {
        PhpNamespaceStub stub = (PhpNamespaceStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getParentNamespaceName().toString();
            if (string == null) {
                PhpNamespaceImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        PhpNamespaceReference element = (PhpNamespaceReference)this.findChildByClass(PhpNamespaceReference.class);
        if (element != null) {
            String fullName = element.getFullName();
            return fullName != null ? PhpLangUtil.toFQN(fullName) : "\\";
        }
        return "\\";
    }

    @Override
    public boolean isBraced() {
        return this.findChildByType(PhpTokenTypes.opSEMICOLON) == null;
    }

    @Override
    @NotNull
    public String getFQN() {
        String string = this.getParentNamespaceName() + this.getName();
        if (string == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getNamespaceName() {
        return "\\";
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getNamespacePresentation(this);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(2);
        }
        if ((nameNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            PsiElement newIdentifier = PhpPsiElementFactory.createFromText(this.getProject(), PhpTokenTypes.IDENTIFIER, "namespace Foo\\" + name + ";");
            nameNode.getTreeParent().replaceChild(nameNode, newIdentifier.getNode());
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(3);
        }
        phpElementVisitor.visitPhpNamespace(this);
    }

    @Override
    public Icon getIcon() {
        return PhpIcons.NAMESPACE;
    }

    @Override
    @NotNull
    public PhpControlFlow getControlFlow() {
        PhpControlFlow phpControlFlow = this.getScope().getControlFlow();
        if (phpControlFlow == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(4);
        }
        return phpControlFlow;
    }

    @Override
    @NotNull
    public PhpScope getScope() {
        if (this.myScope == null) {
            this.myScope = new PhpScopeImpl(this);
        }
        PhpScope phpScope = this.myScope;
        if (phpScope == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(5);
        }
        return phpScope;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        if (this.myScope != null) {
            this.myScope.clear();
        }
    }

    @Override
    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        Set<CharSequence> set = PhpLangUtil.FILE_PREDEFINED_VARIABLES_SET;
        if (set == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    public PsiDirectory @NotNull [] getDirectories() {
        PsiDirectory[] psiDirectoryArray = this.getAllDirectories().toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(7);
        }
        return psiDirectoryArray;
    }

    public PsiDirectory @NotNull [] getDirectories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(8);
        }
        ArrayList<PsiDirectory> result = null;
        Collection<PsiDirectory> directories = this.getAllDirectories();
        for (PsiDirectory directory : directories) {
            if (!scope.contains(directory.getVirtualFile())) continue;
            if (result == null) {
                result = new ArrayList<PsiDirectory>();
            }
            result.add(directory);
        }
        PsiDirectory[] psiDirectoryArray = result == null ? PsiDirectory.EMPTY_ARRAY : result.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            PhpNamespaceImpl.$$$reportNull$$$0(9);
        }
        return psiDirectoryArray;
    }

    private Collection<PsiDirectory> getAllDirectories() {
        CachedValueProvider provider = () -> {
            PsiDirectory psiDirectory = this.getContainingFile().getParent();
            List<String> namespaces = PhpNamespaceByPsrProvider.INSTANCE.suggestNamespaces(psiDirectory);
            String namespaceName = namespaces.size() > 0 ? namespaces.iterator().next() : null;
            List directories = namespaceName != null && ("\\" + namespaceName).equals(this.getFQN()) ? Collections.singletonList(psiDirectory) : Collections.emptyList();
            return CachedValueProvider.Result.create(directories, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)this.getProject())});
        };
        return (Collection)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamespaceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentNamespaceName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamespaceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 8 -> new IllegalArgumentException(string);
        };
    }
}

