/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.PhpExpressionClassNamesProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNativeExpressionClassNamesProvider
implements PhpExpressionClassNamesProvider {
    @Override
    public Collection<@Nullable String> getClassNames(@NotNull PsiElement element) {
        PhpExpression classReference;
        if (element == null) {
            PhpNativeExpressionClassNamesProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof StringLiteralExpression) {
            PhpType fqn = PhpNativeExpressionClassNamesProvider.getFqnFromAssignedStringLiteral((StringLiteralExpression)element);
            if (fqn != null) {
                return fqn.getTypes();
            }
            return Collections.singletonList(null);
        }
        if (element instanceof ClassConstantReference && PhpLangUtil.equalsClassConstantNames(((ClassConstantReference)element).getName(), "class") && (classReference = ((ClassConstantReference)element).getClassReference()) instanceof ClassReference) {
            return Collections.singletonList(((ClassReference)classReference).getFQN());
        }
        return Collections.emptyList();
    }

    private static PhpType getFqnFromAssignedStringLiteral(StringLiteralExpression literalExpression) {
        String contents;
        if (literalExpression == null) {
            return null;
        }
        if (PhpPsiUtil.getChildByCondition((PsiElement)literalExpression, Variable.INSTANCEOF) != null) {
            return null;
        }
        String string = contents = literalExpression.isSingleQuote() ? StringUtil.unescapeBackSlashes((String)literalExpression.getContents()) : literalExpression.getContents();
        if (StringUtil.containsWhitespaces((CharSequence)contents)) {
            return null;
        }
        return new PhpType().add(PhpLangUtil.toFQN(contents));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/elements/impl/PhpNativeExpressionClassNamesProvider", "getClassNames"));
    }
}

