/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.completion.PhpGlobalsArrayIndexCompletionProvider;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpVariantsUtil;
import com.jetbrains.php.completion.insert.PhpVariableInsertHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocParamTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpCustomDocTagTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpGlobalVariableTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStub;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpGlobalArrayAccessAssignmentIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpGlobalVariableFakeElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableImpl
extends PhpNamedElementImpl<PhpVariableStub>
implements Variable {
    private static final Logger LOG = Logger.getInstance(VariableImpl.class);
    private static final OffsetComparator OFFSET_COMPARATOR = new OffsetComparator();
    private static final TokenSet NN = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.VARIABLE_NAME});
    private static final ResolveCache.PolyVariantResolver<PhpReference> MY_RESOLVER = (expression, incompleteCode) -> {
        Collection<? extends PhpNamedElement> globals = expression.resolveGlobal(incompleteCode);
        return PsiElementResolveResult.createResults(globals);
    };
    private static final Key<CachedValue<Map<String, TreeSet<PhpNamedElement>>>> CHILDREN_TO_PROCESS_KEY = Key.create((String)"php.variables.scope");
    private static final Key<CachedValue<Map<String, TreeSet<PhpNamedElement>>>> CHILDREN_TO_PROCESS_KEY_GLOBAL = Key.create((String)"php.variables.scope.global");

    public VariableImpl(ASTNode node) {
        super(node);
    }

    public VariableImpl(PhpVariableStub stub) {
        super(stub, PhpStubElementTypes.VARIABLE);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getName() {
        PhpVariableStub stub = (PhpVariableStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                VariableImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.canReadName()) {
            String name = this.getNameNode().getText();
            String string = name.charAt(0) == '$' ? name.substring(1) : name;
            if (string == null) {
                VariableImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        PhpVariableStub stub = (PhpVariableStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                VariableImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        ASTNode nameNode = this.getNameNode();
        CharSequence name = nameNode != null ? nameNode.getChars() : "";
        CharSequence charSequence = name.length() > 0 && name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name;
        if (charSequence == null) {
            VariableImpl.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            VariableImpl.$$$reportNull$$$0(4);
        }
        if (this.canReadName() && !PhpLangUtil.equalsVariableNames(this.getName(), name)) {
            ASTNode nameNode = this.getNameNode();
            assert (nameNode != null);
            ASTNode newNameNode = PhpPsiElementFactory.createVariable(this.getProject(), name, nameNode.getChars().charAt(0) == '$').getNameNode();
            if (newNameNode != null) {
                nameNode.getTreeParent().replaceChild(nameNode, newNameNode);
            }
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            VariableImpl.$$$reportNull$$$0(5);
        }
        phpElementVisitor.visitPhpVariable(this);
    }

    @Override
    public boolean isDeclarationGlobal() {
        return this.isWriteAccess();
    }

    @Override
    public boolean isDeclaration() {
        return this.isWriteAccess(false);
    }

    @Override
    public boolean canReadName() {
        ASTNode node = this.getNode();
        return node.getChildren(null).length > 0 && node.findChildByType(PhpTokenTypes.DOLLAR) == null && node.findChildByType(PhpTokenTypes.VARIABLE) != null;
    }

    public PsiReference getReference() {
        if (this.canReadName()) {
            return this;
        }
        return null;
    }

    @NotNull
    public PsiElement getElement() {
        VariableImpl variableImpl = this;
        if (variableImpl == null) {
            VariableImpl.$$$reportNull$$$0(6);
        }
        return variableImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            VariableImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String s) throws IncorrectOperationException {
        if (s == null) {
            VariableImpl.$$$reportNull$$$0(8);
        }
        return this.setName(s);
    }

    public PsiElement bindToElement(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            VariableImpl.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException("Method bindToElement is not yet implemented in " + this.getClass().getName());
    }

    public boolean isReferenceTo(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            VariableImpl.$$$reportNull$$$0(10);
        }
        if (psiElement instanceof PhpClass && PhpLangUtil.isThisReference((PsiElement)this) || (psiElement instanceof Variable || psiElement instanceof Parameter || psiElement instanceof PhpDocVariable) && PhpLangUtil.equalsVariableNames(this.getNameCS(), ((PhpNamedElement)psiElement).getNameCS())) {
            ResolveResult[] results;
            Object scopeHolder = PhpPsiUtil.getParentByCondition((PsiElement)this, PhpScopeHolder.INSTANCE_OF);
            if (PhpPsiUtil.getParentByCondition(psiElement, PhpScopeHolder.INSTANCE_OF) == scopeHolder) {
                return true;
            }
            if (PhpLangUtil.isThisReference((PsiElement)this) && scopeHolder instanceof Method) {
                return psiElement == ((Method)scopeHolder).getContainingClass();
            }
            for (ResolveResult result : results = this.multiResolve(false)) {
                PsiElement element = result.getElement();
                if (psiElement != element && !(element instanceof PhpGlobalVariableFakeElement)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public SearchScope getUseScope() {
        Function f = PhpPsiUtil.getParentOfClass((PsiElement)this, Function.class);
        if (f != null) {
            return new LocalSearchScope((PsiElement)f);
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            VariableImpl.$$$reportNull$$$0(11);
        }
        return searchScope;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PhpIcons.VARIABLE;
        if (icon == null) {
            VariableImpl.$$$reportNull$$$0(12);
        }
        return icon;
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getVarPresentation(this);
    }

    @Override
    public boolean isWriteAccess() {
        return this.isWriteAccess(true);
    }

    @Override
    public boolean isWriteAccess(boolean global) {
        return VariableImpl.isLocalWriteAccess((PsiElement)this) || PhpCodeInsightUtil.isPassByRefParameter((PsiElement)this, global);
    }

    public static boolean isLocalWriteAccess(PsiElement variable) {
        PsiElement that = variable;
        PsiElement parent = variable.getParent();
        if (parent == null) {
            return false;
        }
        IElementType parentType = parent.getNode().getElementType();
        while (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(parentType)) {
            that = parent;
            parent = parent.getParent();
            parentType = parent.getNode().getElementType();
        }
        if (VariableImpl.inMultiAssignment(parent)) {
            return true;
        }
        if (parent instanceof AssignmentExpression) {
            return ((AssignmentExpression)parent).getVariable() == that;
        }
        if (parent instanceof PhpUnset) {
            return true;
        }
        if (parent instanceof UnaryExpression && (parentType == PhpElementTypes.INFIX_WRITE_EXPRESSION || parentType == PhpElementTypes.POSTFIX_EXPRESSION)) {
            return true;
        }
        if (PhpElementTypes.STATIC_STATEMENT.equals(parentType)) {
            return true;
        }
        if (parent instanceof ForeachStatement) {
            ForeachStatement foreach = (ForeachStatement)parent;
            return foreach.getKey() == variable || foreach.getValue() == variable || foreach.getVariables().contains(variable);
        }
        if (parent instanceof Catch) {
            return ((Catch)parent).getException() == variable;
        }
        if (parent instanceof PhpUseList) {
            return true;
        }
        if (parent instanceof Global) {
            return ArrayUtilRt.find((Object[])((Global)parent).getVariables(), (Object)variable) > -1;
        }
        return false;
    }

    public static boolean inMultiAssignment(PsiElement parent) {
        MultiassignmentExpression multi = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition(parent, false, MultiassignmentExpression.INSTANCEOF, Statement.INSTANCEOF);
        return multi != null && !PsiTreeUtil.isAncestor((PsiElement)multi.getValue(), (PsiElement)parent, (boolean)false);
    }

    public static LookupElement @NotNull [] getVariableVariants(@NotNull PsiElement point, boolean includeGlobal) {
        if (point == null) {
            VariableImpl.$$$reportNull$$$0(13);
        }
        return VariableImpl.getVariableVariants(point, null, includeGlobal);
    }

    public static LookupElement @NotNull [] getVariableVariants(@NotNull PsiElement point, @Nullable PsiElement originalPosition, boolean includeGlobal) {
        PhpClass phpClass;
        if (point == null) {
            VariableImpl.$$$reportNull$$$0(14);
        }
        Project project = point.getProject();
        HashSet<String> locals = new HashSet<String>();
        ArrayList<Object> allVariants = new ArrayList<Object>();
        for (PhpNamedElement phpNamedElement : VariableImpl.getDeclarationsUnionWithExternalRefs(point)) {
            LookupElement lookupElement;
            String name;
            if (originalPosition != null && phpNamedElement.getContainingFile() == originalPosition.getContainingFile() && PsiTreeUtil.isAncestor((PsiElement)phpNamedElement, (PsiElement)originalPosition, (boolean)false) || !locals.add(name = phpNamedElement.getName()) || (lookupElement = PhpVariantsUtil.getLookupElementForVariable(phpNamedElement)) == null) continue;
            allVariants.add(lookupElement);
        }
        Method method = (Method)PsiTreeUtil.getParentOfType((PsiElement)point, Method.class, (boolean)true, (Class[])new Class[]{PhpClass.class});
        if (!locals.contains("this") && method != null && !method.isStatic() && (phpClass = method.getContainingClass()) != null) {
            allVariants.add((Object)PhpLookupElement.createKeywordLookupElement("this", PhpVariableIndex.KEY, PhpIcons.VARIABLE, phpClass.getType(), project, PhpVariableInsertHandler.getInstance()));
        }
        if (includeGlobal) {
            PhpIndex phpIndex = PhpIndex.getInstance(project);
            Collection<String> globalNames = phpIndex.getAllVariableNames(null);
            ArrayList<PhpLookupElement> globals = new ArrayList<PhpLookupElement>(globalNames.size());
            for (String global : globalNames) {
                if (!StringUtil.isNotEmpty((String)global) || locals.contains(global)) continue;
                globals.add(PhpLookupElement.createVariableElement(project, global));
            }
            for (String name : PhpGlobalArrayAccessAssignmentIndex.getAllVariableNames(project)) {
                if (globalNames.contains(name)) continue;
                globals.add((PhpLookupElement)VariableImpl.createGlobalArrayAccessElement(project, name));
            }
            allVariants.addAll(globals);
        }
        if (!locals.contains("value") && method instanceof PhpPropertyHook) {
            PhpPropertyHook phpPropertyHook = (PhpPropertyHook)method;
            Parameter param = phpPropertyHook.getParameter(0);
            if (param != null && !param.getName().equalsIgnoreCase("value")) {
                LookupElement[] lookupElementArray = allVariants.toArray(LookupElement.EMPTY_ARRAY);
                if (lookupElementArray == null) {
                    VariableImpl.$$$reportNull$$$0(15);
                }
                return lookupElementArray;
            }
            Field field = phpPropertyHook.getContainingField();
            if (field != null) {
                allVariants.add((Object)PhpLookupElement.createKeywordLookupElement("value", PhpVariableIndex.KEY, PhpIcons.VARIABLE, field.getDeclaredType(), project, PhpVariableInsertHandler.getInstance()));
            }
        }
        LookupElement[] lookupElementArray = allVariants.toArray(LookupElement.EMPTY_ARRAY);
        if (lookupElementArray == null) {
            VariableImpl.$$$reportNull$$$0(16);
        }
        return lookupElementArray;
    }

    @NotNull
    private static LookupElementBuilder createGlobalArrayAccessElement(final Project project, final String name) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)name).withInsertHandler((InsertHandler)PhpVariableInsertHandler.getInstance()).withExpensiveRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(name);
                PhpGlobalsArrayIndexCompletionProvider.renderGlobalVariableFromGlobalsArray(project, presentation, name);
            }
        });
        if (lookupElementBuilder == null) {
            VariableImpl.$$$reportNull$$$0(17);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static Collection<? extends PhpNamedElement> getDeclarationsUnionWithExternalRefs(@NotNull PsiElement point) {
        if (point == null) {
            VariableImpl.$$$reportNull$$$0(18);
        }
        TreeSet<PhpNamedElement> result = VariableImpl.createVariableDeclarationsSet();
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(point, false, null);
        result.addAll(declarations);
        result.addAll(VariableImpl.updateDeclarationsWithExternalRef(declarations, point, null));
        TreeSet<PhpNamedElement> treeSet = result;
        if (treeSet == null) {
            VariableImpl.$$$reportNull$$$0(19);
        }
        return treeSet;
    }

    @Nullable
    public PsiElement resolve() {
        return VariableImpl.getLeastByPathAndOffset(this.multiResolve(false));
    }

    @Nullable
    public static PsiElement getLeastByPathAndOffset(ResolveResult @NotNull [] results) {
        if (results == null) {
            VariableImpl.$$$reportNull$$$0(20);
        }
        if (results.length == 0) {
            return null;
        }
        if (results.length > 1) {
            PsiElement result = null;
            int resultId = Integer.MAX_VALUE;
            int resultTextOffset = Integer.MAX_VALUE;
            Boolean isFake = null;
            for (ResolveResult aR : results) {
                int candidateTextOffset;
                PsiElement candidate = aR.getElement();
                if (candidate == null || !candidate.isValid()) continue;
                VirtualFile f = candidate.getContainingFile().getVirtualFile();
                if (f instanceof LightVirtualFile) {
                    f = ((LightVirtualFile)f).getOriginalFile();
                }
                int candidateId = f instanceof VirtualFileWithId ? ((VirtualFileWithId)f).getId() : 0;
                boolean candidateIsFake = candidate instanceof FakePsiElement;
                if (candidateIsFake && isFake == Boolean.FALSE) continue;
                if (candidateId < resultId || !candidateIsFake && isFake == Boolean.TRUE) {
                    candidateTextOffset = candidate.getTextOffset();
                    result = candidate;
                    isFake = candidateIsFake;
                    resultId = candidateId;
                    resultTextOffset = candidateTextOffset;
                    continue;
                }
                if (candidateId != resultId || (candidateTextOffset = candidate.getTextOffset()) >= resultTextOffset) continue;
                result = candidate;
                isFake = candidateIsFake;
                resultTextOffset = candidateTextOffset;
            }
            return result;
        }
        return results[0].getElement();
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (!incompleteCode) {
            ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false);
            if (resolveResultArray == null) {
                VariableImpl.$$$reportNull$$$0(21);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = MY_RESOLVER.resolve((PsiPolyVariantReference)this, true);
        if (resolveResultArray == null) {
            VariableImpl.$$$reportNull$$$0(22);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        return VariableImpl.resolveLocal(this);
    }

    @Override
    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = this.getType();
        if (phpType == null) {
            VariableImpl.$$$reportNull$$$0(23);
        }
        return phpType;
    }

    @NotNull
    public static Set<? extends PhpNamedElement> resolveLocal(@NotNull VariableImpl variable) {
        if (variable == null) {
            VariableImpl.$$$reportNull$$$0(24);
        }
        return variable.resolveInFile(false);
    }

    @NotNull
    private Set<? extends PhpNamedElement> resolveInFile(boolean allowGlobalLookup) {
        Set set = this.resolveVariables(allowGlobalLookup).collect(Collectors.toCollection(LinkedHashSet::new));
        if (set == null) {
            VariableImpl.$$$reportNull$$$0(25);
        }
        return set;
    }

    @ApiStatus.Internal
    @NotNull
    public Stream<? extends PhpNamedElement> resolveVariables(boolean allowGlobalLookup) {
        PhpClass aClass;
        if ("this".equalsIgnoreCase(this.getName()) && (aClass = PhpClassImpl.getContainingClass((PsiElement)this)) != null) {
            Stream<PhpClass> stream = Stream.of(aClass);
            if (stream == null) {
                VariableImpl.$$$reportNull$$$0(26);
            }
            return stream;
        }
        int variableOffset = this.getTextRange().getStartOffset();
        Stream<PhpNamedElement> stream = VariableImpl.collectDeclarations((PsiElement)this, allowGlobalLookup, this.getName()).stream().filter(declaration -> declaration.getTextRange().getStartOffset() <= variableOffset);
        if (stream == null) {
            VariableImpl.$$$reportNull$$$0(27);
        }
        return stream;
    }

    @NotNull
    private static TreeSet<PhpNamedElement> createVariableDeclarationsSet() {
        return new TreeSet<PhpNamedElement>(OFFSET_COMPARATOR);
    }

    public static Set<? extends PhpNamedElement> collectDeclarations(@NotNull PsiElement position, boolean allowGlobalLookup, @Nullable String name) {
        if (position == null) {
            VariableImpl.$$$reportNull$$$0(28);
        }
        PhpScopeHolder scope = PhpPsiUtil.getScopeHolder(position);
        PsiFile containingFile = position.getContainingFile().getOriginalFile();
        if (scope == null || scope instanceof PsiFile) {
            scope = containingFile;
        }
        return VariableImpl.collectDeclarationsByScope((PsiElement)scope, allowGlobalLookup, name);
    }

    public static Set<? extends PhpNamedElement> collectDeclarationsByScope(@NotNull PsiElement scope, boolean allowGlobalLookup, @Nullable String name) {
        Map<String, TreeSet<PhpNamedElement>> scopeMap;
        if (scope == null) {
            VariableImpl.$$$reportNull$$$0(29);
        }
        if ((scopeMap = VariableImpl.getCachedScopeMap(scope, allowGlobalLookup)) != null) {
            if (name == null) {
                TreeSet<PhpNamedElement> decls = VariableImpl.createVariableDeclarationsSet();
                Collection<TreeSet<PhpNamedElement>> treeSetCollection = scopeMap.values();
                for (TreeSet<PhpNamedElement> phpNamedElements : treeSetCollection) {
                    decls.addAll(phpNamedElements);
                }
                return decls;
            }
            if (scopeMap.containsKey(name)) {
                return Collections.unmodifiableSortedSet((SortedSet)scopeMap.get(name));
            }
        }
        return Collections.emptySet();
    }

    private static Map<String, TreeSet<PhpNamedElement>> getCachedScopeMap(@NotNull PsiElement scope, boolean allowGlobalLookup) {
        if (scope == null) {
            VariableImpl.$$$reportNull$$$0(30);
        }
        if (allowGlobalLookup) {
            return (Map)CachedValuesManager.getCachedValue((PsiElement)scope, CHILDREN_TO_PROCESS_KEY_GLOBAL, () -> CachedValueProvider.Result.create(VariableImpl.doFetchScopeMap(scope, true), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)scope, CHILDREN_TO_PROCESS_KEY, () -> CachedValueProvider.Result.create(VariableImpl.doFetchScopeMap(scope, false), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static Map<String, TreeSet<PhpNamedElement>> doFetchScopeMap(@NotNull PsiElement scope, boolean allowGlobalLookup) {
        if (scope == null) {
            VariableImpl.$$$reportNull$$$0(31);
        }
        Map<String, TreeSet<PhpNamedElement>> scopeMap = Collections.emptyMap();
        DeclarationCollector collector = new DeclarationCollector(allowGlobalLookup);
        scope.accept((PsiElementVisitor)collector);
        Map<PsiElement, Map<String, TreeSet<PhpNamedElement>>> all = collector.myAllDecls;
        for (PsiElement psiElement : all.keySet()) {
            if (psiElement != scope) continue;
            scopeMap = all.get(psiElement);
        }
        return scopeMap;
    }

    @Override
    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        Collection<? extends PhpNamedElement> glob;
        boolean globOnly;
        boolean superGlobal = SUPERGLOBALS.contains(this.getName());
        Collection<? extends PhpNamedElement> result = !superGlobal ? this.resolveInFile(true) : EMPTY_SET;
        boolean bl = globOnly = superGlobal || PhpPsiUtil.getParentOfClass((PsiElement)this, false, Function.class) == null && result.size() == 0 || result.size() > 0 && PhpPsiUtil.getParentOfClass((PsiElement)result.iterator().next(), Global.class) != null;
        if (globOnly && !(glob = PhpGlobalVariableTP.resolveGlobalVariables(this.getProject(), this.getName())).isEmpty()) {
            result = glob;
        }
        Collection<? extends PhpNamedElement> collection = result = VariableImpl.updateDeclarationsWithExternalRef(result, (PsiElement)this, this.getName());
        if (collection == null) {
            VariableImpl.$$$reportNull$$$0(32);
        }
        return collection;
    }

    public static Collection<? extends PhpNamedElement> collectDeclarationsWithExternalRef(@NotNull PsiElement element, boolean allowGlobalLookup, @Nullable String name) {
        if (element == null) {
            VariableImpl.$$$reportNull$$$0(33);
        }
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations(element, allowGlobalLookup, name);
        return VariableImpl.updateDeclarationsWithExternalRef(declarations, element, name);
    }

    private static Collection<? extends PhpNamedElement> updateDeclarationsWithExternalRef(@NotNull Collection<? extends PhpNamedElement> declarations, @NotNull PsiElement element, @Nullable String name) {
        if (declarations == null) {
            VariableImpl.$$$reportNull$$$0(34);
        }
        if (element == null) {
            VariableImpl.$$$reportNull$$$0(35);
        }
        Function my = PhpPsiUtil.getParentOfClass(element, true, Function.class);
        while (VariableImpl.hasReferencesToExternalScope(declarations, my)) {
            Set<? extends PhpNamedElement> declarationFromParenScope = VariableImpl.collectDeclarations(my.getParent(), false, name);
            if (declarationFromParenScope.isEmpty()) {
                return declarations;
            }
            declarations = declarationFromParenScope;
            my = PhpPsiUtil.getParentOfClass(my, true, Function.class);
        }
        return declarations;
    }

    private static boolean hasReferencesToExternalScope(@NotNull Collection<? extends PhpNamedElement> declarations, @Nullable Function my) {
        if (declarations == null) {
            VariableImpl.$$$reportNull$$$0(36);
        }
        return my != null && (VariableImpl.hasExternalRefInDeclaration(declarations) || my.isClosure() && FunctionImpl.isShortArrowFunction(my));
    }

    private static boolean hasExternalRefInDeclaration(@NotNull Collection<? extends PhpNamedElement> result) {
        if (result == null) {
            VariableImpl.$$$reportNull$$$0(37);
        }
        for (PhpNamedElement phpNamedElement : result) {
            StubElement stub;
            StubElement stubElement = stub = phpNamedElement instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)phpNamedElement).getStub() : null;
            if (stub != null && !VariableImpl.stubParentIsClosure(stub) || !(phpNamedElement.getParent() instanceof PhpUseList)) continue;
            return true;
        }
        return false;
    }

    private static boolean stubParentIsClosure(@NotNull StubElement<?> stub) {
        PsiElement psi;
        if (stub == null) {
            VariableImpl.$$$reportNull$$$0(38);
        }
        return (psi = stub.getParentStub().getPsi()) instanceof Function && ((Function)psi).isClosure();
    }

    @Override
    @NotNull
    public Collection<String> getSignatureParts() {
        return VariableImpl.getSignatures(this);
    }

    @NotNull
    private static Collection<String> getSignatures(VariableImpl variable) {
        boolean isThis = "this".equalsIgnoreCase(variable.getName());
        if (isThis) {
            PhpClass phpClass;
            Function f = PhpPsiUtil.getParentOfClass((PsiElement)variable, Function.class);
            if (f instanceof Method && (phpClass = PhpPsiUtil.getParentOfClass((PsiElement)variable, PhpClass.class)) != null) {
                Set<String> set = Collections.singleton(PhpTypeSignatureKey.CLASS.sign(phpClass.getFQN()));
                if (set == null) {
                    VariableImpl.$$$reportNull$$$0(39);
                }
                return set;
            }
            Set<String> set = Collections.singleton("\\null");
            if (set == null) {
                VariableImpl.$$$reportNull$$$0(40);
            }
            return set;
        }
        PhpNamedElement decl = (PhpNamedElement)ContainerUtil.find(VariableImpl.resolveLocal(variable), d -> variable.isSuitableDeclaration((PhpNamedElement)d));
        if (decl != null) {
            if (decl instanceof Parameter && ((Parameter)decl).isVariadic()) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    VariableImpl.$$$reportNull$$$0(41);
                }
                return list;
            }
            PhpType type = variable == decl && !variable.getDocType().isEmpty() ? variable.getDocType() : decl.getType();
            Collection collection = type.getTypesWithParametrisedParts().stream().filter(s -> !PhpType.isPrimitiveType(PhpType.removeParametrisedType(s)) && !PhpType.isPluralPrimitiveType(PhpType.removeParametrisedType(s))).map(PhpTypeSignatureKey.CLASS::signIfUnsigned).collect(Collectors.toList());
            if (collection == null) {
                VariableImpl.$$$reportNull$$$0(42);
            }
            return collection;
        }
        List<String> element = VariableImpl.getSignaturesFromFunctionCall(variable);
        if (!element.isEmpty()) {
            List<String> list = element;
            if (list == null) {
                VariableImpl.$$$reportNull$$$0(43);
            }
            return list;
        }
        Set<String> set = Collections.singleton(PhpTypeSignatureKey.VARIABLE.sign(variable.getName()));
        if (set == null) {
            VariableImpl.$$$reportNull$$$0(44);
        }
        return set;
    }

    @NotNull
    public static List<String> getSignaturesFromFunctionCall(@Nullable Variable variable) {
        PsiElement element;
        if (variable != null && variable.getParent() instanceof ParameterList && (element = variable.getParent().getParent()) instanceof FunctionReference) {
            List list = ContainerUtil.map((Collection)((FunctionReference)element).getSignatureParts(), s -> PhpTypeSignatureKey.PARAMETER.sign(s + "." + PhpCodeInsightUtil.getParameterIndex((PsiElement)variable)));
            if (list == null) {
                VariableImpl.$$$reportNull$$$0(45);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            VariableImpl.$$$reportNull$$$0(46);
        }
        return list;
    }

    private boolean isSuitableDeclaration(PhpNamedElement decl) {
        PsiElement parent = decl.getParent();
        if (decl instanceof Parameter || decl instanceof PhpDocVariable) {
            return true;
        }
        if (PhpPsiUtil.getParentOfClass((PsiElement)decl, Global.class) != null || parent instanceof ParameterList) {
            return false;
        }
        if (decl instanceof Variable && ((Variable)decl).isDeclaration()) {
            if (PhpPsiUtil.getParentOfClass((PsiElement)decl, Global.class) != null) {
                return false;
            }
            if (parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getVariable() == decl || parent instanceof MultiassignmentExpression && ((MultiassignmentExpression)parent).getVariables().contains(decl)) {
                return !PsiTreeUtil.isAncestor((PsiElement)((AssignmentExpression)parent).getValue(), (PsiElement)this, (boolean)false);
            }
            return PhpPsiUtil.getParentOfClass((PsiElement)decl, Global.class) == null;
        }
        return false;
    }

    @Override
    @NotNull
    public String getImmediateNamespaceName() {
        return "";
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        PhpType phpType = stub != null ? stub.getType() : super.getType();
        if (phpType == null) {
            VariableImpl.$$$reportNull$$$0(47);
        }
        return phpType;
    }

    @Override
    @NotNull
    public PhpType getDocType() {
        PhpDocComment comment = this.getDocComment();
        if (comment == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                VariableImpl.$$$reportNull$$$0(48);
            }
            return phpType;
        }
        PhpType res = new PhpType();
        this.getCurrentVarTags(comment).forEach(res::add);
        this.customTagsForVariable(comment).forEach(res::add);
        PhpType phpType = res;
        if (phpType == null) {
            VariableImpl.$$$reportNull$$$0(49);
        }
        return phpType;
    }

    public Collection<PhpDocParamTag> getCurrentVarTags(PhpDocComment comment) {
        if (comment == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.filter(((PhpDocCommentImpl)comment).getVarTags(), t -> PhpLangUtil.equalsVariableNames(t.getVarName(), this.getName()));
    }

    @NotNull
    public Stream<PhpDocTag> customTagsForVariable(PhpDocComment comment) {
        Stream<PhpDocTag> stream = VariableImpl.customVarTags(comment).stream().filter(tag -> PhpLangUtil.equalsVariableNames(PhpDocParamTagImpl.getVarName(tag), this.getName()));
        if (stream == null) {
            VariableImpl.$$$reportNull$$$0(50);
        }
        return stream;
    }

    @NotNull
    public static Collection<PhpDocTag> customVarTags(PhpDocComment comment) {
        Collection<PhpDocTag> collection = PhpCustomDocTagTypeProvider.getTypeFromCustomTag(comment, PhpCustomDocTagTypeProvider::getVarTag);
        if (collection == null) {
            VariableImpl.$$$reportNull$$$0(51);
        }
        return collection;
    }

    @Override
    public Collection<PhpDocTag> getDocTags() {
        return Stream.concat(this.customTagsForVariable(this.getDocComment()), Stream.ofNullable(VariableImpl.getDocTag(this))).collect(Collectors.toSet());
    }

    @Nullable
    public static PhpDocParamTag getDocTag(@NotNull Variable variable) {
        PhpDocParamTag varTag;
        PhpDocComment docComment;
        if (variable == null) {
            VariableImpl.$$$reportNull$$$0(52);
        }
        if ((docComment = variable.getDocComment()) != null && (varTag = docComment.getVarTag()) != null && PhpLangUtil.equalsVariableNames(varTag.getVarName(), variable.getName())) {
            return varTag;
        }
        return null;
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        PhpDocComment docComment = PhpPsiUtil.getDocCommentFor(this, (NullableFunction<? super PhpPsiElement, ? extends PhpPsiElement>)((NullableFunction)element -> (PhpPsiElement)PhpPsiUtil.getParentByCondition((PsiElement)element, Statement.INSTANCEOF, GroupStatement.INSTANCEOF)));
        return docComment != null ? docComment : super.getDocComment();
    }

    public static boolean isVariableVariable(@NotNull Variable variable) {
        PhpPsiElement child;
        if (variable == null) {
            VariableImpl.$$$reportNull$$$0(53);
        }
        return !(variable.getParent() instanceof StringLiteralExpression) && (!variable.canReadName() ? (child = variable.getFirstPsiChild()) instanceof Variable || child instanceof ArrayAccessExpression : PhpPsiUtil.isOfType(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)variable, true), PhpTokenTypes.ARROW) && !PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)variable, true), PhpTokenTypes.chLPAREN));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 8, 9, 10, 13, 14, 18, 20, 24, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 52, 53 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/VariableImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 24: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/VariableImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableVariants";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalArrayAccessElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsUnionWithExternalRefs";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVariables";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatures";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesFromFunctionCall";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "customTagsForVariable";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "customVarTags";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getVariableVariants";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsUnionWithExternalRefs";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLeastByPathAndOffset";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectDeclarations";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectDeclarationsByScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCachedScopeMap";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doFetchScopeMap";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectDeclarationsWithExternalRef";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateDeclarationsWithExternalRef";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasReferencesToExternalScope";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "hasExternalRefInDeclaration";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "stubParentIsClosure";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getDocTag";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isVariableVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 8, 9, 10, 13, 14, 18, 20, 24, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 52, 53 -> new IllegalArgumentException(string);
        };
    }

    private static class OffsetComparator
    implements Comparator<PhpNamedElement> {
        private OffsetComparator() {
        }

        @Override
        public int compare(PhpNamedElement o1, PhpNamedElement o2) {
            return o1.getTextOffset() - o2.getTextOffset();
        }
    }

    private static class DeclarationCollector
    extends PhpRecursiveElementVisitor {
        private static final int MAX_TREE_DEPTH = 200;
        private final Stack<PsiElement> myScope = new Stack();
        private Map<String, TreeSet<PhpNamedElement>> myDecls;
        private final Map<PsiElement, Map<String, TreeSet<PhpNamedElement>>> myAllDecls = new WeakHashMap<PsiElement, Map<String, TreeSet<PhpNamedElement>>>();
        private final boolean global;
        private int myDepth = 0;
        private final Collection<String> myPossibleWrites = CollectionFactory.createCaseInsensitiveStringSet();

        DeclarationCollector(boolean global) {
            this.myDecls = new HashMap<String, TreeSet<PhpNamedElement>>();
            this.global = global;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                DeclarationCollector.$$$reportNull$$$0(0);
            }
            try {
                if (this.myDepth++ <= 200) {
                    super.visitElement(element);
                }
            }
            finally {
                --this.myDepth;
            }
        }

        @Override
        public void visitPhpFile(PhpFile phpFile) {
            this.myScope.push((Object)phpFile);
            super.visitPhpFile(phpFile);
            this.myScope.pop();
        }

        @Override
        public void visitPhpFunction(Function function) {
            this.myScope.push((Object)function);
            super.visitPhpFunction(function);
            this.myScope.pop();
        }

        @Override
        public void visitPhpNamespace(PhpNamespace namespace) {
            this.myScope.push((Object)namespace);
            super.visitPhpNamespace(namespace);
            this.myScope.pop();
        }

        @Override
        public void visitPhpMethod(Method method) {
            this.myScope.push((Object)method);
            super.visitPhpMethod(method);
            this.myScope.pop();
        }

        @Override
        public void visitPhpClass(PhpClass phpClass) {
            this.myScope.push((Object)phpClass);
            super.visitPhpClass(phpClass);
            this.myScope.pop();
        }

        @Override
        public void visitPhpVariable(Variable element) {
            if (element.isWriteAccess(this.global) || !this.global && !this.myPossibleWrites.contains(element.getName())) {
                this.myPossibleWrites.add(element.getName());
                this.save(element);
            }
        }

        @Override
        public void visitPhpParameter(Parameter parameter) {
            this.save(parameter);
        }

        @Override
        public void visitPhpDocVariable(PhpDocVariable expression) {
            String name;
            PhpDocTag tag = PhpPsiUtil.getParentOfClass((PsiElement)expression, PhpDocTag.class);
            if (tag != null && ("@var".equals(name = tag.getName()) || "@type".equals(name))) {
                PhpDocComment docComment = PhpPsiUtil.getParentOfClass((PsiElement)tag, PhpDocComment.class);
                if (docComment != null && DeclarationCollector.isDocCommentWithOwnerVariableToSave(tag, docComment)) {
                    return;
                }
                this.save(expression);
            }
        }

        private static boolean isDocCommentWithOwnerVariableToSave(PhpDocTag tag, PhpDocComment docComment) {
            return ContainerUtil.exists((Iterable)PsiTreeUtil.findChildrenOfAnyType((PsiElement)docComment.getOwner(), (Class[])new Class[]{Variable.class}), v -> v.getDocTags().contains(tag) && VariableImpl.isLocalWriteAccess((PsiElement)v));
        }

        private void save(PhpNamedElement namedElement) {
            String name;
            TreeSet<PhpNamedElement> decls;
            if (this.myScope.isEmpty()) {
                this.myScope.push((Object)namedElement.getContainingFile());
            }
            this.myDecls = this.myAllDecls.get(this.myScope.peek());
            if (this.myDecls == null) {
                this.myDecls = new HashMap<String, TreeSet<PhpNamedElement>>();
                this.myAllDecls.put((PsiElement)this.myScope.peek(), this.myDecls);
            }
            if ((decls = this.myDecls.get(name = namedElement.getName())) == null) {
                decls = VariableImpl.createVariableDeclarationsSet();
                this.myDecls.put(name, decls);
            }
            decls.add(namedElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/elements/impl/VariableImpl$DeclarationCollector", "visitElement"));
        }
    }
}

