/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeAnalyzer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpIteratedAccessTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpKeyTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpGeneratorsOperandsTypeIndex;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayAccessTP
implements PhpTypeProvider4 {
    public static final char SEPARATOR = '.';

    @Override
    public char getKey() {
        return 'E';
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement e) {
        PsiElement parent;
        if (e instanceof ArrayAccessExpression) {
            // empty if block
        }
        if (e instanceof Variable && (parent = e.getParent()) instanceof ForeachStatement) {
            ForeachStatement foreach = (ForeachStatement)parent;
            PsiElement arr = foreach.getArray();
            if (foreach.getKey() != e && arr instanceof PhpTypedElement) {
                int numberOfNestedList = PhpArrayAccessTP.countNestedList(e);
                if (numberOfNestedList > 0) {
                    PhpType type = ((PhpTypedElement)arr).getType().elementType(PhpIteratedAccessTP.TYPE_KEY);
                    for (int i = 0; i < numberOfNestedList; ++i) {
                        type = type.elementType(PhpIteratedAccessTP.TYPE_KEY);
                    }
                    return type;
                }
                if (e == foreach.getValue()) {
                    PhpArrayAccessTypeAnalyzer processor;
                    PhpType iteratedType = new PhpType().add(((PhpTypedElement)arr).getType());
                    if (arr instanceof PhpReference && ContainerUtil.exists(((PhpReference)arr).resolveLocal(), PhpArrayAccessTP::hasGeneratorOperands)) {
                        for (String signature : ((PhpReference)arr).getSignatureParts()) {
                            iteratedType.add(signature);
                        }
                    }
                    PhpType type = iteratedType.elementType(PhpIteratedAccessTP.TYPE_KEY);
                    PhpAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)arr, PhpAccessInstruction.class);
                    if (instruction != null && (processor = PhpTypeAnalyserVisitor.createProcessor(arr, null)) != null) {
                        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges(instruction, false, processor);
                        return new PhpType().add(type).add(processor.getType());
                    }
                    return type;
                }
            }
        }
        return null;
    }

    private static boolean hasGeneratorOperands(PhpNamedElement s) {
        return s instanceof Function && !PhpGeneratorsOperandsTypeIndex.getGeneratorOperands((Function)s).isEmpty();
    }

    private static int countNestedList(PsiElement variable) {
        PsiElement element = PhpPsiUtil.findPrevSiblingOfAnyType(variable, PhpTokenTypes.kwAS);
        ArrayDeque<IntRef> currentListParensDepth = new ArrayDeque<IntRef>();
        while (element != null && element != variable) {
            IntRef p;
            if (PhpPsiUtil.isOfType(element = element.getNextSibling(), PhpTokenTypes.chLBRACKET)) {
                currentListParensDepth.push(new IntRef(1));
                continue;
            }
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.kwLIST)) {
                currentListParensDepth.push(new IntRef(0));
                continue;
            }
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.chLPAREN)) {
                p = (IntRef)currentListParensDepth.peek();
                if (p == null) continue;
                p.inc();
                continue;
            }
            if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.chRPAREN, PhpTokenTypes.chRBRACKET) || (p = (IntRef)currentListParensDepth.peek()) == null) continue;
            int v = p.get() - 1;
            p.set(v);
            if (v != 0) continue;
            currentListParensDepth.pop();
        }
        return currentListParensDepth.size();
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        return PhpArrayAccessTP.doComplete(expression, project, PhpTypeSignatureKey.ARRAY_ELEMENT);
    }

    public static PhpType doComplete(String expression, Project project, PhpTypeKey typeKey) {
        boolean signatureShouldNotBeOmitted;
        int numberOfElementSigns = PhpArrayAccessTP.getNumberOfElementSigns(expression, typeKey);
        String refSignature = expression.substring(numberOfElementSigns * 2);
        PhpType completedSignature = new PhpType().add(refSignature).filterOut(PhpKeyTypeProvider::isArrayKeySignature).global(project);
        PhpType result = new PhpType();
        boolean atLeastOnPluralType = false;
        boolean bl = signatureShouldNotBeOmitted = !PhpIndexImpl.incompleteSignatureCanBeOmitted(refSignature) && Arrays.stream(PhpTypeSignatureKey.values()).anyMatch(s -> s.isSigned(refSignature));
        if (completedSignature.filterUnknown().isEmpty() && signatureShouldNotBeOmitted) {
            return PhpType.MIXED;
        }
        for (String type : completedSignature.getTypesWithParametrisedParts()) {
            if (PhpType.isPluralType(type) || PhpType.isArray(type)) {
                atLeastOnPluralType = true;
                PhpType partType = new PhpType().add(type);
                for (int i = 0; i < numberOfElementSigns; ++i) {
                    partType = partType.elementType(typeKey);
                }
                result.add(partType);
                continue;
            }
            if (PhpType.isMixedType(type) || signatureShouldNotBeOmitted && StringUtil.startsWithChar((CharSequence)type, (char)'?')) {
                atLeastOnPluralType = true;
            }
            result.add(PhpType.MIXED);
        }
        PhpType type = PhpArrayAccessTP.tryCompleteTypeFromGenericInstantiation(project, refSignature, numberOfElementSigns);
        if (type != null) {
            result.add(type);
            return result;
        }
        if (!atLeastOnPluralType) {
            return null;
        }
        return result;
    }

    @Nullable
    private static PhpType tryCompleteTypeFromGenericInstantiation(Project project, String refSignature, int numberOfElementSigns) {
        if (!PhpType.hasParameterizedPart(refSignature)) {
            return null;
        }
        String rawClassName = PhpType.removeParametrisedType(refSignature);
        if (!PhpTypeSignatureKey.CLASS.isSigned(rawClassName)) {
            return null;
        }
        String className = PhpTypeSignatureKey.CLASS.unsign(rawClassName);
        Collection<PhpClass> classes = PhpIndex.getInstance(project).getAnyByFQN(className);
        if (classes.isEmpty()) {
            return null;
        }
        PhpClass clazz = (PhpClass)ContainerUtil.getFirstItem(classes);
        Method method = clazz.findMethodByName("offsetGet");
        if (method == null) {
            return null;
        }
        Map<String, String> mapping = PhpClassImpl.createGenericMappingFromInstantiation(clazz, refSignature);
        PhpType returnType = method.getType();
        return PhpGenericsBaseExtendedWithGenericTypeProvider.substituteTypesWithMapping(returnType, mapping, numberOfElementSigns - 1);
    }

    public static int getNumberOfElementSigns(String expression, PhpTypeKey typeKey) {
        int numberOfSignatures = 0;
        int indexOfElementSignature = 0;
        while (typeKey.is(expression.charAt(indexOfElementSignature + 1))) {
            indexOfElementSignature += 2;
            ++numberOfSignatures;
        }
        return numberOfSignatures;
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return PhpArrayAccessTP.getBySignature(expression, visited, depth, project, PhpTypeSignatureKey.ARRAY_ELEMENT, PhpIndexImpl.ARRAY_VALUE_PROVIDERS);
    }

    @NotNull
    public static List<PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project, PhpTypeKey key, Map<String, String> providers) {
        SmartList elements = new SmartList();
        PhpIndex index = PhpIndex.getInstance(project);
        Collection<? extends PhpNamedElement> bySignature = index.getBySignature(expression, visited, ++depth);
        for (PsiElement psiElement : bySignature) {
            if (!(psiElement instanceof PhpTypedElement)) continue;
            PhpType type = ((PhpTypedElement)psiElement).getType();
            type = type.elementType(key);
            Set<String> strings = type.getTypes();
            for (String name : strings) {
                Collection<PhpClass> interfaces;
                if (PhpType.isUnresolved(name)) {
                    if (key.is(name.charAt(1))) {
                        elements.addAll(index.getTypeMethods(name.substring(2), visited, providers, depth));
                        continue;
                    }
                    elements.addAll(index.getBySignature(name));
                    continue;
                }
                Collection<PhpClass> classes = index.getClassesByFQN(name);
                if (classes.size() > 0) {
                    elements.addAll(classes);
                }
                if ((interfaces = index.getInterfacesByFQN(name)).size() <= 0) continue;
                elements.addAll(interfaces);
            }
        }
        SmartList smartList = elements;
        if (smartList == null) {
            PhpArrayAccessTP.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpArrayAccessTP", "getBySignature"));
    }
}

