/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayFunctionsProcessorParameterTypeProvider
implements PhpTypeProvider4 {
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u8501');

    @Override
    public char getKey() {
        return KEY.getKey();
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        return null;
    }

    @Nullable
    public static PhpType createLocalType(@NotNull Parameter element) {
        Function closure;
        if (element == null) {
            PhpArrayFunctionsProcessorParameterTypeProvider.$$$reportNull$$$0(0);
        }
        if ((closure = PhpPsiUtil.getParentOfClass(element, Function.class)) == null || !closure.isClosure()) {
            return null;
        }
        PhpExpression closureArgument = (PhpExpression)ObjectUtils.tryCast((Object)closure.getParent(), PhpExpression.class);
        if (closureArgument == null) {
            return null;
        }
        ParameterList parameterList = (ParameterList)ObjectUtils.tryCast((Object)closureArgument.getParent(), ParameterList.class);
        if (parameterList == null) {
            return null;
        }
        String functionName = PhpArrayFunctionsProcessorParameterTypeProvider.getFunctionName(parameterList);
        if (functionName == null) {
            return null;
        }
        Object[] parameters = parameterList.getParameters();
        int closureIndex = ArrayUtil.indexOf((Object[])parameters, (Object)closureArgument);
        if (closureIndex == 0 && functionName.equalsIgnoreCase("array_map")) {
            return PhpArrayFunctionsProcessorParameterTypeProvider.getElementType((PsiElement[])parameters, 1);
        }
        if (closureIndex == 1 && functionName.equalsIgnoreCase("array_filter")) {
            PsiElement mode = parameterList.getParameter(2);
            if (mode instanceof ConstantReference && "\\ARRAY_FILTER_USE_KEY".equals(((ConstantReference)mode).getFQN()) || PhpCodeInsightUtil.getParameterIndex(element) == 1) {
                return PhpType.NUMERIC;
            }
            return PhpArrayFunctionsProcessorParameterTypeProvider.getElementType((PsiElement[])parameters, 0);
        }
        return null;
    }

    @Nullable
    private static String getFunctionName(ParameterList parameterList) {
        FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)parameterList.getParent(), FunctionReference.class);
        if (functionReference == null || functionReference instanceof MethodReference) {
            return null;
        }
        return functionReference.getName();
    }

    @Nullable
    private static PhpType getElementType(PsiElement[] parameters, int index) {
        if (index >= parameters.length) {
            return null;
        }
        PhpTypedElement type = (PhpTypedElement)ObjectUtils.tryCast((Object)parameters[index], PhpTypedElement.class);
        return type != null ? type.getType().elementType().map(KEY::sign) : null;
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        return PhpType.global(project, expression.substring(2));
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return PhpIndex.getInstance(project).getBySignature(expression, visited, depth);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/resolve/types/PhpArrayFunctionsProcessorParameterTypeProvider", "createLocalType"));
    }
}

