/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collector;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocTypeFromSuperMemberTP
implements PhpTypeProvider4 {
    private static final char KEY = '\u0401';

    @Override
    public char getKey() {
        return '\u0401';
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        return null;
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        for (PhpNamedElement phpNamedElement : PhpIndex.getInstance(project).getBySignature(expression.substring(2))) {
            PhpType superParameterDocType;
            if (phpNamedElement instanceof Method) {
                PhpType superMethodDocType = PhpDocTypeFromSuperMemberTP.getSuperMethodDocType((Method)phpNamedElement);
                if (superMethodDocType == null) continue;
                return superMethodDocType;
            }
            if (!(phpNamedElement instanceof Parameter) || (superParameterDocType = PhpDocTypeFromSuperMemberTP.getSuperParameterDocType(phpNamedElement, expression)) == null) continue;
            return superParameterDocType;
        }
        return null;
    }

    @Nullable
    public static PhpType getSuperParameterDocType(PhpNamedElement parameter, String parameterSignature) {
        return (PhpType)PhpDocTypeFromSuperMemberTP.superParameters(parameter, parameterSignature).map(PhpDocTypeFromSuperMemberTP::getDocType).nonNull().collect(PhpDocTypeFromSuperMemberTP.toType());
    }

    public static StreamEx<Parameter> superParameters(PhpNamedElement parameter, String parameterSignature) {
        int parameterIndex = Integer.parseInt(parameterSignature.substring(parameterSignature.lastIndexOf(".") + 1));
        if (parameterIndex < 0) {
            return StreamEx.empty();
        }
        Method method = PhpPsiUtil.getParentOfClass((PsiElement)parameter, Method.class);
        if (method == null) {
            return StreamEx.empty();
        }
        return PhpDocTypeFromSuperMemberTP.superMethods(method).map(superMethod -> superMethod.getParameter(parameterIndex)).nonNull();
    }

    @Nullable
    public static PhpType getDocType(Parameter superParameter) {
        PhpDocParamTag tag = superParameter.getDocTag();
        if (tag != null) {
            return tag.getType();
        }
        Method superMethod = PhpPsiUtil.getParentOfClass(superParameter, Method.class);
        PhpDocComment superDocComment = superMethod != null ? superMethod.getDocComment() : null;
        return superDocComment != null && superDocComment.hasInheritDocTag() ? PhpDocTypeFromSuperMemberTP.getCurrentSignedType(superParameter.getLocalType()) : null;
    }

    @NotNull
    public static PhpType getCurrentSignedType(PhpType type) {
        PhpType phpType = type.filterOut(s -> !s.startsWith("#\u0401"));
        if (phpType == null) {
            PhpDocTypeFromSuperMemberTP.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    @Nullable
    public static PhpType getDocType(Method superMethod) {
        PhpDocComment superDocComment;
        PhpDocComment phpDocComment = superDocComment = superMethod != null ? superMethod.getDocComment() : null;
        if (superDocComment != null) {
            PhpDocReturnTag returnTag = superDocComment.getReturnTag();
            if (returnTag != null) {
                return returnTag.getType();
            }
            if (superDocComment.hasInheritDocTag()) {
                return PhpDocTypeFromSuperMemberTP.getCurrentSignedType(superMethod.getLocalType(true));
            }
        }
        return null;
    }

    @NotNull
    public static StreamEx<Method> superMethods(@NotNull Method method) {
        PhpClass aClass;
        if (method == null) {
            PhpDocTypeFromSuperMemberTP.$$$reportNull$$$0(1);
        }
        if ((aClass = method.getContainingClass()) == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                PhpDocTypeFromSuperMemberTP.$$$reportNull$$$0(2);
            }
            return streamEx;
        }
        String methodName = method.getName();
        StreamEx<Method> streamEx = PhpDocTypeFromSuperMemberTP.superMethods(aClass, methodName);
        if (streamEx == null) {
            PhpDocTypeFromSuperMemberTP.$$$reportNull$$$0(3);
        }
        return streamEx;
    }

    private static StreamEx<Method> superMethods(PhpClass aClass, String methodName) {
        HashSet visited = new HashSet();
        return PhpDocTypeFromSuperMemberTP.getSuperClasses(aClass).map(superClass -> superClass.findMethodByName(methodName, visited)).nonNull();
    }

    @Nullable
    public static PhpType getSuperMethodDocType(Method method) {
        return (PhpType)PhpDocTypeFromSuperMemberTP.superMethods(method).map(PhpDocTypeFromSuperMemberTP::getDocType).nonNull().collect(PhpDocTypeFromSuperMemberTP.toType());
    }

    private static Collector<PhpType, PhpType, PhpType> toType() {
        return Collector.of(PhpType::new, PhpType::add, PhpType::add, new Collector.Characteristics[0]);
    }

    private static StreamEx<PhpClass> getSuperClasses(PhpClass aClass) {
        return StreamEx.of(aClass.getSuperClasses()).append((Object[])aClass.getImplementedInterfaces()).nonNull();
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpDocTypeFromSuperMemberTP";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSignedType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpDocTypeFromSuperMemberTP";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "superMethods";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "superMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

