/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExcludeTypeTP
implements PhpTypeProvider4 {
    public static final Logger LOG = Logger.getInstance(PhpExcludeTypeTP.class);
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('-');

    @Override
    public char getKey() {
        return KEY.getKey();
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        return null;
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        int c = PhpType.getPluralDimension(expression);
        int i = (expression = PhpType.unpluralize(expression, c)).lastIndexOf("\u2206");
        if (i <= 0) {
            LOG.warn("Invalid exclusion signature: " + expression);
            return null;
        }
        PhpType.PhpTypeExclusion excludeCode = PhpExcludeTypeTP.getExclusion(expression, i);
        if (i + 2 < expression.length() && ApplicationManager.getApplication().isInternal() && !(excludeCode instanceof PhpTypesOutsideClassHierarchyExclusion) && !(excludeCode instanceof PhpPrimitiveTypeExclusion)) {
            LOG.warn("Non-optimal exclusion signature: " + expression);
        }
        assert (excludeCode != null) : expression;
        return new PhpType().add(expression.substring(2, i)).global(project).filterOut(type -> excludeCode.isNotApplicableType(project, (String)type)).pluralise(c);
    }

    @Nullable
    private static PhpType.PhpTypeExclusion getExclusion(String expression, int separatorIndex) {
        String code = expression.substring(separatorIndex + 1, separatorIndex + 2);
        if (code.equalsIgnoreCase("c")) {
            return new PhpTypesOutsideClassHierarchyExclusion(expression.substring(separatorIndex + 2));
        }
        if (code.equalsIgnoreCase("a")) {
            return new PhpPrimitiveTypeExclusion(expression.substring(separatorIndex + 2));
        }
        return PhpType.fromCode(code);
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        int i = expression.lastIndexOf("\u2206");
        if (i <= 0) {
            LOG.warn("Invalid exclusion signature: " + expression);
            return null;
        }
        String classRef = expression.substring(0, i);
        PhpIndex index = PhpIndex.getInstance(project);
        return StringUtil.startsWithChar((CharSequence)classRef, (char)'#') ? index.getBySignature(classRef, visited, depth) : index.getAnyByFQN(classRef);
    }

    @Override
    public boolean emptyResultIsComplete() {
        return true;
    }

    public static class PhpTypesOutsideClassHierarchyExclusion
    implements PhpType.PhpTypeExclusion {
        private static final String CODE = "c";
        private final String myInstanceofClassFqn;

        public PhpTypesOutsideClassHierarchyExclusion(String fqn) {
            this.myInstanceofClassFqn = fqn;
        }

        @Override
        public boolean isNotApplicableType(@Nullable Project project, @NotNull String type) {
            if (type == null) {
                PhpTypesOutsideClassHierarchyExclusion.$$$reportNull$$$0(0);
            }
            if (project == null) {
                return PhpType.isNotExtendablePrimitiveType(type) || PhpType.isArray(type) || PhpType.isPluralType(type);
            }
            Collection<PhpClass> classes = PhpIndex.getInstance(project).getAnyByFQN(type);
            if (classes.isEmpty()) {
                return false;
            }
            if (this.superExists(project, classes)) {
                return false;
            }
            HashSet<PhpClass> instanceOfClasses = new HashSet<PhpClass>(PhpIndex.getInstance(project).getAnyByFQN(this.myInstanceofClassFqn));
            if (!instanceOfClasses.isEmpty() && ContainerUtil.all(instanceOfClasses, i -> !i.isInterface()) && ContainerUtil.all(classes, i -> !i.isInterface())) {
                return true;
            }
            Ref superExistsInSubclasses = new Ref((Object)false);
            PhpIndex.getInstance(project).processAllSubclasses(type, instanceOfClasses, (Processor<? super PhpClass>)((Processor)c -> {
                if (this.superExists(project, Collections.singleton(c))) {
                    superExistsInSubclasses.set((Object)true);
                    return false;
                }
                return true;
            }));
            return (Boolean)superExistsInSubclasses.get() == false;
        }

        private boolean superExists(@NotNull Project project, Collection<PhpClass> subclasses) {
            if (project == null) {
                PhpTypesOutsideClassHierarchyExclusion.$$$reportNull$$$0(1);
            }
            return ContainerUtil.exists(subclasses, c -> PhpLangUtil.equalsClassNames(c.getFQN(), this.myInstanceofClassFqn) || this.getSubclassFQNs(project).contains(c.getFQN()));
        }

        @NotNull
        private Collection<String> getSubclassFQNs(@NotNull Project project) {
            if (project == null) {
                PhpTypesOutsideClassHierarchyExclusion.$$$reportNull$$$0(2);
            }
            Collection collection = PhpCaches.getInstance((Project)project).SUBCLASSES_CACHE.computeIfAbsent(this.myInstanceofClassFqn, s -> ContainerUtil.map(PhpIndex.getInstance(project).getAllSubclasses((String)s), PhpNamedElement::getFQN));
            if (collection == null) {
                PhpTypesOutsideClassHierarchyExclusion.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Override
        public String getCode() {
            return CODE + this.myInstanceofClassFqn;
        }

        @Override
        public boolean filterOnlyUnresolved() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpExcludeTypeTP$PhpTypesOutsideClassHierarchyExclusion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpExcludeTypeTP$PhpTypesOutsideClassHierarchyExclusion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubclassFQNs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isNotApplicableType";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "superExists";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubclassFQNs";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpPrimitiveTypeExclusion
    implements PhpType.PhpTypeExclusion {
        private static final String CODE = "a";
        private final String myPrimitiveType;

        public PhpPrimitiveTypeExclusion(String type) {
            this.myPrimitiveType = type;
        }

        @Override
        public boolean isNotApplicableType(@Nullable Project project, @NotNull String type) {
            if (type == null) {
                PhpPrimitiveTypeExclusion.$$$reportNull$$$0(0);
            }
            if (PhpType.isArray(this.myPrimitiveType)) {
                return PhpType.isArray(type) || PhpType.isPluralType(type);
            }
            return type.equalsIgnoreCase(this.myPrimitiveType);
        }

        @Override
        public String getCode() {
            return CODE + this.myPrimitiveType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpExcludeTypeTP$PhpPrimitiveTypeExclusion", "isNotApplicableType"));
        }
    }
}

