/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.completion.PhpArrayShapeIndexCompletionProvider;
import com.jetbrains.php.completion.PhpObjectShapeCompletionProvider;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayShapeIndexTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayShapeTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpObjectShapeTypeProvider
implements PhpTypeProvider4 {
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('l');

    @Override
    public char getKey() {
        return KEY.getKey();
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof Field || element instanceof Function) {
            return PhpObjectShapeTypeProvider.getTypeForObjectShapeOwner((PhpNamedElement)element);
        }
        if (element instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)element;
            return PhpObjectShapeTypeProvider.getTypeInsideObjectShape(fieldReference);
        }
        return null;
    }

    @Nullable
    private static PhpType getTypeForObjectShapeOwner(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpObjectShapeTypeProvider.$$$reportNull$$$0(0);
        }
        PhpType type = new PhpType();
        for (PhpShapeEntriesIndex.PhpShapeEntry shape : PhpObjectShapeCompletionProvider.getObjectShapes(element)) {
            String payload = PhpArrayShapeIndexTP.serializeShape(shape);
            if (payload == null) continue;
            type.add(KEY.sign(payload));
        }
        return type.isEmpty() ? null : type;
    }

    @Nullable
    private static PhpType getTypeInsideObjectShape(@NotNull FieldReference fieldReference) {
        ArrayDeque<PhpExpectedFunctionArgument> parentAccesses;
        PhpPsiElement parent;
        if (fieldReference == null) {
            PhpObjectShapeTypeProvider.$$$reportNull$$$0(1);
        }
        if ((parent = PhpObjectShapeCompletionProvider.findParent(fieldReference, parentAccesses = new ArrayDeque<PhpExpectedFunctionArgument>())) == null || parent == fieldReference) {
            return null;
        }
        PhpType type = new PhpType();
        Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes = PhpObjectShapeTypeProvider.tryGetObjectShapesInner((PsiElement)parent, new ArrayDeque<PhpExpectedFunctionArgument>(parentAccesses));
        for (PhpShapeEntriesIndex.PhpShapeEntry shape : objectShapes) {
            String key = StringUtil.unquoteString((String)shape.getKey().getValue());
            if (!key.equals(fieldReference.getName())) continue;
            type.add(shape.getType());
        }
        if (!type.isEmpty()) {
            return type;
        }
        return PhpArrayShapeTP.getPossibleEncodedShape((PsiElement)parent, fieldReference.getName(), parentAccesses, KEY);
    }

    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> tryGetObjectShapesInner(@NotNull PsiElement parent, ArrayDeque<PhpExpectedFunctionArgument> parentAccesses) {
        Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapes;
        if (parent == null) {
            PhpObjectShapeTypeProvider.$$$reportNull$$$0(2);
        }
        if (!(objectShapes = PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, PhpObjectShapeCompletionProvider.getObjectShapesInner(parent))).isEmpty()) {
            return objectShapes;
        }
        FieldReference firstFieldReference = (FieldReference)PhpPsiUtil.getParentByCondition(parent, FieldReference.INSTANCEOF, Statement.INSTANCEOF);
        if (firstFieldReference == null) {
            return Collections.emptyList();
        }
        parentAccesses.poll();
        return PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, PhpObjectShapeCompletionProvider.getObjectShapesInner((PsiElement)firstFieldReference));
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> objectShapesFromTypes(PsiElement value) {
        PhpReference ref = (PhpReference)ObjectUtils.tryCast((Object)value, PhpReference.class);
        if (ref == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.flatMap(ref.getSignatureParts(), s -> PhpObjectShapeTypeProvider.fetchObjectShapeEntries(value.getProject(), s));
    }

    private static List<PhpShapeEntriesIndex.PhpShapeEntry> fetchObjectShapeEntries(Project project, String signature) {
        return PhpArrayShapeIndexTP.fetchShapeEntries(project, signature, KEY).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        return PhpArrayShapeIndexTP.complete(expression, project, KEY);
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpObjectShapeTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeForObjectShapeOwner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeInsideObjectShape";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetObjectShapesInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

