/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpOverriddenTraitMethodTP
implements PhpTypeProvider4 {
    private static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('T');
    private static final String PARENT_SYMBOL = "&";

    @Override
    public char getKey() {
        return KEY.getKey();
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        PhpClass containingClass;
        if (element instanceof Variable && PhpLangUtil.isThisReference(element)) {
            PhpClass containingClass2 = PhpOverriddenTraitMethodTP.getContainingTrait(element);
            if (containingClass2 != null) {
                return new PhpType().add(KEY.sign(containingClass2.getFQN()));
            }
        } else if (element instanceof ClassReference && PhpLangUtil.isParentReference(element) && (containingClass = PhpOverriddenTraitMethodTP.getContainingTrait(element)) != null) {
            String traitSignature = containingClass.getFQN() + PARENT_SYMBOL;
            return new PhpType().add(KEY.sign(traitSignature));
        }
        return null;
    }

    @Nullable
    private static PhpClass getContainingTrait(PsiElement position) {
        PhpClass containingTrait = PhpPsiUtil.getParentOfClass(position, PhpClass.class);
        return containingTrait != null && containingTrait.isTrait() ? containingTrait : null;
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        PhpType type = new PhpType();
        PhpOverriddenTraitMethodTP.usingClasses(project, expression.substring(2)).forEach(type::add);
        return type;
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return Collections.emptySet();
    }

    @NotNull
    public static Collection<PhpClass> usingClasses(Project project, String traitExpression) {
        boolean parent = traitExpression.endsWith(PARENT_SYMBOL);
        if (parent) {
            traitExpression = traitExpression.substring(0, traitExpression.length() - 1);
        }
        PhpIndex index = PhpIndex.getInstance(project);
        List traits = ContainerUtil.filterIsInstance(index.getAnyByFQN(traitExpression), PhpClass.class);
        StreamEx traitUsages = StreamEx.of((Collection)traits).flatMap(trait -> PhpOverriddenTraitMethodTP.traitUsages(trait).stream());
        Collection res = parent ? (Collection)traitUsages.flatMap(phpClass -> phpClass.getSuperClasses().stream()).collect(Collectors.toList()) : (Collection)traitUsages.collect(Collectors.toList());
        Collection collection = res.isEmpty() ? traits : res;
        if (collection == null) {
            PhpOverriddenTraitMethodTP.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public static Collection<PhpClass> traitUsages(PhpClass trait) {
        HashSet<PhpClass> res = new HashSet<PhpClass>();
        PhpIndex.getInstance(trait.getProject()).processNestedTraitUsages(trait, null, (Processor<? super PhpClass>)((Processor)c -> {
            if (!c.isTrait()) {
                res.add((PhpClass)c);
            }
            return true;
        }));
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpOverriddenTraitMethodTP", "usingClasses"));
    }
}

