/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.diagnostic.PluginException;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpCaches;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocTagStub;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider2;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider3;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStub;
import com.jetbrains.php.lang.psi.stubs.PhpFunctionStub;
import com.jetbrains.php.lang.psi.stubs.PhpMemberStub;
import com.jetbrains.php.lang.psi.stubs.PhpParameterStub;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.stubs.indexes.gist.PhpElementStubGist;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpTypeInfo {
    public static final Logger LOG = Logger.getInstance(PhpTypeInfo.class);
    private static final RecursionGuard<PsiElement> RECURSION_GUARD = RecursionManager.createGuard((String)"php.type.info");

    public static PhpType getType(@Nullable PsiElement psi) {
        return PhpTypeInfo.getType(psi, new PhpTypeAnalyserVisitor()).createImmutableType();
    }

    private static PhpType getType(@Nullable PsiElement psi, PhpTypeAnalyserVisitor analyser) {
        ProgressManager.checkCanceled();
        if (psi == null) {
            return PhpType.EMPTY;
        }
        Map<PsiElement, PhpType> type_cache = PhpCaches.getInstance((Project)psi.getProject()).TYPE_CACHE;
        PhpType type = null;
        if (psi instanceof StubBasedPsiElementBase) {
            StubElement stub = ((StubBasedPsiElementBase)psi).getGreenStub();
            if (!Registry.is((String)"php.use.type.gist") && stub instanceof PhpTypedStub) {
                type = ((PhpTypedStub)stub).getType();
                if (type != null) {
                    return type;
                }
            } else if (Registry.is((String)"php.use.type.gist") && PhpTypeInfo.shouldUseGistForStubElement(stub) && (type = type_cache.get(psi)) == null && (type = PhpElementStubGist.Companion.getInstance(psi.getProject()).getDataFromGist(stub)) != null) {
                type_cache.put(psi, type);
            }
            if (type != null) {
                return type;
            }
        }
        return PhpTypeInfo.getTypeCached(psi, analyser, type_cache);
    }

    private static boolean shouldUseGistForStubElement(StubElement<?> stub) {
        return stub instanceof PhpMemberStub || stub instanceof PhpConstantStub || stub instanceof PhpFunctionStub || stub instanceof PhpParameterStub || stub instanceof PhpDocTagStub;
    }

    public static PhpType getTypeCached(@NotNull PsiElement psi, PhpTypeAnalyserVisitor analyser, Map<PsiElement, PhpType> type_cache) {
        PhpType type;
        if (psi == null) {
            PhpTypeInfo.$$$reportNull$$$0(0);
        }
        if ((type = type_cache.get(psi)) == null) {
            RecursionGuard.StackStamp mark = RecursionManager.markStack();
            List currentStack = RECURSION_GUARD.currentStack();
            if (currentStack.size() > 100) {
                PsiElement top = (PsiElement)currentStack.get(0);
                LOG.debug("RECURSION LIMIT for " + top + " `" + top.getText() + "`:" + top.getTextOffset() + " on " + psi + " `" + StringUtil.trimLog((String)psi.getText(), (int)50) + "`:" + psi.getTextOffset() + "+" + psi.getTextLength() + " in " + PsiUtilCore.getVirtualFile((PsiElement)psi));
                RECURSION_GUARD.prohibitResultCaching((Object)psi);
            } else {
                type = PhpTypeInfo.getTypeFromAST(psi, analyser);
            }
            if (type == null) {
                type = PhpType.EMPTY;
            }
            if (type_cache.size() > 7000) {
                type_cache.clear();
            }
            if (mark.mayCacheNow() || psi == ContainerUtil.getLastItem((List)RECURSION_GUARD.currentStack())) {
                type_cache.put(psi, type);
            }
        }
        return type;
    }

    @NotNull
    public static PhpType getTypeFromAST(@NotNull PsiElement psi, PhpTypeAnalyserVisitor typeAnalyser) {
        if (psi == null) {
            PhpTypeInfo.$$$reportNull$$$0(1);
        }
        PhpType type = (PhpType)RECURSION_GUARD.doPreventingRecursion((Object)psi, true, () -> {
            PhpType provided;
            PhpType providedTypes = new PhpType();
            PhpType analysed = typeAnalyser.getTypeFromAST(psi);
            for (PhpTypeProvider4 phpTypeProvider4 : typeAnalyser.getTypeProviders(psi)) {
                try {
                    ProgressManager.checkCanceled();
                    provided = phpTypeProvider4.getType(psi);
                    if (provided != null && !provided.isEmpty() && LOG.isTraceEnabled()) {
                        LOG.trace("TypeProvider4 " + phpTypeProvider4.getClass() + " +'" + provided + " @" + psi);
                    }
                    providedTypes.add(provided != null && typeAnalyser.filterOutMixed() ? provided.filterMixed() : provided);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass((String)("TypeProvider contract violation? by " + phpTypeProvider4.getClass() + " on " + psi.getText()), (Throwable)e, phpTypeProvider4.getClass());
                }
            }
            if (!providedTypes.isEmpty()) {
                analysed = analysed.add(providedTypes);
            }
            for (PhpTypeProvider3 phpTypeProvider3 : PhpTypeProvider3.EP_NAME.getExtensionList()) {
                try {
                    ProgressManager.checkCanceled();
                    if ('\u0196' == phpTypeProvider3.getKey() && !Registry.is((String)"php.enable.php.toolbox.type.provider")) continue;
                    provided = phpTypeProvider3.getType(psi);
                    if (provided != null && !provided.isEmpty() && LOG.isTraceEnabled()) {
                        LOG.trace("TypeProvider3 " + phpTypeProvider3.getClass() + " +'" + provided + " @" + psi);
                    }
                    providedTypes.add(provided);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw PluginException.createByClass((String)("TypeProvider contract violation? by " + phpTypeProvider3.getClass() + " on " + psi.getText()), (Throwable)e, phpTypeProvider3.getClass());
                }
            }
            if (!providedTypes.isEmpty()) {
                return analysed.add(providedTypes);
            }
            for (PhpTypeProvider2 phpTypeProvider2 : PhpTypeProvider2.EP_NAME.getExtensionList()) {
                ProgressManager.checkCanceled();
                String providerType = phpTypeProvider2.getType(psi);
                if (providerType == null) continue;
                StringUtil.split((String)providerType, (String)"|").stream().map(s -> "#" + phpTypeProvider2.getKey() + s).forEach(providedTypes::add);
            }
            if (!providedTypes.isEmpty()) {
                return analysed.add(providedTypes);
            }
            return analysed;
        });
        PhpType phpType = (PhpType)ObjectUtils.notNull((Object)type, (Object)PhpType.EMPTY);
        if (phpType == null) {
            PhpTypeInfo.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromAST";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCached";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromAST";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

