/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitAssertInstanceOfTypeProvider
implements PhpTypeProvider4 {
    private static final Key<CachedValue<Boolean>> CONTAINS_ASSERT_INSTANCEOF = Key.create((String)"php.phpunit.assert.instanceof");
    public static final String ASSERT_INSTANCEOF_METHOD_NAME = "assertInstanceOf";

    @Override
    public char getKey() {
        return 'i';
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        if (!(element instanceof Variable) || ((Variable)element).isWriteAccess(false)) {
            return null;
        }
        Function function = PhpPsiUtil.getParentOfClass(element, Function.class);
        if (!(function instanceof Method) || !PhpUnitAssertInstanceOfTypeProvider.functionContainsAssertInstanceOf(function)) {
            return null;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((Variable)element, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return null;
        }
        Ref ambiguity = new Ref((Object)false);
        Collection<String> instanceOfCallsFqns = this.collectFqnsFromInstanceofCalls((Variable)element, instruction, (Ref<Boolean>)ambiguity);
        if (!((Boolean)ambiguity.get()).booleanValue() && !instanceOfCallsFqns.isEmpty()) {
            PhpType type = new PhpType();
            instanceOfCallsFqns.forEach(type::add);
            return type;
        }
        return null;
    }

    private static boolean functionContainsAssertInstanceOf(Function function) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)function, CONTAINS_ASSERT_INSTANCEOF, () -> {
            boolean res = false;
            for (PhpInstruction instruction : function.getControlFlow().getInstructions()) {
                MethodReference call;
                FunctionReference patt2870$temp;
                if (!(instruction instanceof PhpCallInstruction) || !((patt2870$temp = ((PhpCallInstruction)instruction).getFunctionReference()) instanceof MethodReference) || !PhpLangUtil.equalsMethodNames((call = (MethodReference)patt2870$temp).getName(), ASSERT_INSTANCEOF_METHOD_NAME)) continue;
                res = true;
                break;
            }
            return CachedValueProvider.Result.create((Object)res, (Object[])new Object[]{function});
        });
    }

    @NotNull
    private Collection<String> collectFqnsFromInstanceofCalls(final Variable element, PhpAccessVariableInstruction instruction, final Ref<Boolean> ambiguity) {
        final HashSet<String> instanceOfCallsFqns = new HashSet<String>();
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(element.getName(), instruction.getVariableName()) && instruction.getAccess().isWrite()) {
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }

            @Override
            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                String fqn;
                PsiElement variableToCheck;
                FunctionReference reference = instruction.getFunctionReference();
                if (reference instanceof MethodReference && PhpLangUtil.equalsMethodNames(reference.getName(), PhpUnitAssertInstanceOfTypeProvider.ASSERT_INSTANCEOF_METHOD_NAME) && (variableToCheck = reference.getParameter(1)) instanceof Variable && PhpLangUtil.equalsVariableNames(element.getName(), ((Variable)variableToCheck).getName()) && (fqn = PhpCodeInsightUtil.toString(reference.getParameter(0), false)) != null) {
                    instanceOfCallsFqns.add(PhpLangUtil.toFQN(fqn));
                    return false;
                }
                return super.processPhpCallInstruction(instruction);
            }

            @Override
            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                ambiguity.set((Object)true);
                return false;
            }
        });
        HashSet<String> hashSet = instanceOfCallsFqns;
        if (hashSet == null) {
            PhpUnitAssertInstanceOfTypeProvider.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        return null;
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpUnitAssertInstanceOfTypeProvider", "collectFqnsFromInstanceofCalls"));
    }
}

