/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.generics;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethodTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class PhpGenericTypeProvider
implements PhpTypeProvider4 {
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('q');

    @Override
    public char getKey() {
        return KEY.getKey();
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpDocMethodTag) {
            return PhpGenericTypeProvider.getGenericTypeFromDocMethod(element);
        }
        if (element instanceof PhpTypedElement) {
            Collection<PhpDocTag> tags = ((PhpTypedElement)element).getDocTags();
            if (!PhpGenericTypeProvider.hasTemplates(tags)) {
                return null;
            }
            for (PhpDocTag tag : tags) {
                PhpType type = PhpGenericTypeProvider.getGenericType(tag, e -> (PhpReference)ObjectUtils.tryCast((Object)e, PhpDocType.class));
                if (type == null) continue;
                return type.map(KEY::sign);
            }
        }
        return null;
    }

    private static boolean hasTemplates(Collection<PhpDocTag> tags) {
        PhpDocTag firstTag = (PhpDocTag)ContainerUtil.getFirstItem(tags);
        return firstTag != null && !PhpGenericsTemplatesCustomDocTagValueStubProvider.getTemplates((PhpDocComment)ObjectUtils.tryCast((Object)firstTag.getParent(), PhpDocComment.class)).isEmpty();
    }

    @Nullable
    public static PhpType getGenericTypeFromDocMethod(PsiElement element) {
        return PhpGenericTypeProvider.getGenericType((PhpDocMethodTag)element, PhpGenericTypeProvider::getReferenceFromDocMethodType);
    }

    @Nullable
    public static PhpReference getReferenceFromDocMethodType(PsiElement e) {
        return PhpPsiUtil.isOfType(e, (IElementType)PhpDocElementTypes.phpDocMethodType) ? (PhpReference)PsiTreeUtil.getChildOfType((PsiElement)e, PhpReference.class) : null;
    }

    @Nullable
    private static PhpType getGenericType(PhpDocTag tag, Function<PsiElement, PhpReference> referenceExtractor) {
        List parts = PhpGenericsTemplatesCustomDocTagValueStubProvider.templatesParts(tag, referenceExtractor).collect(Collectors.toList());
        if (parts.size() > 1) {
            return PhpType.createParametrized((String)parts.get(0), ArrayUtil.toStringArray(parts.subList(1, parts.size())));
        }
        return null;
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        return null;
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        String signature = (String)ContainerUtil.getFirstItem(PhpParameterBasedTypeProvider.extractSignatures(expression, 0));
        return signature != null ? PhpIndex.getInstance(project).getBySignature(signature, visited, depth) : Collections.emptyList();
    }
}

