/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.generics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpIteratedAccessTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaTypeMappingsTable;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGenericsArrayAccessExtendedWithGenericTypeProvider
extends PhpGenericsBaseExtendedWithGenericTypeProvider<PhpNamedElement> {
    public static final String GENERIC_GENERATOR_KEY = "\u03c9";

    @Override
    public char getKey() {
        return PhpIteratedAccessTP.TYPE_KEY.getKey();
    }

    @Override
    @Nullable
    public PhpType complete(Project project, String expression, int depth) {
        PhpType genericGenerator = PhpGenericsArrayAccessExtendedWithGenericTypeProvider.tryCompleteGenericGeneratorType(project, expression.substring(2));
        if (!genericGenerator.isEmpty()) {
            return genericGenerator;
        }
        PhpType type = super.complete(project, expression, depth);
        if (type != null) {
            return type.map(t -> PhpGenericsArrayAccessExtendedWithGenericTypeProvider.unpluralizeParametersAware(project, t));
        }
        return null;
    }

    private static String unpluralizeParametersAware(Project project, String t) {
        List<String> parameters = PhpType.getParametrizedParts(t);
        if (!parameters.isEmpty() && PhpType.from("\\iterable", "\\Iterator").isConvertibleFrom(project, PhpType.from(t))) {
            return (String)ContainerUtil.getLastItem(parameters);
        }
        return (String)ContainerUtil.getFirstItem(PhpType.from(t).unpluralize().getTypes());
    }

    private static PhpType tryCompleteGenericGeneratorType(Project project, String expression) {
        PhpType res = new PhpType();
        if (!expression.startsWith("#\u03c0")) {
            return res;
        }
        List<String> signatures = PhpParameterBasedTypeProvider.extractSignatures(expression, 2);
        if (signatures.isEmpty()) {
            return res;
        }
        String subject = PhpParameterBasedTypeProvider.completeSubject(project, signatures.get(0));
        List<String> params = signatures.subList(1, signatures.size());
        Map<String, PhpMetaTypeMappingsTable> map = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(project);
        if (map == null) {
            return res;
        }
        for (PhpNamedElement phpNamedElement : PhpIndex.getInstance(project).getBySignature(subject)) {
            if (!(phpNamedElement instanceof Function)) continue;
            PhpGenericsArrayAccessExtendedWithGenericTypeProvider.addArgumentsFromResolvedGenerator(res, params, map, (Function)phpNamedElement);
        }
        return res;
    }

    private static void addArgumentsFromResolvedGenerator(PhpType res, List<String> params, Map<String, PhpMetaTypeMappingsTable> map, Function element) {
        Collection<PhpParameterBasedTypeProvider.PhpPassedArgument> arguments = PhpParameterBasedTypeProvider.convertFromNamedToPositional(params, element);
        for (Integer index : PhpGenericsArrayAccessExtendedWithGenericTypeProvider.getGenericGeneratorIndex(element, map)) {
            PhpParameterBasedTypeProvider.PhpPassedArgument argument = (PhpParameterBasedTypeProvider.PhpPassedArgument)ContainerUtil.find(arguments, a -> a.myIndex == index);
            if (argument == null) continue;
            res.add(argument.myArgument);
        }
    }

    private static Collection<Integer> getGenericGeneratorIndex(Function function, Map<String, PhpMetaTypeMappingsTable> map) {
        PhpMetaTypeMappingsTable table = map.get(PhpTypeSignatureKey.getSignature(function));
        if (table == null) {
            return Collections.emptySet();
        }
        return ContainerUtil.map(table.get(GENERIC_GENERATOR_KEY), s -> StringUtil.parseInt((String)s, (int)-1));
    }

    public static boolean extendsByFQN(PhpClass phpClass, String fqn) {
        return PhpType.findSuper(fqn, phpClass.getFQN(), PhpIndex.getInstance(phpClass.getProject()));
    }

    @Override
    protected StreamEx<? extends PhpNamedElement> resolveTargetMembers(Project project, String expression, PhpIndex index, Map<String, Set<List<String>>> extendedClassesToSubstitutedTemplates, int depth) {
        return ((StreamEx)((StreamEx)StreamEx.of(extendedClassesToSubstitutedTemplates.keySet()).filter(StringUtil::isNotEmpty)).flatMap(fqn -> index.getAnyByFQN((String)fqn).stream()).filter(containingClass -> PhpGenericsArrayAccessExtendedWithGenericTypeProvider.extendsByFQN(containingClass, "\\Traversable"))).map(c -> PhpGenericsArrayAccessExtendedWithGenericTypeProvider.resolveTargetMember(c)).nonNull();
    }

    @Nullable
    public static PhpNamedElement resolveTargetMember(PhpClass c) {
        if (PhpLangUtil.equalsClassNames("\\Traversable", c.getFQN())) {
            return c;
        }
        return c.findMethodByName(PhpGenericsArrayAccessExtendedWithGenericTypeProvider.getMethodName(c));
    }

    @Override
    protected Class<PhpNamedElement> getElementClass() {
        return PhpNamedElement.class;
    }

    @NotNull
    private static CharSequence getMethodName(PhpClass c) {
        return PhpGenericsArrayAccessExtendedWithGenericTypeProvider.extendsByFQN(c, "\\IteratorAggregate") ? "getIterator" : "current";
    }

    @Override
    protected Collection<String> getDeclaredTypes(PhpNamedElement m) {
        if (m instanceof Method) {
            Set<String> types = m.getDocType().getTypesWithParametrisedParts();
            if (PhpLangUtil.equalsMethodNames(m.getName(), "current")) {
                return ContainerUtil.map(types, s -> PhpType.pluralise(s, 1));
            }
            return types;
        }
        if (m instanceof PhpClass) {
            return Collections.singleton(PhpType.createParametrizedType("\\Traversable", PhpGenericsExtendedTypeProvider.KEY.sign("TValue")));
        }
        return Collections.emptySet();
    }

    @Override
    @Nullable
    protected String getClassRef(@Nullable String expression) {
        return expression != null ? expression.substring(2) : null;
    }

    @Override
    protected PhpClass getContainingClass(PhpNamedElement element) {
        if (element instanceof PhpClass) {
            return (PhpClass)element;
        }
        if (element instanceof Method) {
            return ((Method)element).getContainingClass();
        }
        return null;
    }
}

