/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.generics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocPrefixProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericConstructorTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsGenericMetaSignatureResolver;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplateIndex;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpTypeProviderEx;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpGenericsBaseExtendedWithGenericTypeProvider<T>
extends PhpTypeProviderEx {
    @Override
    @Nullable
    public PhpType complete(Project project, String expression, int depth) {
        Map<String, Set<List<String>>> extendedClassesToSubstitutedTemplates;
        PhpIndex index = PhpIndex.getInstance(project);
        String classRef = this.getClassRef(expression);
        if (classRef == null) {
            return null;
        }
        if (PhpType.hasParameterizedPart(classRef) && !PhpType.isUnresolved(classRef)) {
            classRef = PhpTypeSignatureKey.CLASS.sign(classRef);
        }
        if ((extendedClassesToSubstitutedTemplates = PhpGenericsBaseExtendedWithGenericTypeProvider.getExtendedClassesToSubstitutedTemplates(index, classRef, depth)).isEmpty()) {
            return null;
        }
        expression = PhpGenericsBaseExtendedWithGenericTypeProvider.unwrapMetaMethodCall(expression);
        return (PhpType)this.resolveTargetMembers(project, expression, index, extendedClassesToSubstitutedTemplates, depth).flatMap(m -> this.getSubstitutedTemplateInfo(m, true).stream()).flatMap(info -> PhpGenericsBaseExtendedWithGenericTypeProvider.substituteTemplateType(extendedClassesToSubstitutedTemplates, info).stream()).nonNull().reduce((Object)new PhpType(), PhpType::add, PhpType::or);
    }

    private static String unwrapMetaMethodCall(String expression) {
        List<String> signatures;
        int dotIndex;
        String classReference;
        if (PhpTypeSignatureKey.METHOD.isSigned(expression) && (classReference = expression.substring(2, dotIndex = expression.lastIndexOf(46))).startsWith("#\u03c0") && !(signatures = PhpParameterBasedTypeProvider.extractSignatures(classReference, 2)).isEmpty()) {
            return PhpTypeSignatureKey.METHOD.sign(signatures.get(0) + expression.substring(dotIndex));
        }
        return expression;
    }

    protected StreamEx<? extends T> resolveTargetMembers(Project project, String expression, PhpIndex index, Map<String, Set<List<String>>> extendedClassesToSubstitutedTemplates, int depth) {
        return StreamEx.of(index.getBySignature(expression, null, depth + 1)).select(this.getElementClass());
    }

    protected abstract Class<T> getElementClass();

    @Nullable
    protected String getClassRef(@Nullable String expression) {
        if (expression == null) {
            return null;
        }
        int dot = expression.lastIndexOf(46);
        if (dot < 0) {
            return null;
        }
        return expression.substring(2, dot);
    }

    public static Map<String, Set<List<String>>> getExtendedClassesToSubstitutedTemplates(PhpIndex index, String classRef, int depth) {
        return PhpGenericsBaseExtendedWithGenericTypeProvider.decodeExtendedClassesAndSubstitutedTemplates(index, classRef, depth).nonNull().mapToEntry(c -> (String)c.getFirst(), c -> Collections.singleton((List)c.getSecond())).toMap(ContainerUtil::union);
    }

    @NotNull
    private static StreamEx<Pair<String, List<String>>> decodeExtendedClassesAndSubstitutedTemplates(PhpIndex index, String classRef, int depth) {
        StreamEx streamEx = PhpGenericsBaseExtendedWithGenericTypeProvider.decodeExtendedClassesAndSubstitutedTemplates(index, classRef, new HashSet<String>(), depth).map(p -> Pair.create((Object)PhpGenericsGenericMetaSignatureResolver.normalizeCallable((String)p.getFirst()), (Object)((List)p.getSecond())));
        if (streamEx == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(0);
        }
        return streamEx;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static StreamEx<Pair<String, List<String>>> decodeExtendedClassesAndSubstitutedTemplates(PhpIndex index, String classRef, Collection<String> visited, int depth) {
        List r;
        if (!visited.add(classRef) || !classRef.startsWith("#") && !PhpType.hasParameterizedPart(classRef)) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(1);
            }
            return streamEx;
        }
        if (PhpGenericConstructorTypeProvider.KEY.signed(classRef)) {
            List<String> signatures = PhpParameterBasedTypeProvider.extractSignatures(classRef, 2);
            String classFQN = signatures.get(0);
            List<String> argumentsSignatures = signatures.stream().skip(1L).map(s -> PhpGenericsBaseExtendedWithGenericTypeProvider.completeArgumentSignature(index, PhpParameterBasedTypeProvider.extractSignatures(s, 0))).collect(Collectors.toList());
            return PhpGenericsBaseExtendedWithGenericTypeProvider.substituteConstructorArgumentSignatures(index, classFQN, argumentsSignatures);
        }
        if (classRef.startsWith("#\u03c0")) {
            List<String> signatures = PhpParameterBasedTypeProvider.extractSignatures(classRef, 2);
            if (signatures.size() > 1) {
                String classFQN = signatures.get(0);
                StreamEx streamEx = ((StreamEx)StreamEx.of(index.getBySignature(classFQN)).select(com.jetbrains.php.lang.psi.elements.Function.class).map(m -> PhpGenericsBaseExtendedWithGenericTypeProvider.substituteTemplateTypeInPolymorphicMethod((String)signatures.get(0), signatures.subList(1, signatures.size()), m)).filter(Objects::nonNull)).flatMap(s -> PhpGenericsBaseExtendedWithGenericTypeProvider.decodeExtendedClassesAndSubstitutedTemplates(index, s, visited, depth));
                if (streamEx == null) {
                    PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(2);
                }
                return streamEx;
            }
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(3);
            }
            return streamEx;
        }
        Set<@NlsSafe String> globalTypes = ((PhpIndexImpl)index).completeType(((PhpIndexImpl)index).getProject(), PhpType.from(classRef), null, depth + 1, null).getTypesWithParametrisedParts();
        @NlsSafe StreamEx types = StreamEx.of(globalTypes);
        if (classRef.length() > 1 && PhpIndexImpl.isClassSignature(classRef.charAt(1))) {
            types = types.append((Object)classRef.substring(2));
        }
        if (!(r = (List)((StreamEx)types.map(v -> Pair.create((Object)PhpType.removeParametrisedType(v), PhpType.getParametrizedParts(v))).filter(v -> !((List)v.getSecond()).isEmpty() && !ContainerUtil.all((Collection)((Collection)v.getSecond()), PhpGenericsBaseExtendedWithGenericTypeProvider::containsUnresolved))).flatMap(decoded -> StreamEx.of((Object)decoded).append(PhpGenericsBaseExtendedWithGenericTypeProvider.expandExtendedTemplates(index, (Pair<String, List<String>>)decoded, new HashSet<PhpClass>()))).collect(Collectors.toList())).isEmpty()) {
            StreamEx streamEx = StreamEx.of((Collection)r);
            if (streamEx == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(4);
            }
            return streamEx;
        }
        if (!PhpType.isUnresolved(classRef)) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(5);
            }
            return streamEx;
        }
        StreamEx streamEx = ((StreamEx)StreamEx.of(index.getBySignature(classRef)).append(globalTypes.stream().flatMap(fqn -> index.getAnyByFQN((String)fqn).stream()))).flatMap(e -> PhpGenericsBaseExtendedWithGenericTypeProvider.isPolymorphicMethod(e) && PhpTypeSignatureKey.METHOD.isSigned(classRef) ? PhpGenericsBaseExtendedWithGenericTypeProvider.unwrapClassReference(index, classRef) : Stream.of(e)).flatMap(e -> e instanceof PhpClass ? PhpGenericsBaseExtendedWithGenericTypeProvider.getExtendedClassesAndSubstitutedTemplates((PhpClass)e).stream() : PhpGenericsBaseExtendedWithGenericTypeProvider.decodeExtendedClassesAndSubsittutedTemplates(index, e, visited, depth));
        if (streamEx == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(6);
        }
        return streamEx;
    }

    private static boolean containsUnresolved(String type) {
        return ContainerUtil.exists(((PhpType)PhpExpressionImpl.getTypeFromSerializedClosureParameter(type).getSecond()).getTypesWithParametrisedParts(), t -> PhpType.isUnresolved(t) && !PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned((String)t) && !PhpTypeSignatureKey.CLASS.isSigned((String)t));
    }

    @Nullable
    private static String substituteTemplateTypeInPolymorphicMethod(String classRefSignature, List<String> arguments, @NotNull com.jetbrains.php.lang.psi.elements.Function function) {
        if (function == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(7);
        }
        PhpType type = function.getType();
        if (!arguments.isEmpty()) {
            Set<@NlsSafe String> types = type.getTypesWithParametrisedParts();
            return types.stream().filter(PhpGenericTypeProvider.KEY::signed).map(s -> PhpGenericsBaseExtendedWithGenericTypeProvider.resolvePolymorphicSignature(function.getProject(), types, s, classRefSignature)).map(s -> PhpGenericsBaseExtendedWithGenericTypeProvider.substituteTemplateTypeInPolymorphicMethodReturnType(function, s, arguments)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    private static String resolvePolymorphicSignature(Project project, Set<@NlsSafe String> types, String resolveSignature, String classRefSignature) {
        String shortSignature = PhpGenericsBaseExtendedWithGenericTypeProvider.getShortSignature(resolveSignature);
        if (ContainerUtil.exists(types, s -> PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned((String)s) && PhpGenericsBaseExtendedWithGenericTypeProvider.getShortSignature(s).equals(shortSignature))) {
            return PhpIndexImpl.resolveNamePolymorphicAware(project, classRefSignature, PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign(resolveSignature));
        }
        return resolveSignature;
    }

    @NotNull
    private static String getShortSignature(String signature) {
        String string = PhpType.removeParametrisedType(signature.substring(2));
        if (string == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static String substituteTemplateTypeInPolymorphicMethodReturnType(com.jetbrains.php.lang.psi.elements.Function m, String genericType, List<String> callSignaturesArguments) {
        List<String> genericArgumentSignatures;
        String genericSignature = PhpType.removeParametrisedType(genericType);
        if (PhpGenericTypeProvider.KEY.signed(genericSignature)) {
            genericSignature = genericSignature.substring(2);
        }
        if (!(genericArgumentSignatures = PhpType.getParametrizedParts(genericType)).isEmpty()) {
            List substitutedSignatures = genericArgumentSignatures.stream().map(PhpGenericsBaseExtendedWithGenericTypeProvider::convertArraySignature).map(signature -> PhpGenericsBaseExtendedWithGenericTypeProvider.mapCallArgumentToGenericTemplateInMethod(m, callSignaturesArguments, signature)).collect(Collectors.toList());
            if (!substitutedSignatures.isEmpty() && ((String)substitutedSignatures.get(0)).equals(genericSignature)) {
                return null;
            }
            return PhpType.createParametrizedType(genericSignature, ArrayUtil.toStringArray(substitutedSignatures));
        }
        return null;
    }

    private static String convertArraySignature(String signature) {
        String parts;
        if (PhpType.hasParameterizedPart(signature) && "\\array".equals(PhpType.removeParametrisedType(signature)) && (parts = (String)ContainerUtil.getLastItem(PhpType.getParametrizedParts(signature))) != null) {
            return StringUtil.split((String)parts, (String)"|").stream().map(t -> PhpType.pluralise(t, 1)).collect(Collectors.joining("|"));
        }
        return signature;
    }

    @NotNull
    private static String mapCallArgumentToGenericTemplateInMethod(com.jetbrains.php.lang.psi.elements.Function m, List<String> callSignaturesArguments, String genericSignature) {
        String string = StringUtil.split((String)genericSignature, (String)"|").stream().map(s -> PhpGenericsBaseExtendedWithGenericTypeProvider.mapCallArgumentToGenericTemplateInMethodImpl(m, callSignaturesArguments, s)).collect(Collectors.joining("|"));
        if (string == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private static String mapCallArgumentToGenericTemplateInMethodImpl(com.jetbrains.php.lang.psi.elements.Function m, List<String> callSignaturesArguments, String s) {
        Parameter[] parameters = m.getParameters();
        return IntStream.range(0, Math.min(parameters.length, callSignaturesArguments.size())).boxed().flatMap(p -> parameters[p].getDocType().getTypesWithParametrisedParts().stream().map(t -> Pair.create((Object)p, (Object)t))).map(p -> PhpGenericsBaseExtendedWithGenericTypeProvider.unwrapGenericFromCallArgument(m.getProject(), (String)callSignaturesArguments.get((Integer)p.first), (String)p.getSecond(), s)).filter(Objects::nonNull).findFirst().orElse(s);
    }

    @Nullable
    private static String unwrapGenericFromCallArgument(Project project, String callType, String paramType, String template) {
        for (String callTypeSignature : PhpParameterBasedTypeProvider.extractSignatures(callType, 0)) {
            String res = PhpGenericsBaseExtendedWithGenericTypeProvider.doUnwrapGenericFromCallArgument(project, callTypeSignature, PhpTypeSignatureKey.CLASS.signIfUnsigned(paramType), template);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Nullable
    private static String doUnwrapGenericFromCallArgument(Project project, String callType, String paramType, String template) {
        while (PhpType.isPluralType(paramType)) {
            if (PhpType.isPluralType(callType)) {
                callType = PhpType.unpluralize(callType, 1);
                paramType = PhpType.unpluralize(paramType, 1);
                continue;
            }
            return null;
        }
        if (paramType.equals(PhpGenericsBaseExtendedWithGenericTypeProvider.toPresentableTemplate(template)) || PhpGenericsBaseExtendedWithGenericTypeProvider.isTypedString(project, paramType, template)) {
            return callType;
        }
        if (PhpType.hasParameterizedPart(paramType)) {
            String callPrefix;
            String paramPrefix = PhpType.removeParametrisedType(paramType);
            if (PhpType.hasParameterizedPart(callType) && ((callPrefix = PhpType.removeParametrisedType(callType)).equals(paramPrefix) || PhpTypeSignatureKey.CLASS.signIfUnsigned(callPrefix).equals(paramPrefix))) {
                List<String> paramParts = PhpType.getParametrizedParts(paramType);
                List<String> callParts = PhpType.getParametrizedParts(callType);
                for (int i = 0; i < Math.min(paramParts.size(), callParts.size()); ++i) {
                    String unwrappedGenericPart = PhpGenericsBaseExtendedWithGenericTypeProvider.unwrapGenericFromCallArgument(project, callParts.get(i), paramParts.get(i), template);
                    if (unwrappedGenericPart == null) continue;
                    return unwrappedGenericPart;
                }
            }
        } else if (paramType.equals(PhpGenericsBaseExtendedWithGenericTypeProvider.toPresentableTemplate(PhpType.unpluralize(template)))) {
            return PhpType.pluralise(callType, 1);
        }
        return null;
    }

    private static boolean isTypedString(Project project, String paramType, String template) {
        String paramTypeTemplate = (String)ContainerUtil.getOnlyItem(PhpType.getParametrizedParts(paramType));
        if (paramTypeTemplate == null) {
            return false;
        }
        return paramTypeTemplate.equals(PhpGenericsBaseExtendedWithGenericTypeProvider.toPresentableTemplate(template)) && PhpType.global(project, paramType).equals(PhpType.STRING) || paramType.startsWith("#C\\class-string");
    }

    @NotNull
    private static String toPresentableTemplate(String template) {
        if (PhpGenericsExtendedTypeProvider.KEY.signed(template)) {
            String string = PhpGenericsExtendedTypeProvider.KEY.sign(PhpLangUtil.toPresentableFQN(template.substring(2, template.length() - 1)));
            if (string == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = PhpGenericsExtendedTypeProvider.KEY.sign(PhpLangUtil.toPresentableFQN(template));
        if (string == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static String findGenericInstantiationType(PhpType type, String className) {
        return (String)ContainerUtil.find(type.getTypesWithParametrisedParts(), t -> t.startsWith(className + "<") || className.contains("<") && t.equals(className));
    }

    @NotNull
    public static PhpType substituteTypesWithMapping(PhpType fullType, Map<String, String> mapping, int pluralizeDimensionAdjustment) {
        PhpType result = new PhpType();
        List types = ContainerUtil.map(fullType.getTypesWithParametrisedParts(), type -> {
            boolean hasParameterisedParts;
            int pluralizeDimension = 0;
            if (PhpType.isPluralType(type)) {
                pluralizeDimension = PhpType.getPluralDimension(type);
                type = PhpType.unpluralize(type);
            }
            if (hasParameterisedParts = PhpType.hasParameterizedPart(type)) {
                return PhpGenericsBaseExtendedWithGenericTypeProvider.substituteTypeWithParametrisedTypes(type, mapping, pluralizeDimension, pluralizeDimensionAdjustment);
            }
            if (!PhpGenericsExtendedTypeProvider.KEY.signed((String)type)) {
                return type;
            }
            return PhpGenericsBaseExtendedWithGenericTypeProvider.substituteSingleType(type, mapping, pluralizeDimension, pluralizeDimensionAdjustment);
        });
        for (String type2 : types) {
            result.add(type2);
        }
        PhpType phpType = result;
        if (phpType == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    private static String substituteSingleType(String type, Map<String, String> mapping, int pluralizeDimension, int pluralizeDimensionAdjustment) {
        String name = StringUtil.trimStart((String)StringUtil.trimEnd((String)type.substring(2), (String)"."), (String)"\\");
        String mapped = mapping.get(name);
        if (mapped == null) {
            return type;
        }
        if (pluralizeDimension != 0) {
            int adjustedDimension = pluralizeDimension - pluralizeDimensionAdjustment;
            if (adjustedDimension >= 0) {
                return PhpType.pluralise(mapped, pluralizeDimension - pluralizeDimensionAdjustment);
            }
            return "\\mixed";
        }
        if (pluralizeDimensionAdjustment != 0) {
            return "\\mixed";
        }
        return PhpType.pluralise(mapped, pluralizeDimension);
    }

    @NotNull
    private static String substituteTypeWithParametrisedTypes(String type, Map<String, String> mapping, int pluralizeDimension, int pluralizeDimensionAdjustment) {
        String raw = PhpType.removeParametrisedType(type);
        if (PhpGenericsExtendedTypeProvider.KEY.signed(raw) || PhpGenericTypeProvider.KEY.signed(raw)) {
            raw = PhpGenericsBaseExtendedWithGenericTypeProvider.substituteSingleType(raw, mapping, pluralizeDimension, pluralizeDimensionAdjustment);
        }
        List<String> parts = PhpType.getParametrizedParts(type);
        PhpType partsType = PhpType.from((String[])parts.toArray(String[]::new));
        PhpType resType = PhpGenericsBaseExtendedWithGenericTypeProvider.substituteTypesWithMapping(partsType, mapping, pluralizeDimensionAdjustment);
        String string = PhpType.pluralise(PhpType.createParametrizedType(raw, (String[])resType.getTypesWithParametrisedParts().toArray(String[]::new)), pluralizeDimension);
        if (string == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static Collection<String> getTemplates(PhpNamedElement function) {
        PhpClass containingClass;
        List<String> templates = PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(function.getDocComment());
        if (templates.isEmpty() && function instanceof PhpClassMember && (containingClass = ((PhpClassMember)function).getContainingClass()) != null) {
            List<String> list = PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(containingClass.getDocComment());
            if (list == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        List<String> list = templates;
        if (list == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static Stream<? extends PhpNamedElement> unwrapClassReference(PhpIndex index, String classRef) {
        return index.getBySignature(classRef.substring(2, classRef.lastIndexOf(46))).stream();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isPolymorphicMethod(PhpNamedElement e) {
        if (!(e instanceof Method)) return false;
        if (!ContainerUtil.exists(e.getDocType().getTypes(), PhpTypeSignatureKey.POLYMORPHIC_CLASS::isSigned)) return false;
        return true;
    }

    @NotNull
    private static Stream<Pair<String, List<String>>> decodeExtendedClassesAndSubsittutedTemplates(PhpIndex index, PhpNamedElement e, Collection<String> visited, int depth) {
        Stream<Pair<String, List<String>>> stream = e.getType().getTypes().stream().flatMap(s -> PhpGenericsBaseExtendedWithGenericTypeProvider.decodeExtendedClassesAndSubstitutedTemplates(index, s, visited, depth));
        if (stream == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(16);
        }
        return stream;
    }

    @NotNull
    private static StreamEx<Pair<String, List<String>>> substituteConstructorArgumentSignatures(PhpIndex index, String classFQN, List<String> argumentsSignatures) {
        StreamEx streamEx = StreamEx.of(index.getAnyByFQN(classFQN)).flatMap(c -> PhpGenericsBaseExtendedWithGenericTypeProvider.substituteConstructorArgumentSignatures(c, argumentsSignatures));
        if (streamEx == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(17);
        }
        return streamEx;
    }

    private static StreamEx<Pair<String, List<String>>> substituteConstructorArgumentSignatures(PhpClass clazz, List<String> argumentsSignatures) {
        Method constructor = clazz.getConstructor();
        if (constructor == null) {
            return StreamEx.empty();
        }
        PhpClass containingClass = constructor.getContainingClass();
        List<PhpType> types = PhpGenericsBaseExtendedWithGenericTypeProvider.getParamTagTypes(constructor);
        return PhpGenericsBaseExtendedWithGenericTypeProvider.substituteArgumentSignature(clazz, containingClass, argumentsSignatures, types, new HashSet<String>());
    }

    private static StreamEx<Pair<String, List<String>>> substituteArgumentSignature(PhpClass clazz, PhpClass containingClass, List<String> argumentsSignatures, List<PhpType> types, Collection<String> mixins) {
        if (containingClass == null) {
            return StreamEx.empty();
        }
        String fqn = clazz.getFQN();
        if (!mixins.add(fqn)) {
            return StreamEx.empty();
        }
        List<String> currentClassTemplates = PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(containingClass.getDocComment());
        Pair<String, List<String>> substitutedClassTemplates = PhpGenericsBaseExtendedWithGenericTypeProvider.substituteConstructorArgumentSignatures(argumentsSignatures, fqn, currentClassTemplates, types);
        StreamEx res = StreamEx.empty();
        if (substitutedClassTemplates != null) {
            res = res.append(substitutedClassTemplates);
        }
        PhpIndex index = PhpIndex.getInstance(clazz.getProject());
        Stream<Pair> substitutedTemplatesFromExtendedClasses = PhpGenericsBaseExtendedWithGenericTypeProvider.getExtendedClassesAndSubstitutedTemplates(clazz).stream().flatMap(c -> StreamEx.of((Object)c).append(PhpGenericsBaseExtendedWithGenericTypeProvider.expandExtendedTemplates(index, (Pair<String, List<String>>)c, new HashSet<PhpClass>()))).map(p -> PhpGenericsBaseExtendedWithGenericTypeProvider.substituteConstructorArgumentSignatures(argumentsSignatures, (String)p.getFirst(), PhpGenericsBaseExtendedWithGenericTypeProvider.updateWithTemplates(PhpGenericsBaseExtendedWithGenericTypeProvider.unsign((List)p.getSecond()), currentClassTemplates), types)).filter(Objects::nonNull);
        return (StreamEx)res.append(substitutedTemplatesFromExtendedClasses);
    }

    private static List<String> unsign(List<String> templates) {
        return ContainerUtil.map(templates, s -> PhpGenericsExtendedTypeProvider.KEY.signed((String)s) ? PhpGenericsExtendedTypeProvider.unsign(s) : s);
    }

    private static List<String> updateWithTemplates(List<String> templateCandidates, List<String> currentClassTemplates) {
        return ContainerUtil.map(templateCandidates, t -> t.startsWith("\\") && currentClassTemplates.contains(t.substring(1)) ? t.substring(1) : t);
    }

    @Nullable
    private static Pair<String, List<String>> substituteConstructorArgumentSignatures(List<String> argumentsSignatures, String fqn, List<String> templates, List<PhpType> types) {
        Map<Integer, PhpConstructorCallArgumentDescriptor> indices = PhpGenericsBaseExtendedWithGenericTypeProvider.getParametersToTemplateIndices(templates, types);
        List<String> substitutedTemplates = PhpGenericsBaseExtendedWithGenericTypeProvider.substituteTemplatesFromArguments(indices, argumentsSignatures);
        return !substitutedTemplates.isEmpty() && !ContainerUtil.all(substitutedTemplates, StringUtil::isEmpty) ? Pair.create((Object)fqn, substitutedTemplates) : null;
    }

    private static List<String> substituteTemplatesFromArguments(Map<Integer, PhpConstructorCallArgumentDescriptor> indices, List<String> signatures) {
        if (indices.isEmpty()) {
            return Collections.emptyList();
        }
        int templatesCount = indices.values().stream().map(t -> t.myTemplateIndex).max(Integer::compare).orElse(0) + 1;
        ArrayList res = IntStream.range(0, templatesCount).mapToObj(s -> "").collect(Collectors.toCollection(ArrayList::new));
        for (Integer argumentIndex : indices.keySet()) {
            PhpConstructorCallArgumentDescriptor descriptor = indices.get(argumentIndex);
            if (argumentIndex >= signatures.size()) continue;
            res.set(descriptor.myTemplateIndex, PhpGenericsBaseExtendedWithGenericTypeProvider.unpluralize(signatures.get(argumentIndex), descriptor.myPluralDimension));
        }
        return res;
    }

    private static String unpluralize(String s, int dimension) {
        PhpType argumentType = PhpType.from(s);
        for (int i = 0; i < dimension; ++i) {
            argumentType = argumentType.elementType();
        }
        return (String)ContainerUtil.getFirstItem(argumentType.getTypes(), (Object)"");
    }

    private static String completeArgumentSignature(PhpIndex index, List<String> signatures) {
        return signatures.stream().flatMap(s -> PhpGenericsBaseExtendedWithGenericTypeProvider.completeSignature(index, s).stream()).findFirst().orElse("");
    }

    @NotNull
    private static Collection<String> completeSignature(PhpIndex index, String s) {
        if (StringUtil.isEmpty((String)s)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(18);
            }
            return list;
        }
        Set<String> set = new PhpType().add(s).global(((PhpIndexImpl)index).getProject()).getTypes();
        if (set == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    private static List<PhpType> getParamTagTypes(Method constructor) {
        PhpDocComment comment = constructor.getDocComment();
        if (comment != null) {
            List list = ContainerUtil.map(PhpGenericsTemplateIndex.getParamTags(comment), PhpTypedElement::getDocType);
            if (list == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(20);
            }
            return list;
        }
        List list = ((StreamEx)((StreamEx)StreamEx.of((Object[])constructor.getParameters()).filter(p -> p.isPromotedField())).map(p -> p.getDocComment()).filter(Objects::nonNull)).map(fieldComment -> fieldComment.getParamTags()).flatMap(Collection::stream).map(PhpTypedElement::getDocType).toList();
        if (list == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static Map<Integer, PhpConstructorCallArgumentDescriptor> getParametersToTemplateIndices(List<String> templates, List<PhpType> types) {
        Map map = StreamEx.of(IntStream.range(0, types.size()).boxed()).mapToEntry(Function.identity(), i -> PhpGenericsBaseExtendedWithGenericTypeProvider.findTemplateIndexInConstructorCall(templates, (PhpType)types.get((int)i))).nonNullValues().toMap();
        if (map == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(22);
        }
        return map;
    }

    private static PhpConstructorCallArgumentDescriptor findTemplateIndexInConstructorCall(List<String> templates, PhpType paramTagType) {
        for (String t : paramTagType.getTypesWithParametrisedParts()) {
            int i = templates.indexOf(PhpGenericsBaseExtendedWithGenericTypeProvider.normalize(t));
            if (i < 0) continue;
            return new PhpConstructorCallArgumentDescriptor(i, PhpType.getPluralDimension(t));
        }
        return null;
    }

    private static Stream<Pair<String, List<String>>> expandExtendedTemplates(PhpIndex index, Pair<String, List<String>> decoded, Collection<PhpClass> visited) {
        return index.getAnyByFQN((String)decoded.first).stream().filter(visited::add).flatMap(c -> PhpGenericsBaseExtendedWithGenericTypeProvider.expandExtendedTemplates(index, c, decoded, visited));
    }

    private static Stream<Pair<String, List<String>>> expandExtendedTemplates(PhpIndex index, PhpClass phpClass, Pair<String, List<String>> decoded, Collection<PhpClass> visited) {
        return StreamEx.of(PhpGenericsBaseExtendedWithGenericTypeProvider.extendedClassesWithFallthroughTemplates(phpClass)).map(extended -> Pair.create((Object)extended, (Object)((List)decoded.second))).flatMap(d -> StreamEx.of((Object)d).append(PhpGenericsBaseExtendedWithGenericTypeProvider.expandExtendedTemplates(index, (Pair<String, List<String>>)d, visited))).distinct();
    }

    private static Stream<String> extendedClassesWithFallthroughTemplates(PhpClass c) {
        List templates = ContainerUtil.map(PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(c.getDocComment()), t -> PhpGenericsExtendedTypeProvider.KEY.sign(PhpLangUtil.toFQN(t)));
        if (templates.isEmpty()) {
            return Stream.empty();
        }
        return PhpGenericsBaseExtendedWithGenericTypeProvider.getExtendedClassesAndSubstitutedTemplates(c).stream().filter(decoded -> {
            if (templates.size() == ((List)decoded.second).size()) {
                return new HashSet(templates).containsAll((Collection)decoded.second);
            }
            return false;
        }).map(decoded -> (String)decoded.getFirst());
    }

    @NotNull
    private static Collection<String> substituteTemplateType(Map<String, Set<List<String>>> classesToExtendedTemplates, @Nullable TemplateInfo info) {
        if (info != null && classesToExtendedTemplates.containsKey(info.myContainingClassFQN)) {
            List list = ContainerUtil.mapNotNull((Collection)classesToExtendedTemplates.get(info.myContainingClassFQN), extendedTemplates -> PhpGenericsBaseExtendedWithGenericTypeProvider.substituteTemplateType(info, extendedTemplates));
            if (list == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Nullable
    protected static String substituteTemplateType(@NotNull TemplateInfo info, List<String> extendedTemplates) {
        String template;
        if (info == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(25);
        }
        if ((template = info.myTemplate) != null) {
            if (extendedTemplates.size() == 1 && info.myContainingClassFQN.equals("\\IteratorAggregate")) {
                template = StringUtil.replace((String)template, (String)"$1", (String)extendedTemplates.get(0));
            } else {
                for (int i = 0; i < extendedTemplates.size(); ++i) {
                    template = StringUtil.replace((String)template, (String)("$" + i), (String)extendedTemplates.get(i));
                }
            }
            return template;
        }
        return null;
    }

    @NotNull
    protected Collection<TemplateInfo> getSubstitutedTemplateInfo(T m, boolean global) {
        Collection collection = (Collection)ObjectUtils.notNull(this.getSubstitutedTemplateInfo(m, new HashSet(), global), Collections.emptyList());
        if (collection == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(26);
        }
        return collection;
    }

    protected abstract PhpClass getContainingClass(T var1);

    @Nullable
    protected Collection<TemplateInfo> getSubstitutedTemplateInfo(T m, Collection<T> visited, boolean global) {
        return this.doGetSubstitutedTemplateInfo(m, visited);
    }

    @Nullable
    protected List<TemplateInfo> doGetSubstitutedTemplateInfo(T m, Collection<T> visited) {
        if (!visited.add(m)) {
            return null;
        }
        PhpClass containingClass = this.getContainingClass(m);
        if (containingClass == null) {
            return null;
        }
        return this.getSubstitutedTemplateInfo(m, containingClass.getDocComment(), containingClass.getFQN());
    }

    @NotNull
    protected List<TemplateInfo> getSubstitutedTemplateInfo(T m, PhpDocComment docComment, @Nullable String containingClassFQN) {
        if (containingClassFQN == null) {
            List<TemplateInfo> list = Collections.emptyList();
            if (list == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<String> templates = PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(docComment);
        List<TemplateInfo> list = this.getDeclaredTypes(m).stream().map(t -> PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplateInfoFromType(containingClassFQN, templates, t)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Nullable
    private static TemplateInfo getTemplateInfoFromType(@NotNull @NlsSafe String classFQN, List<String> templates, String s) {
        if (classFQN == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(29);
        }
        if (s == null) {
            return null;
        }
        boolean res = false;
        for (int i = 0; i < templates.size(); ++i) {
            String oldS = s;
            s = StringUtil.replace((String)s, (String)PhpGenericsExtendedTypeProvider.KEY.sign(templates.get(i)), (String)("$" + i));
            if (oldS.equals(s = StringUtil.replace((String)s, (String)PhpGenericsExtendedTypeProvider.KEY.sign(PhpLangUtil.toFQN(templates.get(i))), (String)("$" + i)))) continue;
            res = true;
        }
        if (res) {
            return new TemplateInfo(classFQN, s);
        }
        return null;
    }

    protected abstract Collection<String> getDeclaredTypes(T var1);

    protected static List<String> getTemplates(@Nullable PhpDocComment comment) {
        if (comment == null) {
            return Collections.emptyList();
        }
        LinkedHashSet res = new LinkedHashSet();
        PhpDocUtil.processTagElementsByNames(comment, tag -> ContainerUtil.addIfNotNull((Collection)res, (Object)((PhpDocTagImpl)tag).getCustomTagValue()), PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplateNames());
        return new ArrayList<String>(res);
    }

    public static String[] getTemplateNames() {
        return (String[])StreamEx.of((Object[])new String[]{"template", "template-covariant", "template-contravariant"}).flatMap(s -> PhpGenericsBaseExtendedWithGenericTypeProvider.providers().map(e -> e.getPrefix() + s).append((Object)("@" + s))).toArray((Object[])ArrayUtil.EMPTY_STRING_ARRAY);
    }

    private static StreamEx<PhpDocPrefixProvider> providers() {
        return StreamEx.of(PhpDocPrefixProvider.EP_NAME.getExtensionList().stream());
    }

    private static String normalize(@NotNull String s) {
        List<String> parts;
        String template;
        if (s == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(30);
        }
        s = PhpType.unpluralize(PhpLangUtil.toPresentableFQN(s), PhpType.getPluralDimension(s));
        while (s.startsWith("#")) {
            if (PhpGenericsExtendedTypeProvider.KEY.signed(s)) {
                s = s.substring(2, s.length() - 1);
                continue;
            }
            s = s.substring(2);
        }
        if (s.startsWith("class-string") && PhpType.hasParameterizedPart(s) && (template = (String)ContainerUtil.find(parts = PhpType.getParametrizedParts(s), p -> PhpGenericsExtendedTypeProvider.KEY.signed((String)p))) != null) {
            s = template.substring(2);
        }
        s = PhpLangUtil.toPresentableFQN(s);
        return StringUtil.trimTrailing((String)s, (char)'.');
    }

    @NotNull
    private static Collection<Pair<String, List<String>>> getExtendedClassesAndSubstitutedTemplates(PhpClass e) {
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)e, () -> {
            ArrayList res = new ArrayList();
            PhpClassHierarchyUtils.processSuperWithoutMixins(e, true, false, (Processor<? super PhpClass>)((Processor)c -> {
                Collection<Pair<String, List<String>>> templates = PhpGenericsBaseExtendedWithGenericTypeProvider.doGetExtendedClassesAndSubstitutedTemplates(c);
                if (!templates.isEmpty()) {
                    Collection<Pair<String, List<String>>> mixinTemplates = PhpGenericsBaseExtendedWithGenericTypeProvider.doProcessStreamOfPhpDocTagToGetExtendedClasses(c, PhpGenericsBaseExtendedWithGenericTypeProvider.mixinClassesTags(c));
                    HashSet<String> mixins = new HashSet<String>();
                    for (Pair<String, List<String>> template : mixinTemplates) {
                        mixins.add((String)template.first);
                    }
                    for (Pair<String, List<String>> template : templates) {
                        for (PhpClass extendedClass : PhpIndex.getInstance(c.getProject()).getAnyByFQN((String)template.first)) {
                            List templatesTypes = ContainerUtil.map(PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(extendedClass), t -> PhpType.from(PhpGenericsExtendedTypeProvider.KEY.sign((CharSequence)t)));
                            res.addAll(PhpGenericsBaseExtendedWithGenericTypeProvider.substituteArgumentSignature(extendedClass, extendedClass, (List)template.second, templatesTypes, mixins).toList());
                        }
                        res.add(template);
                    }
                    return false;
                }
                return true;
            }));
            return CachedValueProvider.Result.create(res, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (collection == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(31);
        }
        return collection;
    }

    @NotNull
    private static Collection<Pair<String, List<String>>> doGetExtendedClassesAndSubstitutedTemplates(PhpClass e) {
        return PhpGenericsBaseExtendedWithGenericTypeProvider.doProcessStreamOfPhpDocTagToGetExtendedClasses(e, (Stream<? extends PhpDocTag>)((StreamEx)PhpGenericsBaseExtendedWithGenericTypeProvider.extendedClasses(e).append(PhpGenericsBaseExtendedWithGenericTypeProvider.usedClassesTags(e))).append(PhpGenericsBaseExtendedWithGenericTypeProvider.mixinClassesTags(e)));
    }

    @NotNull
    private static Collection<Pair<String, List<String>>> doProcessStreamOfPhpDocTagToGetExtendedClasses(PhpClass e, Stream<? extends PhpDocTag> stream) {
        List list = ((StreamEx)((StreamEx)StreamEx.of(stream).map(t -> ((PhpDocTagImpl)t).getCustomTagValue()).filter(Objects::nonNull)).append(PhpGenericsBaseExtendedWithGenericTypeProvider.encodedTemplateFromImplementedIteratorMethods(e))).map(PhpGenericsTemplatesCustomDocTagValueStubProvider::decodeExtendedClassAndTemplate).toList();
        if (list == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(32);
        }
        return list;
    }

    private static Stream<String> encodedTemplateFromImplementedIteratorMethods(PhpClass c) {
        Method getIteratorMethod = c.findOwnMethodByName("getIterator");
        if (getIteratorMethod instanceof FunctionImpl) {
            return ((FunctionImpl)((Object)getIteratorMethod)).returnTags().map(PhpGenericsTemplatesCustomDocTagValueStubProvider::encodeTemplateParts).map(PhpGenericsBaseExtendedWithGenericTypeProvider::substituteExtendingClassWithIteratorAggregate).filter(Objects::nonNull);
        }
        return Stream.empty();
    }

    private static String substituteExtendingClassWithIteratorAggregate(@Nullable String encoded) {
        if (encoded == null) {
            return null;
        }
        return "\\IteratorAggregate" + encoded.substring(encoded.indexOf(124));
    }

    @NotNull
    private static StreamEx<PhpDocTag> extendedClasses(PhpClass e) {
        PhpDocComment docComment = e.getDocComment();
        if (docComment == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(33);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of((Object[])PhpGenericsTemplatesCustomDocTagValueStubProvider.getExtendedNames()).flatMap(name -> Arrays.stream(docComment.getTagElementsByName((String)name)));
        if (streamEx == null) {
            PhpGenericsBaseExtendedWithGenericTypeProvider.$$$reportNull$$$0(34);
        }
        return streamEx;
    }

    protected static Stream<? extends PhpDocTag> usedClassesTags(PhpClass e) {
        return PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)e, PhpUseList.class).stream().map(PhpPsiUtil::getDocCommentFor).flatMap(PhpGenericsBaseExtendedWithGenericTypeProvider::usedClassesTags);
    }

    protected static Stream<? extends PhpDocTag> mixinClassesTags(PhpClass e) {
        PhpDocComment docComment = e.getDocComment();
        if (docComment == null) {
            return StreamEx.empty();
        }
        return StreamEx.of((Object[])PhpGenericsTemplatesCustomDocTagValueStubProvider.getMixinNames()).flatMap(name -> Arrays.stream(docComment.getTagElementsByName((String)name)));
    }

    protected static Stream<? extends PhpDocTag> usedClassesTags(@Nullable PhpDocComment comment) {
        if (comment == null) {
            return Stream.empty();
        }
        return Arrays.stream(PhpGenericsTemplatesCustomDocTagValueStubProvider.getUsedNames()).flatMap(name -> Arrays.stream(comment.getTagElementsByName((String)name)));
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        if (PhpType.hasParameterizedPart(expression)) {
            return this.getBySignature(PhpType.removeParametrisedType(expression), visited, depth, project);
        }
        return null;
    }

    @Override
    public boolean interceptsNativeSignature() {
        return true;
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 25, 29, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/generics/PhpGenericsBaseExtendedWithGenericTypeProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQN";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeExtendedClassesAndSubstitutedTemplates";
                break;
            }
            case 7: 
            case 25: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/generics/PhpGenericsBaseExtendedWithGenericTypeProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mapCallArgumentToGenericTemplateInMethod";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTypesWithMapping";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTypeWithParametrisedTypes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeExtendedClassesAndSubsittutedTemplates";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteConstructorArgumentSignatures";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "completeSignature";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTagTypes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersToTemplateIndices";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTemplateType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutedTemplateInfo";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedClassesAndSubstitutedTemplates";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "doProcessStreamOfPhpDocTagToGetExtendedClasses";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "extendedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substituteTemplateTypeInPolymorphicMethod";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "substituteTemplateType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateInfoFromType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 25, 29, 30 -> new IllegalArgumentException(string);
        };
    }

    private static class PhpConstructorCallArgumentDescriptor {
        private final int myTemplateIndex;
        private final int myPluralDimension;

        private PhpConstructorCallArgumentDescriptor(int index, int dimension) {
            this.myTemplateIndex = index;
            this.myPluralDimension = dimension;
        }
    }

    protected static class TemplateInfo {
        private final String myContainingClassFQN;
        private final String myTemplate;

        private TemplateInfo(String fqn, String template) {
            this.myContainingClassFQN = fqn;
            this.myTemplate = template;
        }
    }
}

