/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.generics;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocPrefixProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaTypeMappingsTable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGenericsTemplateIndex
extends FileBasedIndexExtension<String, PhpMetaTypeMappingsTable> {
    @NonNls
    public static final ID<String, PhpMetaTypeMappingsTable> KEY = ID.create((String)"php.generic.template.index");

    @NotNull
    public ID<String, PhpMetaTypeMappingsTable> getName() {
        ID<String, PhpMetaTypeMappingsTable> iD = KEY;
        if (iD == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, PhpMetaTypeMappingsTable, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
            if (file == null) {
                return Collections.emptyMap();
            }
            return file.getTopLevelDefs().values().stream().flatMap(PhpFuncGetArgUsageProvider::getFunctions).map(PhpGenericsTemplateIndex::getMap).reduce(new HashMap(), ContainerUtil::union);
        };
        if (dataIndexer == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    private static Map<String, PhpMetaTypeMappingsTable> getMap(com.jetbrains.php.lang.psi.elements.Function f) {
        if (PhpGenericsTemplateIndex.returnedTemplates(f).findFirst().isEmpty()) {
            return Collections.emptyMap();
        }
        boolean isIntersection = PhpGenericsTemplateIndex.returnedTemplates(f).anyMatch(s -> PhpPsiUtil.isOfType(s.getPrevSibling(), PhpDocTokenTypes.DOC_AMPERSAND));
        PhpMetaTypeMappingsTable table = new PhpMetaTypeMappingsTable();
        PhpGenericsTemplateIndex.parameterIndicesWithDocTypeBySupplier(f, Function.identity()).forEach(i -> table.put(PhpGenericsTemplateIndex.getKey("\u03c0\u2020", isIntersection), String.valueOf(i)));
        PhpGenericsTemplateIndex.parameterIndicesWithDocTypeBySupplier(f, PhpGenericsTemplateIndex::createTemplateText).forEach(i -> table.put(PhpGenericsTemplateIndex.getKey("\u03c0", isIntersection), "$" + i));
        PhpGenericsTemplateIndex.parameterIndicesWithDocTypeByPsiSupplier(f, PhpGenericsTemplateIndex::createArrayDocTypePredicate).forEach(i -> table.put("\u03c0e\u2020", String.valueOf(i)));
        PhpGenericsTemplateIndex.parameterIndicesWithDocTypeMatchesByText(f, PhpGenericsTemplateIndex::unwrapList).forEach(i -> table.put("\u2020e", String.valueOf(i)));
        PhpGenericsTemplateIndex.parameterIndicesWithDocTypeMatchesByText(f, s2 -> PhpGenericsTemplateIndex.createTemplateText(PhpGenericsTemplateIndex.unwrapList(s2))).forEach(i -> table.put("\u2020e", String.valueOf(i)));
        List<PhpDocParamTag> paramTags = PhpGenericsTemplateIndex.getParamTags(f.getDocComment());
        List<Parameter> parameters = Arrays.asList(f.getParameters());
        PhpGenericsTemplateIndex.returnedTemplates(f).map(PsiElement::getText).flatMap(returnedTemplate -> PhpGenericsTemplateIndex.genericTypeDescriptors(paramTags, returnedTemplate, parameters)).forEach(s -> table.put("~", (String)s));
        IntStream.concat(PhpGenericsTemplateIndex.parameterIndicesWithDocTypeBySupplier(f, PhpGenericsTemplateIndex::unwrapGenerator), PhpGenericsTemplateIndex.parameterIndicesWithDocTypeBySupplier(f, s -> PhpGenericsTemplateIndex.createTemplateText(PhpGenericsTemplateIndex.unwrapGenerator(s)))).distinct().forEach(i -> table.put("\u03c9", String.valueOf(i)));
        if (table.getKeys().isEmpty()) {
            return Collections.emptyMap();
        }
        return Map.of(PhpTypeSignatureKey.getSignature(f), table);
    }

    @NotNull
    private static String getKey(String key, boolean isIntersection) {
        Object object = isIntersection ? "&" + key : key;
        if (object == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(2);
        }
        return object;
    }

    private static Predicate<PhpDocType> createArrayDocTypePredicate(PhpDocType t) {
        String text = t.getText();
        return type -> text.equals(PhpGenericsTemplateIndex.unwrapList(type));
    }

    @Nullable
    public static String unwrapList(PhpDocType s) {
        PhpDocType docType;
        if (PhpPsiUtil.isOfType(s.getLastChild(), PhpDocTokenTypes.DOC_RBRACKET)) {
            return PhpType.unpluralize(s.getText());
        }
        if (PhpWorkaroundUtil.isGenericArray(s) && (docType = (PhpDocType)PhpWorkaroundUtil.valueDocTypes((PsiElement)s).first()) != null) {
            return docType.getText();
        }
        return null;
    }

    @Nullable
    private static String unwrapGenerator(String s) {
        String importedName = PhpLangUtil.toPresentableFQN(s);
        String argument = StringUtil.trimEnd((String)StringUtil.trimStart((String)importedName, (String)"Generator<"), (String)">");
        return argument.equals(importedName) ? null : argument;
    }

    @NotNull
    private static Stream<String> genericTypeDescriptors(List<PhpDocParamTag> paramTags, String returnedTemplate, List<Parameter> parameters) {
        Stream<String> stream = paramTags.stream().map(paramTag -> PhpGenericsTemplateIndex.getGenericTypeDescriptor(paramTag, returnedTemplate, parameters)).filter(Objects::nonNull);
        if (stream == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(3);
        }
        return stream;
    }

    private static String getGenericTypeDescriptor(PhpDocParamTag tag, String returnedTemplate, List<Parameter> parameters) {
        List<String> parts = PhpGenericsTemplatesCustomDocTagValueStubProvider.templatesParts(tag).toList();
        if (parts.size() < 2) {
            return null;
        }
        String paramIndex = PhpGenericsTemplateIndex.getParameterIndex(tag, parameters).findFirst().orElse(null);
        if (paramIndex == null) {
            return null;
        }
        int indexOfReturnedTemplate = Math.max(parts.indexOf(PhpGenericsExtendedTypeProvider.KEY.sign(PhpLangUtil.toFQN(returnedTemplate))), parts.indexOf(PhpLangUtil.toFQN(returnedTemplate)));
        if (indexOfReturnedTemplate < 1) {
            return null;
        }
        return StringUtil.join(Arrays.asList(paramIndex, indexOfReturnedTemplate - 1, (Serializable)((Object)parts.get(0))), (String)".");
    }

    private static Stream<String> getParameterIndex(PhpDocParamTag param, List<Parameter> parameters) {
        String name = param.getVarName();
        int i = ContainerUtil.indexOf(parameters, p -> PhpLangUtil.equalsParameterNames(name, p.getName()));
        if (i < 0) {
            return Stream.empty();
        }
        return Stream.of(String.valueOf(i));
    }

    @NotNull
    private static String createTemplateText(String f) {
        String string = "class-string<" + f + ">";
        if (string == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static IntStream parameterIndicesWithDocTypeByPsiSupplier(com.jetbrains.php.lang.psi.elements.Function f, Function<PhpDocType, @Nullable Predicate<PhpDocType>> docTypeBasedOnReturnTemplateSupplier) {
        PhpDocComment comment = f.getDocComment();
        List<PhpDocParamTag> paramTags = PhpGenericsTemplateIndex.getParamTags(comment);
        List<Parameter> parameters = Arrays.asList(f.getParameters());
        return PhpGenericsTemplateIndex.returnedTemplates(f).flatMap(returnTemplate -> PhpGenericsTemplateIndex.paramNamesWithReturnDocTypeByPredicate(paramTags, (Predicate)docTypeBasedOnReturnTemplateSupplier.apply((PhpDocType)returnTemplate))).distinct().mapToInt(name -> ContainerUtil.indexOf((List)parameters, p -> PhpLangUtil.equalsParameterNames(name, p.getName()))).filter(i -> i >= 0);
    }

    private static IntStream parameterIndicesWithDocTypeMatchesByText(com.jetbrains.php.lang.psi.elements.Function f, Function<PhpDocType, @Nullable String> docTypeBasedOnReturnTemplateSupplier) {
        return PhpGenericsTemplateIndex.parameterIndicesWithDocTypeByPsiSupplier(f, docType -> PhpGenericsTemplateIndex.createTextPredicate(docTypeBasedOnReturnTemplateSupplier, docType));
    }

    private static Predicate<PhpDocType> createTextPredicate(Function<PhpDocType, @Nullable String> docTypeBasedOnReturnTemplateSupplier, PhpDocType type) {
        String text = docTypeBasedOnReturnTemplateSupplier.apply(type);
        return text != null ? t -> text.equals(t.getText()) : null;
    }

    @NotNull
    private static Stream<String> paramNamesWithReturnDocTypeByPredicate(List<PhpDocParamTag> paramTags, @Nullable Predicate<PhpDocType> predicate) {
        if (predicate == null) {
            Stream<String> stream = Stream.empty();
            if (stream == null) {
                PhpGenericsTemplateIndex.$$$reportNull$$$0(5);
            }
            return stream;
        }
        Stream<String> stream = paramTags.stream().filter(tag -> !PhpGenericsTemplateIndex.getDocTypesWithText(tag, predicate).isEmpty()).map(PhpDocParamTag::getVarName).filter(Objects::nonNull);
        if (stream == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(6);
        }
        return stream;
    }

    private static IntStream parameterIndicesWithDocTypeBySupplier(com.jetbrains.php.lang.psi.elements.Function f, Function<String, @Nullable String> docTypeBasedOnReturnTemplateSupplier) {
        return PhpGenericsTemplateIndex.parameterIndicesWithDocTypeMatchesByText(f, s -> (String)docTypeBasedOnReturnTemplateSupplier.apply(s.getText()));
    }

    private static Stream<PhpDocType> returnedTemplates(com.jetbrains.php.lang.psi.elements.Function f) {
        PhpDocComment comment = f.getDocComment();
        if (comment == null) {
            return Stream.empty();
        }
        List<String> templates = PhpGenericsTemplatesCustomDocTagValueStubProvider.getTemplates(comment);
        if (templates.isEmpty()) {
            return Stream.empty();
        }
        Collection<PhpDocTag> returnTags = PhpGenericsTemplateIndex.getReturnTags(comment);
        return StreamEx.of(returnTags).flatMap(returnTag -> PhpGenericsTemplateIndex.getDocTypesWithText(returnTag, t -> PhpGenericsTemplateIndex.hasTemplate(t, templates)).stream()).distinct(PsiElement::getText);
    }

    public static boolean hasTemplate(PhpDocType t, Collection<String> templates) {
        Collection<PhpDocType> docTypes = PhpPsiUtil.findChildrenNonStrict((PsiElement)t, PhpDocType.class);
        return ContainerUtil.exists(docTypes, tt -> {
            boolean isArray = tt.getType().types().anyMatch(ttt -> PhpType.isPluralType(ttt));
            if (isArray) {
                return templates.contains(tt.getText().replace("[]", ""));
            }
            return templates.contains(tt.getText());
        });
    }

    public static Collection<PhpDocTag> getReturnTags(PhpDocComment comment) {
        ArrayList<PhpDocTag> res = new ArrayList<PhpDocTag>();
        String[] tagNames = (String[])StreamEx.of((Collection)PhpDocPrefixProvider.EP_NAME.getExtensionList()).map(p -> p.getPrefix() + "return").prepend((Object)"@return").toArray(String.class);
        PhpDocUtil.processTagElementsByNames(comment, res::add, tagNames);
        return res;
    }

    @NotNull
    public static List<PhpDocParamTag> getParamTags(@Nullable PhpDocComment comment) {
        if (comment == null) {
            List<PhpDocParamTag> list = Collections.emptyList();
            if (list == null) {
                PhpGenericsTemplateIndex.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList<PhpDocParamTag> res = new ArrayList<PhpDocParamTag>();
        String[] tagNames = (String[])StreamEx.of((Collection)PhpDocPrefixProvider.EP_NAME.getExtensionList()).map(p -> p.getPrefix() + "param").prepend((Object[])new String[]{"@param", "@var"}).toArray(String.class);
        PhpDocUtil.processTagElementsByNames(comment, tag -> res.add((PhpDocParamTag)tag), tagNames);
        ArrayList<PhpDocParamTag> arrayList = res;
        if (arrayList == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static Collection<PhpDocType> getDocTypesWithText(@Nullable PhpDocTag tag, Predicate<PhpDocType> predicate) {
        if (tag == null) {
            return Collections.emptyList();
        }
        ArrayList<PhpDocType> res = new ArrayList<PhpDocType>();
        for (PhpPsiElement child = tag.getFirstPsiChild(); child != null; child = child.getNextPsiSibling()) {
            if (!(child instanceof PhpDocType)) continue;
            PhpDocTypeImpl.visitPhpDocTypeConditionalTypesAware((PhpDocType)child, docType -> {
                if (predicate.test((PhpDocType)docType)) {
                    res.add((PhpDocType)docType);
                }
            });
        }
        return res;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(9);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<PhpMetaTypeMappingsTable> getValueExternalizer() {
        DataExternalizer<PhpMetaTypeMappingsTable> dataExternalizer = PhpMetaTypeMappingsTable.EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(10);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 6;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpGenericsTemplateIndex.$$$reportNull$$$0(11);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/resolve/types/generics/PhpGenericsTemplateIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "genericTypeDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplateText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "paramNamesWithReturnDocTypeByPredicate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTags";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

