/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.prophecy;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.prophecy.ProphecyProphesizeTypeProvider;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProphecyProphesizedMethodCallTypeProvider
implements PhpTypeProvider4 {
    @NotNull
    private static final PhpType METHOD_PROPHECY = PhpType.from("\\Prophecy\\Prophecy\\MethodProphecy");
    private static final String PROPHECY_PREFIX = "#M#" + ProphecyProphesizeTypeProvider.KEY.getKey();

    @Override
    public char getKey() {
        return PhpTypeSignatureKey.METHOD.getKey();
    }

    @Override
    @Nullable
    public PhpType getType(PsiElement element) {
        return null;
    }

    @Override
    @Nullable
    public PhpType complete(String expression, Project project) {
        if (expression.startsWith(PROPHECY_PREFIX)) {
            int lastDot = expression.lastIndexOf(46);
            String prophesizedClassFQN = (String)ContainerUtil.getLastItem(PhpParameterBasedTypeProvider.extractSignatures(expression.substring(PROPHECY_PREFIX.length(), lastDot), 0));
            String name = prophesizedClassFQN + "." + expression.substring(lastDot + 1);
            String prophesizedMethodSignature = PhpTypeSignatureKey.METHOD.sign(PhpTypeSignatureKey.CLASS.sign(name));
            if (prophesizedClassFQN != null && !PhpIndex.getInstance(project).getBySignature(prophesizedMethodSignature).isEmpty()) {
                return METHOD_PROPHECY;
            }
        }
        return null;
    }

    @Override
    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    @Override
    public boolean interceptsNativeSignature() {
        return true;
    }
}

