/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.impl.PhpFilePathUtils;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStub;
import com.jetbrains.php.lang.psi.stubs.PhpConstantStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCaseSensitiveConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PhpConstantElementTypeBase
extends PhpStubElementType<PhpConstantStub, Constant> {
    public PhpConstantElementTypeBase(@NotNull String debugName) {
        if (debugName == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    @NotNull
    public PhpConstantStub createStub(@NotNull Constant psi, StubElement parentStub) {
        if (psi == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(1);
        }
        if (Registry.is((String)"php.use.type.gist")) {
            return new PhpConstantStubImpl(parentStub, this, StringRef.fromString((String)psi.getName()), StringRef.fromString((String)psi.getNamespaceName()), StringRef.fromString((String)psi.getValuePresentation()), null, StringRef.fromString((String)PhpNamedElementImpl.getDeprecatedSinceVersion(psi)), PhpConstantStubImpl.packFlags(psi), PhpFilePathUtils.evaluateLocally((PsiElement)psi));
        }
        return new PhpConstantStubImpl(parentStub, this, StringRef.fromString((String)psi.getName()), StringRef.fromString((String)psi.getNamespaceName()), StringRef.fromString((String)psi.getValuePresentation()), PhpTypeInfo.getType((PsiElement)psi), StringRef.fromString((String)PhpNamedElementImpl.getDeprecatedSinceVersion(psi)), PhpConstantStubImpl.packFlags(psi), PhpFilePathUtils.evaluateLocally((PsiElement)psi));
    }

    public void serialize(@NotNull PhpConstantStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(2);
        }
        if (dataStream == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(3);
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getNamespaceName());
        dataStream.writeName(stub.getValuePresentation());
        if (!Registry.is((String)"php.use.type.gist")) {
            PhpConstantElementTypeBase.writePhpType(dataStream, stub.getType());
        }
        dataStream.writeShort((int)stub.getFlags());
        dataStream.writeName(stub.getDeprecatedSinceVersion());
        List<List<PhpFilePathUtils.PhpFilePathDescriptor>> filePaths = ((PhpConstantStubImpl)stub).getFilePaths();
        PhpConstantElementTypeBase.writeFilePaths(dataStream, filePaths);
    }

    public static void writeFilePaths(@NotNull StubOutputStream dataStream, List<List<PhpFilePathUtils.PhpFilePathDescriptor>> paths) throws IOException {
        if (dataStream == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(4);
        }
        dataStream.writeInt(paths.size());
        for (List<PhpFilePathUtils.PhpFilePathDescriptor> path : paths) {
            dataStream.writeInt(path.size());
            for (PhpFilePathUtils.PhpFilePathDescriptor p : path) {
                PhpConstantElementTypeBase.writeFilePathDescriptor(dataStream, p);
            }
        }
    }

    @NotNull
    public static List<List<PhpFilePathUtils.PhpFilePathDescriptor>> readFilePaths(@NotNull StubInputStream dataStream) throws IOException {
        int size;
        if (dataStream == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(5);
        }
        if ((size = dataStream.readInt()) == 0) {
            List<List<PhpFilePathUtils.PhpFilePathDescriptor>> list = Collections.emptyList();
            if (list == null) {
                PhpConstantElementTypeBase.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<List<PhpFilePathUtils.PhpFilePathDescriptor>> res = new ArrayList<List<PhpFilePathUtils.PhpFilePathDescriptor>>();
        for (int i = 0; i < size; ++i) {
            int s = dataStream.readInt();
            ArrayList<PhpFilePathUtils.PhpFilePathDescriptor> r = new ArrayList<PhpFilePathUtils.PhpFilePathDescriptor>();
            for (int j = 0; j < s; ++j) {
                r.add(PhpConstantElementTypeBase.readFilePathDescriptor(dataStream));
            }
            res.add(r);
        }
        ArrayList<List<PhpFilePathUtils.PhpFilePathDescriptor>> arrayList = res;
        if (arrayList == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void writeFilePathDescriptor(@NotNull StubOutputStream dataStream, PhpFilePathUtils.PhpFilePathDescriptor p) throws IOException {
        if (dataStream == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(8);
        }
        if (p instanceof PhpFilePathUtils.PhpStringFilePathDescriptor) {
            dataStream.writeInt(0);
            dataStream.writeUTF(((PhpFilePathUtils.PhpStringFilePathDescriptor)p).getString());
        } else if (p instanceof PhpFilePathUtils.PhpSignatureFilePathDescriptor) {
            dataStream.writeInt(1);
            dataStream.writeUTF(((PhpFilePathUtils.PhpSignatureFilePathDescriptor)p).getSignature());
        } else if (p instanceof PhpFilePathUtils.PhpDirUpFilePathDescriptor) {
            dataStream.writeInt(2);
            dataStream.writeInt(((PhpFilePathUtils.PhpDirUpFilePathDescriptor)p).getLevel());
            List<PhpFilePathUtils.PhpFilePathDescriptor> descriptors = ((PhpFilePathUtils.PhpDirUpFilePathDescriptor)p).getDescriptors();
            dataStream.writeInt(descriptors.size());
            for (PhpFilePathUtils.PhpFilePathDescriptor descriptor : descriptors) {
                PhpConstantElementTypeBase.writeFilePathDescriptor(dataStream, descriptor);
            }
        } else if (p instanceof PhpFilePathUtils.PhpProjectRelativeStringFilePathDescriptor) {
            PhpFilePathUtils.PhpProjectRelativeStringFilePathDescriptor descriptor = (PhpFilePathUtils.PhpProjectRelativeStringFilePathDescriptor)p;
            dataStream.writeInt(3);
            dataStream.writeUTF(descriptor.getRelativePath());
        } else {
            throw new IllegalStateException();
        }
    }

    @NotNull
    private static PhpFilePathUtils.PhpFilePathDescriptor readFilePathDescriptor(@NotNull StubInputStream dataStream) throws IOException {
        int i;
        if (dataStream == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(9);
        }
        if ((i = dataStream.readInt()) == 0) {
            String string = dataStream.readUTF();
            return new PhpFilePathUtils.PhpStringFilePathDescriptor(string);
        }
        if (i == 1) {
            String string = dataStream.readUTF();
            return new PhpFilePathUtils.PhpSignatureFilePathDescriptor(string);
        }
        if (i == 2) {
            int level = dataStream.readInt();
            int descriptorSize = dataStream.readInt();
            ArrayList<PhpFilePathUtils.PhpFilePathDescriptor> descriptors = new ArrayList<PhpFilePathUtils.PhpFilePathDescriptor>();
            for (int j = 0; j < descriptorSize; ++j) {
                descriptors.add(PhpConstantElementTypeBase.readFilePathDescriptor(dataStream));
            }
            return new PhpFilePathUtils.PhpDirUpFilePathDescriptor(descriptors, level);
        }
        if (i == 3) {
            String relativeValue = dataStream.readUTF();
            return new PhpFilePathUtils.PhpProjectRelativeStringFilePathDescriptor(relativeValue);
        }
        throw new IllegalStateException();
    }

    @NotNull
    public PhpConstantStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(10);
        }
        PhpType type = null;
        StringRef name = dataStream.readName();
        StringRef namespace = dataStream.readName();
        assert (namespace != null);
        StringRef valuePresentation = dataStream.readName();
        if (!Registry.is((String)"php.use.type.gist")) {
            type = PhpConstantElementTypeBase.readPhpType(dataStream);
        }
        short flags = dataStream.readShort();
        StringRef deprecatedSinceRef = dataStream.readName();
        List<List<PhpFilePathUtils.PhpFilePathDescriptor>> res = PhpConstantElementTypeBase.readFilePaths(dataStream);
        return new PhpConstantStubImpl(parentStub, this, name, namespace, valuePresentation, type, deprecatedSinceRef, flags, res);
    }

    @Override
    public void indexStub(@NotNull PhpConstantStub stub, @NotNull IndexSink sink) {
        String shortName;
        if (stub == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(11);
        }
        if (sink == null) {
            PhpConstantElementTypeBase.$$$reportNull$$$0(12);
        }
        if ((shortName = stub.getName()) != null) {
            if (stub.isCaseSensitive()) {
                sink.occurrence(PhpCaseSensitiveConstantIndex.KEY, (Object)shortName);
            } else {
                sink.occurrence(PhpConstantIndex.KEY, (Object)StringUtil.toLowerCase((String)shortName));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/PhpConstantElementTypeBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/PhpConstantElementTypeBase";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readFilePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeFilePaths";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readFilePaths";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeFilePathDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readFilePathDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

