/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpFilePathUtils;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpConstantElementTypeBase;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStubBase;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStub;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStubImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableElementType
extends PhpStubElementType<PhpVariableStub, Variable> {
    public PhpVariableElementType(@NotNull String debugName) {
        if (debugName == null) {
            PhpVariableElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
    }

    public Variable createPsi(@NotNull PhpVariableStub stub) {
        if (stub == null) {
            PhpVariableElementType.$$$reportNull$$$0(1);
        }
        return new VariableImpl(stub);
    }

    @NotNull
    public PhpVariableStub createStub(@NotNull Variable psi, StubElement parentStub) {
        if (psi == null) {
            PhpVariableElementType.$$$reportNull$$$0(2);
        }
        PhpType type = PhpVariableElementType.inferredAssignedTypeToGlobalVariable(psi);
        String name = psi.getName();
        PhpType expressionType = PhpVariableElementType.isFirstWrite(psi) ? psi.getType() : PhpVariableElementType.inferredAssignedTypeToGlobalVariable((Variable)ObjectUtils.tryCast((Object)PhpVariableElementType.resolveFirstWrite(psi), Variable.class));
        return new PhpVariableStubImpl(parentStub, this, StringRef.fromString((String)name), expressionType, type, PhpNamedStubBase.packDocCommentPresence(psi), PhpVariableElementType.collectFilePathsFromLastWriters(psi));
    }

    @NotNull
    public static PhpType inferredAssignedTypeToGlobalVariable(@Nullable Variable variable) {
        PhpVariableStub stub;
        if (variable == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpVariableElementType.$$$reportNull$$$0(3);
            }
            return phpType;
        }
        if (variable instanceof VariableImpl && (stub = (PhpVariableStub)((VariableImpl)variable).getGreenStub()) instanceof PhpVariableStubImpl) {
            PhpType phpType = ((PhpVariableStubImpl)stub).getInferredAssignedType();
            if (phpType == null) {
                PhpVariableElementType.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        PhpType phpType = (PhpType)CachedValuesManager.getCachedValue((PsiElement)variable, () -> CachedValueProvider.Result.create((Object)PhpVariableElementType.doInferredAssignedTypeToGlobalVariable(variable), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (phpType == null) {
            PhpVariableElementType.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    @NotNull
    private static List<List<PhpFilePathUtils.PhpFilePathDescriptor>> collectFilePathsFromLastWriters(final Variable variable) {
        if (!PhpVariableElementType.isFirstWrite(variable)) {
            List<List<PhpFilePathUtils.PhpFilePathDescriptor>> list = Collections.emptyList();
            if (list == null) {
                PhpVariableElementType.$$$reportNull$$$0(6);
            }
            return list;
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        if (scopeHolder == null) {
            List<List<PhpFilePathUtils.PhpFilePathDescriptor>> list = Collections.emptyList();
            if (list == null) {
                PhpVariableElementType.$$$reportNull$$$0(7);
            }
            return list;
        }
        final ArrayList<List<PhpFilePathUtils.PhpFilePathDescriptor>> res = new ArrayList<List<PhpFilePathUtils.PhpFilePathDescriptor>>();
        PhpControlFlowUtil.processPredecessors(scopeHolder.getControlFlow().getExitPoint(), false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName()) && instruction.getAccess().isWrite()) {
                    res.addAll(PhpFilePathUtils.evaluateLocally((PsiElement)instruction.getAnchor()));
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        ArrayList<List<PhpFilePathUtils.PhpFilePathDescriptor>> arrayList = res;
        if (arrayList == null) {
            PhpVariableElementType.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static PhpType doInferredAssignedTypeToGlobalVariable(Variable variable) {
        if (!PhpVariableElementType.isFirstWrite(variable.getNode())) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpVariableElementType.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        PhpType docType = variable.getDocType();
        if (!docType.isEmpty()) {
            PhpType phpType = docType;
            if (phpType == null) {
                PhpVariableElementType.$$$reportNull$$$0(10);
            }
            return phpType;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        if (scopeHolder != null && instruction != null) {
            PhpExitPointInstruction exitPoint = scopeHolder.getControlFlow().getExitPoint();
            PhpVariableInferredTypeAnalyzerProcessor processor = new PhpVariableInferredTypeAnalyzerProcessor(variable, variable.getName(), scopeHolder, exitPoint){

                @Override
                public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                    return this.doProcessArrayAccess(instruction);
                }
            };
            PhpVariableInferredTypeAnalyzerProcessor.inferType(processor, variable, variable.getName(), scopeHolder, exitPoint);
            PhpType inferredType = processor.getType();
            PhpType typeWithoutVariableSignature = inferredType.filterOut(t -> PhpTypeSignatureKey.VARIABLE.isSigned((String)t) && PhpLangUtil.equalsVariableNames(t.substring(2), variable.getName()));
            boolean originalDeclarationReached = typeWithoutVariableSignature.size() != inferredType.size() || inferredType.isEmpty();
            PhpType phpType = originalDeclarationReached ? new PhpType().add(typeWithoutVariableSignature).add(variable.getType()) : typeWithoutVariableSignature;
            if (phpType == null) {
                PhpVariableElementType.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        PhpType phpType = variable.getType();
        if (phpType == null) {
            PhpVariableElementType.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    public void serialize(@NotNull PhpVariableStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            PhpVariableElementType.$$$reportNull$$$0(13);
        }
        if (dataStream == null) {
            PhpVariableElementType.$$$reportNull$$$0(14);
        }
        dataStream.writeName(stub.getName());
        PhpVariableElementType.writePhpType(dataStream, stub.getType());
        dataStream.writeShort((int)stub.getFlags());
        PhpVariableElementType.writePhpType(dataStream, ((PhpVariableStubImpl)stub).getInferredAssignedType());
        PhpConstantElementTypeBase.writeFilePaths(dataStream, ((PhpVariableStubImpl)stub).getFilePaths());
    }

    @NotNull
    public PhpVariableStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            PhpVariableElementType.$$$reportNull$$$0(15);
        }
        StringRef name = dataStream.readName();
        PhpType type = PhpVariableElementType.readPhpType(dataStream);
        short flags = dataStream.readShort();
        PhpType inferredAssignedType = PhpVariableElementType.readPhpType(dataStream);
        List<List<PhpFilePathUtils.PhpFilePathDescriptor>> filePaths = PhpConstantElementTypeBase.readFilePaths(dataStream);
        return new PhpVariableStubImpl(parentStub, this, name, type, inferredAssignedType, flags, filePaths);
    }

    public boolean shouldCreateStub(ASTNode node) {
        return PhpVariableElementType.isApplicableForStub(node);
    }

    private static boolean isFirstWrite(ASTNode node) {
        return PhpVariableElementType.isFirstWrite((PhpPsiElement)node.getPsi());
    }

    private static boolean isFirstWrite(PhpPsiElement variable) {
        return variable == PhpVariableElementType.resolveFirstWrite(variable);
    }

    private static PhpNamedElement resolveFirstWrite(PhpPsiElement variable) {
        return (PhpNamedElement)ContainerUtil.getFirstItem(VariableImpl.collectDeclarations((PsiElement)variable, false, variable.getName()));
    }

    public static boolean isApplicableForStub(ASTNode node) {
        if (node.getElementType() != PhpStubElementTypes.VARIABLE) {
            return false;
        }
        for (ASTNode parent = node.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            IElementType type = parent.getElementType();
            if (type == PhpElementTypes.WHILE || type == PhpElementTypes.DO_WHILE || type == PhpElementTypes.FOR || type == PhpElementTypes.FOREACH || type == PhpElementTypes.IF || type == PhpElementTypes.CONCATENATION_EXPRESSION || type == PhpElementTypes.METHOD_REFERENCE || type == PhpElementTypes.FIELD_REFERENCE || type == PhpElementTypes.PARAMETER_LIST) {
                return false;
            }
            if (type != PhpStubElementTypes.CLASS_METHOD && type != PhpStubElementTypes.FUNCTION) continue;
            return false;
        }
        PsiElement element = node.getPsi();
        return ((Variable)element).isDeclaration();
    }

    @Override
    public void indexStub(@NotNull PhpVariableStub stub, @NotNull IndexSink sink) {
        String shortName;
        if (stub == null) {
            PhpVariableElementType.$$$reportNull$$$0(16);
        }
        if (sink == null) {
            PhpVariableElementType.$$$reportNull$$$0(17);
        }
        if ((shortName = stub.getName()) != null) {
            sink.occurrence(PhpVariableIndex.KEY, (Object)shortName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/PhpVariableElementType";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/PhpVariableElementType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "inferredAssignedTypeToGlobalVariable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilePathsFromLastWriters";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doInferredAssignedTypeToGlobalVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

