/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCustomFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionsWithNotCatchedDynamicPassedCallsIndex;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpChooserFunctionsIndex
extends PhpCustomFunctionIndex<IntSet> {
    private static final IntSet EMPTY_SET = new IntOpenHashSet();

    @Override
    @Nullable
    protected IntSet getDataFromAST(@NotNull Function function) {
        List<Parameter> parameters;
        if (function == null) {
            PhpChooserFunctionsIndex.$$$reportNull$$$0(0);
        }
        if ((parameters = Arrays.asList(function.getParameters())).isEmpty()) {
            return null;
        }
        List predecessors = ContainerUtil.filter(function.getControlFlow().getExitPoint().getPredecessors(), p -> !(p instanceof PhpThrowInstruction));
        IntOpenHashSet res = new IntOpenHashSet();
        for (PhpInstruction predecessor : predecessors) {
            boolean unambiguousReturn;
            if (predecessor instanceof PhpReturnInstruction && (unambiguousReturn = PhpPreviousDfaAnalyzerProcessor.processWrappedValues(((PhpReturnInstruction)predecessor).getArgument(), (Processor<? super PsiElement>)((Processor)arg_0 -> this.lambda$getDataFromAST$2(parameters, (IntSet)res, arg_0)), false))) continue;
            return null;
        }
        return res.isEmpty() ? null : res;
    }

    private boolean isPassedParameter(final Variable argument) {
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(argument, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            return false;
        }
        final Ref overwritten = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), argument.getName()) && instruction.getAccess().isWrite()) {
                    overwritten.set((Object)true);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }

            @Override
            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence name = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                if (PhpLangUtil.equalsVariableNames(name, argument.getName()) && instruction.getAccess().isWrite()) {
                    overwritten.set((Object)true);
                    return false;
                }
                return super.processArrayAccessInstruction(instruction);
            }
        });
        return (Boolean)overwritten.get() == false;
    }

    @Override
    protected DataExternalizer<IntSet> getExternalizer() {
        return PhpFunctionsWithNotCatchedDynamicPassedCallsIndex.EXTERNALIZER;
    }

    @NotNull
    public static IntSet getReturnedIndices(FunctionReference reference) {
        if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "min") || PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "max")) {
            return new IntOpenHashSet(IntStream.range(0, reference.getParameters().length).toArray());
        }
        IntSet intSet = PhpCustomFunctionIndex.getDataHierarchyAware(reference, PhpChooserFunctionsIndex.class).stream().reduce((set, set2) -> PhpChooserFunctionsIndex.intersection(set, set)).orElse(EMPTY_SET);
        if (intSet == null) {
            PhpChooserFunctionsIndex.$$$reportNull$$$0(1);
        }
        return intSet;
    }

    private static IntSet intersection(IntSet set, IntSet set1) {
        IntOpenHashSet res = new IntOpenHashSet();
        set.forEach(arg_0 -> PhpChooserFunctionsIndex.lambda$intersection$4(set1, (IntSet)res, arg_0));
        return res;
    }

    private static /* synthetic */ void lambda$intersection$4(IntSet set1, IntSet res, int i) {
        if (set1.contains(i)) {
            res.add(i);
        }
    }

    private /* synthetic */ boolean lambda$getDataFromAST$2(List parameters, IntSet res, PsiElement argument) {
        int i;
        if (argument instanceof Variable && (i = ContainerUtil.indexOf((List)parameters, p -> PhpLangUtil.equalsParameterNames(p.getName(), ((Variable)argument).getName()))) >= 0 && this.isPassedParameter((Variable)argument)) {
            res.add(i);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpChooserFunctionsIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpChooserFunctionsIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnedIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromAST";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

