/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocPrefixProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocTypeAliasesIndex
extends FileBasedIndexExtension<String, Map<String, PhpType>> {
    @NonNls
    public static final ID<String, Map<String, PhpType>> KEY = ID.create((String)"php.doc.type.aliases.index");

    @NotNull
    public ID<String, Map<String, PhpType>> getName() {
        ID<String, Map<String, PhpType>> iD = KEY;
        if (iD == null) {
            PhpDocTypeAliasesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Map<String, PhpType>, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> StreamEx.of(PhpPsiUtil.findAllClasses(inputData.getPsiFile())).mapToEntry(c -> c.getFQN(), c -> PhpDocTypeAliasesIndex.getTypeAliases(c.getDocComment())).filterValues(Predicate.not(Map::isEmpty)).toMap(ContainerUtil::union);
        if (dataIndexer == null) {
            PhpDocTypeAliasesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    private static Map<String, PhpType> getTypeAliases(@Nullable PhpDocComment comment) {
        if (comment == null) {
            return Collections.emptyMap();
        }
        return StreamEx.of(PhpDocPrefixProvider.EP_NAME.getExtensionList().stream()).flatMapToEntry(p -> PhpDocTypeAliasesIndex.getTypeAliases(comment, p.getPrefix())).toMap(PhpType::or);
    }

    @NotNull
    private static Map<String, PhpType> getTypeAliases(@NotNull PhpDocComment comment, String tagPrefix) {
        if (comment == null) {
            PhpDocTypeAliasesIndex.$$$reportNull$$$0(2);
        }
        Map<String, PhpType> map = PhpGenericsExtendedTypeProvider.getCustomTypes(comment, tagPrefix + "type");
        if (map == null) {
            PhpDocTypeAliasesIndex.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpDocTypeAliasesIndex.$$$reportNull$$$0(4);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Map<String, PhpType>> getValueExternalizer() {
        return new PhpTypeExternalizer();
    }

    public int getVersion() {
        return 2;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpDocTypeAliasesIndex.$$$reportNull$$$0(5);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public static PhpType getTypeByAliasName(Project project, String classFQN, String aliasName) {
        PhpType res = new PhpType();
        FileBasedIndex.getInstance().processValues(KEY, (Object)classFQN, null, (file, type) -> {
            res.add((PhpType)type.get(aliasName));
            return true;
        }, GlobalSearchScope.allScope((Project)project));
        PhpType phpType = res;
        if (phpType == null) {
            PhpDocTypeAliasesIndex.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpDocTypeAliasesIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpDocTypeAliasesIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAliases";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByAliasName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAliases";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class PhpTypeExternalizer
    implements DataExternalizer<Map<String, PhpType>> {
        private PhpTypeExternalizer() {
        }

        public void save(@NotNull DataOutput out, Map<String, PhpType> value) throws IOException {
            if (out == null) {
                PhpTypeExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (Map.Entry<String, PhpType> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                Set<@NlsSafe String> types = entry.getValue().getTypes();
                out.writeInt(types.size());
                for (String type : types) {
                    out.writeUTF(type);
                }
            }
        }

        public Map<String, PhpType> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                PhpTypeExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            HashMap<String, PhpType> res = new HashMap<String, PhpType>(size);
            for (int i = 0; i < size; ++i) {
                String aliasName = in.readUTF();
                int typeSize = in.readInt();
                PhpType type = new PhpType();
                for (int j = 0; j < typeSize; ++j) {
                    type.add(in.readUTF());
                }
                res.put(aliasName, type);
            }
            return res;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpDocTypeAliasesIndex$PhpTypeExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

