/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInvokeCallsOffsetsIndex;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PhpFuncGetArgParameterIndicesUsageIndex
extends FileBasedIndexExtension<String, IntList> {
    @NonNls
    private static final ID<String, IntList> KEY = ID.create((String)"php.func.get.arg.usage.index");
    public static final int AMBIGUOUS_PARAMETER_INDEX = -1;

    @NotNull
    public ID<String, IntList> getName() {
        ID<String, IntList> iD = KEY;
        if (iD == null) {
            PhpFuncGetArgParameterIndicesUsageIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, IntList, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            HashMap<String, IntList> map = new HashMap<String, IntList>();
            PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), PhpFile.class);
            if (file != null) {
                for (Function function : PhpFuncGetArgUsageProvider.findTopLevelFunctions(file)) {
                    IntList implicitlyUsedParameterIndices = this.getImplicitlyUsedParameterIndices(function);
                    if (implicitlyUsedParameterIndices.isEmpty()) continue;
                    map.put(function.getFQN(), implicitlyUsedParameterIndices);
                }
            }
            return map;
        };
        if (dataIndexer == null) {
            PhpFuncGetArgParameterIndicesUsageIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    private IntList getImplicitlyUsedParameterIndices(Function function) {
        IntOpenHashSet res = new IntOpenHashSet();
        PhpControlFlowUtil.processFlow(function.getControlFlow(), new PhpInstructionProcessor((IntSet)res){
            final /* synthetic */ IntSet val$res;
            {
                this.val$res = intSet;
            }

            @Override
            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                FunctionReference reference = instruction.getFunctionReference();
                if (!(reference instanceof MethodReference)) {
                    String name = reference.getName();
                    if (PhpLangUtil.equalsFunctionNames(name, "func_get_args") || PhpLangUtil.equalsFunctionNames(name, "func_num_args")) {
                        this.val$res.add(-1);
                        return false;
                    }
                    if (PhpLangUtil.equalsFunctionNames(name, "func_get_arg")) {
                        PsiElement parameter = reference.getParameter(0);
                        int parameterIndex = PhpPsiUtil.isOfType(parameter, PhpElementTypes.NUMBER) ? StringUtil.parseInt((String)parameter.getText(), (int)-1) : -1;
                        this.val$res.add(parameterIndex);
                        return parameterIndex != -1;
                    }
                }
                return super.processPhpCallInstruction(instruction);
            }
        });
        return new IntArrayList((IntCollection)res);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpFuncGetArgParameterIndicesUsageIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<IntList> getValueExternalizer() {
        PhpInvokeCallsOffsetsIndex.IntArrayExternalizer intArrayExternalizer = PhpInvokeCallsOffsetsIndex.IntArrayExternalizer.INSTANCE;
        if (intArrayExternalizer == null) {
            PhpFuncGetArgParameterIndicesUsageIndex.$$$reportNull$$$0(3);
        }
        return intArrayExternalizer;
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpFuncGetArgParameterIndicesUsageIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static Stream<Integer> implicitlyUsedParameterIndices(@NotNull Function f) {
        if (f == null) {
            PhpFuncGetArgParameterIndicesUsageIndex.$$$reportNull$$$0(5);
        }
        HashSet res = new HashSet();
        FileBasedIndex.getInstance().processValues(KEY, (Object)f.getFQN(), null, (file, value) -> {
            res.addAll(value);
            return !res.contains(-1);
        }, GlobalSearchScope.allScope((Project)f.getProject()));
        return res.stream();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFuncGetArgParameterIndicesUsageIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpFuncGetArgParameterIndicesUsageIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "implicitlyUsedParameterIndices";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

