/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGlobalVariableFakeElement
extends RenameableFakePsiElement
implements PhpNamedElement {
    private final String myName;
    private final PhpType myType;
    private final int myOffsetInFile;

    public PhpGlobalVariableFakeElement(@Nullable PsiFile containingFile, String name, PhpType type, int offsetInFile) {
        super((PsiElement)containingFile);
        this.myName = name;
        this.myType = type;
        this.myOffsetInFile = offsetInFile;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getParent().findElementAt(this.myOffsetInFile);
    }

    @Nullable
    public ASTNode getNode() {
        return this.getNameNode();
    }

    @Nls
    @Nullable
    public String getTypeName() {
        return PhpBundle.message("global.variable.from.globals.array.assignment", new Object[0]);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpIcons.VARIABLE;
    }

    @Override
    @NotNull
    public String getFQN() {
        String string = PhpLangUtil.toFQN(this.myName);
        if (string == null) {
            PhpGlobalVariableFakeElement.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getNamespaceName() {
        return "\\";
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getNode() : null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PhpGlobalVariableFakeElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        String string = this.myName;
        if (string == null) {
            PhpGlobalVariableFakeElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        return null;
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor) {
    }

    @Override
    @Nullable
    public PhpPsiElement getFirstPsiChild() {
        return null;
    }

    @Override
    @Nullable
    public PhpPsiElement getNextPsiSibling() {
        return null;
    }

    @Override
    @Nullable
    public PhpPsiElement getPrevPsiSibling() {
        return null;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType phpType = this.myType;
        if (phpType == null) {
            PhpGlobalVariableFakeElement.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    @Nullable
    public TextRange getTextRange() {
        int endOffset = this.myOffsetInFile + this.myName.length() + 2;
        return TextRange.create((int)this.myOffsetInFile, (int)endOffset);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)this.getNameIdentifier(), (Object)this.getParent());
        if (psiElement == null) {
            PhpGlobalVariableFakeElement.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpGlobalVariableFakeElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

