/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.intentions.strings.converters.PhpConcatenationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInvokeCallsOffsetsIndex;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class PhpPutEnvArgumentsIndex
extends FileBasedIndexExtension<String, PhpEnvArgument> {
    public static final ID<String, PhpEnvArgument> KEY = ID.create((String)"php.putenv.arguments");

    @NotNull
    public ID<String, PhpEnvArgument> getName() {
        ID<String, PhpEnvArgument> iD = KEY;
        if (iD == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    private static Pair<String, String> getArgumentNameAndValue(@NotNull FunctionReference reference) {
        PsiElement parameter;
        String argumentText;
        int indexOfEquals;
        if (reference == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(1);
        }
        String argumentName = (indexOfEquals = (argumentText = PhpPutEnvArgumentsIndex.getArgumentText(parameter = reference.getParameter(0))).indexOf("=")) >= 0 ? argumentText.substring(0, indexOfEquals) : argumentText;
        String argumentValue = indexOfEquals >= 0 ? argumentText.substring(indexOfEquals + 1) : "";
        Variable type = (Variable)PsiTreeUtil.findChildOfType((PsiElement)parameter, Variable.class);
        if (type != null && type.getText().equals(argumentName)) {
            Pair pair = Pair.create((Object)"", (Object)argumentValue);
            if (pair == null) {
                PhpPutEnvArgumentsIndex.$$$reportNull$$$0(2);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)argumentName, (Object)argumentValue);
        if (pair == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    public DataIndexer<String, PhpEnvArgument, FileContent> getIndexer() {
        return new DataIndexer<String, PhpEnvArgument, FileContent>(){

            @NotNull
            public Map<String, PhpEnvArgument> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                final HashMap<String, PhpEnvArgument> map = new HashMap<String, PhpEnvArgument>();
                PsiFile file = inputData.getPsiFile();
                if (file instanceof PhpFile && file.getText().contains("putenv")) {
                    PhpControlFlowUtil.processFile((PhpFile)file, new PhpControlFlowUtil.PhpRecursiveInstructionProcessor(){

                        @Override
                        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                            Pair<String, String> nameAndValue;
                            String argumentName;
                            FunctionReference reference = instruction.getFunctionReference();
                            if (StringUtil.equalsIgnoreCase((CharSequence)reference.getName(), (CharSequence)"putenv") && StringUtil.isNotEmpty((String)(argumentName = (String)(nameAndValue = PhpPutEnvArgumentsIndex.getArgumentNameAndValue(reference)).getFirst()))) {
                                map.computeIfAbsent(argumentName, s -> new PhpEnvArgument((IntList)new IntArrayList(), (String)nameAndValue.getSecond())).getPutValueOffsets().add(reference.getTextOffset());
                            }
                            return true;
                        }
                    });
                }
                HashMap<String, PhpEnvArgument> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static String getArgumentText(PsiElement parameter) {
        if (parameter instanceof StringLiteralExpression) {
            StringLiteralExpression literal = (StringLiteralExpression)parameter;
            String contents = literal.getContents();
            String string = literal.isSingleQuote() ? StringUtil.unescapeBackSlashes((String)contents) : contents;
            if (string == null) {
                PhpPutEnvArgumentsIndex.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (parameter instanceof BinaryExpression) {
            BinaryExpression binary = (BinaryExpression)parameter;
            if (PhpConcatenationStringRepresentationConverter.isConcatenation(parameter)) {
                List<PhpStringPartDescriptor> parts = PhpConcatenationStringRepresentationConverter.INSTANCE.getStringParts(binary);
                String string = parts.stream().map(descriptor -> PhpPutEnvArgumentsIndex.getArgumentText(descriptor.getElement())).collect(Collectors.joining());
                if (string == null) {
                    PhpPutEnvArgumentsIndex.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        return "";
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(6);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<PhpEnvArgument> getValueExternalizer() {
        DataExternalizer<PhpEnvArgument> dataExternalizer = PhpEnvArgument.EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(7);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpPutEnvArgumentsIndex.$$$reportNull$$$0(8);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentNameAndValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentNameAndValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class PhpEnvArgument {
        private static final DataExternalizer<PhpEnvArgument> EXTERNALIZER = new DataExternalizer<PhpEnvArgument>(){

            public void save(@NotNull DataOutput out, PhpEnvArgument value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                out.writeUTF(value.getValue());
                PhpInvokeCallsOffsetsIndex.IntArrayExternalizer.INSTANCE.save(out, value.getPutValueOffsets());
            }

            public PhpEnvArgument read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                String value = in.readUTF();
                IntList putValueOffsets = PhpInvokeCallsOffsetsIndex.IntArrayExternalizer.INSTANCE.read(in);
                return new PhpEnvArgument(putValueOffsets, value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$PhpEnvArgument$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        @NotNull
        private final IntList myPutValueOffsets;
        @NotNull
        private final String myValue;

        public PhpEnvArgument(@NotNull IntList putValueOffsets, @NotNull String value) {
            if (putValueOffsets == null) {
                PhpEnvArgument.$$$reportNull$$$0(0);
            }
            if (value == null) {
                PhpEnvArgument.$$$reportNull$$$0(1);
            }
            this.myPutValueOffsets = putValueOffsets;
            this.myValue = value;
        }

        @NotNull
        public IntList getPutValueOffsets() {
            IntList intList = this.myPutValueOffsets;
            if (intList == null) {
                PhpEnvArgument.$$$reportNull$$$0(2);
            }
            return intList;
        }

        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                PhpEnvArgument.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpEnvArgument argument = (PhpEnvArgument)o;
            return this.myPutValueOffsets.equals(argument.myPutValueOffsets) && this.myValue.equals(argument.myValue);
        }

        public int hashCode() {
            return Objects.hash(this.myPutValueOffsets, this.myValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "putValueOffsets";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$PhpEnvArgument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPutEnvArgumentsIndex$PhpEnvArgument";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPutValueOffsets";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

