/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConstructorCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.codeSmell.PhpParameterByRefIsNotUsedAsReferenceInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCustomFunctionIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpTriviallyPureFunctionsIndex
extends PhpCustomFunctionIndex<PurityType> {
    private static final int[] EMPTY = new int[0];

    @Override
    protected DataExternalizer<PurityType> getExternalizer() {
        return PurityTypeDataExternalizer.INSTANCE;
    }

    @Override
    @Nullable
    protected PurityType getDataFromAST(@NotNull Function function) {
        if (function == null) {
            PhpTriviallyPureFunctionsIndex.$$$reportNull$$$0(0);
        }
        if (PhpTriviallyPureFunctionsIndex.cannotBeTriviallyPure(function)) {
            return PurityType.NOT_PURE;
        }
        Ref nonTrivial = new Ref((Object)false);
        PurityType type = PhpTriviallyPureFunctionsIndex.getPurityType(function, (Ref<Boolean>)nonTrivial, false);
        if (((Boolean)nonTrivial.get()).booleanValue()) {
            return PurityType.NOT_PURE;
        }
        return type;
    }

    public static boolean cannotBeTriviallyPure(Function function) {
        return PhpSideEffectDetector.hasPureAttribute(function) || function instanceof PhpDocMethod || function instanceof Method && ((Method)function).isAbstract();
    }

    public static PurityType getPurityType(Function function, Ref<@NotNull Boolean> nonTrivial, boolean global) {
        if (ContainerUtil.exists((Object[])function.getParameters(), p -> PhpType.intersects(PhpTriviallyPureFunctionsIndex.getTypeFromDeclaration(p), PhpType.CALLABLE))) {
            return PurityType.NOT_PURE;
        }
        return PhpTriviallyPureFunctionsIndex.getPurityType(function, nonTrivial, (Ref<Boolean>)new Ref((Object)true), global);
    }

    @NotNull
    private static PhpType getTypeFromDeclaration(Parameter p) {
        PhpType phpType = PhpType.or(p.getDeclaredType(), p.getDocType());
        if (phpType == null) {
            PhpTriviallyPureFunctionsIndex.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static PurityType getPurityType(Function function, final Ref<Boolean> nonTrivial, final Ref<@NotNull Boolean> empty, final boolean global) {
        Collection<Variable> usedVariables;
        if (function.isClosure() && ContainerUtil.exists(usedVariables = PhpControlFlowBuilder.getUsedVariables(function, (PhpScopeHolder)PhpPsiUtil.getParentByCondition(function, PhpScopeHolder.INSTANCE_OF)), PhpWorkaroundUtil::isReadReference)) {
            return PurityType.NOT_PURE;
        }
        Parameter[] parameters = function.getParameters();
        Collection<Parameter> parameterRefsByName = PhpParameterByRefIsNotUsedAsReferenceInspection.getParametersByRefNames(parameters, EMPTY);
        if (!(parameterRefsByName.isEmpty() || global && !ContainerUtil.exists(parameterRefsByName, p -> !PhpParameterByRefIsNotUsedAsReferenceInspection.isUnusedAsRefParameter(function, p)))) {
            return PurityType.NOT_PURE;
        }
        final Ref canContainSideEffect = new Ref((Object)false);
        PhpControlFlow flow = function.getControlFlow();
        if (flow.getInstructions().length == 0) {
            return PurityType.NOT_PURE;
        }
        final @NotNull Ref globalPure = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(flow.getEntryPoint(), false, new PhpInstructionProcessor(){

            @Override
            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                FunctionReference reference = instruction.getFunctionReference();
                if (!PhpCodeInsightUtil.isStdPureFunction(reference, true)) {
                    nonTrivial.set((Object)true);
                } else if (!PhpCodeInsightUtil.isStdPureFunction(reference, false)) {
                    globalPure.set((Object)true);
                }
                return super.processPhpCallInstruction(instruction);
            }

            @Override
            public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                FieldReference fieldReference = instruction.getFieldReference();
                if (fieldReference != null && fieldReference.isStatic()) {
                    globalPure.set((Object)true);
                }
                return super.processAccessFieldInObjectContextInstruction(instruction);
            }

            @Override
            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                FieldReference fieldReference = instruction.getFieldReference();
                if (fieldReference != null && fieldReference.isStatic()) {
                    globalPure.set((Object)true);
                }
                return super.processAccessFieldByVariableInstruction(instruction);
            }

            @Override
            public boolean processConstructorCallInstruction(PhpConstructorCallInstruction instruction) {
                NewExpression newExpression = instruction.getNewExpression();
                if (!PhpCodeInsightUtil.isStdPureConstructor(newExpression)) {
                    nonTrivial.set((Object)true);
                }
                return super.processConstructorCallInstruction(instruction);
            }

            @Override
            public boolean processInstruction(PhpInstruction instruction) {
                PsiElement anchor = instruction.getAnchor();
                if (anchor == null) {
                    return true;
                }
                if (((Boolean)empty.get()).booleanValue() && !PhpPsiUtil.isOfType(anchor.getParent(), PhpElementTypes.PARAMETER_DEFAULT_VALUE)) {
                    if (PhpPsiUtil.getParentByCondition(anchor, false, (Condition<? super PsiElement>)((Condition)PhpAttribute.class::isInstance), Statement.INSTANCEOF) == null) {
                        empty.set((Object)false);
                    }
                }
                if (PhpSideEffectDetector.canContainSideEffect(anchor, global, false, true)) {
                    canContainSideEffect.set((Object)true);
                    return false;
                }
                return true;
            }

            @Override
            public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                return true;
            }
        });
        if (!((Boolean)canContainSideEffect.get()).booleanValue() && function.isClosure() && FunctionImpl.isShortArrowFunction(function) && PhpSideEffectDetector.canContainSideEffect(FunctionImpl.getShortArrowFunctionArgument(function), global, false, true)) {
            canContainSideEffect.set((Object)true);
        }
        if (((Boolean)empty.get()).booleanValue() || ((Boolean)canContainSideEffect.get()).booleanValue()) {
            return PurityType.NOT_PURE;
        }
        return (Boolean)globalPure.get() != false ? PurityType.PURE_GLOBAL : PurityType.PURE_LOCAL;
    }

    @NotNull
    public static PurityType getPurity(@NotNull Function function) {
        if (function == null) {
            PhpTriviallyPureFunctionsIndex.$$$reportNull$$$0(2);
        }
        Set<Function> functions = function instanceof PhpDocMethod ? PhpTriviallyPureFunctionsIndex.getMagicCallMethods(((PhpDocMethod)function).getContainingClass()) : Collections.singleton(function);
        PurityType purityType = functions.stream().map(f -> (PurityType)((Object)((Object)ObjectUtils.notNull((Object)((Object)((PurityType)((Object)((Object)PhpCustomFunctionIndex.getData(f, PhpTriviallyPureFunctionsIndex.class))))), (Object)((Object)PurityType.NOT_PURE))))).max(Comparator.comparingInt(Enum::ordinal)).orElse(PurityType.NOT_PURE);
        if (purityType == null) {
            PhpTriviallyPureFunctionsIndex.$$$reportNull$$$0(3);
        }
        return purityType;
    }

    private static Collection<Function> getMagicCallMethods(@Nullable PhpClass aClass) {
        if (aClass == null) {
            return Collections.emptyList();
        }
        ArrayList<Function> list = new ArrayList<Function>();
        ContainerUtil.addIfNotNull(list, (Object)aClass.findMethodByName("__call"));
        ContainerUtil.addIfNotNull(list, (Object)aClass.findMethodByName("__callStatic"));
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpTriviallyPureFunctionsIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpTriviallyPureFunctionsIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPurity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromAST";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPurity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private static class PurityTypeDataExternalizer
    implements DataExternalizer<PurityType> {
        private static final PurityTypeDataExternalizer INSTANCE = new PurityTypeDataExternalizer();

        private PurityTypeDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, PurityType value) throws IOException {
            if (out == null) {
                PurityTypeDataExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.ordinal());
        }

        public PurityType read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                PurityTypeDataExternalizer.$$$reportNull$$$0(1);
            }
            return PurityType.values()[in.readInt()];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpTriviallyPureFunctionsIndex$PurityTypeDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum PurityType {
        PURE_LOCAL,
        PURE_GLOBAL,
        NOT_PURE;

    }
}

