/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionClassConstantArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionScalarArgument;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitDataProvidersIndex
extends FileBasedIndexExtension<String, Set<DataProviderUsage>> {
    @NonNls
    public static final ID<String, Set<DataProviderUsage>> KEY = ID.create((String)"php.unit.data.providers");
    private static final String PHPUNIT_DATA_PROVIDER_ATTRIBUTE = "\\PHPUnit\\Framework\\Attributes\\DataProvider";
    private static final String PHPUNIT_DATA_PROVIDER_EXTERNAL_ATTRIBUTE = "\\PHPUnit\\Framework\\Attributes\\DataProviderExternal";

    @NotNull
    public ID<String, Set<DataProviderUsage>> getName() {
        ID<String, Set<DataProviderUsage>> iD = KEY;
        if (iD == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Set<DataProviderUsage>, FileContent> getIndexer() {
        return new DataIndexer<String, Set<DataProviderUsage>, FileContent>(){

            @NotNull
            public Map<String, Set<DataProviderUsage>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap<String, Set<DataProviderUsage>> map = new HashMap<String, Set<DataProviderUsage>>();
                for (PhpClass testClass : PhpPsiUtil.findAllClasses(inputData.getPsiFile())) {
                    PhpClassImpl phpClass;
                    if (!TestFinderHelper.isTest((PsiElement)testClass) || (phpClass = (PhpClassImpl)ObjectUtils.tryCast((Object)testClass, PhpClassImpl.class)) == null) continue;
                    for (Method method : phpClass.getOwnMethods()) {
                        PhpDocComment docComment = method.getDocComment();
                        HashSet<Pair<String, String>> dataProviders = new HashSet<Pair<String, String>>();
                        dataProviders.addAll(PhpUnitDataProvidersIndex.getDataProvidersFromDocComment(method, docComment));
                        dataProviders.addAll(PhpUnitDataProvidersIndex.getDataProvidersFromAttributes(method));
                        for (Pair pair : dataProviders) {
                            map.computeIfAbsent((String)pair.second, c -> new HashSet()).add(new DataProviderUsage(phpClass.getFQN(), method.getName(), (String)pair.first));
                        }
                    }
                }
                HashMap<String, Set<DataProviderUsage>> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitDataProvidersIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitDataProvidersIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static Set<Pair<String, String>> getDataProvidersFromAttributes(@NotNull Method method) {
        if (method == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(1);
        }
        HashSet<Pair<String, String>> fqnAnNames = new HashSet<Pair<String, String>>();
        for (PhpAttribute dataProvider : method.getAttributes(PHPUNIT_DATA_PROVIDER_ATTRIBUTE)) {
            @Nullable PhpExpectedFunctionArgument argument = PhpUnitDataProvidersIndex.getAttributeArgument(dataProvider, "methodName", 0);
            if (argument == null) continue;
            PhpExpectedFunctionScalarArgument methodNameArg = (PhpExpectedFunctionScalarArgument)ObjectUtils.tryCast((Object)argument, PhpExpectedFunctionScalarArgument.class);
            if (method.getContainingClass() == null || methodNameArg == null || !methodNameArg.isStringLiteral()) continue;
            fqnAnNames.add((Pair<String, String>)Pair.create((Object)method.getContainingClass().getFQN(), (Object)StringUtil.unquoteString((String)methodNameArg.getValue())));
        }
        for (PhpAttribute dataProvider : method.getAttributes(PHPUNIT_DATA_PROVIDER_EXTERNAL_ATTRIBUTE)) {
            String classFqn;
            PhpExpectedFunctionArgument classNameArg = PhpUnitDataProvidersIndex.getAttributeArgument(dataProvider, "className", 0);
            if (classNameArg == null || (classFqn = PhpUnitDataProvidersIndex.extractClassFqn(classNameArg)) == null) continue;
            PhpExpectedFunctionScalarArgument methodNameArg = (PhpExpectedFunctionScalarArgument)ObjectUtils.tryCast((Object)PhpUnitDataProvidersIndex.getAttributeArgument(dataProvider, "methodName", 1), PhpExpectedFunctionScalarArgument.class);
            if (method.getContainingClass() == null || methodNameArg == null || !methodNameArg.isStringLiteral()) continue;
            fqnAnNames.add((Pair<String, String>)Pair.create((Object)classFqn, (Object)StringUtil.unquoteString((String)methodNameArg.getValue())));
        }
        HashSet<Pair<String, String>> hashSet = fqnAnNames;
        if (hashSet == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @Nullable
    private static String extractClassFqn(PhpExpectedFunctionArgument argument) {
        PhpExpectedFunctionClassConstantArgument classConstant;
        PhpExpectedFunctionScalarArgument scalarArgument;
        if (argument instanceof PhpExpectedFunctionScalarArgument && (scalarArgument = (PhpExpectedFunctionScalarArgument)argument).isStringLiteral()) {
            String className = StringUtil.unquoteString((String)scalarArgument.getValue());
            return PhpLangUtil.isFqn(className) ? className : null;
        }
        if (argument instanceof PhpExpectedFunctionClassConstantArgument && PhpLangUtil.equalsClassConstantNames("class", (classConstant = (PhpExpectedFunctionClassConstantArgument)argument).getConstantName())) {
            return classConstant.getClassFqn();
        }
        return null;
    }

    @Nullable
    public static PhpExpectedFunctionArgument getAttributeArgument(@NotNull PhpAttribute attribute, @NotNull String name, int index) {
        List<PhpAttribute.PhpAttributeArgument> arguments;
        PhpAttribute.PhpAttributeArgument byName;
        if (attribute == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(3);
        }
        if (name == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(4);
        }
        if ((byName = (PhpAttribute.PhpAttributeArgument)ContainerUtil.find(arguments = attribute.getArguments(), arg -> arg.getName().equals(name))) != null) {
            return byName.getArgument();
        }
        return arguments.size() > index ? arguments.get(index).getArgument() : null;
    }

    @NotNull
    private static Set<Pair<String, String>> getDataProvidersFromDocComment(@NotNull Method method, @Nullable PhpDocComment docComment) {
        if (method == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(5);
        }
        if (docComment == null) {
            Set<Pair<String, String>> set = Collections.emptySet();
            if (set == null) {
                PhpUnitDataProvidersIndex.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set set = (Set)((StreamEx)StreamEx.of((Object[])docComment.getTagElementsByName("@dataProvider")).map(PhpPsiElement::getFirstPsiChild).select(PhpDocRef.class).map(ref -> PhpUnitUtil.getClassFqnAndMethodName(ref, method.getNamespaceName())).filter(fqnAnName -> StringUtil.isNotEmpty((String)((String)fqnAnName.second)))).collect(Collectors.toSet());
        if (set == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(7);
        }
        return set;
    }

    public static Stream<Method> getDataProviderUsages(@NotNull Method dataProvider) {
        String dataProviderClassFqn;
        if (dataProvider == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(8);
        }
        String name = dataProvider.getName();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)dataProvider.getProject());
        String string = dataProviderClassFqn = dataProvider.getContainingClass() != null ? dataProvider.getContainingClass().getFQN() : null;
        if (dataProviderClassFqn == null) {
            return Stream.empty();
        }
        List usages = FileBasedIndex.getInstance().getValues(KEY, (Object)name, scope);
        return ((EntryStream)((EntryStream)StreamEx.of((Collection)usages).flatMap(it -> it.stream()).mapToEntry(usage -> PhpUnitDataProvidersIndex.getMethods(usage, dataProvider.getProject())).flatMapValues(methods -> methods).mapKeys(usage -> usage.dataProviderFqn).filter(usage -> ((Method)usage.getValue()).getContainingClass() != null)).filter(usage -> dataProviderClassFqn.equals(usage.getKey()) || PhpUnitDataProvidersIndex.hasNonOverriddenMethodInHierarchy((String)usage.getKey(), ((Method)usage.getValue()).getContainingClass(), dataProvider))).values().distinct();
    }

    private static Stream<Method> getMethods(@NotNull DataProviderUsage usage, @NotNull Project project) {
        if (usage == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(9);
        }
        if (project == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(10);
        }
        return PhpIndex.getInstance(project).getClassesByFQN(usage.classFqn).stream().map(c -> c.findOwnMethodByName(usage.methodName)).filter(Objects::nonNull);
    }

    private static boolean hasNonOverriddenMethodInHierarchy(@Nullable String dataProviderFqn, @NotNull PhpClass usageClass, @NotNull Method method) {
        if (usageClass == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(11);
        }
        if (method == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(12);
        }
        List<PhpClass> dataProviderClasses = dataProviderFqn != null ? PhpIndex.getInstance(usageClass.getProject()).getClassesByFQN(dataProviderFqn) : Collections.singletonList(usageClass);
        PhpClass dataProviderClass = (PhpClass)ContainerUtil.getOnlyItem(dataProviderClasses);
        return PhpClassHierarchyUtils.isSuperClass(method.getContainingClass(), dataProviderClass, false, false) && dataProviderClass.findMethodByName(method.getName()) == method;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(13);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<DataProviderUsage>> getValueExternalizer() {
        DataProviderUsageExternalizer dataProviderUsageExternalizer = DataProviderUsageExternalizer.INSTANCE;
        if (dataProviderUsageExternalizer == null) {
            PhpUnitDataProvidersIndex.$$$reportNull$$$0(14);
        }
        return dataProviderUsageExternalizer;
    }

    public int getVersion() {
        return 4;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{PhpFileType.INSTANCE});
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitDataProvidersIndex";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitDataProvidersIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProvidersFromAttributes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProvidersFromDocComment";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvidersFromAttributes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeArgument";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvidersFromDocComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDataProviderUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasNonOverriddenMethodInHierarchy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    public record DataProviderUsage(@NotNull String classFqn, @NotNull String methodName, @Nullable String dataProviderFqn) {
        @NotNull
        private final String classFqn;
        @NotNull
        private final String methodName;

        public DataProviderUsage(@NotNull String classFqn, @NotNull String methodName, @Nullable String dataProviderFqn) {
            if (classFqn == null) {
                DataProviderUsage.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                DataProviderUsage.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String classFqn() {
            String string = this.classFqn;
            if (string == null) {
                DataProviderUsage.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String methodName() {
            String string = this.methodName;
            if (string == null) {
                DataProviderUsage.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitDataProvidersIndex$DataProviderUsage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitDataProvidersIndex$DataProviderUsage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classFqn";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "methodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static class DataProviderUsageExternalizer
    implements DataExternalizer<Set<DataProviderUsage>> {
        public static final DataProviderUsageExternalizer INSTANCE = new DataProviderUsageExternalizer();

        DataProviderUsageExternalizer() {
        }

        public void save(@NotNull DataOutput out, Set<DataProviderUsage> value) throws IOException {
            if (out == null) {
                DataProviderUsageExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (DataProviderUsage item : value) {
                DataProviderUsageExternalizer.saveItem(out, item);
            }
        }

        public Set<DataProviderUsage> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                DataProviderUsageExternalizer.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            HashSet<DataProviderUsage> result = new HashSet<DataProviderUsage>(size);
            for (int i = 0; i < size; ++i) {
                result.add(DataProviderUsageExternalizer.readItem(in));
            }
            return result;
        }

        private static DataProviderUsage readItem(DataInput in) throws IOException {
            String classFqn = in.readUTF();
            String methodName = in.readUTF();
            String dataProviderFqn = StringUtil.nullize((String)in.readUTF());
            return new DataProviderUsage(classFqn, methodName, dataProviderFqn);
        }

        private static void saveItem(DataOutput out, DataProviderUsage value) throws IOException {
            out.writeUTF(value.classFqn);
            out.writeUTF(value.methodName);
            out.writeUTF(StringUtil.notNullize((String)value.dataProviderFqn));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUnitDataProvidersIndex$DataProviderUsageExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

