/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpAttributesRegistryBase<T> {
    public List<T> getValues(@Nullable PsiElement element, boolean allowAmbiguity) {
        if (element == null) {
            return ContainerUtil.emptyList();
        }
        if (element instanceof Variable) {
            PhpAccessVariableInstruction accessInstruction = PhpControlFlowUtil.getAccessInstruction((Variable)element, PhpAccessVariableInstruction.class);
            if (accessInstruction != null) {
                Ref ambiguous = new Ref((Object)false);
                Collection<T> arguments = this.collectValuesFromAssignments((Variable)element, accessInstruction, (Ref<Boolean>)ambiguous, allowAmbiguity);
                if (allowAmbiguity || !((Boolean)ambiguous.get()).booleanValue()) {
                    return new ArrayList<T>(arguments);
                }
            }
        } else {
            if (element instanceof FunctionReference) {
                return this.getValues((FunctionReference)element);
            }
            if (element instanceof FieldReference) {
                return this.getValues((FieldReference)element, allowAmbiguity);
            }
        }
        return this.getExpectedValues(element, allowAmbiguity);
    }

    @NotNull
    protected List<T> getExpectedValues(@NotNull PsiElement element, boolean allowAmbiguity) {
        PhpReference reference;
        PsiElement parent;
        if (element == null) {
            PhpAttributesRegistryBase.$$$reportNull$$$0(0);
        }
        if ((parent = element.getParent()) instanceof PhpReturn) {
            Function function = PhpPsiUtil.getParentOfClass(element, Function.class);
            if (function != null) {
                List<T> list = this.getValues(function);
                if (list == null) {
                    PhpAttributesRegistryBase.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpAttributesRegistryBase.$$$reportNull$$$0(2);
            }
            return list;
        }
        int depth = 0;
        Object arrayCreation = PhpPsiUtil.getParentByCondition(element, ArrayCreationExpression.INSTANCEOF, ParameterList.INSTANCEOF);
        while (arrayCreation != null) {
            ++depth;
            element = arrayCreation;
            arrayCreation = PhpPsiUtil.getParentByCondition(element, ArrayCreationExpression.INSTANCEOF, ParameterList.INSTANCEOF);
        }
        parent = element.getParent();
        if (parent instanceof ParameterList && (reference = PhpAnnotatorVisitor.getReferenceToResolve((ParameterListOwner)ObjectUtils.tryCast((Object)parent.getParent(), ParameterListOwner.class))) != null) {
            List functions = ContainerUtil.filterIsInstance(this.resolve(reference).toList(), Function.class);
            if (!allowAmbiguity && functions.size() > 1 || functions.isEmpty()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    PhpAttributesRegistryBase.$$$reportNull$$$0(3);
                }
                return list;
            }
            int parameterIndex = PhpWorkaroundUtil.resolveMappedParameterIndex(element);
            List values = functions.stream().flatMap(f -> this.getParameterValues((Function)f, parameterIndex).stream()).distinct().toList();
            List list = this.getParameterNestedArrayCreationValues(depth, values);
            if (list == null) {
                PhpAttributesRegistryBase.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            PhpAttributesRegistryBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    protected Collection<T> collectValuesFromAssignments(final Variable element, PhpAccessVariableInstruction accessInstruction, final Ref<Boolean> ambiguous, final boolean allowAmbiguity) {
        final LinkedHashSet arguments = new LinkedHashSet();
        PhpControlFlowUtil.processPreviousVariableAccesses(accessInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.getAccess().isWrite()) {
                    PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                    List assignedArguments = PhpAttributesRegistryBase.this.getValuesFromAssignedValue((Variable)ObjectUtils.tryCast((Object)instruction.getAnchor(), Variable.class), value);
                    if (!assignedArguments.isEmpty()) {
                        arguments.addAll(assignedArguments);
                    } else {
                        ambiguous.set((Object)true);
                        if (!allowAmbiguity) {
                            this.haltTraversal();
                        }
                    }
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }

            @Override
            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                int parameterIndex;
                List parameterArguments;
                Function function;
                PhpNamedElement resolvedParameter = (PhpNamedElement)ContainerUtil.find((Iterable)element.resolveLocal(), a -> a instanceof Parameter);
                if (resolvedParameter != null && (function = PhpPsiUtil.getParentOfClass((PsiElement)resolvedParameter, Function.class)) != null && !(parameterArguments = PhpAttributesRegistryBase.this.getParameterValuesInner(function, parameterIndex = ArrayUtil.indexOf((Object[])function.getParameters(), (Object)resolvedParameter))).isEmpty()) {
                    arguments.addAll(parameterArguments);
                    return true;
                }
                ambiguous.set((Object)true);
                if (!allowAmbiguity) {
                    this.haltTraversal();
                }
                return super.processEntryPointInstruction(instruction);
            }
        });
        return arguments;
    }

    @NotNull
    protected List<T> getValuesFromAssignedValue(@Nullable Variable variable, PsiElement value) {
        List<T> list = this.getValues((FunctionReference)ObjectUtils.tryCast((Object)value, FunctionReference.class));
        if (list == null) {
            PhpAttributesRegistryBase.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    protected abstract List<T> getParameterValuesInner(@NotNull Function var1, int var2);

    @NotNull
    protected abstract List<T> getValuesInner(Function var1);

    @NotNull
    protected List<T> getParameterNestedArrayCreationValues(int depth, List<T> parentAccesses) {
        List<T> list = parentAccesses;
        if (list == null) {
            PhpAttributesRegistryBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<T> getValues(Function function) {
        List list = this.getFromFunctionHierarchyAware(function, this::getValuesInner);
        if (list == null) {
            PhpAttributesRegistryBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<T> getParameterValues(Function function, int argumentIndex) {
        Parameter[] parameters = function.getParameters();
        if (parameters.length > 0 && parameters.length - 1 < argumentIndex && parameters[parameters.length - 1].isVariadic()) {
            List list = this.getFromFunctionHierarchyAware(function, f -> this.getParameterValuesInner((Function)f, parameters.length - 1));
            if (list == null) {
                PhpAttributesRegistryBase.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = this.getFromFunctionHierarchyAware(function, f -> this.getParameterValuesInner((Function)f, argumentIndex));
        if (list == null) {
            PhpAttributesRegistryBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    protected abstract List<T> getValues(Field var1);

    protected <F> List<F> getFromFunctionHierarchyAware(Function base, java.util.function.Function<Function, List<F>> f) {
        Ref result = new Ref((Object)ContainerUtil.emptyList());
        result.set(f.apply(base));
        if (((List)result.get()).isEmpty() && base instanceof Method) {
            PhpClassHierarchyUtils.processSuperMethods((Method)base, (classMember, subClass, baseClass) -> {
                List values = (List)f.apply((Function)((Object)classMember));
                if (values.isEmpty()) {
                    return true;
                }
                result.set((Object)values);
                return false;
            });
        }
        return (List)result.get();
    }

    @NotNull
    public List<T> getValues(FunctionReference functionReference) {
        if (functionReference == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpAttributesRegistryBase.$$$reportNull$$$0(11);
            }
            return list;
        }
        Function function = this.getFunction(functionReference);
        if (function == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpAttributesRegistryBase.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<T> list = this.getValues(function);
        if (list == null) {
            PhpAttributesRegistryBase.$$$reportNull$$$0(13);
        }
        return list;
    }

    protected Stream<? extends PsiElement> resolve(PhpReference reference) {
        return StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement);
    }

    @Nullable
    public Function getFunction(PhpReference reference) {
        return StreamEx.of(this.resolve(reference)).select(Function.class).findFirst().orElse(null);
    }

    protected List<T> getValues(MemberReference element, boolean allowAmbiguity) {
        List fields = ContainerUtil.filterIsInstance(this.resolve(element).toList(), Field.class);
        if (!allowAmbiguity && fields.size() > 1) {
            return ContainerUtil.emptyList();
        }
        return fields.stream().flatMap(f -> this.getValues((Field)f).stream()).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpAttributesRegistryBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpAttributesRegistryBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesFromAssignedValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNestedArrayCreationValues";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedValues";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

