/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantArgument;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExpectedFunctionClassConstantArgument
extends PhpExpectedFunctionArgument {
    @NotNull
    private final String myClassFqn;
    @NotNull
    private final String myConstantName;

    public PhpExpectedFunctionClassConstantArgument(@NotNull String classFqn, @NotNull String constantName, int argumentIndex, int order, @Nullable String argumentSet, boolean flag, boolean fromAttribute) {
        if (classFqn == null) {
            PhpExpectedFunctionClassConstantArgument.$$$reportNull$$$0(0);
        }
        if (constantName == null) {
            PhpExpectedFunctionClassConstantArgument.$$$reportNull$$$0(1);
        }
        super(argumentIndex, order, argumentSet, flag, fromAttribute);
        this.myClassFqn = classFqn;
        this.myConstantName = constantName;
    }

    @Override
    @Nullable
    public PhpNamedElement getNamedElement(@NotNull Project project) {
        if (project == null) {
            PhpExpectedFunctionClassConstantArgument.$$$reportNull$$$0(2);
        }
        PhpIndex index = PhpIndex.getInstance(project);
        return StreamEx.of(index.getAnyByFQN(this.myClassFqn)).map(phpClass -> this.findConstant((PhpClass)phpClass)).nonNull().findFirst().orElse(null);
    }

    @Nullable
    private PhpNamedElement findConstant(PhpClass phpClass) {
        Field field = phpClass.findOwnFieldByName(this.myConstantName, true);
        if (field != null && field.isConstant()) {
            return field;
        }
        if (phpClass.isEnum()) {
            return (PhpNamedElement)ContainerUtil.find(phpClass.getEnumCases(), e -> PhpLangUtil.equalsClassConstantNames(e.getName(), this.myConstantName));
        }
        return null;
    }

    @Override
    @NotNull
    public String getValue() {
        String string = this.myClassFqn + "." + this.myConstantName;
        if (string == null) {
            PhpExpectedFunctionClassConstantArgument.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean matches(@NotNull PsiElement actualArgument) {
        if (actualArgument == null) {
            PhpExpectedFunctionClassConstantArgument.$$$reportNull$$$0(4);
        }
        if (actualArgument instanceof ClassConstantReference) {
            PhpExpression reference = ((ClassConstantReference)actualArgument).getClassReference();
            return reference instanceof ClassReference && PhpExpectedFunctionConstantArgument.referenceMatchesFqn(this.myClassFqn, (ClassReference)reference) && PhpLangUtil.equalsConstantNames(((ClassConstantReference)actualArgument).getName(), this.myConstantName);
        }
        return false;
    }

    @Override
    @NotNull
    public PsiElement createReference(Project project) {
        ClassConstantReference classConstantReference = PhpPsiElementFactory.createPhpPsiFromText(project, ClassConstantReference.class, this.myClassFqn + "::" + this.myConstantName);
        if (classConstantReference == null) {
            PhpExpectedFunctionClassConstantArgument.$$$reportNull$$$0(5);
        }
        return classConstantReference;
    }

    @NotNull
    public String getClassFqn() {
        String string = this.myClassFqn;
        if (string == null) {
            PhpExpectedFunctionClassConstantArgument.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getConstantName() {
        String string = this.myConstantName;
        if (string == null) {
            PhpExpectedFunctionClassConstantArgument.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionClassConstantArgument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedFunctionClassConstantArgument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqn";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElement";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

